/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.commit;

import org.apache.celeborn.client.commit.AbstractPartitionCompletenessValidator;
import org.apache.celeborn.client.commit.LegacySkewHandlingPartitionValidator;
import org.apache.celeborn.client.commit.SkewHandlingWithoutMapRangeValidator;
import org.apache.celeborn.common.CommitMetadata;
import org.apache.celeborn.common.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0002\u0005\u0001'!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u0016\u0001A\u0003%\u0001\u0006C\u0004-\u0001\t\u0007I\u0011B\u0014\t\r5\u0002\u0001\u0015!\u0003)\u0011\u0015q\u0003\u0001\"\u00010\u0005y\u0001\u0016M\u001d;ji&|gnQ8na2,G/\u001a8fgN4\u0016\r\\5eCR|'O\u0003\u0002\n\u0015\u000511m\\7nSRT!a\u0003\u0007\u0002\r\rd\u0017.\u001a8u\u0015\tia\"\u0001\u0005dK2,'m\u001c:o\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0005j]R,'O\\1m\u0015\tyB\"\u0001\u0004d_6lwN\\\u0005\u0003Cq\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u0011\u0005)2o[3x\u0011\u0006tG\r\\5oOZ\u000bG.\u001b3bi>\u0014X#\u0001\u0015\u0011\u0005\u0015J\u0013B\u0001\u0016\t\u0005\u0019\n%m\u001d;sC\u000e$\b+\u0019:uSRLwN\\\"p[BdW\r^3oKN\u001ch+\u00197jI\u0006$xN]\u0001\u0017g.,w\u000fS1oI2Lgn\u001a,bY&$\u0017\r^8sA\u0005YB.Z4bGf\u001c6.Z<IC:$G.\u001b8h-\u0006d\u0017\u000eZ1u_J\fA\u0004\\3hC\u000eL8k[3x\u0011\u0006tG\r\\5oOZ\u000bG.\u001b3bi>\u0014\b%\u0001\u000bwC2LG-\u0019;f'V\u0014\u0007+\u0019:uSRLwN\u001c\u000b\ta\u00053\u0005J\u0013)S)B!Q#M\u001a7\u0013\t\u0011dC\u0001\u0004UkBdWM\r\t\u0003+QJ!!\u000e\f\u0003\u000f\t{w\u000e\\3b]B\u0011qG\u0010\b\u0003qq\u0002\"!\u000f\f\u000e\u0003iR!a\u000f\n\u0002\rq\u0012xn\u001c;?\u0013\tid#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f\u0017\u0011\u0015\u0011e\u00011\u0001D\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u0005U!\u0015BA#\u0017\u0005\rIe\u000e\u001e\u0005\u0006\u000f\u001a\u0001\raQ\u0001\u000egR\f'\u000f^'ba&sG-\u001a=\t\u000b%3\u0001\u0019A\"\u0002\u0017\u0015tG-T1q\u0013:$W\r\u001f\u0005\u0006\u0017\u001a\u0001\r\u0001T\u0001\u0015C\u000e$X/\u00197D_6l\u0017\u000e^'fi\u0006$\u0017\r^1\u0011\u00055sU\"\u0001\u0010\n\u0005=s\"AD\"p[6LG/T3uC\u0012\fG/\u0019\u0005\u0006#\u001a\u0001\r\u0001T\u0001\u0017Kb\u0004Xm\u0019;fI\u000e{W.\\5u\u001b\u0016$\u0018\rZ1uC\")1K\u0002a\u0001\u0007\u0006\tS\r\u001f9fGR,G\rV8uC2l\u0015\r\u001d9fe\u000e{WO\u001c;G_J\u0004\u0016M]3oi\")QK\u0002a\u0001g\u0005!3o[3x!\u0006\u0014H/\u001b;j_:D\u0015M\u001c3mS:<w+\u001b;i_V$X*\u00199SC:<W\r")
public class PartitionCompletenessValidator
implements Logging {
    private final AbstractPartitionCompletenessValidator skewHandlingValidator;
    private final AbstractPartitionCompletenessValidator legacySkewHandlingValidator;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        PartitionCompletenessValidator partitionCompletenessValidator = this;
        synchronized (partitionCompletenessValidator) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private AbstractPartitionCompletenessValidator skewHandlingValidator() {
        return this.skewHandlingValidator;
    }

    private AbstractPartitionCompletenessValidator legacySkewHandlingValidator() {
        return this.legacySkewHandlingValidator;
    }

    public Tuple2<Object, String> validateSubPartition(int partitionId, int startMapIndex, int endMapIndex, CommitMetadata actualCommitMetadata, CommitMetadata expectedCommitMetadata, int expectedTotalMapperCountForParent, boolean skewPartitionHandlingWithoutMapRange) {
        AbstractPartitionCompletenessValidator validator = skewPartitionHandlingWithoutMapRange ? this.skewHandlingValidator() : this.legacySkewHandlingValidator();
        Tuple2<Object, String> tuple2 = validator.processSubPartition(partitionId, startMapIndex, endMapIndex, actualCommitMetadata, expectedTotalMapperCountForParent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean successfullyProcessed = tuple2._1$mcZ$sp();
        String error = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)successfullyProcessed), (Object)error);
        boolean successfullyProcessed2 = tuple22._1$mcZ$sp();
        String error2 = (String)tuple22._2();
        if (!successfullyProcessed2) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)error2);
        }
        if (!validator.isPartitionComplete(partitionId)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"Partition is valid but still waiting for more data");
        }
        CommitMetadata currentCommitMetadata = validator.currentCommitMetadata(partitionId);
        if (!CommitMetadata.checkCommitMetadata(expectedCommitMetadata, currentCommitMetadata)) {
            String errorMsg = new StringBuilder(138).append("AQE Partition ").append(partitionId).append(" failed validation check").append("while processing range startMapIndex: ").append(startMapIndex).append(" endMapIndex: ").append(endMapIndex).append("ExpectedCommitMetadata ").append(expectedCommitMetadata).append(", ").append("ActualCommitMetadata ").append(currentCommitMetadata).append(", ").toString();
            this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> errorMsg);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)errorMsg);
        }
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(90).append("AQE Partition ").append(partitionId).append(" completed validation check , ").append("expectedCommitMetadata ").append(expectedCommitMetadata).append(", ").append("actualCommitMetadata ").append(currentCommitMetadata).toString());
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"Partition is complete");
    }

    public PartitionCompletenessValidator() {
        Logging.$init$(this);
        this.skewHandlingValidator = new SkewHandlingWithoutMapRangeValidator();
        this.legacySkewHandlingValidator = new LegacySkewHandlingPartitionValidator();
    }
}

