/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.fallback;

import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.plugin.flink.fallback.ShuffleFallbackPolicy;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaFallbackPolicy
implements ShuffleFallbackPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaFallbackPolicy.class);
    public static final QuotaFallbackPolicy INSTANCE = new QuotaFallbackPolicy();

    @Override
    public boolean needFallback(JobShuffleContext shuffleContext, CelebornConf celebornConf, LifecycleManager lifecycleManager) {
        boolean needFallback;
        if (!celebornConf.quotaEnabled()) {
            return false;
        }
        ControlMessages.CheckQuotaResponse response = lifecycleManager.checkQuota();
        boolean bl = needFallback = !response.isAvailable();
        if (needFallback) {
            LOG.warn("Quota exceeds for current user {}. Because {}", (Object)lifecycleManager.getUserIdentifier(), (Object)response.reason());
        }
        return needFallback;
    }
}

