
 -- Licensed to the Apache Software Foundation (ASF) under one or more
 -- contributor license agreements.  See the NOTICE file distributed with
 -- this work for additional information regarding copyright ownership.
 -- The ASF licenses this file to You under the Apache License, Version 2.0
 -- (the "License"); you may not use this file except in compliance with
 -- the License.  You may obtain a copy of the License at

 --    http://www.apache.org/licenses/LICENSE-2.0

 -- Unless required by applicable law or agreed to in writing, software
 -- distributed under the License is distributed on an "AS IS" BASIS,
 -- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 -- See the License for the specific language governing permissions and
 -- limitations under the License.

CREATE OR REPLACE TRANSIENT TABLE {ADBC_CATALOG}.{ADBC_SCHEMA}.{ADBC_TABLE} (
	NUMBERTYPE NUMBER(38,0),
	DECIMALTYPE NUMBER(18,1),
	NUMERICTYPE NUMBER(28,1),
	INTTYPE NUMBER(38,0),
	INTEGERTYPE NUMBER(38,0),
	BIGINTTYPE NUMBER(38,0),
	SMALLINTTYPE NUMBER(38,0),
	TINYINTTYPE NUMBER(38,0),
	BYTEINTTYPE NUMBER(38,0),
	FLOATTYPE FLOAT,
	FLOAT4TYPE FLOAT,
	FLOAT8TYPE FLOAT,
	DOUBLETYPE FLOAT,
	DOUBLEPRECISIONTYPE FLOAT,
	REALTYPE FLOAT,
	VARCHARTYPE VARCHAR(16777216),
	CHARTYPE VARCHAR(1),
	CHARACTERTYPE VARCHAR(1),
	STRINGTYPE VARCHAR(16777216),
	TEXTTYPE VARCHAR(16777216),
	BINARYTYPE BINARY(8388608),
	VARBINARYTYPE BINARY(8388608),
	BOOLEANTYPE BOOLEAN,
	DATETYPE DATE,
	DATETIMETYPE TIMESTAMP_NTZ(9),
	TIMETYPE TIME(9),
	TIMESTAMPTYPE TIMESTAMP_NTZ(9),
	TIMESTAMPLTZTYPE TIMESTAMP_LTZ(9),
	TIMESTAMPNTZTYPE TIMESTAMP_NTZ(9),
	TIMESTAMPTZTYPE TIMESTAMP_TZ(9)
);

INSERT INTO {ADBC_CATALOG}.{ADBC_SCHEMA}.{ADBC_TABLE}
(
    NUMBERTYPE, DECIMALTYPE, NUMERICTYPE, INTTYPE, INTEGERTYPE, BIGINTTYPE, SMALLINTTYPE, TINYINTTYPE,
    BYTEINTTYPE, FLOATTYPE, FLOAT4TYPE, FLOAT8TYPE, DOUBLETYPE, DOUBLEPRECISIONTYPE, REALTYPE, VARCHARTYPE,
    CHARTYPE, CHARACTERTYPE, STRINGTYPE, TEXTTYPE, BINARYTYPE, VARBINARYTYPE, BOOLEANTYPE, DATETYPE, DATETIMETYPE,
    TIMETYPE, TIMESTAMPTYPE, TIMESTAMPLTZTYPE, TIMESTAMPNTZTYPE, TIMESTAMPTZTYPE
)
VALUES
(
    1, 123.1, 123.1, 123, 123, 123, 123, 123,
    123, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 'Hello',
    'H', 'H', 'H', 'Hello World', to_binary('Hello World', 'UTF-8'), to_binary('Hello World', 'UTF-8'), TRUE, '2023-07-28', '2023-07-28 12:34:56',
    '12:34:56', '2023-07-28 12:34:56', '2023-07-28 12:34:56', '2023-07-28 12:34:56', '2023-07-28 12:34:56'
);

INSERT INTO {ADBC_CATALOG}.{ADBC_SCHEMA}.{ADBC_TABLE}
(
    NUMBERTYPE, DECIMALTYPE, NUMERICTYPE, INTTYPE, INTEGERTYPE, BIGINTTYPE, SMALLINTTYPE, TINYINTTYPE,
    BYTEINTTYPE, FLOATTYPE, FLOAT4TYPE, FLOAT8TYPE, DOUBLETYPE, DOUBLEPRECISIONTYPE, REALTYPE, VARCHARTYPE,
    CHARTYPE, CHARACTERTYPE, STRINGTYPE, TEXTTYPE, BINARYTYPE, VARBINARYTYPE, BOOLEANTYPE, DATETYPE, DATETIMETYPE,
    TIMETYPE, TIMESTAMPTYPE, TIMESTAMPLTZTYPE, TIMESTAMPNTZTYPE, TIMESTAMPTZTYPE
 )
 VALUES
 (
    12345678901234567890123456789012345678, 123.1, 123.1, 123, 123, 123, 123, 123,
    123, 123.45, 123.45, 123.45, 123.45, 123.45, 123.45, 'Hello',
    'H', 'H', 'H', 'Hello World', to_binary('Hello World', 'UTF-8'), to_binary('Hello World', 'UTF-8'), TRUE, '2023-07-28', '2023-07-28 12:34:56',
    '12:34:56', '2023-07-28 12:34:56', '2023-07-28 12:34:56', '2023-07-28 12:34:56', '2023-07-28 12:34:56'
 );
