/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq;

import jakarta.jms.Message;
import jakarta.jms.Session;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalDestinationPropagateStrategy
implements MessageCreatedStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(OriginalDestinationPropagateStrategy.class);

    public void onMessageCreated(Message message, Session session, Exchange exchange, Throwable cause) {
        JmsMessage msg;
        Message jms;
        if (exchange.getIn() instanceof JmsMessage && (jms = (msg = (JmsMessage)exchange.getIn(JmsMessage.class)).getJmsMessage()) instanceof ActiveMQMessage) {
            ActiveMQDestination from;
            ActiveMQMessage amq = (ActiveMQMessage)jms;
            if (message instanceof ActiveMQMessage && amq.getOriginalDestination() == null && (from = amq.getDestination()) != null) {
                LOG.trace("Setting OriginalDestination: {} on {}", (Object)from, (Object)message);
                ((ActiveMQMessage)message).setOriginalDestination(from);
            }
        }
    }
}

