/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

public class ReplicaUnderRecovery
extends LocalReplica {
    private LocalReplica original;
    private long recoveryId;

    public ReplicaUnderRecovery(ReplicaInfo replica, long recoveryId) {
        super(replica, replica.getVolume(), ((LocalReplica)replica).getDir());
        if (replica.getState() != HdfsServerConstants.ReplicaState.FINALIZED && replica.getState() != HdfsServerConstants.ReplicaState.RBW && replica.getState() != HdfsServerConstants.ReplicaState.RWR) {
            throw new IllegalArgumentException("Cannot recover replica: " + replica);
        }
        this.original = (LocalReplica)replica;
        this.recoveryId = recoveryId;
    }

    public ReplicaUnderRecovery(ReplicaUnderRecovery from) {
        super(from);
        this.original = (LocalReplica)from.getOriginalReplica();
        this.recoveryId = from.getRecoveryID();
    }

    @Override
    public long getRecoveryID() {
        return this.recoveryId;
    }

    @Override
    public void setRecoveryID(long recoveryId) {
        if (recoveryId <= this.recoveryId) {
            throw new IllegalArgumentException("The new recovery id: " + recoveryId + " must be greater than the current one: " + this.recoveryId);
        }
        this.recoveryId = recoveryId;
    }

    @Override
    public ReplicaInfo getOriginalReplica() {
        return this.original;
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.RUR;
    }

    @Override
    public long getVisibleLength() {
        return this.original.getVisibleLength();
    }

    @Override
    public long getBytesOnDisk() {
        return this.original.getBytesOnDisk();
    }

    public void setBlockId(long blockId) {
        super.setBlockId(blockId);
        this.original.setBlockId(blockId);
    }

    public void setGenerationStamp(long gs) {
        super.setGenerationStamp(gs);
        this.original.setGenerationStamp(gs);
    }

    public void setNumBytes(long numBytes) {
        super.setNumBytes(numBytes);
        this.original.setNumBytes(numBytes);
    }

    @Override
    public void updateWithReplica(StorageLocation replicaLocation) {
        super.updateWithReplica(replicaLocation);
        this.original.updateWithReplica(replicaLocation);
    }

    @Override
    void setVolume(FsVolumeSpi vol) {
        super.setVolume(vol);
        this.original.setVolume(vol);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + "\n  recoveryId=" + this.recoveryId + "\n  original=" + this.original;
    }

    @Override
    public ReplicaRecoveryInfo createInfo() {
        return new ReplicaRecoveryInfo(this.original.getBlockId(), this.original.getBytesOnDisk(), this.original.getGenerationStamp(), this.original.getState());
    }
}

