"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.pplOnTypeFormatProvider = exports.pplRangeFormatProvider = exports.formatPPLQuery = void 0;
function formatPPLQuery(query) {
    // Split by pipes and trim each segment
    const segments = query.split('|').map((seg) => seg.replace(/\s+/g, ' ').trim());
    // Rejoin with pipes at column 0
    return segments.join('\n| ');
}
exports.formatPPLQuery = formatPPLQuery;
exports.pplRangeFormatProvider = {
    provideDocumentRangeFormattingEdits(model, range) {
        const text = model.getValueInRange(range);
        const formatted = formatPPLQuery(text);
        return [
            {
                text: formatted,
                range,
            },
        ];
    },
};
exports.pplOnTypeFormatProvider = {
    autoFormatTriggerCharacters: ['|'],
    provideOnTypeFormattingEdits(model) {
        const fullRange = model.getFullModelRange();
        const text = model.getValue();
        const formatted = formatPPLQuery(text);
        return [
            {
                range: fullRange,
                text: formatted,
            },
        ];
    },
};
//# sourceMappingURL=formatter.js.map