/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.cluster.diskcleanup;

import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.store.StoreStats;
import org.opensearch.timeseries.util.ClientUtil;
import org.opensearch.transport.client.Client;

public class IndexCleanup {
    private static final Logger LOG = LogManager.getLogger(IndexCleanup.class);
    private final Client client;
    private final ClientUtil clientUtil;
    private final ClusterService clusterService;

    public IndexCleanup(Client client, ClientUtil clientUtil, ClusterService clusterService) {
        this.client = client;
        this.clientUtil = clientUtil;
        this.clusterService = clusterService;
    }

    public void deleteDocsBasedOnShardSize(String indexName, long maxShardSize, QueryBuilder queryForDeleteByQueryRequest, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
            LOG.debug("skip as the index:{} doesn't exist", (Object)indexName);
            return;
        }
        ActionListener indicesStatsResponseListener = ActionListener.wrap(indicesStatsResponse -> {
            boolean cleanupNeeded = Arrays.stream(indicesStatsResponse.getShards()).map(ShardStats::getStats).filter(Objects::nonNull).map(CommonStats::getStore).filter(Objects::nonNull).map(StoreStats::getSizeInBytes).anyMatch(size -> size > maxShardSize);
            if (cleanupNeeded) {
                this.deleteDocsByQuery(indexName, queryForDeleteByQueryRequest, (ActionListener<Long>)ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)false);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.getCheckpointShardStoreStats(indexName, (ActionListener<IndicesStatsResponse>)indicesStatsResponseListener);
    }

    private void getCheckpointShardStoreStats(String indexName, ActionListener<IndicesStatsResponse> listener) {
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.store();
        indicesStatsRequest.indices(new String[]{indexName});
        this.client.admin().indices().stats(indicesStatsRequest, listener);
    }

    public void deleteDocsByQuery(String indexName, QueryBuilder queryForDeleteByQueryRequest, ActionListener<Long> listener) {
        DeleteByQueryRequest deleteRequest = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{indexName}).setQuery(queryForDeleteByQueryRequest).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN).setRefresh(true);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.clientUtil.execute(DeleteByQueryAction.INSTANCE, deleteRequest, ActionListener.wrap(response -> {
                long deleted = response.getDeleted();
                if (deleted > 0L) {
                    LOG.info("{} docs are deleted for index:{}", (Object)deleted, (Object)indexName);
                }
                listener.onResponse((Object)response.getDeleted());
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

