/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.labelresolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.rule.MatchLabel;
import org.opensearch.rule.attribute_extractor.AttributeExtractor;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.storage.AttributeValueStore;
import org.opensearch.rule.storage.AttributeValueStoreFactory;

public class FeatureValueResolver {
    private final AttributeValueStoreFactory storeFactory;
    private final List<AttributeExtractor<String>> orderedExtractors;
    private final Map<Attribute, List<MatchLabel<String>>> matchLabelMap = new HashMap<Attribute, List<MatchLabel<String>>>();
    private Set<String> intersection = null;
    final float EPSILON = 1.0E-6f;

    public FeatureValueResolver(AttributeValueStoreFactory storeFactory, List<AttributeExtractor<String>> orderedExtractors) {
        this.storeFactory = storeFactory;
        this.orderedExtractors = orderedExtractors;
    }

    public Optional<String> resolve() {
        for (AttributeExtractor<String> extractor : this.orderedExtractors) {
            Attribute attr = extractor.getAttribute();
            AttributeValueStore store = this.storeFactory.getAttributeValueStore(attr);
            List matchLabels = attr.findAttributeMatches(extractor, store);
            this.matchLabelMap.put(attr, matchLabels);
            Set flattenedValues = matchLabels.stream().map(MatchLabel::getFeatureValue).collect(Collectors.toSet());
            if (this.intersection == null) {
                this.intersection = flattenedValues;
            } else {
                this.intersection.retainAll(flattenedValues);
            }
            if (!this.intersection.isEmpty()) continue;
            return Optional.empty();
        }
        if (this.intersection == null || this.intersection.isEmpty()) {
            return Optional.empty();
        }
        if (this.intersection.size() == 1) {
            String res = this.intersection.iterator().next();
            return Optional.of(res);
        }
        return this.breakTie();
    }

    private Optional<String> breakTie() {
        for (AttributeExtractor<String> extractor : this.orderedExtractors) {
            Set<String> nextIntersection = this.getTopScoringMatches(extractor.getAttribute());
            if (nextIntersection.size() == 1) {
                return Optional.of(nextIntersection.iterator().next());
            }
            this.intersection = nextIntersection;
        }
        return Optional.empty();
    }

    private Set<String> getTopScoringMatches(Attribute attribute) {
        HashSet<String> topValues = new HashSet<String>();
        List<MatchLabel<String>> matches = this.matchLabelMap.get(attribute);
        if (matches == null || matches.isEmpty()) {
            return topValues;
        }
        for (int i = 0; i < matches.size(); ++i) {
            MatchLabel<String> curr = matches.get(i);
            if (!this.intersection.contains(curr.getFeatureValue())) continue;
            float topScore = curr.getMatchScore();
            topValues.addAll(this.collectAllTopScoringValues(matches, i, topScore));
            break;
        }
        return topValues;
    }

    private Set<String> collectAllTopScoringValues(List<MatchLabel<String>> matches, int startIndex, float topScore) {
        MatchLabel<String> m;
        HashSet<String> values = new HashSet<String>();
        for (int j = startIndex; j < matches.size() && this.belongsToTopScoringGroup(m = matches.get(j), topScore); ++j) {
            values.add((String)m.getFeatureValue());
        }
        return values;
    }

    private boolean belongsToTopScoringGroup(MatchLabel<String> match, float topScore) {
        return this.intersection.contains(match.getFeatureValue()) && Math.abs(match.getMatchScore() - topScore) < 1.0E-6f;
    }
}

