/*
 * SPDX-FileCopyrightText: Copyright (c) 2021-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <core/core.h>
#include <gpu/gpu.h>
#include <gpu/eng_desc.h>
#include <g_allclasses.h>
#include <ctrl/ctrl0080/ctrl0080gpu.h> // NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_TU102(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALTU102_NUM_CLASS_DESCS (sizeof(halTU102ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALTU102_NUM_CLASSES 53

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALTU102_NUM_CLASSES);

    *pNumClassDescriptors = HALTU102_NUM_CLASS_DESCS;
    return halTU102ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_TU104(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU104ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALTU104_NUM_CLASS_DESCS (sizeof(halTU104ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALTU104_NUM_CLASSES 53

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALTU104_NUM_CLASSES);

    *pNumClassDescriptors = HALTU104_NUM_CLASS_DESCS;
    return halTU104ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_TU106(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU106ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALTU106_NUM_CLASS_DESCS (sizeof(halTU106ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALTU106_NUM_CLASSES 53

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALTU106_NUM_CLASSES);

    *pNumClassDescriptors = HALTU106_NUM_CLASS_DESCS;
    return halTU106ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_TU116(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU116ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALTU116_NUM_CLASS_DESCS (sizeof(halTU116ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALTU116_NUM_CLASSES 53

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALTU116_NUM_CLASSES);

    *pNumClassDescriptors = HALTU116_NUM_CLASS_DESCS;
    return halTU116ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_TU117(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halTU117ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVB4B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC371_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC4B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC570_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC573_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC57A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC57B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC57E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_A, ENG_GR(0) },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_COMPUTE_A, ENG_GR(0) },
        { TURING_DMA_COPY_A, ENG_CE(0) },
        { TURING_DMA_COPY_A, ENG_CE(1) },
        { TURING_DMA_COPY_A, ENG_CE(2) },
        { TURING_DMA_COPY_A, ENG_CE(3) },
        { TURING_DMA_COPY_A, ENG_CE(4) },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALTU117_NUM_CLASS_DESCS (sizeof(halTU117ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALTU117_NUM_CLASSES 53

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALTU117_NUM_CLASSES);

    *pNumClassDescriptors = HALTU117_NUM_CLASS_DESCS;
    return halTU117ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GA100(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA100ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_A, ENG_GR(0) },
        { AMPERE_COMPUTE_A, ENG_GR(1) },
        { AMPERE_COMPUTE_A, ENG_GR(2) },
        { AMPERE_COMPUTE_A, ENG_GR(3) },
        { AMPERE_COMPUTE_A, ENG_GR(4) },
        { AMPERE_COMPUTE_A, ENG_GR(5) },
        { AMPERE_COMPUTE_A, ENG_GR(6) },
        { AMPERE_COMPUTE_A, ENG_GR(7) },
        { AMPERE_DMA_COPY_A, ENG_CE(0) },
        { AMPERE_DMA_COPY_A, ENG_CE(1) },
        { AMPERE_DMA_COPY_A, ENG_CE(2) },
        { AMPERE_DMA_COPY_A, ENG_CE(3) },
        { AMPERE_DMA_COPY_A, ENG_CE(4) },
        { AMPERE_DMA_COPY_A, ENG_CE(5) },
        { AMPERE_DMA_COPY_A, ENG_CE(6) },
        { AMPERE_DMA_COPY_A, ENG_CE(7) },
        { AMPERE_DMA_COPY_A, ENG_CE(8) },
        { AMPERE_DMA_COPY_A, ENG_CE(9) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC4D1_VIDEO_NVJPG, ENG_NVJPG },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC6B0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVC6FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGA100_NUM_CLASS_DESCS (sizeof(halGA100ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGA100_NUM_CLASSES 47

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGA100_NUM_CLASSES);

    *pNumClassDescriptors = HALGA100_NUM_CLASS_DESCS;
    return halGA100ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GA102(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGA102_NUM_CLASS_DESCS (sizeof(halGA102ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGA102_NUM_CLASSES 59

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGA102_NUM_CLASSES);

    *pNumClassDescriptors = HALGA102_NUM_CLASS_DESCS;
    return halGA102ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GA103(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA103ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGA103_NUM_CLASS_DESCS (sizeof(halGA103ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGA103_NUM_CLASSES 59

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGA103_NUM_CLASSES);

    *pNumClassDescriptors = HALGA103_NUM_CLASS_DESCS;
    return halGA103ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GA104(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA104ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGA104_NUM_CLASS_DESCS (sizeof(halGA104ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGA104_NUM_CLASSES 59

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGA104_NUM_CLASSES);

    *pNumClassDescriptors = HALGA104_NUM_CLASS_DESCS;
    return halGA104ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GA106(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA106ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGA106_NUM_CLASS_DESCS (sizeof(halGA106ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGA106_NUM_CLASSES 59

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGA106_NUM_CLASSES);

    *pNumClassDescriptors = HALGA106_NUM_CLASS_DESCS;
    return halGA106ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GA107(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGA107ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_B, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_COMPUTE_B, ENG_GR(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC670_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC671_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC673_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC7B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC7B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC7FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGA107_NUM_CLASS_DESCS (sizeof(halGA107ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGA107_NUM_CLASSES 59

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGA107_NUM_CLASSES);

    *pNumClassDescriptors = HALGA107_NUM_CLASS_DESCS;
    return halGA107ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_AD102(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALAD102_NUM_CLASS_DESCS (sizeof(halAD102ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALAD102_NUM_CLASSES 62

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALAD102_NUM_CLASSES);

    *pNumClassDescriptors = HALAD102_NUM_CLASS_DESCS;
    return halAD102ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_AD103(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD103ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALAD103_NUM_CLASS_DESCS (sizeof(halAD103ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALAD103_NUM_CLASSES 62

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALAD103_NUM_CLASSES);

    *pNumClassDescriptors = HALAD103_NUM_CLASS_DESCS;
    return halAD103ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_AD104(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD104ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALAD104_NUM_CLASS_DESCS (sizeof(halAD104ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALAD104_NUM_CLASSES 62

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALAD104_NUM_CLASSES);

    *pNumClassDescriptors = HALAD104_NUM_CLASS_DESCS;
    return halAD104ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_AD106(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD106ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALAD106_NUM_CLASS_DESCS (sizeof(halAD106ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALAD106_NUM_CLASSES 62

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALAD106_NUM_CLASSES);

    *pNumClassDescriptors = HALAD106_NUM_CLASS_DESCS;
    return halAD106ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_AD107(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halAD107ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ADA_A, ENG_GR(0) },
        { ADA_COMPUTE_A, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_DMA_COPY_B, ENG_CE(0) },
        { AMPERE_DMA_COPY_B, ENG_CE(1) },
        { AMPERE_DMA_COPY_B, ENG_CE(2) },
        { AMPERE_DMA_COPY_B, ENG_CE(3) },
        { AMPERE_DMA_COPY_B, ENG_CE(4) },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC67A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC67B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC67E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC770_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC771_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC773_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC77D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVC9B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVC9B7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVC9D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVC9FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALAD107_NUM_CLASS_DESCS (sizeof(halAD107ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALAD107_NUM_CLASSES 62

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALAD107_NUM_CLASSES);

    *pNumClassDescriptors = HALAD107_NUM_CLASS_DESCS;
    return halAD107ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GH100(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGH100ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_A, ENG_GR(0) },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_COMPUTE_A, ENG_GR(0) },
        { HOPPER_COMPUTE_A, ENG_GR(1) },
        { HOPPER_COMPUTE_A, ENG_GR(2) },
        { HOPPER_COMPUTE_A, ENG_GR(3) },
        { HOPPER_COMPUTE_A, ENG_GR(4) },
        { HOPPER_COMPUTE_A, ENG_GR(5) },
        { HOPPER_COMPUTE_A, ENG_GR(6) },
        { HOPPER_COMPUTE_A, ENG_GR(7) },
        { HOPPER_DMA_COPY_A, ENG_CE(0) },
        { HOPPER_DMA_COPY_A, ENG_CE(1) },
        { HOPPER_DMA_COPY_A, ENG_CE(2) },
        { HOPPER_DMA_COPY_A, ENG_CE(3) },
        { HOPPER_DMA_COPY_A, ENG_CE(4) },
        { HOPPER_DMA_COPY_A, ENG_CE(5) },
        { HOPPER_DMA_COPY_A, ENG_CE(6) },
        { HOPPER_DMA_COPY_A, ENG_CE(7) },
        { HOPPER_DMA_COPY_A, ENG_CE(8) },
        { HOPPER_DMA_COPY_A, ENG_CE(9) },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { KEPLER_INLINE_TO_MEMORY_B, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(5) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(6) },
        { NVB8B0_VIDEO_DECODER, ENG_NVDEC(7) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(4) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(5) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(6) },
        { NVB8D1_VIDEO_NVJPG, ENG_NVJPEG(7) },
        { NVB8FA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGH100_NUM_CLASS_DESCS (sizeof(halGH100ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGH100_NUM_CLASSES 50

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGH100_NUM_CLASSES);

    *pNumClassDescriptors = HALGH100_NUM_CLASS_DESCS;
    return halGH100ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB100(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB100ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(10) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(11) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(12) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(13) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(14) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(15) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(16) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(17) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(18) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(19) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(5) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(6) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(7) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(4) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(5) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(6) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(7) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(1) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB100_NUM_CLASS_DESCS (sizeof(halGB100ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB100_NUM_CLASSES 51

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB100_NUM_CLASSES);

    *pNumClassDescriptors = HALGB100_NUM_CLASS_DESCS;
    return halGB100ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB102(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB102ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB102_NUM_CLASS_DESCS (sizeof(halGB102ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB102_NUM_CLASSES 51

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB102_NUM_CLASSES);

    *pNumClassDescriptors = HALGB102_NUM_CLASS_DESCS;
    return halGB102ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB10B(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB10BClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_SYNCPOINT, ENG_KERNEL_DISPLAY },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC970_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVC971_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVC973_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVC97A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVC97B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC97D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVC97E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB10B_NUM_CLASS_DESCS (sizeof(halGB10BClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB10B_NUM_CLASSES 64

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB10B_NUM_CLASSES);

    *pNumClassDescriptors = HALGB10B_NUM_CLASS_DESCS;
    return halGB10BClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB110(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB110ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(10) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(11) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(12) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(13) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(14) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(15) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(16) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(17) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(18) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(19) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(4) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(5) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(6) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(7) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(4) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(5) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(6) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(7) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(1) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB110_NUM_CLASS_DESCS (sizeof(halGB110ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB110_NUM_CLASSES 51

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB110_NUM_CLASSES);

    *pNumClassDescriptors = HALGB110_NUM_CLASS_DESCS;
    return halGB110ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB112(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB112ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_A, ENG_GR(0) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_A, ENG_GR(0) },
        { BLACKWELL_COMPUTE_A, ENG_GR(1) },
        { BLACKWELL_COMPUTE_A, ENG_GR(2) },
        { BLACKWELL_COMPUTE_A, ENG_GR(3) },
        { BLACKWELL_COMPUTE_A, ENG_GR(4) },
        { BLACKWELL_COMPUTE_A, ENG_GR(5) },
        { BLACKWELL_COMPUTE_A, ENG_GR(6) },
        { BLACKWELL_COMPUTE_A, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(8) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(9) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCDB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCDD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCDFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB112_NUM_CLASS_DESCS (sizeof(halGB112ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB112_NUM_CLASSES 51

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB112_NUM_CLASSES);

    *pNumClassDescriptors = HALGB112_NUM_CLASS_DESCS;
    return halGB112ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB202(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB202ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(3) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(2) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(3) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(2) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(3) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB202_NUM_CLASS_DESCS (sizeof(halGB202ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB202_NUM_CLASSES 68

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB202_NUM_CLASSES);

    *pNumClassDescriptors = HALGB202_NUM_CLASS_DESCS;
    return halGB202ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB203(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB203ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(1) },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(2) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(1) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(1) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB203_NUM_CLASS_DESCS (sizeof(halGB203ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB203_NUM_CLASSES 68

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB203_NUM_CLASSES);

    *pNumClassDescriptors = HALGB203_NUM_CLASS_DESCS;
    return halGB203ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB205(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB205ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB205_NUM_CLASS_DESCS (sizeof(halGB205ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB205_NUM_CLASSES 68

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB205_NUM_CLASSES);

    *pNumClassDescriptors = HALGB205_NUM_CLASS_DESCS;
    return halGB205ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB206(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB206ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFD1_VIDEO_NVJPG, ENG_NVJPEG(0) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB206_NUM_CLASS_DESCS (sizeof(halGB206ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB206_NUM_CLASSES 68

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB206_NUM_CLASSES);

    *pNumClassDescriptors = HALGB206_NUM_CLASS_DESCS;
    return halGB206ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB207(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB207ClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_LOCAL_USER, ENG_SW },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCFB0_VIDEO_DECODER, ENG_NVDEC(0) },
        { NVCFB7_VIDEO_ENCODER, ENG_NVENC(0) },
        { NVCFFA_VIDEO_OFA, ENG_OFA(0) },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB207_NUM_CLASS_DESCS (sizeof(halGB207ClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB207_NUM_CLASSES 67

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB207_NUM_CLASSES);

    *pNumClassDescriptors = HALGB207_NUM_CLASS_DESCS;
    return halGB207ClassDescriptorList;
}



const CLASSDESCRIPTOR *
gpuGetClassDescriptorList_GB20B(POBJGPU pGpu, NvU32 *pNumClassDescriptors)
{
    static const CLASSDESCRIPTOR halGB20BClassDescriptorList[] = {
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(0) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(1) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(2) },
        { ACCESS_COUNTER_NOTIFY_BUFFER, ENG_GR(3) },
        { AMPERE_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { AMPERE_USERMODE_A, ENG_GPU },
        { BLACKWELL_B, ENG_GR(0) },
        { BLACKWELL_B, ENG_GR(1) },
        { BLACKWELL_B, ENG_GR(2) },
        { BLACKWELL_B, ENG_GR(3) },
        { BLACKWELL_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { BLACKWELL_CHANNEL_GPFIFO_B, ENG_KERNEL_FIFO },
        { BLACKWELL_COMPUTE_B, ENG_GR(0) },
        { BLACKWELL_COMPUTE_B, ENG_GR(1) },
        { BLACKWELL_COMPUTE_B, ENG_GR(2) },
        { BLACKWELL_COMPUTE_B, ENG_GR(3) },
        { BLACKWELL_COMPUTE_B, ENG_GR(4) },
        { BLACKWELL_COMPUTE_B, ENG_GR(5) },
        { BLACKWELL_COMPUTE_B, ENG_GR(6) },
        { BLACKWELL_COMPUTE_B, ENG_GR(7) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_A, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(0) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(1) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(2) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(3) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(4) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(5) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(6) },
        { BLACKWELL_DMA_COPY_B, ENG_CE(7) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(0) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(1) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(2) },
        { BLACKWELL_INLINE_TO_MEMORY_A, ENG_GR(3) },
        { BLACKWELL_USERMODE_A, ENG_GPU },
        { FERMI_CONTEXT_SHARE_A, ENG_KERNEL_FIFO },
        { FERMI_TWOD_A, ENG_GR(0) },
        { FERMI_TWOD_A, ENG_GR(1) },
        { FERMI_TWOD_A, ENG_GR(2) },
        { FERMI_TWOD_A, ENG_GR(3) },
        { FERMI_VASPACE_A, ENG_DMA },
        { G84_PERFBUFFER, ENG_BUS },
        { GF100_DISP_SW, ENG_SW },
        { GF100_HDACODEC, ENG_HDACODEC },
        { GF100_SUBDEVICE_INFOROM, ENG_GPU },
        { GF100_SUBDEVICE_MASTER, ENG_GPU },
        { GF100_TIMED_SEMAPHORE_SW, ENG_SW },
        { GF100_ZBC_CLEAR, ENG_KERNEL_MEMORY_SYSTEM },
        { GP100_UVM_SW, ENG_SW },
        { HOPPER_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { HOPPER_SEC2_WORK_LAUNCH_A, ENG_SEC2 },
        { HOPPER_USERMODE_A, ENG_GPU },
        { KEPLER_CHANNEL_GROUP_A, ENG_KERNEL_FIFO },
        { KEPLER_DEVICE_VGPU, ENG_GPU },
        { MMU_FAULT_BUFFER, ENG_GR(0) },
        { MMU_FAULT_BUFFER, ENG_GR(1) },
        { MMU_FAULT_BUFFER, ENG_GR(2) },
        { MMU_FAULT_BUFFER, ENG_GR(3) },
        { NV0060_SYNC_GPU_BOOST, ENG_GPU },
        { NV01_MEMORY_VIRTUAL, ENG_DMA },
        { NV04_DISPLAY_COMMON, ENG_KERNEL_DISPLAY },
        { NV04_SOFTWARE_TEST, ENG_SW },
        { NV50_DEFERRED_API_CLASS, ENG_SW },
        { NV50_MEMORY_VIRTUAL, ENG_DMA },
        { NV50_P2P, ENG_BUS },
        { NV50_THIRD_PARTY_P2P, ENG_BUS },
        { NVA081_VGPU_CONFIG, ENG_GPU },
        { NVA084_KERNEL_HOST_VGPU_DEVICE, ENG_GPU },
        { NVC372_DISPLAY_SW, ENG_KERNEL_DISPLAY },
        { NVC77F_ANY_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCA71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCA73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCA7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCA7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCA7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCB70_DISPLAY, ENG_KERNEL_DISPLAY },
        { NVCB71_DISP_SF_USER, ENG_KERNEL_DISPLAY },
        { NVCB73_DISP_CAPABILITIES, ENG_KERNEL_DISPLAY },
        { NVCB7A_CURSOR_IMM_CHANNEL_PIO, ENG_KERNEL_DISPLAY },
        { NVCB7B_WINDOW_IMM_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCB7D_CORE_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NVCB7E_WINDOW_CHANNEL_DMA, ENG_KERNEL_DISPLAY },
        { NV_CONFIDENTIAL_COMPUTE, ENG_CONF_COMPUTE },
        { RM_USER_SHARED_DATA, ENG_GPU },
        { TURING_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { TURING_USERMODE_A, ENG_GPU },
        { VOLTA_CHANNEL_GPFIFO_A, ENG_KERNEL_FIFO },
        { VOLTA_USERMODE_A, ENG_GPU },
    };

    #define HALGB20B_NUM_CLASS_DESCS (sizeof(halGB20BClassDescriptorList) / sizeof(CLASSDESCRIPTOR))

    #define HALGB20B_NUM_CLASSES 75

    ct_assert(NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE >= HALGB20B_NUM_CLASSES);

    *pNumClassDescriptors = HALGB20B_NUM_CLASS_DESCS;
    return halGB20BClassDescriptorList;
}


