/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

public enum PostgreTablePersistence {
    PERMANENT('p', "TABLE"),
    UNLOGGED('u', "UNLOGGED TABLE"),
    TEMPORARY('t', "TEMP TABLE"),
    UNKNOWN('?', "?");

    private final char code;
    private final String tableType;

    private PostgreTablePersistence(char code, String tableType) {
        this.code = code;
        this.tableType = tableType;
    }

    public char getCode() {
        return this.code;
    }

    public static PostgreTablePersistence getByCode(String code) {
        return code != null && code.length() == 1 ? PostgreTablePersistence.getByCode(code.charAt(0)) : UNKNOWN;
    }

    public static PostgreTablePersistence getByCode(char pCode) {
        PostgreTablePersistence[] postgreTablePersistenceArray = PostgreTablePersistence.values();
        int n = postgreTablePersistenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgreTablePersistence pt = postgreTablePersistenceArray[n2];
            if (pt.getCode() == pCode) {
                return pt;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public String getTableTypeClause() {
        return this.tableType;
    }
}

