/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeSession;
import com.mysql.cj.ServerVersion;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.exceptions.AssertionFailedException;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.jdbc.DatabaseMetaDataInformationSchema;
import com.mysql.cj.jdbc.DatabaseMetaDataMysqlSchema;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.ResultSetFactory;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.a.result.ByteArrayRow;
import com.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import com.mysql.cj.result.DefaultColumnDefinition;
import com.mysql.cj.result.Field;
import com.mysql.cj.util.LRUCache;
import com.mysql.cj.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public abstract class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final List<String> MYSQL_KEYWORDS = Arrays.asList("ACCESSIBLE", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DENSE_RANK", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "EMPTY", "ENCLOSED", "ESCAPED", "EXCEPT", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FIRST_VALUE", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "FUNCTION", "GENERATED", "GET", "GRANT", "GROUP", "GROUPING", "GROUPS", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS", "IS", "ITERATE", "JOIN", "JSON_TABLE", "KEY", "KEYS", "KILL", "LAG", "LAST_VALUE", "LATERAL", "LEAD", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MANUAL", "MASTER_BIND", "MASTER_SSL_VERIFY_SERVER_CERT", "MATCH", "MAXVALUE", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NTH_VALUE", "NTILE", "NULL", "NUMERIC", "OF", "ON", "OPTIMIZE", "OPTIMIZER_COSTS", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "OVER", "PARALLEL", "PARTITION", "PERCENT_RANK", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "QUALIFY", "RANGE", "RANK", "READ", "READS", "READ_WRITE", "REAL", "RECURSIVE", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESIGNAL", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "ROW", "ROWS", "ROW_NUMBER", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SIGNAL", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STORED", "STRAIGHT_JOIN", "SYSTEM", "TABLE", "TABLESAMPLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "VIRTUAL", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL");
    static final List<String> SQL2003_KEYWORDS = Arrays.asList("ABS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASENSITIVE", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOOLEAN", "BOTH", "BY", "CALL", "CALLED", "CARDINALITY", "CASCADED", "CASE", "CAST", "CEIL", "CEILING", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLECT", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONSTRAINT", "CONVERT", "CORR", "CORRESPONDING", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DENSE_RANK", "DEREF", "DESCRIBE", "DETERMINISTIC", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "END", "END-EXEC", "ESCAPE", "EVERY", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXP", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOAT", "FLOOR", "FOR", "FOREIGN", "FREE", "FROM", "FULL", "FUNCTION", "FUSION", "GET", "GLOBAL", "GRANT", "GROUP", "GROUPING", "HAVING", "HOLD", "HOUR", "IDENTITY", "IN", "INDICATOR", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "IS", "JOIN", "LANGUAGE", "LARGE", "LATERAL", "LEADING", "LEFT", "LIKE", "LN", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOWER", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MOD", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NO", "NONE", "NORMALIZE", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUT", "OUTER", "OVER", "OVERLAPS", "OVERLAY", "PARAMETER", "PARTITION", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "POSITION", "POWER", "PRECISION", "PREPARE", "PRIMARY", "PROCEDURE", "RANGE", "RANK", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELEASE", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "ROW_NUMBER", "SAVEPOINT", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SELECT", "SENSITIVE", "SESSION_USER", "SET", "SIMILAR", "SMALLINT", "SOME", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQRT", "START", "STATIC", "STDDEV_POP", "STDDEV_SAMP", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UESCAPE", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPPER", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VAR_POP", "VAR_SAMP", "WHEN", "WHENEVER", "WHERE", "WIDTH_BUCKET", "WINDOW", "WITH", "WITHIN", "WITHOUT", "YEAR");
    static final Lock KEYWORDS_CACHE_LOCK = new ReentrantLock();
    private static final ServerVersion DEFAULT_SERVER_VERSION = new ServerVersion(0, 0, 0);
    static Map<ServerVersion, String> keywordsCache = Collections.synchronizedMap(new LRUCache(10));
    static int MAX_BUFFER_SIZE = 65535;
    private final JdbcConnection conn;
    private final NativeSession session;
    private final ExceptionInterceptor exceptionInterceptor;
    private final ResultSetFactory resultSetFactory;
    private final String database;
    private final String quoteId;
    private final RuntimeProperty<PropertyDefinitions.DatabaseTerm> databaseTermProp;
    private final RuntimeProperty<Boolean> getProceduresReturnsFunctionsProp;
    private final RuntimeProperty<Boolean> noAccessToProcedureBodiesProp;
    private final RuntimeProperty<Boolean> nullDatabaseMeansCurrentProp;
    private final RuntimeProperty<Boolean> pedanticProp;
    private final RuntimeProperty<Boolean> tinyInt1IsBitProp;
    private final RuntimeProperty<Boolean> transformedBitIsBooleanProp;
    private final RuntimeProperty<Boolean> useHostsInPrivilegesProp;
    private final RuntimeProperty<Boolean> yearIsDateTypeProp;
    private String metaDataEncoding = null;
    private int metaDataCollationIndex = -1;

    protected static DatabaseMetaData getInstance(JdbcConnection conn, String database, ResultSetFactory resultSetFactory) throws SQLException {
        if (conn.getPropertySet().getBooleanProperty(PropertyKey.useInformationSchema).getValue().booleanValue()) {
            return new DatabaseMetaDataInformationSchema(conn, database, resultSetFactory);
        }
        return new DatabaseMetaDataMysqlSchema(conn, database, resultSetFactory);
    }

    DatabaseMetaData(JdbcConnection conn, String database, ResultSetFactory resultSetFactory) {
        this.conn = conn;
        this.session = (NativeSession)this.conn.getSession();
        this.exceptionInterceptor = this.conn.getExceptionInterceptor();
        this.database = this.normalizeIdentifierCase(database);
        this.resultSetFactory = resultSetFactory;
        this.quoteId = this.session.getIdentifierQuoteString();
        this.databaseTermProp = this.conn.getPropertySet().getEnumProperty(PropertyKey.databaseTerm);
        this.getProceduresReturnsFunctionsProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.getProceduresReturnsFunctions);
        this.noAccessToProcedureBodiesProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.noAccessToProcedureBodies);
        this.nullDatabaseMeansCurrentProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.nullDatabaseMeansCurrent);
        this.pedanticProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.pedantic);
        this.tinyInt1IsBitProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.tinyInt1isBit);
        this.transformedBitIsBooleanProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.transformedBitIsBoolean);
        this.useHostsInPrivilegesProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.useHostsInPrivileges);
        this.yearIsDateTypeProp = this.conn.getPropertySet().getBooleanProperty(PropertyKey.yearIsDateType);
    }

    JdbcConnection getJdbcConnection() {
        return this.conn;
    }

    NativeSession getSession() {
        return this.session;
    }

    ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    String getDatabase() {
        return this.database;
    }

    String getQuoteId() {
        return this.quoteId;
    }

    PropertyDefinitions.DatabaseTerm databaseTermValue() {
        return this.databaseTermProp.getValue();
    }

    Boolean getProceduresReturnsFunctionsValue() {
        return this.getProceduresReturnsFunctionsProp.getValue();
    }

    Boolean noAccessToProcedureBodiesValue() {
        return this.noAccessToProcedureBodiesProp.getValue();
    }

    Boolean nullDatabaseMeansCurrentValue() {
        return this.nullDatabaseMeansCurrentProp.getValue();
    }

    Boolean pedanticValue() {
        return this.pedanticProp.getValue();
    }

    Boolean tinyInt1IsBitValue() {
        return this.tinyInt1IsBitProp.getValue();
    }

    Boolean transformedBitIsBooleanValue() {
        return this.transformedBitIsBooleanProp.getValue();
    }

    Boolean useHostsInPrivilegesValue() {
        return this.useHostsInPrivilegesProp.getValue();
    }

    Boolean yearIsDateTypeValue() {
        return this.yearIsDateTypeProp.getValue();
    }

    public String getMetaDataEncoding() {
        return this.metaDataEncoding;
    }

    public void setMetaDataEncoding(String metadataEncoding) {
        this.metaDataEncoding = metadataEncoding;
    }

    public int getMetaDataCollationIndex() {
        return this.metaDataCollationIndex;
    }

    public void setMetadataCollationIndex(int metadataCollationIndex) {
        this.metaDataCollationIndex = metadataCollationIndex;
    }

    /*
     * Exception decompiling
     */
    PreparedStatement prepareMetaDataSafeStatement(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    byte[] s2b(String s) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            return StringUtils.getBytes(s, this.getMetaDataEncoding());
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
        }
    }

    byte[] n2b(Number n) {
        return n.toString().getBytes();
    }

    String normalizeIdentifierCase(String identifier) {
        if (identifier == null) {
            return null;
        }
        try {
            return this.storesLowerCaseIdentifiers() ? identifier.toLowerCase(Locale.ROOT) : identifier;
        }
        catch (SQLException e) {
            return identifier;
        }
    }

    String normalizeIdentifierQuoting(String identifier) {
        return this.pedanticValue() != false ? identifier : StringUtils.unquoteIdentifier(identifier, this.quoteId);
    }

    String quoteIdentifier(String identifier) {
        return StringUtils.quoteIdentifier(identifier, this.quoteId, true);
    }

    String chooseDatabaseTerm(String catalog, String schema) {
        String databaseName = this.chooseBasedOnDatabaseTerm(() -> catalog, () -> schema);
        if (databaseName == null && this.nullDatabaseMeansCurrentValue().booleanValue()) {
            return this.normalizeIdentifierCase(this.database);
        }
        return databaseName;
    }

    <T, E extends Exception> T chooseBasedOnDatabaseTerm(ThrowingSupplier<T, E> catalogChoice, ThrowingSupplier<T, E> schemaChoice) throws E {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.CATALOG ? catalogChoice.get() : schemaChoice.get();
    }

    private byte[][] getTypeInfo(String mysqlTypeName) throws SQLException {
        MysqlType mt = MysqlType.getByName(mysqlTypeName);
        byte[][] row = new byte[18][];
        row[0] = this.s2b(mysqlTypeName);
        row[1] = this.n2b(mt == MysqlType.YEAR && this.yearIsDateTypeValue() == false ? 5 : mt.getJdbcType());
        row[2] = this.n2b(mt.getPrecision() > Integer.MAX_VALUE ? Integer.MAX_VALUE : mt.getPrecision().intValue());
        switch (mt) {
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case BINARY: 
            case VARBINARY: 
            case CHAR: 
            case VARCHAR: 
            case ENUM: 
            case SET: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: 
            case GEOMETRY: 
            case VECTOR: 
            case UNKNOWN: {
                row[3] = this.s2b("'");
                row[4] = this.s2b("'");
                break;
            }
            default: {
                row[3] = this.s2b("");
                row[4] = this.s2b("");
            }
        }
        row[5] = this.s2b(mt.getCreateParams());
        row[6] = this.n2b(1);
        row[7] = this.s2b("true");
        row[8] = this.n2b(3);
        row[9] = this.s2b(mt.isAllowed(32) ? "true" : "false");
        row[10] = this.s2b("false");
        switch (mt) {
            case BIGINT: 
            case BIGINT_UNSIGNED: 
            case BOOLEAN: 
            case INT: 
            case INT_UNSIGNED: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: 
            case SMALLINT: 
            case SMALLINT_UNSIGNED: 
            case TINYINT: 
            case TINYINT_UNSIGNED: {
                row[11] = this.s2b("true");
                break;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: 
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                boolean supportsAutoIncrement = !this.session.versionMeetsMinimum(8, 4, 0);
                row[11] = supportsAutoIncrement ? this.s2b("true") : this.s2b("false");
                break;
            }
            default: {
                row[11] = this.s2b("false");
            }
        }
        row[12] = this.s2b(mt.getName());
        switch (mt) {
            case DOUBLE: 
            case DOUBLE_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                row[13] = this.s2b("-308");
                row[14] = this.s2b("308");
                break;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                row[13] = this.s2b("-38");
                row[14] = this.s2b("38");
                break;
            }
            default: {
                row[13] = this.s2b("0");
                row[14] = this.s2b("0");
            }
        }
        row[15] = this.s2b("0");
        row[16] = this.s2b("0");
        row[17] = this.s2b("10");
        return row;
    }

    Field[] createBestRowIdentifierFields() {
        Field[] fields = new Field[]{new Field("", "SCOPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 4), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_SIZE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "BUFFER_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "DECIMAL_DIGITS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 10), new Field("", "PSEUDO_COLUMN", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5)};
        return fields;
    }

    Field[] createCatalogsFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64)};
        return fields;
    }

    Field[] createColumnPrivilegesFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "GRANTOR", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "GRANTEE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PRIVILEGE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "IS_GRANTABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 3)};
        return fields;
    }

    Field[] createColumnsFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 5), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_SIZE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "DECIMAL_DIGITS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "NUM_PREC_RADIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "COLUMN_DEF", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "SQL_DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "SQL_DATETIME_SUB", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "CHAR_OCTET_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "IS_NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 3), new Field("", "SCOPE_CATALOG", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SCOPE_SCHEMA", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SCOPE_TABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SOURCE_DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 10), new Field("", "IS_AUTOINCREMENT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 3), new Field("", "IS_GENERATEDCOLUMN", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 3)};
        return fields;
    }

    Field[] createForeignKeysFields() {
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PKTABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PKTABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PKCOLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "FKTABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "FKTABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "FKTABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "FKCOLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "KEY_SEQ", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 2), new Field("", "UPDATE_RULE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 2), new Field("", "DELETE_RULE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 2), new Field("", "FK_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "PK_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "DEFERRABILITY", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 2)};
        return fields;
    }

    Field[] createFunctionColumnsFields() {
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "FUNCTION_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "FUNCTION_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "COLUMN_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "PRECISION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "SCALE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 12), new Field("", "RADIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 512), new Field("", "CHAR_OCTET_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 32), new Field("", "ORDINAL_POSITION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 32), new Field("", "IS_NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 12), new Field("", "SPECIFIC_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64)};
        return fields;
    }

    Field[] createFunctionsFields() {
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "FUNCTION_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "FUNCTION_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 512), new Field("", "FUNCTION_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "SPECIFIC_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return fields;
    }

    Field[] createIndexInfoFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "NON_UNIQUE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BOOLEAN, 4), new Field("", "INDEX_QUALIFIER", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 1), new Field("", "INDEX_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 4), new Field("", "ORDINAL_POSITION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 4), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "ASC_OR_DESC", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 1), new Field("", "CARDINALITY", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BIGINT, 20), new Field("", "PAGES", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BIGINT, 20), new Field("", "FILTER_CONDITION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 32)};
        return fields;
    }

    Field[] createPrimaryKeysFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "KEY_SEQ", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5), new Field("", "PK_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return fields;
    }

    Field[] createProcedureColumnsFields() {
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PROCEDURE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PROCEDURE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 4), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PRECISION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "SCALE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 12), new Field("", "RADIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 512), new Field("", "COLUMN_DEF", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 512), new Field("", "SQL_DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "SQL_DATETIME_SUB", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "CHAR_OCTET_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "ORDINAL_POSITION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "IS_NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 4), new Field("", "SPECIFIC_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return fields;
    }

    Field[] createProceduresFields() {
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PROCEDURE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PROCEDURE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "reserved1", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "reserved2", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "reserved3", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 0), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 512), new Field("", "PROCEDURE_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 6), new Field("", "SPECIFIC_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return fields;
    }

    Field[] createSchemasFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_CATALOG", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return fields;
    }

    Field[] createTablePrivilegesFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "GRANTOR", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "GRANTEE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "PRIVILEGE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "IS_GRANTABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 4)};
        return fields;
    }

    ColumnDefinition createTablesFields() {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TABLE_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 512), new Field("", "TYPE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TYPE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "SELF_REFERENCING_COL_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "REF_GENERATION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 0)};
        return new DefaultColumnDefinition(fields);
    }

    Field[] createVersionColumnsFields() {
        Field[] fields = new Field[]{new Field("", "SCOPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 5), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "COLUMN_SIZE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 16), new Field("", "BUFFER_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 16), new Field("", "DECIMAL_DIGITS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 16), new Field("", "PSEUDO_COLUMN", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5)};
        return fields;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TYPE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "ATTR_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 4), new Field("", "ATTR_TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "ATTR_SIZE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 4), new Field("", "DECIMAL_DIGITS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 32), new Field("", "NUM_PREC_RADIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 32), new Field("", "NULLABLE ", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 4), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 512), new Field("", "ATTR_DEF", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SQL_DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 4), new Field("", "SQL_DATETIME_SUB", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 4), new Field("", "CHAR_OCTET_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 32), new Field("", "ORDINAL_POSITION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 32), new Field("", "IS_NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 8), new Field("", "SCOPE_CATALOG", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SCOPE_SCHEMA", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SCOPE_TABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SOURCE_DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 4)};
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.chooseBasedOnDatabaseTerm(() -> "database", () -> "CATALOG");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Field[] fields = new Field[]{new Field("", "NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "MAX_LEN", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "DEFAULT_VALUE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 255), new Field("", "DESCRIPTION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 255)};
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.getServerVersion().getMajor();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.getServerVersion().getMinor();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.conn.getServerVersion().toString();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 4;
    }

    @Override
    public int getDriverMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    @Override
    public int getDriverMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "MySQL Connector/J";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "mysql-connector-j-9.6.0 (Revision: fdef61f4af21fa9e0ac334ff0664ec754c164cc0)";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.quoteId;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return MAX_BUFFER_SIZE - 4;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "COLUMN_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "COLUMN_SIZE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "DECIMAL_DIGITS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "NUM_PREC_RADIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "COLUMN_USAGE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 512), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 512), new Field("", "CHAR_OCTET_LENGTH", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 12), new Field("", "IS_NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 8)};
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.chooseBasedOnDatabaseTerm(() -> "", () -> "SCHEMA");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        String keywords = keywordsCache.get(DEFAULT_SERVER_VERSION);
        if (keywords != null) {
            return keywords;
        }
        KEYWORDS_CACHE_LOCK.lock();
        try {
            keywords = keywordsCache.get(DEFAULT_SERVER_VERSION);
            if (keywords != null) {
                String string = keywords;
                return string;
            }
            TreeSet<String> mysqlKeywordSet = new TreeSet<String>();
            mysqlKeywordSet.addAll(MYSQL_KEYWORDS);
            mysqlKeywordSet.removeAll(SQL2003_KEYWORDS);
            keywords = mysqlKeywordSet.stream().collect(Collectors.joining(","));
            keywordsCache.put(this.conn.getServerVersion(), keywords);
            String string = keywords;
            return string;
        }
        finally {
            KEYWORDS_CACHE_LOCK.unlock();
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,BIN,BIT_LENGTH,CHAR,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONV,ELT,EXPORT_SET,FIELD,FIND_IN_SET,HEX,INSERT,INSTR,LCASE,LEFT,LENGTH,LOAD_FILE,LOCATE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH,MID,OCT,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SPACE,STRCMP,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SUPERTABLE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TYPE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SUPERTYPE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SUPERTYPE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "SUPERTYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64)};
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
        Field[] fields = new Field[]{new Field("", "TABLE_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64)};
        rows.add(new ByteArrayRow(new byte[][]{TableType.LOCAL_TEMPORARY.asBytes()}, this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(new byte[][]{TableType.SYSTEM_TABLE.asBytes()}, this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(new byte[][]{TableType.SYSTEM_VIEW.asBytes()}, this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(new byte[][]{TableType.TABLE.asBytes()}, this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(new byte[][]{TableType.VIEW.asBytes()}, this.getExceptionInterceptor()));
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 5), new Field("", "PRECISION", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "LITERAL_PREFIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 8), new Field("", "LITERAL_SUFFIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 8), new Field("", "CREATE_PARAMS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "NULLABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5), new Field("", "CASE_SENSITIVE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BOOLEAN, 3), new Field("", "SEARCHABLE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 3), new Field("", "UNSIGNED_ATTRIBUTE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BOOLEAN, 3), new Field("", "FIXED_PREC_SCALE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BOOLEAN, 3), new Field("", "AUTO_INCREMENT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.BOOLEAN, 3), new Field("", "LOCAL_TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.CHAR, 64), new Field("", "MINIMUM_SCALE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5), new Field("", "MAXIMUM_SCALE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 5), new Field("", "SQL_DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "SQL_DATETIME_SUB", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "NUM_PREC_RADIX", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10)};
        ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
        rows.add(new ByteArrayRow(this.getTypeInfo("BIT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("TINYINT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("TINYINT UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("BIGINT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("BIGINT UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("LONG VARBINARY"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMBLOB"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("LONGBLOB"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("BLOB"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("VECTOR"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("VARBINARY"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("TINYBLOB"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("BINARY"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("LONG VARCHAR"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMTEXT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("LONGTEXT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("TEXT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("CHAR"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("ENUM"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("SET"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DECIMAL"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("NUMERIC"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("INTEGER"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("INT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMINT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("INTEGER UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("INT UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("MEDIUMINT UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("SMALLINT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("SMALLINT UNSIGNED"), this.getExceptionInterceptor()));
        if (!this.yearIsDateTypeValue().booleanValue()) {
            rows.add(new ByteArrayRow(this.getTypeInfo("YEAR"), this.getExceptionInterceptor()));
        }
        rows.add(new ByteArrayRow(this.getTypeInfo("FLOAT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE PRECISION"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("REAL"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DOUBLE PRECISION UNSIGNED"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("VARCHAR"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("TINYTEXT"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("BOOL"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DATE"), this.getExceptionInterceptor()));
        if (this.yearIsDateTypeValue().booleanValue()) {
            rows.add(new ByteArrayRow(this.getTypeInfo("YEAR"), this.getExceptionInterceptor()));
        }
        rows.add(new ByteArrayRow(this.getTypeInfo("TIME"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("DATETIME"), this.getExceptionInterceptor()));
        rows.add(new ByteArrayRow(this.getTypeInfo("TIMESTAMP"), this.getExceptionInterceptor()));
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TYPE_SCHEM", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "TYPE_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "CLASS_NAME", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 64), new Field("", "DATA_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.INT, 10), new Field("", "REMARKS", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.VARCHAR, 512), new Field("", "BASE_TYPE", this.metaDataCollationIndex, this.metaDataEncoding, MysqlType.SMALLINT, 10)};
        return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(new ArrayList(), new DefaultColumnDefinition(fields)));
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLException {
        if (this.useHostsInPrivilegesValue().booleanValue()) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.conn.getMetaDataSafeStatement();
                rs = stmt.executeQuery("SELECT USER()");
                rs.next();
                String string = rs.getString(1);
                return string;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {
                        AssertionFailedException.shouldNotHappen(ex);
                    }
                    rs = null;
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ex) {
                        AssertionFailedException.shouldNotHappen(ex);
                    }
                    stmt = null;
                }
            }
        }
        return this.conn.getUser();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.conn.getPropertySet().getBooleanProperty(PropertyKey.emulateLocators).getValue() == false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return !this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return !this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.CATALOG;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return MysqlType.supportsConvert(fromType, toType);
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.conn.getPropertySet().getBooleanProperty(PropertyKey.overrideSupportsIntegrityEnhancementFacility).getValue() != false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return !this.conn.lowerCaseTableNames();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return !this.conn.lowerCaseTableNames();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (!(type != 1003 && type != 1004 || concurrency != 1007 && concurrency != 1008)) {
            return true;
        }
        if (type == 1005) {
            return false;
        }
        throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.20"), "S1009", this.getExceptionInterceptor());
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.databaseTermValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException(Messages.getString("Common.UnableToUnwrap", new Object[]{iface.toString()}), "S1009", this.conn.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private static /* synthetic */ String lambda$prepareMetaDataSafeStatement$3() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$prepareMetaDataSafeStatement$2() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$prepareMetaDataSafeStatement$1() {
        return this.conn.getUser();
    }

    private /* synthetic */ String lambda$prepareMetaDataSafeStatement$0() {
        return this.conn.getDatabase();
    }

    static enum TableType {
        LOCAL_TEMPORARY("LOCAL TEMPORARY"),
        SYSTEM_TABLE("SYSTEM TABLE"),
        SYSTEM_VIEW("SYSTEM VIEW"),
        TABLE("TABLE", new String[]{"BASE TABLE"}),
        VIEW("VIEW"),
        UNKNOWN("UNKNOWN");

        private String name;
        private byte[] nameAsBytes;
        private String[] synonyms;

        private TableType(String tableTypeName) {
            this(tableTypeName, null);
        }

        private TableType(String tableTypeName, String[] tableTypeSynonyms) {
            this.name = tableTypeName;
            this.nameAsBytes = tableTypeName.getBytes();
            this.synonyms = tableTypeSynonyms;
        }

        String getName() {
            return this.name;
        }

        byte[] asBytes() {
            return this.nameAsBytes;
        }

        boolean equalsTo(String tableTypeName) {
            return this.name.equalsIgnoreCase(tableTypeName);
        }

        static TableType getTableTypeEqualTo(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.equalsTo(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }

        boolean compliesWith(String tableTypeName) {
            if (this.equalsTo(tableTypeName)) {
                return true;
            }
            if (this.synonyms != null) {
                for (String synonym : this.synonyms) {
                    if (!synonym.equalsIgnoreCase(tableTypeName)) continue;
                    return true;
                }
            }
            return false;
        }

        static TableType getTableTypeCompliantWith(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.compliesWith(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }
    }

    @FunctionalInterface
    static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

