/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.capsule;

import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyCapsuleNameMatchesNode
extends Node {
    public abstract boolean execute(Node var1, Object var2, Object var3);

    @Specialization
    static boolean compare(Node inliningTarget, Object name1, Object name2, @CachedLibrary(limit="2") InteropLibrary lib, @Cached ReadByteNode readByteNode) {
        try {
            if (name1 != null && lib.isNull(name1)) {
                name1 = null;
            }
            if (name2 != null && lib.isNull(name2)) {
                name2 = null;
            }
            if (name1 == null || name2 == null) {
                return name1 == name2;
            }
            if (lib.isPointer(name1) && lib.isPointer(name2) && lib.asPointer(name1) == lib.asPointer(name2)) {
                return true;
            }
            int i = 0;
            while (true) {
                byte b2;
                byte b1;
                if ((b1 = readByteNode.execute(inliningTarget, name1, i)) != (b2 = readByteNode.execute(inliningTarget, name2, i))) {
                    return false;
                }
                if (b1 == 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class ReadByteNode
    extends Node {
        ReadByteNode() {
        }

        public abstract byte execute(Node var1, Object var2, int var3);

        @Specialization
        static byte doManaged(CArrayWrappers.CByteArrayWrapper wrapper, int i) {
            byte[] bytes = wrapper.getByteArray();
            if (i < bytes.length) {
                return bytes[i];
            }
            return 0;
        }

        @Fallback
        static byte doNative(Object ptr, int i, @Cached(inline=false) CStructAccess.ReadByteNode readByteNode) {
            return readByteNode.readArrayElement(ptr, i);
        }
    }
}

