/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import java.lang.reflect.Field;
import java.util.Random;
import net.jpountz.util.Native;
import net.jpountz.util.Utils;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHash64;

public final class XXHashFactory {
    private static XXHashFactory NATIVE_INSTANCE;
    private static XXHashFactory JAVA_UNSAFE_INSTANCE;
    private static XXHashFactory JAVA_SAFE_INSTANCE;
    private final String impl;
    private final XXHash32 hash32;
    private final XXHash64 hash64;
    private final StreamingXXHash32.Factory streamingHash32Factory;
    private final StreamingXXHash64.Factory streamingHash64Factory;

    private static XXHashFactory instance(String string) {
        try {
            return new XXHashFactory(string);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static synchronized XXHashFactory nativeInstance() {
        if (NATIVE_INSTANCE == null) {
            NATIVE_INSTANCE = XXHashFactory.instance("JNI");
        }
        return NATIVE_INSTANCE;
    }

    public static synchronized XXHashFactory safeInstance() {
        if (JAVA_SAFE_INSTANCE == null) {
            JAVA_SAFE_INSTANCE = XXHashFactory.instance("JavaSafe");
        }
        return JAVA_SAFE_INSTANCE;
    }

    public static synchronized XXHashFactory unsafeInstance() {
        if (JAVA_UNSAFE_INSTANCE == null) {
            JAVA_UNSAFE_INSTANCE = XXHashFactory.instance("JavaUnsafe");
        }
        return JAVA_UNSAFE_INSTANCE;
    }

    public static XXHashFactory fastestJavaInstance() {
        if (Utils.isUnalignedAccessAllowed()) {
            try {
                return XXHashFactory.unsafeInstance();
            }
            catch (Throwable throwable) {
                return XXHashFactory.safeInstance();
            }
        }
        return XXHashFactory.safeInstance();
    }

    public static XXHashFactory fastestInstance() {
        if (Native.isLoaded() || Native.class.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            try {
                return XXHashFactory.nativeInstance();
            }
            catch (Throwable throwable) {
                return XXHashFactory.fastestJavaInstance();
            }
        }
        return XXHashFactory.fastestJavaInstance();
    }

    private static <T> T classInstance(String string) throws NoSuchFieldException, SecurityException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        ClassLoader classLoader = XXHashFactory.class.getClassLoader();
        classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        Class<?> clazz = classLoader.loadClass(string);
        Field field = clazz.getField("INSTANCE");
        return (T)field.get(null);
    }

    private XXHashFactory(String string) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.impl = string;
        this.hash32 = (XXHash32)XXHashFactory.classInstance("net.jpountz.xxhash.XXHash32" + string);
        this.streamingHash32Factory = (StreamingXXHash32.Factory)XXHashFactory.classInstance("net.jpountz.xxhash.StreamingXXHash32" + string + "$Factory");
        this.hash64 = (XXHash64)XXHashFactory.classInstance("net.jpountz.xxhash.XXHash64" + string);
        this.streamingHash64Factory = (StreamingXXHash64.Factory)XXHashFactory.classInstance("net.jpountz.xxhash.StreamingXXHash64" + string + "$Factory");
        byte[] byArray = new byte[100];
        Random random = new Random();
        random.nextBytes(byArray);
        int n2 = random.nextInt();
        int n3 = this.hash32.hash(byArray, 0, byArray.length, n2);
        StreamingXXHash32 streamingXXHash32 = this.newStreamingHash32(n2);
        streamingXXHash32.update(byArray, 0, byArray.length);
        int n4 = streamingXXHash32.getValue();
        long l2 = this.hash64.hash(byArray, 0, byArray.length, (long)n2);
        StreamingXXHash64 streamingXXHash64 = this.newStreamingHash64(n2);
        streamingXXHash64.update(byArray, 0, byArray.length);
        long l3 = streamingXXHash64.getValue();
        if (n3 != n4) {
            throw new AssertionError();
        }
        if (l2 != l3) {
            throw new AssertionError();
        }
    }

    public XXHash32 hash32() {
        return this.hash32;
    }

    public XXHash64 hash64() {
        return this.hash64;
    }

    public StreamingXXHash32 newStreamingHash32(int n2) {
        return this.streamingHash32Factory.newStreamingHash(n2);
    }

    public StreamingXXHash64 newStreamingHash64(long l2) {
        return this.streamingHash64Factory.newStreamingHash(l2);
    }

    public static void main(String[] stringArray) {
        System.out.println("Fastest instance is " + XXHashFactory.fastestInstance());
        System.out.println("Fastest Java instance is " + XXHashFactory.fastestJavaInstance());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.impl;
    }
}

