REGISTER_OFFSETS = {
    ("x86", "eax"): 8,
    ("x86", "ax"): 8,
    ("x86", "al"): 8,
    ("x86", "ah"): 9,
    ("x86", "ecx"): 12,
    ("x86", "cx"): 12,
    ("x86", "cl"): 12,
    ("x86", "ch"): 13,
    ("x86", "edx"): 16,
    ("x86", "dx"): 16,
    ("x86", "dl"): 16,
    ("x86", "dh"): 17,
    ("x86", "ebx"): 20,
    ("x86", "bx"): 20,
    ("x86", "bl"): 20,
    ("x86", "bh"): 21,
    ("x86", "esp"): 24,
    ("x86", "sp"): 24,
    ("x86", "ebp"): 28,
    ("x86", "bp"): 28,
    ("x86", "esi"): 32,
    ("x86", "si"): 32,
    ("x86", "sil"): 32,
    ("x86", "sih"): 33,
    ("x86", "edi"): 36,
    ("x86", "di"): 36,
    ("x86", "dil"): 36,
    ("x86", "dih"): 37,
    ("x86", "cc_op"): 40,
    ("x86", "cc_dep1"): 44,
    ("x86", "cc_dep2"): 48,
    ("x86", "cc_ndep"): 52,
    ("x86", "d"): 56,
    ("x86", "dflag"): 56,
    ("x86", "id"): 60,
    ("x86", "idflag"): 60,
    ("x86", "ac"): 64,
    ("x86", "acflag"): 64,
    ("x86", "eip"): 68,
    ("x86", "ip"): 68,
    ("x86", "pc"): 68,
    ("x86", "fpreg"): 72,
    ("x86", "fpu_regs"): 72,
    ("x86", "mm0"): 72,
    ("x86", "mm1"): 80,
    ("x86", "mm2"): 88,
    ("x86", "mm3"): 96,
    ("x86", "mm4"): 104,
    ("x86", "mm5"): 112,
    ("x86", "mm6"): 120,
    ("x86", "mm7"): 128,
    ("x86", "fptag"): 136,
    ("x86", "fpu_tags"): 136,
    ("x86", "fpround"): 144,
    ("x86", "fc3210"): 148,
    ("x86", "ftop"): 152,
    ("x86", "sseround"): 156,
    ("x86", "xmm0"): 160,
    ("x86", "xmm1"): 176,
    ("x86", "xmm2"): 192,
    ("x86", "xmm3"): 208,
    ("x86", "xmm4"): 224,
    ("x86", "xmm5"): 240,
    ("x86", "xmm6"): 256,
    ("x86", "xmm7"): 272,
    ("x86", "cs"): 288,
    ("x86", "ds"): 290,
    ("x86", "es"): 292,
    ("x86", "fs"): 294,
    ("x86", "gs"): 296,
    ("x86", "ss"): 298,
    ("x86", "ldt"): 304,
    ("x86", "gdt"): 312,
    ("x86", "emnote"): 320,
    ("x86", "cmstart"): 324,
    ("x86", "cmlen"): 328,
    ("x86", "nraddr"): 332,
    ("x86", "sc_class"): 336,
    ("x86", "ip_at_syscall"): 340,
    ("amd64", "rax"): 16,
    ("amd64", "eax"): 16,
    ("amd64", "ax"): 16,
    ("amd64", "al"): 16,
    ("amd64", "ah"): 17,
    ("amd64", "rcx"): 24,
    ("amd64", "ecx"): 24,
    ("amd64", "cx"): 24,
    ("amd64", "cl"): 24,
    ("amd64", "ch"): 25,
    ("amd64", "rdx"): 32,
    ("amd64", "edx"): 32,
    ("amd64", "dx"): 32,
    ("amd64", "dl"): 32,
    ("amd64", "dh"): 33,
    ("amd64", "rbx"): 40,
    ("amd64", "ebx"): 40,
    ("amd64", "bx"): 40,
    ("amd64", "bl"): 40,
    ("amd64", "bh"): 41,
    ("amd64", "rsp"): 48,
    ("amd64", "sp"): 48,
    ("amd64", "esp"): 48,
    ("amd64", "rbp"): 56,
    ("amd64", "bp"): 56,
    ("amd64", "ebp"): 56,
    ("amd64", "_bp"): 56,
    ("amd64", "bpl"): 56,
    ("amd64", "bph"): 57,
    ("amd64", "rsi"): 64,
    ("amd64", "esi"): 64,
    ("amd64", "si"): 64,
    ("amd64", "sil"): 64,
    ("amd64", "sih"): 65,
    ("amd64", "rdi"): 72,
    ("amd64", "edi"): 72,
    ("amd64", "di"): 72,
    ("amd64", "dil"): 72,
    ("amd64", "dih"): 73,
    ("amd64", "r8"): 80,
    ("amd64", "r8d"): 80,
    ("amd64", "r8w"): 80,
    ("amd64", "r8b"): 80,
    ("amd64", "r9"): 88,
    ("amd64", "r9d"): 88,
    ("amd64", "r9w"): 88,
    ("amd64", "r9b"): 88,
    ("amd64", "r10"): 96,
    ("amd64", "r10d"): 96,
    ("amd64", "r10w"): 96,
    ("amd64", "r10b"): 96,
    ("amd64", "r11"): 104,
    ("amd64", "r11d"): 104,
    ("amd64", "r11w"): 104,
    ("amd64", "r11b"): 104,
    ("amd64", "r12"): 112,
    ("amd64", "r12d"): 112,
    ("amd64", "r12w"): 112,
    ("amd64", "r12b"): 112,
    ("amd64", "r13"): 120,
    ("amd64", "r13d"): 120,
    ("amd64", "r13w"): 120,
    ("amd64", "r13b"): 120,
    ("amd64", "r14"): 128,
    ("amd64", "r14d"): 128,
    ("amd64", "r14w"): 128,
    ("amd64", "r14b"): 128,
    ("amd64", "r15"): 136,
    ("amd64", "r15d"): 136,
    ("amd64", "r15w"): 136,
    ("amd64", "r15b"): 136,
    ("amd64", "cc_op"): 144,
    ("amd64", "cc_dep1"): 152,
    ("amd64", "cc_dep2"): 160,
    ("amd64", "cc_ndep"): 168,
    ("amd64", "d"): 176,
    ("amd64", "dflag"): 176,
    ("amd64", "rip"): 184,
    ("amd64", "ip"): 184,
    ("amd64", "pc"): 184,
    ("amd64", "ac"): 192,
    ("amd64", "acflag"): 192,
    ("amd64", "id"): 200,
    ("amd64", "idflag"): 200,
    ("amd64", "fs"): 208,
    ("amd64", "fs_const"): 208,
    ("amd64", "sseround"): 216,
    ("amd64", "cr0"): 768,
    ("amd64", "cr2"): 784,
    ("amd64", "cr3"): 792,
    ("amd64", "cr4"): 800,
    ("amd64", "cr8"): 832,
    ("amd64", "ymm0"): 224,
    ("amd64", "xmm0"): 224,
    ("amd64", "xmm0lq"): 224,
    ("amd64", "xmm0hq"): 232,
    ("amd64", "ymm0hx"): 240,
    ("amd64", "ymm1"): 256,
    ("amd64", "xmm1"): 256,
    ("amd64", "xmm1lq"): 256,
    ("amd64", "xmm1hq"): 264,
    ("amd64", "ymm1hx"): 272,
    ("amd64", "ymm2"): 288,
    ("amd64", "xmm2"): 288,
    ("amd64", "xmm2lq"): 288,
    ("amd64", "xmm2hq"): 296,
    ("amd64", "ymm2hx"): 304,
    ("amd64", "ymm3"): 320,
    ("amd64", "xmm3"): 320,
    ("amd64", "xmm3lq"): 320,
    ("amd64", "xmm3hq"): 328,
    ("amd64", "ymm3hx"): 336,
    ("amd64", "ymm4"): 352,
    ("amd64", "xmm4"): 352,
    ("amd64", "xmm4lq"): 352,
    ("amd64", "xmm4hq"): 360,
    ("amd64", "ymm4hx"): 368,
    ("amd64", "ymm5"): 384,
    ("amd64", "xmm5"): 384,
    ("amd64", "xmm5lq"): 384,
    ("amd64", "xmm5hq"): 392,
    ("amd64", "ymm5hx"): 400,
    ("amd64", "ymm6"): 416,
    ("amd64", "xmm6"): 416,
    ("amd64", "xmm6lq"): 416,
    ("amd64", "xmm6hq"): 424,
    ("amd64", "ymm6hx"): 432,
    ("amd64", "ymm7"): 448,
    ("amd64", "xmm7"): 448,
    ("amd64", "xmm7lq"): 448,
    ("amd64", "xmm7hq"): 456,
    ("amd64", "ymm7hx"): 464,
    ("amd64", "ymm8"): 480,
    ("amd64", "xmm8"): 480,
    ("amd64", "xmm8lq"): 480,
    ("amd64", "xmm8hq"): 488,
    ("amd64", "ymm8hx"): 496,
    ("amd64", "ymm9"): 512,
    ("amd64", "xmm9"): 512,
    ("amd64", "xmm9lq"): 512,
    ("amd64", "xmm9hq"): 520,
    ("amd64", "ymm9hx"): 528,
    ("amd64", "ymm10"): 544,
    ("amd64", "xmm10"): 544,
    ("amd64", "xmm10lq"): 544,
    ("amd64", "xmm10hq"): 552,
    ("amd64", "ymm10hx"): 560,
    ("amd64", "ymm11"): 576,
    ("amd64", "xmm11"): 576,
    ("amd64", "xmm11lq"): 576,
    ("amd64", "xmm11hq"): 584,
    ("amd64", "ymm11hx"): 592,
    ("amd64", "ymm12"): 608,
    ("amd64", "xmm12"): 608,
    ("amd64", "xmm12lq"): 608,
    ("amd64", "xmm12hq"): 616,
    ("amd64", "ymm12hx"): 624,
    ("amd64", "ymm13"): 640,
    ("amd64", "xmm13"): 640,
    ("amd64", "xmm13lq"): 640,
    ("amd64", "xmm13hq"): 648,
    ("amd64", "ymm13hx"): 656,
    ("amd64", "ymm14"): 672,
    ("amd64", "xmm14"): 672,
    ("amd64", "xmm14lq"): 672,
    ("amd64", "xmm14hq"): 680,
    ("amd64", "ymm14hx"): 688,
    ("amd64", "ymm15"): 704,
    ("amd64", "xmm15"): 704,
    ("amd64", "xmm15lq"): 704,
    ("amd64", "xmm15hq"): 712,
    ("amd64", "ymm15hx"): 720,
    ("amd64", "ftop"): 896,
    ("amd64", "fpreg"): 904,
    ("amd64", "fpu_regs"): 904,
    ("amd64", "mm0"): 904,
    ("amd64", "mm1"): 912,
    ("amd64", "mm2"): 920,
    ("amd64", "mm3"): 928,
    ("amd64", "mm4"): 936,
    ("amd64", "mm5"): 944,
    ("amd64", "mm6"): 952,
    ("amd64", "mm7"): 960,
    ("amd64", "fptag"): 968,
    ("amd64", "fpu_tags"): 968,
    ("amd64", "fpround"): 976,
    ("amd64", "fc3210"): 984,
    ("amd64", "emnote"): 992,
    ("amd64", "cmstart"): 1000,
    ("amd64", "cmlen"): 1008,
    ("amd64", "nraddr"): 1016,
    ("amd64", "gs"): 1032,
    ("amd64", "gs_const"): 1032,
    ("amd64", "ip_at_syscall"): 1040,
    ("amd64", "cs_seg"): 1048,
    ("amd64", "ds_seg"): 1050,
    ("amd64", "es_seg"): 1052,
    ("amd64", "fs_seg"): 1054,
    ("amd64", "gs_seg"): 1056,
    ("amd64", "ss_seg"): 1058,
    ("arm", "r0"): 8,
    ("arm", "a1"): 8,
    ("arm", "r1"): 12,
    ("arm", "a2"): 12,
    ("arm", "r2"): 16,
    ("arm", "a3"): 16,
    ("arm", "r3"): 20,
    ("arm", "a4"): 20,
    ("arm", "r4"): 24,
    ("arm", "v1"): 24,
    ("arm", "r5"): 28,
    ("arm", "v2"): 28,
    ("arm", "r6"): 32,
    ("arm", "v3"): 32,
    ("arm", "r7"): 36,
    ("arm", "v4"): 36,
    ("arm", "r8"): 40,
    ("arm", "v5"): 40,
    ("arm", "r9"): 44,
    ("arm", "v6"): 44,
    ("arm", "sb"): 44,
    ("arm", "r10"): 48,
    ("arm", "v7"): 48,
    ("arm", "sl"): 48,
    ("arm", "r11"): 52,
    ("arm", "v8"): 52,
    ("arm", "fp"): 52,
    ("arm", "bp"): 52,
    ("arm", "r12"): 56,
    ("arm", "sp"): 60,
    ("arm", "r13"): 60,
    ("arm", "lr"): 64,
    ("arm", "r14"): 64,
    ("arm", "pc"): 68,
    ("arm", "r15"): 68,
    ("arm", "ip"): 68,
    ("arm", "cc_op"): 72,
    ("arm", "cc_dep1"): 76,
    ("arm", "cc_dep2"): 80,
    ("arm", "cc_ndep"): 84,
    ("arm", "qflag32"): 88,
    ("arm", "geflag0"): 92,
    ("arm", "geflag1"): 96,
    ("arm", "geflag2"): 100,
    ("arm", "geflag3"): 104,
    ("arm", "emnote"): 108,
    ("arm", "cmstart"): 112,
    ("arm", "cmlen"): 116,
    ("arm", "nraddr"): 120,
    ("arm", "ip_at_syscall"): 124,
    ("arm", "d0"): 128,
    ("arm", "s0"): 128,
    ("arm", "s1"): 132,
    ("arm", "d1"): 136,
    ("arm", "s2"): 136,
    ("arm", "s3"): 140,
    ("arm", "d2"): 144,
    ("arm", "s4"): 144,
    ("arm", "s5"): 148,
    ("arm", "d3"): 152,
    ("arm", "s6"): 152,
    ("arm", "s7"): 156,
    ("arm", "d4"): 160,
    ("arm", "s8"): 160,
    ("arm", "s9"): 164,
    ("arm", "d5"): 168,
    ("arm", "s10"): 168,
    ("arm", "s11"): 172,
    ("arm", "d6"): 176,
    ("arm", "s12"): 176,
    ("arm", "s13"): 180,
    ("arm", "d7"): 184,
    ("arm", "s14"): 184,
    ("arm", "s15"): 188,
    ("arm", "d8"): 192,
    ("arm", "s16"): 192,
    ("arm", "s17"): 196,
    ("arm", "d9"): 200,
    ("arm", "s18"): 200,
    ("arm", "s19"): 204,
    ("arm", "d10"): 208,
    ("arm", "s20"): 208,
    ("arm", "s21"): 212,
    ("arm", "d11"): 216,
    ("arm", "s22"): 216,
    ("arm", "s23"): 220,
    ("arm", "d12"): 224,
    ("arm", "s24"): 224,
    ("arm", "s25"): 228,
    ("arm", "d13"): 232,
    ("arm", "s26"): 232,
    ("arm", "s27"): 236,
    ("arm", "d14"): 240,
    ("arm", "s28"): 240,
    ("arm", "s29"): 244,
    ("arm", "d15"): 248,
    ("arm", "s30"): 248,
    ("arm", "s31"): 252,
    ("arm", "d16"): 256,
    ("arm", "d17"): 264,
    ("arm", "d18"): 272,
    ("arm", "d19"): 280,
    ("arm", "d20"): 288,
    ("arm", "d21"): 296,
    ("arm", "d22"): 304,
    ("arm", "d23"): 312,
    ("arm", "d24"): 320,
    ("arm", "d25"): 328,
    ("arm", "d26"): 336,
    ("arm", "d27"): 344,
    ("arm", "d28"): 352,
    ("arm", "d29"): 360,
    ("arm", "d30"): 368,
    ("arm", "d31"): 376,
    ("arm", "fpscr"): 384,
    ("arm", "tpidruro"): 388,
    ("arm", "itstate"): 392,
    ("arm64", "x0"): 16,
    ("arm64", "r0"): 16,
    ("arm64", "w0"): 16,
    ("arm64", "x1"): 24,
    ("arm64", "r1"): 24,
    ("arm64", "w1"): 24,
    ("arm64", "x2"): 32,
    ("arm64", "r2"): 32,
    ("arm64", "w2"): 32,
    ("arm64", "x3"): 40,
    ("arm64", "r3"): 40,
    ("arm64", "w3"): 40,
    ("arm64", "x4"): 48,
    ("arm64", "r4"): 48,
    ("arm64", "w4"): 48,
    ("arm64", "x5"): 56,
    ("arm64", "r5"): 56,
    ("arm64", "w5"): 56,
    ("arm64", "x6"): 64,
    ("arm64", "r6"): 64,
    ("arm64", "w6"): 64,
    ("arm64", "x7"): 72,
    ("arm64", "r7"): 72,
    ("arm64", "w7"): 72,
    ("arm64", "x8"): 80,
    ("arm64", "r8"): 80,
    ("arm64", "w8"): 80,
    ("arm64", "x9"): 88,
    ("arm64", "r9"): 88,
    ("arm64", "w9"): 88,
    ("arm64", "x10"): 96,
    ("arm64", "r10"): 96,
    ("arm64", "w10"): 96,
    ("arm64", "x11"): 104,
    ("arm64", "r11"): 104,
    ("arm64", "w11"): 104,
    ("arm64", "x12"): 112,
    ("arm64", "r12"): 112,
    ("arm64", "w12"): 112,
    ("arm64", "x13"): 120,
    ("arm64", "r13"): 120,
    ("arm64", "w13"): 120,
    ("arm64", "x14"): 128,
    ("arm64", "r14"): 128,
    ("arm64", "w14"): 128,
    ("arm64", "x15"): 136,
    ("arm64", "r15"): 136,
    ("arm64", "w15"): 136,
    ("arm64", "x16"): 144,
    ("arm64", "r16"): 144,
    ("arm64", "ip0"): 144,
    ("arm64", "w16"): 144,
    ("arm64", "x17"): 152,
    ("arm64", "r17"): 152,
    ("arm64", "ip1"): 152,
    ("arm64", "w17"): 152,
    ("arm64", "x18"): 160,
    ("arm64", "r18"): 160,
    ("arm64", "w18"): 160,
    ("arm64", "x19"): 168,
    ("arm64", "r19"): 168,
    ("arm64", "w19"): 168,
    ("arm64", "x20"): 176,
    ("arm64", "r20"): 176,
    ("arm64", "w20"): 176,
    ("arm64", "x21"): 184,
    ("arm64", "r21"): 184,
    ("arm64", "w21"): 184,
    ("arm64", "x22"): 192,
    ("arm64", "r22"): 192,
    ("arm64", "w22"): 192,
    ("arm64", "x23"): 200,
    ("arm64", "r23"): 200,
    ("arm64", "w23"): 200,
    ("arm64", "x24"): 208,
    ("arm64", "r24"): 208,
    ("arm64", "w24"): 208,
    ("arm64", "x25"): 216,
    ("arm64", "r25"): 216,
    ("arm64", "w25"): 216,
    ("arm64", "x26"): 224,
    ("arm64", "r26"): 224,
    ("arm64", "w26"): 224,
    ("arm64", "x27"): 232,
    ("arm64", "r27"): 232,
    ("arm64", "w27"): 232,
    ("arm64", "x28"): 240,
    ("arm64", "r28"): 240,
    ("arm64", "w28"): 240,
    ("arm64", "x29"): 248,
    ("arm64", "r29"): 248,
    ("arm64", "fp"): 248,
    ("arm64", "bp"): 248,
    ("arm64", "w29"): 248,
    ("arm64", "x30"): 256,
    ("arm64", "r30"): 256,
    ("arm64", "lr"): 256,
    ("arm64", "w30"): 256,
    ("arm64", "xsp"): 264,
    ("arm64", "sp"): 264,
    ("arm64", "wsp"): 264,
    ("arm64", "pc"): 272,
    ("arm64", "ip"): 272,
    ("arm64", "cc_op"): 280,
    ("arm64", "cc_dep1"): 288,
    ("arm64", "cc_dep2"): 296,
    ("arm64", "cc_ndep"): 304,
    ("arm64", "tpidr_el0"): 312,
    ("arm64", "q0"): 320,
    ("arm64", "v0"): 320,
    ("arm64", "d0"): 320,
    ("arm64", "s0"): 320,
    ("arm64", "h0"): 320,
    ("arm64", "b0"): 320,
    ("arm64", "q1"): 336,
    ("arm64", "v1"): 336,
    ("arm64", "d1"): 336,
    ("arm64", "s1"): 336,
    ("arm64", "h1"): 336,
    ("arm64", "b1"): 336,
    ("arm64", "q2"): 352,
    ("arm64", "v2"): 352,
    ("arm64", "d2"): 352,
    ("arm64", "s2"): 352,
    ("arm64", "h2"): 352,
    ("arm64", "b2"): 352,
    ("arm64", "q3"): 368,
    ("arm64", "v3"): 368,
    ("arm64", "d3"): 368,
    ("arm64", "s3"): 368,
    ("arm64", "h3"): 368,
    ("arm64", "b3"): 368,
    ("arm64", "q4"): 384,
    ("arm64", "v4"): 384,
    ("arm64", "d4"): 384,
    ("arm64", "s4"): 384,
    ("arm64", "h4"): 384,
    ("arm64", "b4"): 384,
    ("arm64", "q5"): 400,
    ("arm64", "v5"): 400,
    ("arm64", "d5"): 400,
    ("arm64", "s5"): 400,
    ("arm64", "h5"): 400,
    ("arm64", "b5"): 400,
    ("arm64", "q6"): 416,
    ("arm64", "v6"): 416,
    ("arm64", "d6"): 416,
    ("arm64", "s6"): 416,
    ("arm64", "h6"): 416,
    ("arm64", "b6"): 416,
    ("arm64", "q7"): 432,
    ("arm64", "v7"): 432,
    ("arm64", "d7"): 432,
    ("arm64", "s7"): 432,
    ("arm64", "h7"): 432,
    ("arm64", "b7"): 432,
    ("arm64", "q8"): 448,
    ("arm64", "v8"): 448,
    ("arm64", "d8"): 448,
    ("arm64", "s8"): 448,
    ("arm64", "h8"): 448,
    ("arm64", "b8"): 448,
    ("arm64", "q9"): 464,
    ("arm64", "v9"): 464,
    ("arm64", "d9"): 464,
    ("arm64", "s9"): 464,
    ("arm64", "h9"): 464,
    ("arm64", "b9"): 464,
    ("arm64", "q10"): 480,
    ("arm64", "v10"): 480,
    ("arm64", "d10"): 480,
    ("arm64", "s10"): 480,
    ("arm64", "h10"): 480,
    ("arm64", "b10"): 480,
    ("arm64", "q11"): 496,
    ("arm64", "v11"): 496,
    ("arm64", "d11"): 496,
    ("arm64", "s11"): 496,
    ("arm64", "h11"): 496,
    ("arm64", "b11"): 496,
    ("arm64", "q12"): 512,
    ("arm64", "v12"): 512,
    ("arm64", "d12"): 512,
    ("arm64", "s12"): 512,
    ("arm64", "h12"): 512,
    ("arm64", "b12"): 512,
    ("arm64", "q13"): 528,
    ("arm64", "v13"): 528,
    ("arm64", "d13"): 528,
    ("arm64", "s13"): 528,
    ("arm64", "h13"): 528,
    ("arm64", "b13"): 528,
    ("arm64", "q14"): 544,
    ("arm64", "v14"): 544,
    ("arm64", "d14"): 544,
    ("arm64", "s14"): 544,
    ("arm64", "h14"): 544,
    ("arm64", "b14"): 544,
    ("arm64", "q15"): 560,
    ("arm64", "v15"): 560,
    ("arm64", "d15"): 560,
    ("arm64", "s15"): 560,
    ("arm64", "h15"): 560,
    ("arm64", "b15"): 560,
    ("arm64", "q16"): 576,
    ("arm64", "v16"): 576,
    ("arm64", "d16"): 576,
    ("arm64", "s16"): 576,
    ("arm64", "h16"): 576,
    ("arm64", "b16"): 576,
    ("arm64", "q17"): 592,
    ("arm64", "v17"): 592,
    ("arm64", "d17"): 592,
    ("arm64", "s17"): 592,
    ("arm64", "h17"): 592,
    ("arm64", "b17"): 592,
    ("arm64", "q18"): 608,
    ("arm64", "v18"): 608,
    ("arm64", "d18"): 608,
    ("arm64", "s18"): 608,
    ("arm64", "h18"): 608,
    ("arm64", "b18"): 608,
    ("arm64", "q19"): 624,
    ("arm64", "v19"): 624,
    ("arm64", "d19"): 624,
    ("arm64", "s19"): 624,
    ("arm64", "h19"): 624,
    ("arm64", "b19"): 624,
    ("arm64", "q20"): 640,
    ("arm64", "v20"): 640,
    ("arm64", "d20"): 640,
    ("arm64", "s20"): 640,
    ("arm64", "h20"): 640,
    ("arm64", "b20"): 640,
    ("arm64", "q21"): 656,
    ("arm64", "v21"): 656,
    ("arm64", "d21"): 656,
    ("arm64", "s21"): 656,
    ("arm64", "h21"): 656,
    ("arm64", "b21"): 656,
    ("arm64", "q22"): 672,
    ("arm64", "v22"): 672,
    ("arm64", "d22"): 672,
    ("arm64", "s22"): 672,
    ("arm64", "h22"): 672,
    ("arm64", "b22"): 672,
    ("arm64", "q23"): 688,
    ("arm64", "v23"): 688,
    ("arm64", "d23"): 688,
    ("arm64", "s23"): 688,
    ("arm64", "h23"): 688,
    ("arm64", "b23"): 688,
    ("arm64", "q24"): 704,
    ("arm64", "v24"): 704,
    ("arm64", "d24"): 704,
    ("arm64", "s24"): 704,
    ("arm64", "h24"): 704,
    ("arm64", "b24"): 704,
    ("arm64", "q25"): 720,
    ("arm64", "v25"): 720,
    ("arm64", "d25"): 720,
    ("arm64", "s25"): 720,
    ("arm64", "h25"): 720,
    ("arm64", "b25"): 720,
    ("arm64", "q26"): 736,
    ("arm64", "v26"): 736,
    ("arm64", "d26"): 736,
    ("arm64", "s26"): 736,
    ("arm64", "h26"): 736,
    ("arm64", "b26"): 736,
    ("arm64", "q27"): 752,
    ("arm64", "v27"): 752,
    ("arm64", "d27"): 752,
    ("arm64", "s27"): 752,
    ("arm64", "h27"): 752,
    ("arm64", "b27"): 752,
    ("arm64", "q28"): 768,
    ("arm64", "v28"): 768,
    ("arm64", "d28"): 768,
    ("arm64", "s28"): 768,
    ("arm64", "h28"): 768,
    ("arm64", "b28"): 768,
    ("arm64", "q29"): 784,
    ("arm64", "v29"): 784,
    ("arm64", "d29"): 784,
    ("arm64", "s29"): 784,
    ("arm64", "h29"): 784,
    ("arm64", "b29"): 784,
    ("arm64", "q30"): 800,
    ("arm64", "v30"): 800,
    ("arm64", "d30"): 800,
    ("arm64", "s30"): 800,
    ("arm64", "h30"): 800,
    ("arm64", "b30"): 800,
    ("arm64", "q31"): 816,
    ("arm64", "v31"): 816,
    ("arm64", "d31"): 816,
    ("arm64", "s31"): 816,
    ("arm64", "h31"): 816,
    ("arm64", "b31"): 816,
    ("arm64", "qcflag"): 832,
    ("arm64", "emnote"): 848,
    ("arm64", "cmstart"): 856,
    ("arm64", "cmlen"): 864,
    ("arm64", "nraddr"): 872,
    ("arm64", "ip_at_syscall"): 880,
    ("arm64", "fpcr"): 888,
    ("ppc32", "gpr0"): 16,
    ("ppc32", "r0"): 16,
    ("ppc32", "gpr1"): 20,
    ("ppc32", "r1"): 20,
    ("ppc32", "sp"): 20,
    ("ppc32", "gpr2"): 24,
    ("ppc32", "r2"): 24,
    ("ppc32", "gpr3"): 28,
    ("ppc32", "r3"): 28,
    ("ppc32", "gpr4"): 32,
    ("ppc32", "r4"): 32,
    ("ppc32", "gpr5"): 36,
    ("ppc32", "r5"): 36,
    ("ppc32", "gpr6"): 40,
    ("ppc32", "r6"): 40,
    ("ppc32", "gpr7"): 44,
    ("ppc32", "r7"): 44,
    ("ppc32", "gpr8"): 48,
    ("ppc32", "r8"): 48,
    ("ppc32", "gpr9"): 52,
    ("ppc32", "r9"): 52,
    ("ppc32", "gpr10"): 56,
    ("ppc32", "r10"): 56,
    ("ppc32", "gpr11"): 60,
    ("ppc32", "r11"): 60,
    ("ppc32", "gpr12"): 64,
    ("ppc32", "r12"): 64,
    ("ppc32", "gpr13"): 68,
    ("ppc32", "r13"): 68,
    ("ppc32", "gpr14"): 72,
    ("ppc32", "r14"): 72,
    ("ppc32", "gpr15"): 76,
    ("ppc32", "r15"): 76,
    ("ppc32", "gpr16"): 80,
    ("ppc32", "r16"): 80,
    ("ppc32", "gpr17"): 84,
    ("ppc32", "r17"): 84,
    ("ppc32", "gpr18"): 88,
    ("ppc32", "r18"): 88,
    ("ppc32", "gpr19"): 92,
    ("ppc32", "r19"): 92,
    ("ppc32", "gpr20"): 96,
    ("ppc32", "r20"): 96,
    ("ppc32", "gpr21"): 100,
    ("ppc32", "r21"): 100,
    ("ppc32", "gpr22"): 104,
    ("ppc32", "r22"): 104,
    ("ppc32", "gpr23"): 108,
    ("ppc32", "r23"): 108,
    ("ppc32", "gpr24"): 112,
    ("ppc32", "r24"): 112,
    ("ppc32", "gpr25"): 116,
    ("ppc32", "r25"): 116,
    ("ppc32", "gpr26"): 120,
    ("ppc32", "r26"): 120,
    ("ppc32", "gpr27"): 124,
    ("ppc32", "r27"): 124,
    ("ppc32", "gpr28"): 128,
    ("ppc32", "r28"): 128,
    ("ppc32", "gpr29"): 132,
    ("ppc32", "r29"): 132,
    ("ppc32", "gpr30"): 136,
    ("ppc32", "r30"): 136,
    ("ppc32", "gpr31"): 140,
    ("ppc32", "r31"): 140,
    ("ppc32", "bp"): 140,
    ("ppc32", "vsr0"): 144,
    ("ppc32", "v0"): 144,
    ("ppc32", "fpr0"): 144,
    ("ppc32", "vsr1"): 160,
    ("ppc32", "v1"): 160,
    ("ppc32", "fpr1"): 160,
    ("ppc32", "vsr2"): 176,
    ("ppc32", "v2"): 176,
    ("ppc32", "fpr2"): 176,
    ("ppc32", "vsr3"): 192,
    ("ppc32", "v3"): 192,
    ("ppc32", "fpr3"): 192,
    ("ppc32", "vsr4"): 208,
    ("ppc32", "v4"): 208,
    ("ppc32", "fpr4"): 208,
    ("ppc32", "vsr5"): 224,
    ("ppc32", "v5"): 224,
    ("ppc32", "fpr5"): 224,
    ("ppc32", "vsr6"): 240,
    ("ppc32", "v6"): 240,
    ("ppc32", "fpr6"): 240,
    ("ppc32", "vsr7"): 256,
    ("ppc32", "v7"): 256,
    ("ppc32", "fpr7"): 256,
    ("ppc32", "vsr8"): 272,
    ("ppc32", "v8"): 272,
    ("ppc32", "fpr8"): 272,
    ("ppc32", "vsr9"): 288,
    ("ppc32", "v9"): 288,
    ("ppc32", "fpr9"): 288,
    ("ppc32", "vsr10"): 304,
    ("ppc32", "v10"): 304,
    ("ppc32", "fpr10"): 304,
    ("ppc32", "vsr11"): 320,
    ("ppc32", "v11"): 320,
    ("ppc32", "fpr11"): 320,
    ("ppc32", "vsr12"): 336,
    ("ppc32", "v12"): 336,
    ("ppc32", "fpr12"): 336,
    ("ppc32", "vsr13"): 352,
    ("ppc32", "v13"): 352,
    ("ppc32", "fpr13"): 352,
    ("ppc32", "vsr14"): 368,
    ("ppc32", "v14"): 368,
    ("ppc32", "fpr14"): 368,
    ("ppc32", "vsr15"): 384,
    ("ppc32", "v15"): 384,
    ("ppc32", "fpr15"): 384,
    ("ppc32", "vsr16"): 400,
    ("ppc32", "v16"): 400,
    ("ppc32", "fpr16"): 400,
    ("ppc32", "vsr17"): 416,
    ("ppc32", "v17"): 416,
    ("ppc32", "fpr17"): 416,
    ("ppc32", "vsr18"): 432,
    ("ppc32", "v18"): 432,
    ("ppc32", "fpr18"): 432,
    ("ppc32", "vsr19"): 448,
    ("ppc32", "v19"): 448,
    ("ppc32", "fpr19"): 448,
    ("ppc32", "vsr20"): 464,
    ("ppc32", "v20"): 464,
    ("ppc32", "fpr20"): 464,
    ("ppc32", "vsr21"): 480,
    ("ppc32", "v21"): 480,
    ("ppc32", "fpr21"): 480,
    ("ppc32", "vsr22"): 496,
    ("ppc32", "v22"): 496,
    ("ppc32", "fpr22"): 496,
    ("ppc32", "vsr23"): 512,
    ("ppc32", "v23"): 512,
    ("ppc32", "fpr23"): 512,
    ("ppc32", "vsr24"): 528,
    ("ppc32", "v24"): 528,
    ("ppc32", "fpr24"): 528,
    ("ppc32", "vsr25"): 544,
    ("ppc32", "v25"): 544,
    ("ppc32", "fpr25"): 544,
    ("ppc32", "vsr26"): 560,
    ("ppc32", "v26"): 560,
    ("ppc32", "fpr26"): 560,
    ("ppc32", "vsr27"): 576,
    ("ppc32", "v27"): 576,
    ("ppc32", "fpr27"): 576,
    ("ppc32", "vsr28"): 592,
    ("ppc32", "v28"): 592,
    ("ppc32", "fpr28"): 592,
    ("ppc32", "vsr29"): 608,
    ("ppc32", "v29"): 608,
    ("ppc32", "fpr29"): 608,
    ("ppc32", "vsr30"): 624,
    ("ppc32", "v30"): 624,
    ("ppc32", "fpr30"): 624,
    ("ppc32", "vsr31"): 640,
    ("ppc32", "v31"): 640,
    ("ppc32", "fpr31"): 640,
    ("ppc32", "vsr32"): 656,
    ("ppc32", "v32"): 656,
    ("ppc32", "vsr33"): 672,
    ("ppc32", "v33"): 672,
    ("ppc32", "vsr34"): 688,
    ("ppc32", "v34"): 688,
    ("ppc32", "vsr35"): 704,
    ("ppc32", "v35"): 704,
    ("ppc32", "vsr36"): 720,
    ("ppc32", "v36"): 720,
    ("ppc32", "vsr37"): 736,
    ("ppc32", "v37"): 736,
    ("ppc32", "vsr38"): 752,
    ("ppc32", "v38"): 752,
    ("ppc32", "vsr39"): 768,
    ("ppc32", "v39"): 768,
    ("ppc32", "vsr40"): 784,
    ("ppc32", "v40"): 784,
    ("ppc32", "vsr41"): 800,
    ("ppc32", "v41"): 800,
    ("ppc32", "vsr42"): 816,
    ("ppc32", "v42"): 816,
    ("ppc32", "vsr43"): 832,
    ("ppc32", "v43"): 832,
    ("ppc32", "vsr44"): 848,
    ("ppc32", "v44"): 848,
    ("ppc32", "vsr45"): 864,
    ("ppc32", "v45"): 864,
    ("ppc32", "vsr46"): 880,
    ("ppc32", "v46"): 880,
    ("ppc32", "vsr47"): 896,
    ("ppc32", "v47"): 896,
    ("ppc32", "vsr48"): 912,
    ("ppc32", "v48"): 912,
    ("ppc32", "vsr49"): 928,
    ("ppc32", "v49"): 928,
    ("ppc32", "vsr50"): 944,
    ("ppc32", "v50"): 944,
    ("ppc32", "vsr51"): 960,
    ("ppc32", "v51"): 960,
    ("ppc32", "vsr52"): 976,
    ("ppc32", "v52"): 976,
    ("ppc32", "vsr53"): 992,
    ("ppc32", "v53"): 992,
    ("ppc32", "vsr54"): 1008,
    ("ppc32", "v54"): 1008,
    ("ppc32", "vsr55"): 1024,
    ("ppc32", "v55"): 1024,
    ("ppc32", "vsr56"): 1040,
    ("ppc32", "v56"): 1040,
    ("ppc32", "vsr57"): 1056,
    ("ppc32", "v57"): 1056,
    ("ppc32", "vsr58"): 1072,
    ("ppc32", "v58"): 1072,
    ("ppc32", "vsr59"): 1088,
    ("ppc32", "v59"): 1088,
    ("ppc32", "vsr60"): 1104,
    ("ppc32", "v60"): 1104,
    ("ppc32", "vsr61"): 1120,
    ("ppc32", "v61"): 1120,
    ("ppc32", "vsr62"): 1136,
    ("ppc32", "v62"): 1136,
    ("ppc32", "vsr63"): 1152,
    ("ppc32", "v63"): 1152,
    ("ppc32", "cia"): 1168,
    ("ppc32", "ip"): 1168,
    ("ppc32", "pc"): 1168,
    ("ppc32", "lr"): 1172,
    ("ppc32", "ctr"): 1176,
    ("ppc32", "xer_so"): 1180,
    ("ppc32", "xer_ov"): 1181,
    ("ppc32", "xer_ca"): 1182,
    ("ppc32", "xer_bc"): 1183,
    ("ppc32", "cr0_321"): 1184,
    ("ppc32", "cr0_0"): 1185,
    ("ppc32", "cr0"): 1185,
    ("ppc32", "cr1_321"): 1186,
    ("ppc32", "cr1_0"): 1187,
    ("ppc32", "cr1"): 1187,
    ("ppc32", "cr2_321"): 1188,
    ("ppc32", "cr2_0"): 1189,
    ("ppc32", "cr2"): 1189,
    ("ppc32", "cr3_321"): 1190,
    ("ppc32", "cr3_0"): 1191,
    ("ppc32", "cr3"): 1191,
    ("ppc32", "cr4_321"): 1192,
    ("ppc32", "cr4_0"): 1193,
    ("ppc32", "cr4"): 1193,
    ("ppc32", "cr5_321"): 1194,
    ("ppc32", "cr5_0"): 1195,
    ("ppc32", "cr5"): 1195,
    ("ppc32", "cr6_321"): 1196,
    ("ppc32", "cr6_0"): 1197,
    ("ppc32", "cr6"): 1197,
    ("ppc32", "cr7_321"): 1198,
    ("ppc32", "cr7_0"): 1199,
    ("ppc32", "cr7"): 1199,
    ("ppc32", "fpround"): 1200,
    ("ppc32", "dfpround"): 1201,
    ("ppc32", "c_fpcc"): 1202,
    ("ppc32", "vrsave"): 1204,
    ("ppc32", "vscr"): 1208,
    ("ppc32", "emnote"): 1212,
    ("ppc32", "cmstart"): 1216,
    ("ppc32", "cmlen"): 1220,
    ("ppc32", "nraddr"): 1224,
    ("ppc32", "nraddr_gpr2"): 1228,
    ("ppc32", "redir_sp"): 1232,
    ("ppc32", "redir_stack"): 1236,
    ("ppc32", "ip_at_syscall"): 1364,
    ("ppc32", "sprg3_ro"): 1368,
    ("ppc32", "tfhar"): 1376,
    ("ppc32", "texasr"): 1384,
    ("ppc32", "tfiar"): 1392,
    ("ppc32", "ppr"): 1400,
    ("ppc32", "texasru"): 1408,
    ("ppc32", "pspb"): 1412,
    ("ppc64", "gpr0"): 16,
    ("ppc64", "r0"): 16,
    ("ppc64", "gpr1"): 24,
    ("ppc64", "r1"): 24,
    ("ppc64", "sp"): 24,
    ("ppc64", "gpr2"): 32,
    ("ppc64", "r2"): 32,
    ("ppc64", "rtoc"): 32,
    ("ppc64", "gpr3"): 40,
    ("ppc64", "r3"): 40,
    ("ppc64", "gpr4"): 48,
    ("ppc64", "r4"): 48,
    ("ppc64", "gpr5"): 56,
    ("ppc64", "r5"): 56,
    ("ppc64", "gpr6"): 64,
    ("ppc64", "r6"): 64,
    ("ppc64", "gpr7"): 72,
    ("ppc64", "r7"): 72,
    ("ppc64", "gpr8"): 80,
    ("ppc64", "r8"): 80,
    ("ppc64", "gpr9"): 88,
    ("ppc64", "r9"): 88,
    ("ppc64", "gpr10"): 96,
    ("ppc64", "r10"): 96,
    ("ppc64", "gpr11"): 104,
    ("ppc64", "r11"): 104,
    ("ppc64", "gpr12"): 112,
    ("ppc64", "r12"): 112,
    ("ppc64", "gpr13"): 120,
    ("ppc64", "r13"): 120,
    ("ppc64", "gpr14"): 128,
    ("ppc64", "r14"): 128,
    ("ppc64", "gpr15"): 136,
    ("ppc64", "r15"): 136,
    ("ppc64", "gpr16"): 144,
    ("ppc64", "r16"): 144,
    ("ppc64", "gpr17"): 152,
    ("ppc64", "r17"): 152,
    ("ppc64", "gpr18"): 160,
    ("ppc64", "r18"): 160,
    ("ppc64", "gpr19"): 168,
    ("ppc64", "r19"): 168,
    ("ppc64", "gpr20"): 176,
    ("ppc64", "r20"): 176,
    ("ppc64", "gpr21"): 184,
    ("ppc64", "r21"): 184,
    ("ppc64", "gpr22"): 192,
    ("ppc64", "r22"): 192,
    ("ppc64", "gpr23"): 200,
    ("ppc64", "r23"): 200,
    ("ppc64", "gpr24"): 208,
    ("ppc64", "r24"): 208,
    ("ppc64", "gpr25"): 216,
    ("ppc64", "r25"): 216,
    ("ppc64", "gpr26"): 224,
    ("ppc64", "r26"): 224,
    ("ppc64", "gpr27"): 232,
    ("ppc64", "r27"): 232,
    ("ppc64", "gpr28"): 240,
    ("ppc64", "r28"): 240,
    ("ppc64", "gpr29"): 248,
    ("ppc64", "r29"): 248,
    ("ppc64", "gpr30"): 256,
    ("ppc64", "r30"): 256,
    ("ppc64", "gpr31"): 264,
    ("ppc64", "r31"): 264,
    ("ppc64", "bp"): 264,
    ("ppc64", "vsr0"): 272,
    ("ppc64", "v0"): 272,
    ("ppc64", "fpr0"): 272,
    ("ppc64", "vsr1"): 288,
    ("ppc64", "v1"): 288,
    ("ppc64", "fpr1"): 288,
    ("ppc64", "vsr2"): 304,
    ("ppc64", "v2"): 304,
    ("ppc64", "fpr2"): 304,
    ("ppc64", "vsr3"): 320,
    ("ppc64", "v3"): 320,
    ("ppc64", "fpr3"): 320,
    ("ppc64", "vsr4"): 336,
    ("ppc64", "v4"): 336,
    ("ppc64", "fpr4"): 336,
    ("ppc64", "vsr5"): 352,
    ("ppc64", "v5"): 352,
    ("ppc64", "fpr5"): 352,
    ("ppc64", "vsr6"): 368,
    ("ppc64", "v6"): 368,
    ("ppc64", "fpr6"): 368,
    ("ppc64", "vsr7"): 384,
    ("ppc64", "v7"): 384,
    ("ppc64", "fpr7"): 384,
    ("ppc64", "vsr8"): 400,
    ("ppc64", "v8"): 400,
    ("ppc64", "fpr8"): 400,
    ("ppc64", "vsr9"): 416,
    ("ppc64", "v9"): 416,
    ("ppc64", "fpr9"): 416,
    ("ppc64", "vsr10"): 432,
    ("ppc64", "v10"): 432,
    ("ppc64", "fpr10"): 432,
    ("ppc64", "vsr11"): 448,
    ("ppc64", "v11"): 448,
    ("ppc64", "fpr11"): 448,
    ("ppc64", "vsr12"): 464,
    ("ppc64", "v12"): 464,
    ("ppc64", "fpr12"): 464,
    ("ppc64", "vsr13"): 480,
    ("ppc64", "v13"): 480,
    ("ppc64", "fpr13"): 480,
    ("ppc64", "vsr14"): 496,
    ("ppc64", "v14"): 496,
    ("ppc64", "fpr14"): 496,
    ("ppc64", "vsr15"): 512,
    ("ppc64", "v15"): 512,
    ("ppc64", "fpr15"): 512,
    ("ppc64", "vsr16"): 528,
    ("ppc64", "v16"): 528,
    ("ppc64", "fpr16"): 528,
    ("ppc64", "vsr17"): 544,
    ("ppc64", "v17"): 544,
    ("ppc64", "fpr17"): 544,
    ("ppc64", "vsr18"): 560,
    ("ppc64", "v18"): 560,
    ("ppc64", "fpr18"): 560,
    ("ppc64", "vsr19"): 576,
    ("ppc64", "v19"): 576,
    ("ppc64", "fpr19"): 576,
    ("ppc64", "vsr20"): 592,
    ("ppc64", "v20"): 592,
    ("ppc64", "fpr20"): 592,
    ("ppc64", "vsr21"): 608,
    ("ppc64", "v21"): 608,
    ("ppc64", "fpr21"): 608,
    ("ppc64", "vsr22"): 624,
    ("ppc64", "v22"): 624,
    ("ppc64", "fpr22"): 624,
    ("ppc64", "vsr23"): 640,
    ("ppc64", "v23"): 640,
    ("ppc64", "fpr23"): 640,
    ("ppc64", "vsr24"): 656,
    ("ppc64", "v24"): 656,
    ("ppc64", "fpr24"): 656,
    ("ppc64", "vsr25"): 672,
    ("ppc64", "v25"): 672,
    ("ppc64", "fpr25"): 672,
    ("ppc64", "vsr26"): 688,
    ("ppc64", "v26"): 688,
    ("ppc64", "fpr26"): 688,
    ("ppc64", "vsr27"): 704,
    ("ppc64", "v27"): 704,
    ("ppc64", "fpr27"): 704,
    ("ppc64", "vsr28"): 720,
    ("ppc64", "v28"): 720,
    ("ppc64", "fpr28"): 720,
    ("ppc64", "vsr29"): 736,
    ("ppc64", "v29"): 736,
    ("ppc64", "fpr29"): 736,
    ("ppc64", "vsr30"): 752,
    ("ppc64", "v30"): 752,
    ("ppc64", "fpr30"): 752,
    ("ppc64", "vsr31"): 768,
    ("ppc64", "v31"): 768,
    ("ppc64", "fpr31"): 768,
    ("ppc64", "vsr32"): 784,
    ("ppc64", "v32"): 784,
    ("ppc64", "vsr33"): 800,
    ("ppc64", "v33"): 800,
    ("ppc64", "vsr34"): 816,
    ("ppc64", "v34"): 816,
    ("ppc64", "vsr35"): 832,
    ("ppc64", "v35"): 832,
    ("ppc64", "vsr36"): 848,
    ("ppc64", "v36"): 848,
    ("ppc64", "vsr37"): 864,
    ("ppc64", "v37"): 864,
    ("ppc64", "vsr38"): 880,
    ("ppc64", "v38"): 880,
    ("ppc64", "vsr39"): 896,
    ("ppc64", "v39"): 896,
    ("ppc64", "vsr40"): 912,
    ("ppc64", "v40"): 912,
    ("ppc64", "vsr41"): 928,
    ("ppc64", "v41"): 928,
    ("ppc64", "vsr42"): 944,
    ("ppc64", "v42"): 944,
    ("ppc64", "vsr43"): 960,
    ("ppc64", "v43"): 960,
    ("ppc64", "vsr44"): 976,
    ("ppc64", "v44"): 976,
    ("ppc64", "vsr45"): 992,
    ("ppc64", "v45"): 992,
    ("ppc64", "vsr46"): 1008,
    ("ppc64", "v46"): 1008,
    ("ppc64", "vsr47"): 1024,
    ("ppc64", "v47"): 1024,
    ("ppc64", "vsr48"): 1040,
    ("ppc64", "v48"): 1040,
    ("ppc64", "vsr49"): 1056,
    ("ppc64", "v49"): 1056,
    ("ppc64", "vsr50"): 1072,
    ("ppc64", "v50"): 1072,
    ("ppc64", "vsr51"): 1088,
    ("ppc64", "v51"): 1088,
    ("ppc64", "vsr52"): 1104,
    ("ppc64", "v52"): 1104,
    ("ppc64", "vsr53"): 1120,
    ("ppc64", "v53"): 1120,
    ("ppc64", "vsr54"): 1136,
    ("ppc64", "v54"): 1136,
    ("ppc64", "vsr55"): 1152,
    ("ppc64", "v55"): 1152,
    ("ppc64", "vsr56"): 1168,
    ("ppc64", "v56"): 1168,
    ("ppc64", "vsr57"): 1184,
    ("ppc64", "v57"): 1184,
    ("ppc64", "vsr58"): 1200,
    ("ppc64", "v58"): 1200,
    ("ppc64", "vsr59"): 1216,
    ("ppc64", "v59"): 1216,
    ("ppc64", "vsr60"): 1232,
    ("ppc64", "v60"): 1232,
    ("ppc64", "vsr61"): 1248,
    ("ppc64", "v61"): 1248,
    ("ppc64", "vsr62"): 1264,
    ("ppc64", "v62"): 1264,
    ("ppc64", "vsr63"): 1280,
    ("ppc64", "v63"): 1280,
    ("ppc64", "cia"): 1296,
    ("ppc64", "ip"): 1296,
    ("ppc64", "pc"): 1296,
    ("ppc64", "lr"): 1304,
    ("ppc64", "ctr"): 1312,
    ("ppc64", "xer_so"): 1320,
    ("ppc64", "xer_ov"): 1321,
    ("ppc64", "xer_ca"): 1322,
    ("ppc64", "xer_bc"): 1323,
    ("ppc64", "cr0_321"): 1324,
    ("ppc64", "cr0_0"): 1325,
    ("ppc64", "cr0"): 1325,
    ("ppc64", "cr1_321"): 1326,
    ("ppc64", "cr1_0"): 1327,
    ("ppc64", "cr1"): 1327,
    ("ppc64", "cr2_321"): 1328,
    ("ppc64", "cr2_0"): 1329,
    ("ppc64", "cr2"): 1329,
    ("ppc64", "cr3_321"): 1330,
    ("ppc64", "cr3_0"): 1331,
    ("ppc64", "cr3"): 1331,
    ("ppc64", "cr4_321"): 1332,
    ("ppc64", "cr4_0"): 1333,
    ("ppc64", "cr4"): 1333,
    ("ppc64", "cr5_321"): 1334,
    ("ppc64", "cr5_0"): 1335,
    ("ppc64", "cr5"): 1335,
    ("ppc64", "cr6_321"): 1336,
    ("ppc64", "cr6_0"): 1337,
    ("ppc64", "cr6"): 1337,
    ("ppc64", "cr7_321"): 1338,
    ("ppc64", "cr7_0"): 1339,
    ("ppc64", "cr7"): 1339,
    ("ppc64", "fpround"): 1340,
    ("ppc64", "dfpround"): 1341,
    ("ppc64", "c_fpcc"): 1342,
    ("ppc64", "vrsave"): 1344,
    ("ppc64", "vscr"): 1348,
    ("ppc64", "emnote"): 1352,
    ("ppc64", "cmstart"): 1360,
    ("ppc64", "cmlen"): 1368,
    ("ppc64", "nraddr"): 1376,
    ("ppc64", "nraddr_gpr2"): 1384,
    ("ppc64", "redir_sp"): 1392,
    ("ppc64", "redir_stack"): 1400,
    ("ppc64", "ip_at_syscall"): 1656,
    ("ppc64", "sprg3_ro"): 1664,
    ("ppc64", "tfhar"): 1672,
    ("ppc64", "texasr"): 1680,
    ("ppc64", "tfiar"): 1688,
    ("ppc64", "ppr"): 1696,
    ("ppc64", "texasru"): 1704,
    ("ppc64", "pspb"): 1708,
    ("s390x", "ia"): 720,
    ("s390x", "ip"): 720,
    ("s390x", "pc"): 720,
    ("s390x", "r0"): 576,
    ("s390x", "r1"): 584,
    ("s390x", "r1_32"): 588,
    ("s390x", "r2"): 592,
    ("s390x", "r2_32"): 596,
    ("s390x", "r3"): 600,
    ("s390x", "r3_32"): 604,
    ("s390x", "r4"): 608,
    ("s390x", "r4_32"): 612,
    ("s390x", "r5"): 616,
    ("s390x", "r5_32"): 620,
    ("s390x", "r6"): 624,
    ("s390x", "r6_32"): 628,
    ("s390x", "r7"): 632,
    ("s390x", "r7_32"): 636,
    ("s390x", "r8"): 640,
    ("s390x", "r8_32"): 644,
    ("s390x", "r9"): 648,
    ("s390x", "r9_32"): 652,
    ("s390x", "r10"): 656,
    ("s390x", "r10_32"): 660,
    ("s390x", "r11"): 664,
    ("s390x", "bp"): 664,
    ("s390x", "r11_32"): 668,
    ("s390x", "r12"): 672,
    ("s390x", "r12_32"): 676,
    ("s390x", "r13"): 680,
    ("s390x", "r13_32"): 684,
    ("s390x", "r14"): 688,
    ("s390x", "lr"): 688,
    ("s390x", "r15"): 696,
    ("s390x", "sp"): 696,
    ("s390x", "v0"): 64,
    ("s390x", "f0"): 64,
    ("s390x", "v1"): 80,
    ("s390x", "f1"): 80,
    ("s390x", "v2"): 96,
    ("s390x", "f2"): 96,
    ("s390x", "v3"): 112,
    ("s390x", "f3"): 112,
    ("s390x", "v4"): 128,
    ("s390x", "f4"): 128,
    ("s390x", "v5"): 144,
    ("s390x", "f5"): 144,
    ("s390x", "v6"): 160,
    ("s390x", "f6"): 160,
    ("s390x", "v7"): 176,
    ("s390x", "f7"): 176,
    ("s390x", "v8"): 192,
    ("s390x", "f8"): 192,
    ("s390x", "v9"): 208,
    ("s390x", "f9"): 208,
    ("s390x", "v10"): 224,
    ("s390x", "f10"): 224,
    ("s390x", "v11"): 240,
    ("s390x", "f11"): 240,
    ("s390x", "v12"): 256,
    ("s390x", "f12"): 256,
    ("s390x", "v13"): 272,
    ("s390x", "f13"): 272,
    ("s390x", "v14"): 288,
    ("s390x", "f14"): 288,
    ("s390x", "v15"): 304,
    ("s390x", "f15"): 304,
    ("s390x", "v16"): 320,
    ("s390x", "v17"): 336,
    ("s390x", "v18"): 352,
    ("s390x", "v19"): 368,
    ("s390x", "v20"): 384,
    ("s390x", "v21"): 400,
    ("s390x", "v22"): 416,
    ("s390x", "v23"): 432,
    ("s390x", "v24"): 448,
    ("s390x", "v25"): 464,
    ("s390x", "v26"): 480,
    ("s390x", "v27"): 496,
    ("s390x", "v28"): 512,
    ("s390x", "v29"): 528,
    ("s390x", "v30"): 544,
    ("s390x", "v31"): 560,
    ("s390x", "a0"): 0,
    ("s390x", "a1"): 4,
    ("s390x", "a2"): 8,
    ("s390x", "a3"): 12,
    ("s390x", "a4"): 16,
    ("s390x", "a5"): 20,
    ("s390x", "a6"): 24,
    ("s390x", "a7"): 28,
    ("s390x", "a8"): 32,
    ("s390x", "a9"): 36,
    ("s390x", "a10"): 40,
    ("s390x", "a11"): 44,
    ("s390x", "a12"): 48,
    ("s390x", "a13"): 52,
    ("s390x", "a14"): 56,
    ("s390x", "a15"): 60,
    ("s390x", "nraddr"): 768,
    ("s390x", "cmstart"): 776,
    ("s390x", "cmlen"): 784,
    ("s390x", "ip_at_syscall"): 792,
    ("s390x", "emnote"): 800,
    ("mips32", "zero"): 8,
    ("mips32", "r0"): 8,
    ("mips32", "at"): 12,
    ("mips32", "r1"): 12,
    ("mips32", "v0"): 16,
    ("mips32", "r2"): 16,
    ("mips32", "v1"): 20,
    ("mips32", "r3"): 20,
    ("mips32", "a0"): 24,
    ("mips32", "r4"): 24,
    ("mips32", "a1"): 28,
    ("mips32", "r5"): 28,
    ("mips32", "a2"): 32,
    ("mips32", "r6"): 32,
    ("mips32", "a3"): 36,
    ("mips32", "r7"): 36,
    ("mips32", "t0"): 40,
    ("mips32", "r8"): 40,
    ("mips32", "t1"): 44,
    ("mips32", "r9"): 44,
    ("mips32", "t2"): 48,
    ("mips32", "r10"): 48,
    ("mips32", "t3"): 52,
    ("mips32", "r11"): 52,
    ("mips32", "t4"): 56,
    ("mips32", "r12"): 56,
    ("mips32", "t5"): 60,
    ("mips32", "r13"): 60,
    ("mips32", "t6"): 64,
    ("mips32", "r14"): 64,
    ("mips32", "t7"): 68,
    ("mips32", "r15"): 68,
    ("mips32", "s0"): 72,
    ("mips32", "r16"): 72,
    ("mips32", "s1"): 76,
    ("mips32", "r17"): 76,
    ("mips32", "s2"): 80,
    ("mips32", "r18"): 80,
    ("mips32", "s3"): 84,
    ("mips32", "r19"): 84,
    ("mips32", "s4"): 88,
    ("mips32", "r20"): 88,
    ("mips32", "s5"): 92,
    ("mips32", "r21"): 92,
    ("mips32", "s6"): 96,
    ("mips32", "r22"): 96,
    ("mips32", "s7"): 100,
    ("mips32", "r23"): 100,
    ("mips32", "t8"): 104,
    ("mips32", "r24"): 104,
    ("mips32", "t9"): 108,
    ("mips32", "r25"): 108,
    ("mips32", "k0"): 112,
    ("mips32", "r26"): 112,
    ("mips32", "k1"): 116,
    ("mips32", "r27"): 116,
    ("mips32", "gp"): 120,
    ("mips32", "r28"): 120,
    ("mips32", "sp"): 124,
    ("mips32", "r29"): 124,
    ("mips32", "s8"): 128,
    ("mips32", "r30"): 128,
    ("mips32", "fp"): 128,
    ("mips32", "bp"): 128,
    ("mips32", "ra"): 132,
    ("mips32", "r31"): 132,
    ("mips32", "lr"): 132,
    ("mips32", "pc"): 136,
    ("mips32", "ip"): 136,
    ("mips32", "hi"): 140,
    ("mips32", "lo"): 144,
    ("mips32", "f0"): 152,
    ("mips32", "f0_lo"): 152,
    ("mips32", "f1"): 160,
    ("mips32", "f1_lo"): 160,
    ("mips32", "f2"): 168,
    ("mips32", "f2_lo"): 168,
    ("mips32", "f3"): 176,
    ("mips32", "f3_lo"): 176,
    ("mips32", "f4"): 184,
    ("mips32", "f4_lo"): 184,
    ("mips32", "f5"): 192,
    ("mips32", "f5_lo"): 192,
    ("mips32", "f6"): 200,
    ("mips32", "f6_lo"): 200,
    ("mips32", "f7"): 208,
    ("mips32", "f7_lo"): 208,
    ("mips32", "f8"): 216,
    ("mips32", "f8_lo"): 216,
    ("mips32", "f9"): 224,
    ("mips32", "f9_lo"): 224,
    ("mips32", "f10"): 232,
    ("mips32", "f10_lo"): 232,
    ("mips32", "f11"): 240,
    ("mips32", "f11_lo"): 240,
    ("mips32", "f12"): 248,
    ("mips32", "f12_lo"): 248,
    ("mips32", "f13"): 256,
    ("mips32", "f13_lo"): 256,
    ("mips32", "f14"): 264,
    ("mips32", "f14_lo"): 264,
    ("mips32", "f15"): 272,
    ("mips32", "f15_lo"): 272,
    ("mips32", "f16"): 280,
    ("mips32", "f16_lo"): 280,
    ("mips32", "f17"): 288,
    ("mips32", "f17_lo"): 288,
    ("mips32", "f18"): 296,
    ("mips32", "f18_lo"): 296,
    ("mips32", "f19"): 304,
    ("mips32", "f19_lo"): 304,
    ("mips32", "f20"): 312,
    ("mips32", "f20_lo"): 312,
    ("mips32", "f21"): 320,
    ("mips32", "f21_lo"): 320,
    ("mips32", "f22"): 328,
    ("mips32", "f22_lo"): 328,
    ("mips32", "f23"): 336,
    ("mips32", "f23_lo"): 336,
    ("mips32", "f24"): 344,
    ("mips32", "f24_lo"): 344,
    ("mips32", "f25"): 352,
    ("mips32", "f25_lo"): 352,
    ("mips32", "f26"): 360,
    ("mips32", "f26_lo"): 360,
    ("mips32", "f27"): 368,
    ("mips32", "f27_lo"): 368,
    ("mips32", "f28"): 376,
    ("mips32", "f28_lo"): 376,
    ("mips32", "f29"): 384,
    ("mips32", "f29_lo"): 384,
    ("mips32", "f30"): 392,
    ("mips32", "f30_lo"): 392,
    ("mips32", "f31"): 400,
    ("mips32", "f31_lo"): 400,
    ("mips32", "fir"): 408,
    ("mips32", "fccr"): 412,
    ("mips32", "fexr"): 416,
    ("mips32", "fenr"): 420,
    ("mips32", "fcsr"): 424,
    ("mips32", "ulr"): 428,
    ("mips32", "emnote"): 432,
    ("mips32", "cmstart"): 436,
    ("mips32", "cmlen"): 440,
    ("mips32", "nraddr"): 444,
    ("mips32", "cond"): 448,
    ("mips32", "dspcontrol"): 452,
    ("mips32", "ac0"): 456,
    ("mips32", "ac1"): 464,
    ("mips32", "ac2"): 472,
    ("mips32", "ac3"): 480,
    ("mips32", "cp0_status"): 488,
    ("mips32", "ip_at_syscall"): 492,
    ("mips64", "zero"): 16,
    ("mips64", "r0"): 16,
    ("mips64", "at"): 24,
    ("mips64", "r1"): 24,
    ("mips64", "v0"): 32,
    ("mips64", "r2"): 32,
    ("mips64", "v1"): 40,
    ("mips64", "r3"): 40,
    ("mips64", "a0"): 48,
    ("mips64", "r4"): 48,
    ("mips64", "a1"): 56,
    ("mips64", "r5"): 56,
    ("mips64", "a2"): 64,
    ("mips64", "r6"): 64,
    ("mips64", "a3"): 72,
    ("mips64", "r7"): 72,
    ("mips64", "t0"): 80,
    ("mips64", "r8"): 80,
    ("mips64", "a4"): 80,
    ("mips64", "t1"): 88,
    ("mips64", "r9"): 88,
    ("mips64", "a5"): 88,
    ("mips64", "t2"): 96,
    ("mips64", "r10"): 96,
    ("mips64", "a6"): 96,
    ("mips64", "t3"): 104,
    ("mips64", "r11"): 104,
    ("mips64", "a7"): 104,
    ("mips64", "t4"): 112,
    ("mips64", "r12"): 112,
    ("mips64", "t5"): 120,
    ("mips64", "r13"): 120,
    ("mips64", "t6"): 128,
    ("mips64", "r14"): 128,
    ("mips64", "t7"): 136,
    ("mips64", "r15"): 136,
    ("mips64", "s0"): 144,
    ("mips64", "r16"): 144,
    ("mips64", "s1"): 152,
    ("mips64", "r17"): 152,
    ("mips64", "s2"): 160,
    ("mips64", "r18"): 160,
    ("mips64", "s3"): 168,
    ("mips64", "r19"): 168,
    ("mips64", "s4"): 176,
    ("mips64", "r20"): 176,
    ("mips64", "s5"): 184,
    ("mips64", "r21"): 184,
    ("mips64", "s6"): 192,
    ("mips64", "r22"): 192,
    ("mips64", "s7"): 200,
    ("mips64", "r23"): 200,
    ("mips64", "t8"): 208,
    ("mips64", "r24"): 208,
    ("mips64", "t9"): 216,
    ("mips64", "r25"): 216,
    ("mips64", "k0"): 224,
    ("mips64", "r26"): 224,
    ("mips64", "k1"): 232,
    ("mips64", "r27"): 232,
    ("mips64", "gp"): 240,
    ("mips64", "r28"): 240,
    ("mips64", "sp"): 248,
    ("mips64", "r29"): 248,
    ("mips64", "s8"): 256,
    ("mips64", "r30"): 256,
    ("mips64", "fp"): 256,
    ("mips64", "bp"): 256,
    ("mips64", "ra"): 264,
    ("mips64", "r31"): 264,
    ("mips64", "lr"): 264,
    ("mips64", "pc"): 272,
    ("mips64", "ip"): 272,
    ("mips64", "hi"): 280,
    ("mips64", "lo"): 288,
    ("mips64", "f0"): 296,
    ("mips64", "f0_lo"): 296,
    ("mips64", "f1"): 304,
    ("mips64", "f1_lo"): 304,
    ("mips64", "f2"): 312,
    ("mips64", "f2_lo"): 312,
    ("mips64", "f3"): 320,
    ("mips64", "f3_lo"): 320,
    ("mips64", "f4"): 328,
    ("mips64", "f4_lo"): 328,
    ("mips64", "f5"): 336,
    ("mips64", "f5_lo"): 336,
    ("mips64", "f6"): 344,
    ("mips64", "f6_lo"): 344,
    ("mips64", "f7"): 352,
    ("mips64", "f7_lo"): 352,
    ("mips64", "f8"): 360,
    ("mips64", "f8_lo"): 360,
    ("mips64", "f9"): 368,
    ("mips64", "f9_lo"): 368,
    ("mips64", "f10"): 376,
    ("mips64", "f10_lo"): 376,
    ("mips64", "f11"): 384,
    ("mips64", "f11_lo"): 384,
    ("mips64", "f12"): 392,
    ("mips64", "f12_lo"): 392,
    ("mips64", "f13"): 400,
    ("mips64", "f13_lo"): 400,
    ("mips64", "f14"): 408,
    ("mips64", "f14_lo"): 408,
    ("mips64", "f15"): 416,
    ("mips64", "f15_lo"): 416,
    ("mips64", "f16"): 424,
    ("mips64", "f16_lo"): 424,
    ("mips64", "f17"): 432,
    ("mips64", "f17_lo"): 432,
    ("mips64", "f18"): 440,
    ("mips64", "f18_lo"): 440,
    ("mips64", "f19"): 448,
    ("mips64", "f19_lo"): 448,
    ("mips64", "f20"): 456,
    ("mips64", "f20_lo"): 456,
    ("mips64", "f21"): 464,
    ("mips64", "f21_lo"): 464,
    ("mips64", "f22"): 472,
    ("mips64", "f22_lo"): 472,
    ("mips64", "f23"): 480,
    ("mips64", "f23_lo"): 480,
    ("mips64", "f24"): 488,
    ("mips64", "f24_lo"): 488,
    ("mips64", "f25"): 496,
    ("mips64", "f25_lo"): 496,
    ("mips64", "f26"): 504,
    ("mips64", "f26_lo"): 504,
    ("mips64", "f27"): 512,
    ("mips64", "f27_lo"): 512,
    ("mips64", "f28"): 520,
    ("mips64", "f28_lo"): 520,
    ("mips64", "f29"): 528,
    ("mips64", "f29_lo"): 528,
    ("mips64", "f30"): 536,
    ("mips64", "f30_lo"): 536,
    ("mips64", "f31"): 544,
    ("mips64", "f31_lo"): 544,
    ("mips64", "fir"): 552,
    ("mips64", "fccr"): 556,
    ("mips64", "fexr"): 560,
    ("mips64", "fenr"): 564,
    ("mips64", "fcsr"): 568,
    ("mips64", "cp0_status"): 572,
    ("mips64", "ulr"): 576,
    ("mips64", "emnote"): 584,
    ("mips64", "cond"): 588,
    ("mips64", "cmstart"): 592,
    ("mips64", "cmlen"): 600,
    ("mips64", "nraddr"): 608,
    ("mips64", "ip_at_syscall"): 616,
    ("riscv64", "x0"): 16,
    ("riscv64", "zero"): 16,
    ("riscv64", "x1"): 24,
    ("riscv64", "ra"): 24,
    ("riscv64", "lr"): 24,
    ("riscv64", "x2"): 32,
    ("riscv64", "sp"): 32,
    ("riscv64", "x3"): 40,
    ("riscv64", "gp"): 40,
    ("riscv64", "x4"): 48,
    ("riscv64", "tp"): 48,
    ("riscv64", "x5"): 56,
    ("riscv64", "t0"): 56,
    ("riscv64", "x6"): 64,
    ("riscv64", "t1"): 64,
    ("riscv64", "x7"): 72,
    ("riscv64", "t2"): 72,
    ("riscv64", "x9"): 88,
    ("riscv64", "s1"): 88,
    ("riscv64", "x10"): 96,
    ("riscv64", "a0"): 96,
    ("riscv64", "x11"): 104,
    ("riscv64", "a1"): 104,
    ("riscv64", "x12"): 112,
    ("riscv64", "a2"): 112,
    ("riscv64", "x13"): 120,
    ("riscv64", "a3"): 120,
    ("riscv64", "x14"): 128,
    ("riscv64", "a4"): 128,
    ("riscv64", "x15"): 136,
    ("riscv64", "a5"): 136,
    ("riscv64", "x16"): 144,
    ("riscv64", "a6"): 144,
    ("riscv64", "x17"): 152,
    ("riscv64", "a7"): 152,
    ("riscv64", "x18"): 160,
    ("riscv64", "s2"): 160,
    ("riscv64", "x19"): 168,
    ("riscv64", "s3"): 168,
    ("riscv64", "x20"): 176,
    ("riscv64", "s4"): 176,
    ("riscv64", "x21"): 184,
    ("riscv64", "s5"): 184,
    ("riscv64", "x22"): 192,
    ("riscv64", "s6"): 192,
    ("riscv64", "x23"): 200,
    ("riscv64", "s7"): 200,
    ("riscv64", "x24"): 208,
    ("riscv64", "s8"): 208,
    ("riscv64", "x25"): 216,
    ("riscv64", "s9"): 216,
    ("riscv64", "x26"): 224,
    ("riscv64", "s10"): 224,
    ("riscv64", "x27"): 232,
    ("riscv64", "s11"): 232,
    ("riscv64", "x28"): 240,
    ("riscv64", "t3"): 240,
    ("riscv64", "x29"): 248,
    ("riscv64", "t4"): 248,
    ("riscv64", "x30"): 256,
    ("riscv64", "t5"): 256,
    ("riscv64", "x31"): 264,
    ("riscv64", "t6"): 264,
    ("riscv64", "pc"): 272,
    ("riscv64", "ip"): 272,
    ("riscv64", "f0"): 280,
    ("riscv64", "ft0"): 280,
    ("riscv64", "f1"): 288,
    ("riscv64", "ft1"): 288,
    ("riscv64", "f2"): 296,
    ("riscv64", "ft2"): 296,
    ("riscv64", "f3"): 304,
    ("riscv64", "ft3"): 304,
    ("riscv64", "f4"): 312,
    ("riscv64", "ft4"): 312,
    ("riscv64", "f5"): 320,
    ("riscv64", "ft5"): 320,
    ("riscv64", "f6"): 328,
    ("riscv64", "ft6"): 328,
    ("riscv64", "f7"): 336,
    ("riscv64", "ft7"): 336,
    ("riscv64", "f9"): 352,
    ("riscv64", "fs1"): 352,
    ("riscv64", "f10"): 360,
    ("riscv64", "fa0"): 360,
    ("riscv64", "f11"): 368,
    ("riscv64", "fa1"): 368,
    ("riscv64", "f12"): 376,
    ("riscv64", "fa2"): 376,
    ("riscv64", "f13"): 384,
    ("riscv64", "fa3"): 384,
    ("riscv64", "f14"): 392,
    ("riscv64", "fa4"): 392,
    ("riscv64", "f15"): 400,
    ("riscv64", "fa5"): 400,
    ("riscv64", "f16"): 408,
    ("riscv64", "fa6"): 408,
    ("riscv64", "f17"): 416,
    ("riscv64", "fa7"): 416,
    ("riscv64", "f18"): 424,
    ("riscv64", "fs2"): 424,
    ("riscv64", "f19"): 432,
    ("riscv64", "fs3"): 432,
    ("riscv64", "f20"): 440,
    ("riscv64", "fs4"): 440,
    ("riscv64", "f21"): 448,
    ("riscv64", "fs5"): 448,
    ("riscv64", "f22"): 456,
    ("riscv64", "fs6"): 456,
    ("riscv64", "f23"): 464,
    ("riscv64", "fs7"): 464,
    ("riscv64", "f24"): 472,
    ("riscv64", "fs8"): 472,
    ("riscv64", "f25"): 480,
    ("riscv64", "fs9"): 480,
    ("riscv64", "f26"): 488,
    ("riscv64", "fs10"): 488,
    ("riscv64", "f27"): 496,
    ("riscv64", "fs11"): 496,
    ("riscv64", "f28"): 504,
    ("riscv64", "ft8"): 504,
    ("riscv64", "f29"): 512,
    ("riscv64", "ft9"): 512,
    ("riscv64", "f30"): 520,
    ("riscv64", "ft10"): 520,
    ("riscv64", "f31"): 528,
    ("riscv64", "ft11"): 528,
}
