/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.chronology.ChronologyDiagram;
import net.sourceforge.plantuml.chronology.SubjectTask;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommonCommands;
import net.sourceforge.plantuml.command.PSystemCommandFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.project.command.NaturalCommand;
import net.sourceforge.plantuml.project.lang.SentenceAnd;
import net.sourceforge.plantuml.project.lang.SentenceAndAnd;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class ChronologyDiagramFactory
extends PSystemCommandFactory {
    private static final List<Subject<ChronologyDiagram>> subjects() {
        return Arrays.asList(SubjectTask.ME);
    }

    public ChronologyDiagramFactory() {
        super(DiagramType.CHRONOLOGY);
    }

    @Override
    protected void initCommandsList(List<Command> cmds) {
        CommonCommands.addTitleCommands(cmds);
        CommonCommands.addCommonCommands2(cmds);
        CommonCommands.addCommonScaleCommands(cmds);
        this.addLanguageCommands(cmds);
    }

    private void addLanguageCommands(List<Command> cmd) {
        for (Subject<ChronologyDiagram> subject : ChronologyDiagramFactory.subjects()) {
            for (SentenceSimple<ChronologyDiagram> sentenceA : subject.getSentences()) {
                cmd.add(NaturalCommand.create(sentenceA));
                for (SentenceSimple<ChronologyDiagram> sentenceB : subject.getSentences()) {
                    String signatureB;
                    String signatureA = sentenceA.getSignature();
                    if (signatureA.equals(signatureB = sentenceB.getSignature())) continue;
                    cmd.add(NaturalCommand.create(new SentenceAnd<ChronologyDiagram>(sentenceA, sentenceB)));
                }
            }
        }
        for (Subject<ChronologyDiagram> subject : ChronologyDiagramFactory.subjects()) {
            for (SentenceSimple<ChronologyDiagram> sentenceA : subject.getSentences()) {
                for (SentenceSimple<ChronologyDiagram> sentenceB : subject.getSentences()) {
                    for (SentenceSimple<ChronologyDiagram> sentenceC : subject.getSentences()) {
                        String signatureA = sentenceA.getSignature();
                        String signatureB = sentenceB.getSignature();
                        String signatureC = sentenceC.getSignature();
                        if (signatureA.equals(signatureB) || signatureA.equals(signatureC) || signatureC.equals(signatureB)) continue;
                        cmd.add(NaturalCommand.create(new SentenceAndAnd<ChronologyDiagram>(sentenceA, sentenceB, sentenceC)));
                    }
                }
            }
        }
    }

    @Override
    public ChronologyDiagram createEmptyDiagram(PathSystem pathSystem, UmlSource source, Previous previous, PreprocessingArtifact preprocessing) {
        return new ChronologyDiagram(source, preprocessing);
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CHRONOLOGY;
    }
}

