/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.ingest.GetPipelineResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetPipelineRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetPipelineRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final String id;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    public static final Endpoint<GetPipelineRequest, GetPipelineResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetPipelineRequest, GetPipelineResponse>(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_ingest/pipeline";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest/pipeline/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetPipelineResponse._DESERIALIZER);

    private GetPipelineRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.id = builder.id;
        this.masterTimeout = builder.masterTimeout;
    }

    public static GetPipelineRequest of(Function<Builder, ObjectBuilder<GetPipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPipelineRequest other = (GetPipelineRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.id, other.id) && Objects.equals(this.masterTimeout, other.masterTimeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetPipelineRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private String id;
        @Nullable
        private Time masterTimeout;

        public Builder() {
        }

        private Builder(GetPipelineRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.id = o.id;
            this.masterTimeout = o.masterTimeout;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.id = o.id;
            this.masterTimeout = o.masterTimeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public GetPipelineRequest build() {
            this._checkSingleUse();
            return new GetPipelineRequest(this);
        }
    }
}

