"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiContextMenuItem", {
  enumerable: true,
  get: function get() {
    return _context_menu_item.EuiContextMenuItem;
  }
});
exports.OuiContextMenuItem = exports.LAYOUT_ALIGN = exports.SIZES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _icon = require("../icon");
var _tool_tip = require("../tool_tip");
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _context_menu_item = require("../../eui_components/context_menu/context_menu_item");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  s: 'ouiContextMenuItem--small',
  m: null
};
var SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.SIZES = SIZES;
var layoutAlignToClassNames = {
  center: null,
  top: 'ouiContextMenu__itemLayout--top',
  bottom: 'ouiContextMenu__itemLayout--bottom'
};
var LAYOUT_ALIGN = (0, _common.keysOf)(layoutAlignToClassNames);
exports.LAYOUT_ALIGN = LAYOUT_ALIGN;
var OuiContextMenuItem = /*#__PURE__*/function (_Component) {
  _inherits(OuiContextMenuItem, _Component);
  var _super = _createSuper(OuiContextMenuItem);
  function OuiContextMenuItem() {
    _classCallCheck(this, OuiContextMenuItem);
    return _super.apply(this, arguments);
  }
  _createClass(OuiContextMenuItem, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        hasPanel = _this$props.hasPanel,
        icon = _this$props.icon,
        buttonRef = _this$props.buttonRef,
        _disabled = _this$props.disabled,
        _this$props$layoutAli = _this$props.layoutAlign,
        layoutAlign = _this$props$layoutAli === void 0 ? 'center' : _this$props$layoutAli,
        toolTipTitle = _this$props.toolTipTitle,
        toolTipContent = _this$props.toolTipContent,
        _this$props$toolTipPo = _this$props.toolTipPosition,
        toolTipPosition = _this$props$toolTipPo === void 0 ? 'right' : _this$props$toolTipPo,
        href = _this$props.href,
        target = _this$props.target,
        rel = _this$props.rel,
        size = _this$props.size,
        rest = _objectWithoutProperties(_this$props, ["children", "className", "hasPanel", "icon", "buttonRef", "disabled", "layoutAlign", "toolTipTitle", "toolTipContent", "toolTipPosition", "href", "target", "rel", "size"]);
      var iconInstance;
      var isHrefValid = !href || (0, _href_validator.validateHref)(href);
      var disabled = _disabled || !isHrefValid;
      if (icon) {
        switch (_typeof(icon)) {
          case 'string':
            iconInstance = /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
              type: icon,
              size: "m",
              className: "ouiContextMenu__icon",
              color: "inherit" // forces the icon to inherit its parent color
            });
            break;
          default:
            // Assume it's already an instance of an icon.
            iconInstance = /*#__PURE__*/(0, _react.cloneElement)(icon, {
              className: 'ouiContextMenu__icon'
            });
        }
      }
      var arrow;
      if (hasPanel) {
        arrow = /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
          type: "arrowRight",
          size: "m",
          className: "ouiContextMenu__arrow"
        });
      }
      var classes = (0, _classnames.default)('ouiContextMenuItem', size && sizeToClassNameMap[size], className, {
        'ouiContextMenuItem-isDisabled': disabled
      });
      var layoutClasses = (0, _classnames.default)('ouiContextMenu__itemLayout', layoutAlignToClassNames[layoutAlign]);
      var buttonInner = /*#__PURE__*/_react.default.createElement("span", {
        className: layoutClasses
      }, iconInstance, /*#__PURE__*/_react.default.createElement("span", {
        className: "ouiContextMenuItem__text"
      }, children), arrow);
      var button;
      // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
      // this is a button and piggyback off its disabled styles.
      if (href && !disabled) {
        var secureRel = (0, _services.getSecureRelForTarget)({
          href: href,
          target: target,
          rel: rel
        });
        button = /*#__PURE__*/_react.default.createElement("a", _extends({
          className: classes,
          href: href,
          target: target,
          rel: secureRel,
          ref: buttonRef
        }, rest), buttonInner);
      } else {
        button = /*#__PURE__*/_react.default.createElement("button", _extends({
          disabled: disabled,
          className: classes,
          type: "button",
          ref: buttonRef
        }, rest), buttonInner);
      }
      if (toolTipContent) {
        return /*#__PURE__*/_react.default.createElement(_tool_tip.OuiToolTip, {
          title: toolTipTitle ? toolTipTitle : null,
          content: toolTipContent,
          anchorClassName: "oui-displayBlock",
          position: toolTipPosition
        }, button);
      } else {
        return button;
      }
    }
  }]);
  return OuiContextMenuItem;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */
exports.OuiContextMenuItem = OuiContextMenuItem;
OuiContextMenuItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  icon: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.string.isRequired, _propTypes.default.any.isRequired]),
  hasPanel: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onClick: _propTypes.default.func,
  buttonRef: _propTypes.default.any,
  /**
     * Required if using a tooltip. Add an optional tooltip on hover
     */
  toolTipContent: _propTypes.default.node,
  /**
     * Optional title for the tooltip
     */
  toolTipTitle: _propTypes.default.node,
  /**
     * Dictates the position of the tooltip.
     */
  toolTipPosition: _propTypes.default.oneOf(["top", "right", "bottom", "left"]),
  href: _propTypes.default.string,
  target: _propTypes.default.string,
  rel: _propTypes.default.string,
  /**
     * How to align icon with content of button
     */
  layoutAlign: _propTypes.default.oneOf(["center", "top", "bottom"]),
  /**
     * Reduce the size to `s` when in need of a more compressed menu
     */
  size: _propTypes.default.oneOf(["s", "m"])
};
/* OUI -> EUI Aliases: Build-Time */