/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.function.BiFunction;

final class RelZero
extends Item {
    private final Item a;
    private final If.Kind kind;

    RelZero(Expr a, If.Kind kind) {
        this.kind = kind;
        this.a = (Item)a;
        if (a.typeKind() == TypeKind.REFERENCE && kind.if_acmp == null) {
            throw new IllegalStateException("Invalid comparison for reference types");
        }
    }

    Item input() {
        return this.a;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.a.process(node.prev(), op);
    }

    @Override
    public ClassDesc type() {
        return ConstantDescs.CD_boolean;
    }

    If.Kind kind() {
        return this.kind;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        Label true_ = cb.newLabel();
        Label end = cb.newLabel();
        switch (this.a.typeKind().asLoadable()) {
            case INT: {
                this.kind.if_.accept(cb, true_);
                break;
            }
            case REFERENCE: {
                this.kind.if_acmpnull.accept(cb, true_);
                break;
            }
            case LONG: {
                cb.lconst_0();
                cb.lcmp();
                cb.iconst_1();
                cb.iand();
                return;
            }
            case FLOAT: {
                cb.fconst_0();
                cb.fcmpg();
                cb.iconst_1();
                cb.iand();
                return;
            }
            case DOUBLE: {
                cb.dconst_0();
                cb.dcmpg();
                cb.iconst_1();
                cb.iand();
                return;
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)((Object)this.a.typeKind().asLoadable()));
            }
        }
        cb.iconst_0();
        cb.goto_(end);
        cb.labelBinding(true_);
        cb.iconst_1();
        cb.labelBinding(end);
    }
}

