/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import java.util.Objects;

public final class ActiveResult {
    private static final ActiveResult ACTIVE = new ActiveResult(true, null, null);
    private final boolean value;
    private final String inactiveReason;
    private final ActiveResult inactiveCause;

    public static ActiveResult active() {
        return ACTIVE;
    }

    public static ActiveResult inactive(String reason) {
        return new ActiveResult(false, Objects.requireNonNull(reason), null);
    }

    public static ActiveResult inactive(String reason, ActiveResult cause) {
        if (cause != null && cause.value) {
            throw new IllegalArgumentException("The cause of an inactive result must also be inactive");
        }
        return new ActiveResult(false, Objects.requireNonNull(reason), cause);
    }

    private ActiveResult(boolean value, String inactiveReason, ActiveResult inactiveCause) {
        this.value = value;
        this.inactiveReason = inactiveReason;
        this.inactiveCause = inactiveCause;
    }

    public boolean value() {
        return this.value;
    }

    public String inactiveReason() {
        return this.inactiveReason;
    }

    public ActiveResult inactiveCause() {
        return this.inactiveCause;
    }
}

