/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.errormanager;

import io.smallrye.common.constraint.Assert;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtErrorManager;

public final class HandlerErrorManager
extends ExtErrorManager {
    private static final ThreadLocal<Boolean> handlingError = new ThreadLocal();
    private final Handler handler;

    public HandlerErrorManager(Handler handler) {
        Assert.checkNotNullParam((String)"handler", (Object)handler);
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(String msg, Exception ex, int code) {
        if (handlingError.get() != Boolean.TRUE) {
            handlingError.set(Boolean.TRUE);
            try {
                this.handler.publish(this.errorToLogRecord(msg, ex, code));
            }
            finally {
                handlingError.remove();
            }
        }
    }
}

