/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.slot;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStore;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreKey;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.HashSet;

public class SlotStoreAdaptor
implements ObjectStoreAPI {
    private final SlotStore store;

    public SlotStoreAdaptor() throws IOException {
        SlotStoreEnvironmentBean envBean = BeanPopulator.getDefaultInstance(SlotStoreEnvironmentBean.class);
        this.store = new SlotStore(envBean);
    }

    public SlotStoreAdaptor(SlotStore slotStore) {
        this.store = slotStore;
    }

    @Override
    public boolean allObjUids(String typeName, InputObjectState foundInstances, int matchState) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("SlotStore.allObjUids(" + typeName + ", " + matchState + ")"));
        }
        SlotStoreKey key = new SlotStoreKey(Uid.nullUid(), typeName, matchState);
        SlotStoreKey[] matchingKeys = this.store.getMatchingKeys(key);
        OutputObjectState buffer = new OutputObjectState();
        try {
            for (SlotStoreKey matchingKey : matchingKeys) {
                UidHelper.packInto(matchingKey.getUid(), buffer);
            }
            UidHelper.packInto(Uid.nullUid(), buffer);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        foundInstances.setBuffer(buffer.buffer());
        return true;
    }

    @Override
    public boolean allObjUids(String typeName, InputObjectState foundInstances) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("SlotStore.allObjUids(" + typeName + ")"));
        }
        return this.allObjUids(typeName, foundInstances, -1);
    }

    @Override
    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"SlotStore.allTypes()");
        }
        String[] knownTypes = this.store.getKnownTypes();
        HashSet<Object> typeSet = new HashSet<Object>();
        if (knownTypes == null || knownTypes.length == 0) {
            return true;
        }
        OutputObjectState buffer = new OutputObjectState();
        try {
            for (String typeName : knownTypes) {
                if (typeName.startsWith("/")) {
                    typeName = typeName.substring(1);
                }
                if (typeName.contains("/")) {
                    String[] parents;
                    Object value = "";
                    for (String parent : parents = typeName.split("/")) {
                        if (parent.length() == 0) continue;
                        if (((String)value).length() > 0) {
                            value = (String)value + "/";
                        }
                        if (typeSet.contains(value = (String)value + parent)) continue;
                        typeSet.add(value);
                        buffer.packString((String)value);
                    }
                    continue;
                }
                buffer.packString(typeName);
            }
            buffer.packString("");
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        foundTypes.setBuffer(buffer.buffer());
        return true;
    }

    @Override
    public int currentState(Uid uid, String typeName) throws ObjectStoreException {
        SlotStoreKey key;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("SlotStore.currentState(" + String.valueOf(uid) + ", " + typeName + ")"));
        }
        if (this.store.contains(key = new SlotStoreKey(uid, typeName, 1))) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public InputObjectState read_committed(Uid uid, String typeName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("SlotStore.read_committed(" + String.valueOf(uid) + ", " + typeName + ")"));
        }
        SlotStoreKey key = new SlotStoreKey(uid, typeName, 1);
        try {
            return this.store.read(key);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public boolean remove_committed(Uid uid, String typeName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("SlotStore.remove_committed(" + String.valueOf(uid) + ", " + typeName + ")"));
        }
        SlotStoreKey key = new SlotStoreKey(uid, typeName, 1);
        try {
            return this.store.remove(key);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public boolean write_committed(Uid uid, String typeName, OutputObjectState buff) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("SlotStore.write_committed(" + String.valueOf(uid) + ", " + typeName + ")"));
        }
        SlotStoreKey key = new SlotStoreKey(uid, typeName, 1);
        try {
            return this.store.write(key, buff);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    @Override
    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    @Override
    public boolean fullCommitNeeded() {
        return false;
    }

    @Override
    public String getStoreName() {
        return this.store.getStoreName();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

