/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Type;
import java.util.Arrays;
import java.util.List;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tuple.TupleType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectArrayJavaType;

public class ArrayTupleType
implements TupleType<Object[]>,
SqmDomainType<Object[]>,
MappingModelExpressible<Object[]> {
    private final ObjectArrayJavaType javaType;
    private final SqmBindableType<?>[] components;

    public ArrayTupleType(SqmBindableType<?>[] components) {
        this.components = components;
        this.javaType = new ObjectArrayJavaType(ArrayTupleType.getTypeDescriptors(components));
    }

    @Override
    public Class<Object[]> getJavaType() {
        return TupleType.super.getJavaType();
    }

    @Override
    public String getTypeName() {
        return SqmDomainType.super.getTypeName();
    }

    @Override
    public SqmDomainType<Object[]> getSqmType() {
        return this;
    }

    private static JavaType<?>[] getTypeDescriptors(SqmExpressible<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    @Override
    public int componentCount() {
        return this.components.length;
    }

    @Override
    public String getComponentName(int index) {
        throw new UnsupportedMappingException("Array tuple has no component names");
    }

    @Override
    public List<String> getComponentNames() {
        throw new UnsupportedMappingException("Array tuple has no component names");
    }

    @Override
    public SqmBindableType<?> get(int index) {
        return this.components[index];
    }

    @Override
    public SqmBindableType<?> get(String componentName) {
        throw new UnsupportedMappingException("Array tuple has no component names");
    }

    @Override
    public JavaType<Object[]> getExpressibleJavaType() {
        return this.javaType;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    public String toString() {
        return "ArrayTupleType" + Arrays.toString(this.components);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException();
    }
}

