/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javajs.util.PT;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.PopInJmol;
import org.openscience.jmol.app.webexport.ScriptButtons;
import org.openscience.jmol.app.webexport.WebPanel;

public class WebExport
extends JPanel
implements WindowListener {
    static final String chemappsPath = "https://chemapps.stolaf.edu/jmol/jsmol";
    private static boolean showMoleculesAndOrbitals = false;
    private static final int STAND_ALONE = 0;
    private static final int IN_JMOL = 1;
    private static int runStatus = 1;
    private static HistoryFile historyFile;
    private static WebPanel[] webPanels;
    static WebExport webExport;
    private static JFrame webFrame;
    private static String windowName;
    static String remoteAppletPath;
    static String localAppletPath;
    static Properties prop;
    static String pageAuthorName;
    static int popInWidth;
    static int popInHeight;
    static int scriptButtonPercent;

    private WebExport(Viewer vwr, HistoryFile hFile) {
        super(new BorderLayout());
        historyFile = hFile;
        remoteAppletPath = historyFile.getProperty("webMakerAppletPath", chemappsPath);
        localAppletPath = historyFile.getProperty("webMakerLocalAppletPath", chemappsPath);
        pageAuthorName = historyFile.getProperty("webMakerPageAuthorName", GT.$("Jmol Web Page Maker"));
        popInWidth = PT.parseInt(historyFile.getProperty("webMakerPopInWidth", "300"));
        popInHeight = PT.parseInt(historyFile.getProperty("webMakerPopInHeight", "300"));
        scriptButtonPercent = PT.parseInt(historyFile.getProperty("webMakerScriptButtonPercent", "60"));
        JTabbedPane mainTabs = new JTabbedPane();
        JFileChooser fc = new JFileChooser();
        webPanels = new WebPanel[2];
        if (runStatus != 0) {
            JPanel introPanel = new JPanel();
            String introFileName = "WebExportIntro";
            URL url = GuiMap.getHtmlResource(this, introFileName);
            if (url == null) {
                System.err.println(GT.o(GT.$("Couldn't find file: {0}"), introFileName + ".html"));
            }
            JEditorPane intro = new JEditorPane();
            if (url != null) {
                try {
                    intro.setPage(url);
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + url);
                }
            }
            intro.setEditable(false);
            JScrollPane introPane = new JScrollPane(intro);
            introPane.setMaximumSize(new Dimension(450, 350));
            introPane.setPreferredSize(new Dimension(400, 300));
            introPanel.setLayout(new BorderLayout());
            introPanel.add(introPane);
            introPanel.setMaximumSize(new Dimension(450, 350));
            introPanel.setPreferredSize(new Dimension(400, 300));
            mainTabs.add(GT.$("Introduction"), introPanel);
            WebExport.webPanels[0] = new PopInJmol(vwr, fc, webPanels, 0);
            WebExport.webPanels[1] = new ScriptButtons(vwr, fc, webPanels, 1);
            int w = Integer.parseInt(historyFile.getProperty("webMakerInfoWidth", "300"));
            int h = Integer.parseInt(historyFile.getProperty("webMakerInfoHeight", "350"));
            mainTabs.addTab(GT.$("Pop-In Jmol"), webPanels[0].getPanel(w, h));
            mainTabs.addTab(GT.$("ScriptButton Jmol"), webPanels[1].getPanel(w, h));
        }
        boolean bl = showMoleculesAndOrbitals = runStatus == 0 || WebPanel.checkOption(vwr.getP("webMakerAllTabs"));
        if (showMoleculesAndOrbitals) {
            // empty if block
        }
        mainTabs.addTab(GT.$("Log"), LogPanel.getPanel());
        this.add(mainTabs);
        this.add((Component)LogPanel.getMiniPanel(), "South");
    }

    static String TimeStamp_WebLink() {
        return GT.o(GT.$("Page skeleton and JavaScript generated by the Export to Web module of {0} on {1}."), new String[]{" <a href=\"https://jmol.sourceforge.net\">Jmol " + Viewer.getJmolVersion() + "</a> ", DateFormat.getDateInstance().format(new Date())});
    }

    public static void dispose() {
        webFrame.dispose();
        webFrame = null;
    }

    public static WebExport createAndShowGUI(Viewer vwr, HistoryFile historyFile, String wName) {
        if (vwr == null) {
            runStatus = 0;
        }
        if (webFrame != null) {
            webFrame.setVisible(true);
            webFrame.toFront();
            return webExport;
        }
        webFrame = new JFrame(GT.$("Jmol Web Page Maker"));
        String imageName = "org/openscience/jmol/app/images/icon.png";
        URL imageUrl = vwr.getClass().getClassLoader().getResource(imageName);
        ImageIcon jmolIcon = new ImageIcon(imageUrl);
        webFrame.setIconImage(jmolIcon.getImage());
        windowName = wName;
        historyFile.repositionWindow(windowName, webFrame, 700, 400, true);
        if (runStatus == 0) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            webFrame.setDefaultCloseOperation(3);
        } else {
            webFrame.setDefaultCloseOperation(2);
        }
        webExport = new WebExport(vwr, historyFile);
        webExport.setOpaque(true);
        webFrame.setContentPane(webExport);
        webFrame.addWindowListener(webExport);
        webFrame.pack();
        webFrame.setVisible(true);
        if (runStatus == 0) {
            // empty if block
        }
        return webExport;
    }

    public static void saveHistory() {
        if (historyFile == null) {
            return;
        }
        historyFile.addWindowInfo(windowName, webFrame, null);
        prop.setProperty("webMakerAppletPath", remoteAppletPath);
        prop.setProperty("webMakerLocalAppletPath", localAppletPath);
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static String getAppletPath(boolean isRemote) {
        return isRemote ? remoteAppletPath : localAppletPath;
    }

    static void setAppletPath(String path, boolean isRemote) {
        if (path == null) {
            path = chemappsPath;
        }
        if (isRemote) {
            remoteAppletPath = path;
            prop.setProperty("webMakerAppletPath", remoteAppletPath);
            historyFile.addProperties(prop);
        } else {
            localAppletPath = path;
            prop.setProperty("webMakerLocalAppletPath", localAppletPath);
            historyFile.addProperties(prop);
        }
    }

    static String getPageAuthorName() {
        return pageAuthorName;
    }

    static void setWebPageAuthor(String pageAuthor) {
        if (pageAuthor == null) {
            pageAuthor = GT.$("Jmol Web Page Maker");
        }
        pageAuthorName = pageAuthor;
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static void setPopInDim(int appletWidth, int appletHeight) {
        if (appletWidth < 25 || appletWidth > 3000) {
            appletWidth = 300;
        }
        if (appletHeight < 25 || appletHeight > 3000) {
            appletHeight = 300;
        }
        popInWidth = appletWidth;
        popInHeight = appletHeight;
        prop.setProperty("webMakerPopInWidth", "" + appletWidth);
        prop.setProperty("webMakerPopInHeight", "" + appletHeight);
        historyFile.addProperties(prop);
    }

    static int getPopInWidth() {
        return popInWidth;
    }

    static int getPopInHeight() {
        return popInHeight;
    }

    static void setScriptButtonPercent(int percent) {
        if (percent < 10 || percent > 90) {
            percent = 60;
        }
        scriptButtonPercent = percent;
        prop.setProperty("webMakerScriptButtonPercent", "" + percent);
        historyFile.addProperties(prop);
    }

    static int getScriptButtonPercent() {
        return scriptButtonPercent;
    }

    static JFrame getFrame() {
        return webFrame;
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public static void cleanUp() {
        FileSystemView Directories = FileSystemView.getFileSystemView();
        File homedir = Directories.getHomeDirectory();
        String homedirpath = homedir.getPath();
        String scratchpath = homedirpath + "/.jmol_WPM";
        File scratchdir = new File(scratchpath);
        if (scratchdir.exists()) {
            File[] dirListing = null;
            dirListing = scratchdir.listFiles();
            for (int i = 0; i < dirListing.length; ++i) {
                dirListing[i].delete();
            }
        }
        WebExport.saveHistory();
    }

    static {
        prop = new Properties();
    }
}

