/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.gradle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.projectWizard.generators.AssetsNewProjectWizardStep;
import com.intellij.ide.projectWizard.generators.AssetsOnboardingTips;
import com.intellij.ide.wizard.NewProjectWizardChainStep;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.BindUtil;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.DefinedKotlinPluginManagementVersion;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradlePluginVersionKt;
import org.jetbrains.kotlin.tools.projectWizard.BuildSystemKotlinNewProjectWizard;
import org.jetbrains.kotlin.tools.projectWizard.BuildSystemKotlinNewProjectWizardData;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizard;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.KotlinWizardUtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.Versions;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinGradleCompatibilityStore;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinLibrariesCompatibilityStore;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinWizardVersionState;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinWizardVersionStore;
import org.jetbrains.kotlin.tools.projectWizard.core.KotlinAssetsProvider;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinNewProjectWizard;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinNewProjectWizardData;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinNewProjectWizardKt;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.wizard.AssetsKotlinKt;
import org.jetbrains.kotlin.tools.projectWizard.wizard.KotlinNewProjectWizardUIBundle;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaKotlinVersionProviderService;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleDsl;
import org.jetbrains.plugins.gradle.frameworkSupport.buildscript.GradleBuildScriptBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.settingsScript.GradleSettingScriptBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.AssetsGradleKt;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleAssetsNewProjectWizardStep;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleNewProjectWizardStep;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard;", "Lorg/jetbrains/kotlin/tools/projectWizard/BuildSystemKotlinNewProjectWizard;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "ordinal", "", "getOrdinal", "()I", "createStep", "Lcom/intellij/ide/wizard/NewProjectWizardStep;", "parent", "Lorg/jetbrains/kotlin/tools/projectWizard/KotlinNewProjectWizard$Step;", "Step", "AssetsStep", "kotlin.project-wizard.gradle"})
public final class GradleKotlinNewProjectWizard
implements BuildSystemKotlinNewProjectWizard {
    @NotNull
    private final String name;
    private final int ordinal;

    public GradleKotlinNewProjectWizard() {
        this.name = "Gradle";
        this.ordinal = 200;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public NewProjectWizardStep createStep(@NotNull KotlinNewProjectWizard.Step parent2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        return (NewProjectWizardStep)NewProjectWizardChainStep.Companion.nextStep((NewProjectWizardStep)new Step(parent2), (Function1)createStep.1.INSTANCE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$AssetsStep;", "Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleAssetsNewProjectWizardStep;", "Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;", "parent", "<init>", "(Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;)V", "setupAssets", "", "project", "Lcom/intellij/openapi/project/Project;", "setupCommonProjectAssets", "setupSingleModuleProjectAssets", "setupMultiModuleProjectAssets", "kotlin.project-wizard.gradle"})
    private static final class AssetsStep
    extends GradleAssetsNewProjectWizardStep<Step> {
        public AssetsStep(@NotNull Step parent2) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            super((GradleNewProjectWizardStep)parent2);
        }

        public void setupAssets(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.setupCommonProjectAssets();
            if (((Step)this.getParent()).getShouldGenerateMultipleModules$kotlin_project_wizard_gradle()) {
                this.setupMultiModuleProjectAssets(project);
            } else {
                this.setupSingleModuleProjectAssets(project);
            }
        }

        private final void setupCommonProjectAssets() {
            if (this.getContext().isCreatingNewProject()) {
                this.addAssets(KotlinAssetsProvider.INSTANCE.getKotlinGradleIgnoreAssets());
                AssetsGradleKt.addGradleWrapperAsset((AssetsNewProjectWizardStep)((AssetsNewProjectWizardStep)this), (GradleVersion)((Step)this.getParent()).getGradleVersionToUse());
            }
        }

        private final void setupSingleModuleProjectAssets(Project project) {
            if (this.getContext().isCreatingNewProject()) {
                this.addTemplateAsset("gradle.properties", "KotlinCodeStyleProperties", new Pair[0]);
            }
            this.addEmptyDirectoryAsset("src/main/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("src/main/resources", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("src/test/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("src/test/resources", new PosixFilePermission[0]);
            if (((Step)this.getParent()).getAddSampleCode()) {
                AssetsKotlinKt.withKotlinSampleCode$default((AssetsNewProjectWizardStep)this, project, "src/main/kotlin", ((Step)this.getParent()).getGroupId(), null, null, false, 56, null);
            }
            this.addOrConfigureSettingsScript(arg_0 -> AssetsStep.setupSingleModuleProjectAssets$lambda$0(this, arg_0));
            this.addBuildScript(arg_0 -> AssetsStep.setupSingleModuleProjectAssets$lambda$3(this, project, arg_0));
        }

        private final void setupMultiModuleProjectAssets(Project project) {
            String string;
            String coroutinesVersion;
            String string2;
            String datetimeVersion;
            boolean bl = this.getContext().isCreatingNewProject();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            KotlinLibrariesCompatibilityStore librariesVersionStore = KotlinLibrariesCompatibilityStore.Companion.getInstance();
            String string4 = librariesVersionStore.getLatestVersion("org.jetbrains.kotlinx", "kotlinx-datetime");
            if (string4 == null) {
                string4 = datetimeVersion = "";
            }
            if ((string2 = librariesVersionStore.getLatestVersion("org.jetbrains.kotlinx", "kotlinx-coroutines-core")) == null) {
                string2 = coroutinesVersion = "";
            }
            if ((string = librariesVersionStore.getLatestVersion("org.jetbrains.kotlinx", "kotlinx-serialization-json")) == null) {
                string = "";
            }
            String serializationJsonVersion = string;
            Pair[] pairArray = new Pair[8];
            pairArray[0] = TuplesKt.to((Object)"PROJECT_NAME", (Object)((Step)this.getParent()).getName());
            pairArray[1] = TuplesKt.to((Object)"PACKAGE_NAME", (Object)((Step)this.getParent()).getGroupId());
            pairArray[2] = TuplesKt.to((Object)"KOTLIN_VERSION", (Object)Versions.INSTANCE.getKOTLIN());
            pairArray[3] = TuplesKt.to((Object)"FOOJAY_VERSION", (Object)Versions.GRADLE_PLUGINS.INSTANCE.getFOOJAY_VERSION());
            Object object = ((Step)this.getParent()).getSelectedJdkJvmTarget();
            if (object == null || (object = ((Integer)object).toString()) == null) {
                object = "21";
            }
            pairArray[4] = TuplesKt.to((Object)"JVM_VERSION", (Object)object);
            pairArray[5] = TuplesKt.to((Object)"KOTLINX_DATETIME_VERSION", (Object)datetimeVersion);
            pairArray[6] = TuplesKt.to((Object)"KOTLINX_SERIALIZATION_JSON_VERSION", (Object)serializationJsonVersion);
            pairArray[7] = TuplesKt.to((Object)"KOTLINX_COROUTINES_VERSION", (Object)coroutinesVersion);
            Map templateParameters = MapsKt.mapOf((Pair[])pairArray);
            this.addTemplateAsset("gradle.properties", "KotlinSampleProperties", templateParameters);
            this.addTemplateAsset("gradle/libs.versions.toml", "KotlinSampleGradleToml", templateParameters);
            this.addTemplateAsset("settings.gradle.kts", "KotlinSampleSettings", templateParameters);
            this.addTemplateAsset("README.md", "KotlinSampleReadme", templateParameters);
            this.addTemplateAsset("buildSrc/build.gradle.kts", "KotlinSampleBuildSrcBuildGradle", templateParameters);
            this.addTemplateAsset("buildSrc/settings.gradle.kts", "KotlinSampleBuildSrcSettings", templateParameters);
            this.addTemplateAsset("buildSrc/src/main/kotlin/kotlin-jvm.gradle.kts", "KotlinSampleConventionPlugin", templateParameters);
            this.addEmptyDirectoryAsset("app/src/main/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("app/src/main/resources", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("app/src/test/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("app/src/test/resources", new PosixFilePermission[0]);
            this.addTemplateAsset("app/build.gradle.kts", "KotlinSampleAppBuildGradle", templateParameters);
            if (((Step)this.getParent()).getAddSampleCode()) {
                String templateName = AssetsOnboardingTips.INSTANCE.shouldRenderOnboardingTips() ? "KotlinSampleAppWithRenderedOnboardingTips" : "KotlinSampleAppWithOnboardingTips";
                AssetsKotlinKt.withKotlinSampleCode$default((AssetsNewProjectWizardStep)this, project, "app/src/main/kotlin", ((Step)this.getParent()).getGroupId(), "App.kt", templateName, false, 32, null);
            }
            this.addEmptyDirectoryAsset("utils/src/main/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("utils/src/main/resources", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("utils/src/test/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("utils/src/test/resources", new PosixFilePermission[0]);
            this.addTemplateAsset("utils/build.gradle.kts", "KotlinSampleUtilsBuildGradle", templateParameters);
            if (((Step)this.getParent()).getAddSampleCode()) {
                this.addTemplateAsset("utils/src/main/kotlin/Utilities.kt", "KotlinSampleUtilsUtilities", templateParameters);
                this.addTemplateAsset("utils/src/test/kotlin/UtilitiesTest.kt", "KotlinSampleUtilsUtilitiesTest", templateParameters);
            }
        }

        private static final Unit setupSingleModuleProjectAssets$lambda$0(AssetsStep this$0, GradleSettingScriptBuilder $this$addOrConfigureSettingsScript) {
            Intrinsics.checkNotNullParameter((Object)$this$addOrConfigureSettingsScript, (String)"$this$addOrConfigureSettingsScript");
            if (((Step)this$0.getParent()).isCreatingNewLinkedProject() && ((Step)this$0.getParent()).isFoojayPluginSupported() || ((Step)this$0.getParent()).isCreatingDaemonToolchain()) {
                $this$addOrConfigureSettingsScript.withFoojayPlugin();
            }
            return Unit.INSTANCE;
        }

        private static final Unit setupSingleModuleProjectAssets$lambda$3(AssetsStep this$0, Project $project, GradleBuildScriptBuilder $this$addBuildScript) {
            block1: {
                String string;
                Intrinsics.checkNotNullParameter((Object)$this$addBuildScript, (String)"$this$addBuildScript");
                $this$addBuildScript.addGroup(((Step)this$0.getParent()).getGroupId());
                $this$addBuildScript.addVersion(((Step)this$0.getParent()).getVersion());
                String it = string = ((Step)this$0.getParent()).getKotlinVersionToUse();
                boolean bl = false;
                String kotlinVersion = !(((Step)this$0.getParent()).usesPluginManagementKotlinVersion($project) || ((Step)this$0.getParent()).usesParentKotlinVersion($project) || ((Step)this$0.getParent()).usesVersionCatalogVersionInBuildSrc($project)) ? string : null;
                $this$addBuildScript.withKotlinJvmPlugin(kotlinVersion);
                $this$addBuildScript.withKotlinTest();
                Integer n = ((Step)this$0.getParent()).getSelectedJdkJvmTarget();
                if (n == null) break block1;
                int it2 = ((Number)n).intValue();
                boolean bl2 = false;
                if (((Step)this$0.getParent()).isFoojayPluginSupported()) {
                    $this$addBuildScript.withKotlinJvmToolchain(it2);
                }
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0014J\"\u0010#\u001a\u0004\u0018\u00010&2\u0006\u0010\u001f\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\nH\u0014J\u0010\u0010)\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010)\u001a\u0004\u0018\u00010&*\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010&*\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\nH\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u000f\u00102\u001a\u0004\u0018\u00010-H\u0002\u00a2\u0006\u0002\u00100J\b\u00103\u001a\u00020\nH\u0014J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u00020:H\u0002J\u000e\u0010;\u001a\u0004\u0018\u00010<*\u00020:H\u0002J\u000e\u0010=\u001a\u00020\n2\u0006\u00109\u001a\u00020:J\u000e\u0010>\u001a\u00020\n2\u0006\u00109\u001a\u00020:J\u000e\u0010?\u001a\u00020\n2\u0006\u00109\u001a\u00020:J\u0010\u0010@\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR+\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012*\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R$\u0010.\u001a\u0004\u0018\u00010-2\b\u0010,\u001a\u0004\u0018\u00010-@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R\u001e\u00105\u001a\u0002042\u0006\u0010,\u001a\u000204@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0018\u0010A\u001a\u000204X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bB\u00107\"\u0004\bC\u0010DR\u0018\u0010E\u001a\b\u0012\u0004\u0012\u0002040\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bF\u0010\fR\u0014\u0010G\u001a\u0002048VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bH\u00107R\u001c\u0010I\u001a\u0002048\u0016@\u0016X\u0097\u000f\u00a2\u0006\f\u001a\u0004\bJ\u00107\"\u0004\bK\u0010DR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u0002040\t8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u0010\fR\u0018\u0010N\u001a\u000204X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bO\u00107\"\u0004\bP\u0010DR\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u0002040\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bR\u0010\fR\u0018\u0010S\u001a\u000204X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bT\u00107\"\u0004\bU\u0010DR\u0018\u0010V\u001a\b\u0012\u0004\u0012\u0002040\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bW\u0010\fR\u0014\u0010X\u001a\u00020Y8VX\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;", "Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleNewProjectWizardStep;", "Lorg/jetbrains/kotlin/tools/projectWizard/KotlinNewProjectWizard$Step;", "Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizardData;", "Lorg/jetbrains/kotlin/tools/projectWizard/BuildSystemKotlinNewProjectWizardData;", "parent", "<init>", "(Lorg/jetbrains/kotlin/tools/projectWizard/KotlinNewProjectWizard$Step;)V", "addSampleCodeProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "getAddSampleCodeProperty", "()Lcom/intellij/openapi/observable/properties/GraphProperty;", "<set-?>", "addSampleCode", "getAddSampleCode", "()Z", "setAddSampleCode", "(Z)V", "addSampleCode$delegate", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "generateMultipleModulesProperty", "generateMultipleModules", "getGenerateMultipleModules$delegate", "(Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;)Ljava/lang/Object;", "getGenerateMultipleModules", "setGenerateMultipleModules", "shouldGenerateMultipleModules", "getShouldGenerateMultipleModules$kotlin_project_wizard_gradle", "setupSampleCodeUI", "", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "setupMultipleModulesUI", "setupSettingsUI", "validateGradleVersion", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "withDialog", "validateLanguageCompatibility", "validateMultiModuleSupport", "setupAdvancedSettingsUI", "value", "", "selectedJdkJvmTarget", "getSelectedJdkJvmTarget", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "resolveSelectedJvmTarget", "resolveIsFoojayPluginSupported", "", "kotlinVersionToUse", "getKotlinVersionToUse", "()Ljava/lang/String;", "resolveKotlinVersionToUse", "project", "Lcom/intellij/openapi/project/Project;", "findParentModule", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleSourceRootGroup;", "usesParentKotlinVersion", "usesPluginManagementKotlinVersion", "usesVersionCatalogVersionInBuildSrc", "setupProject", "buildSystem", "getBuildSystem", "setBuildSystem", "(Ljava/lang/String;)V", "buildSystemProperty", "getBuildSystemProperty", "contentEntryPath", "getContentEntryPath", "language", "getLanguage", "setLanguage", "languageProperty", "getLanguageProperty", "name", "getName", "setName", "nameProperty", "getNameProperty", "path", "getPath", "setPath", "pathProperty", "getPathProperty", "projectPath", "Ljava/nio/file/Path;", "getProjectPath", "()Ljava/nio/file/Path;", "kotlin.project-wizard.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleKotlinNewProjectWizard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleKotlinNewProjectWizard.kt\norg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,424:1\n1#2:425\n1#2:436\n1617#3,9:426\n1869#3:435\n1870#3:437\n1626#3:438\n774#3:439\n865#3,2:440\n1999#3,14:442\n1761#3,3:456\n1310#4,2:459\n183#5,2:461\n*S KotlinDebug\n*F\n+ 1 GradleKotlinNewProjectWizard.kt\norg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step\n*L\n258#1:436\n258#1:426,9\n258#1:435\n258#1:437\n258#1:438\n262#1:439\n262#1:440,2\n263#1:442,14\n270#1:456,3\n286#1:459,2\n296#1:461,2\n*E\n"})
    public static final class Step
    extends GradleNewProjectWizardStep<KotlinNewProjectWizard.Step>
    implements GradleKotlinNewProjectWizardData,
    BuildSystemKotlinNewProjectWizardData {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        private final /* synthetic */ KotlinNewProjectWizard.Step $$delegate_0;
        @NotNull
        private final GraphProperty<Boolean> addSampleCodeProperty;
        @NotNull
        private final GraphProperty addSampleCode$delegate;
        @NotNull
        private final GraphProperty<Boolean> generateMultipleModulesProperty;
        @Nullable
        private Integer selectedJdkJvmTarget;
        private String kotlinVersionToUse;

        public Step(@NotNull KotlinNewProjectWizard.Step parent2) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            super((NewProjectWizardStep)parent2);
            this.$$delegate_0 = parent2;
            this.getData().putUserData(GradleKotlinNewProjectWizardData.Companion.getKEY(), (Object)this);
            this.addSampleCodeProperty = (GraphProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)this.getPropertyGraph().property((Object)true)), (String)"NewProjectWizard.addSampleCodeState");
            this.addSampleCode$delegate = this.getAddSampleCodeProperty();
            this.generateMultipleModulesProperty = (GraphProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)this.getPropertyGraph().property((Object)false)), (String)"NewProjectWizard.generateMultipleModules");
        }

        @Override
        @NotNull
        public GraphProperty<Boolean> getAddSampleCodeProperty() {
            return this.addSampleCodeProperty;
        }

        @Override
        public boolean getAddSampleCode() {
            return (Boolean)this.addSampleCode$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @Override
        public void setAddSampleCode(boolean bl) {
            this.addSampleCode$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        @Override
        public boolean getGenerateMultipleModules() {
            return (Boolean)this.generateMultipleModulesProperty.getValue((Object)this, $$delegatedProperties[1]);
        }

        @Override
        public void setGenerateMultipleModules(boolean bl) {
            this.generateMultipleModulesProperty.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
        }

        private static Object getGenerateMultipleModules$delegate(Step step2) {
            return step2.generateMultipleModulesProperty;
        }

        public final boolean getShouldGenerateMultipleModules$kotlin_project_wizard_gradle() {
            return this.getGenerateMultipleModules() && this.getGradleDsl() == GradleDsl.KOTLIN && this.getContext().isCreatingNewProject() && this.getGradleVersionToUse().compareTo(GradleKotlinNewProjectWizardKt.access$getMIN_GRADLE_VERSION_BUILD_SRC$p()) >= 0;
        }

        private final void setupSampleCodeUI(Panel builder2) {
            Panel.row$default((Panel)builder2, null, arg_0 -> Step.setupSampleCodeUI$lambda$2(this, arg_0), (int)1, null);
        }

        private final void setupMultipleModulesUI(Panel builder2) {
            Panel.row$default((Panel)builder2, null, arg_0 -> Step.setupMultipleModulesUI$lambda$5(this, arg_0), (int)1, null).visibleIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this.getGradleDslProperty()), (Object)GradleDsl.KOTLIN));
        }

        protected void setupSettingsUI(@NotNull Panel builder2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            this.setupJavaSdkUI(builder2);
            this.setupGradleDslUI(builder2);
            this.setupParentsUI(builder2);
            this.setupSampleCodeUI(builder2);
            if (this.getContext().isCreatingNewProject()) {
                this.setupMultipleModulesUI(builder2);
                KotlinWizardUtilsKt.addMultiPlatformLink((NewProjectWizardStep)this, builder2);
            }
        }

        protected boolean validateGradleVersion(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            return this.validateLanguageCompatibility(gradleVersion) && this.validateMultiModuleSupport(gradleVersion);
        }

        @Nullable
        protected ValidationInfo validateGradleVersion(@NotNull ValidationInfoBuilder builder2, @NotNull GradleVersion gradleVersion, boolean withDialog) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            ValidationInfo validationInfo = this.validateLanguageCompatibility(builder2, gradleVersion, withDialog);
            if (validationInfo == null) {
                validationInfo = this.validateMultiModuleSupport(builder2, gradleVersion, withDialog);
            }
            return validationInfo;
        }

        private final boolean validateLanguageCompatibility(GradleVersion gradleVersion) {
            String kotlinVersion = new IdeaKotlinVersionProviderService().getKotlinVersion(ProjectKind.Singleplatform).getVersion().getText();
            return KotlinGradleCompatibilityStore.Companion.kotlinVersionSupportsGradle(IdeKotlinVersion.Companion.get(kotlinVersion), gradleVersion);
        }

        private final ValidationInfo validateLanguageCompatibility(ValidationInfoBuilder $this$validateLanguageCompatibility, GradleVersion gradleVersion, boolean withDialog) {
            if (this.validateLanguageCompatibility(gradleVersion)) {
                return null;
            }
            String kotlinVersion = new IdeaKotlinVersionProviderService().getKotlinVersion(ProjectKind.Singleplatform).getVersion().getText();
            Object[] objectArray = new Object[2];
            objectArray[0] = kotlinVersion;
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion.getVersion(), (String)"getVersion(...)");
            String string = KotlinNewProjectWizardBundle.message("gradle.project.settings.distribution.version.kotlin.unsupported", objectArray);
            String string2 = GradleBundle.message((String)"gradle.settings.wizard.gradle.unsupported.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            objectArray = new Object[2];
            objectArray[0] = kotlinVersion;
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion.getVersion(), (String)"getVersion(...)");
            return this.validationWithDialog($this$validateLanguageCompatibility, withDialog, string, string2, KotlinNewProjectWizardBundle.message("gradle.settings.wizard.unsupported.kotlin.message", objectArray));
        }

        private final boolean validateMultiModuleSupport(GradleVersion gradleVersion) {
            return !this.getGenerateMultipleModules() || gradleVersion.compareTo(GradleKotlinNewProjectWizardKt.access$getMIN_GRADLE_VERSION_BUILD_SRC$p()) >= 0;
        }

        private final ValidationInfo validateMultiModuleSupport(ValidationInfoBuilder $this$validateMultiModuleSupport, GradleVersion gradleVersion, boolean withDialog) {
            if (this.validateMultiModuleSupport(gradleVersion)) {
                return null;
            }
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion.getVersion(), (String)"getVersion(...)");
            String string = KotlinNewProjectWizardBundle.message("gradle.settings.wizard.unsupported.multi.module.message", objectArray);
            String string2 = GradleBundle.message((String)"gradle.settings.wizard.gradle.unsupported.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion.getVersion(), (String)"getVersion(...)");
            return this.errorWithDialog($this$validateMultiModuleSupport, withDialog, string, string2, KotlinNewProjectWizardBundle.message("gradle.settings.wizard.unsupported.multi.module.message", objectArray));
        }

        protected void setupAdvancedSettingsUI(@NotNull Panel builder2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            this.setupGradleDistributionUI(builder2);
            this.setupGroupIdUI(builder2);
            this.setupArtifactIdUI(builder2);
        }

        @Nullable
        public final Integer getSelectedJdkJvmTarget() {
            return this.selectedJdkJvmTarget;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Integer resolveSelectedJvmTarget() {
            Sdk sdk = this.getSdk();
            Sdk sdk2 = sdk;
            if (sdk == null) return null;
            Sdk it = sdk2;
            boolean bl = false;
            JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(it);
            sdk2 = javaSdkVersion;
            if (javaSdkVersion == null) return null;
            Integer n = sdk2.ordinal();
            return n;
        }

        /*
         * Unable to fully structure code
         */
        protected boolean resolveIsFoojayPluginSupported() {
            if (!super.resolveIsFoojayPluginSupported()) {
                return false;
            }
            var2_1 = IdeKotlinVersion.Companion.parse-IoAF18A(this.getKotlinVersionToUse());
            parsedKotlinVersionToUse = (IdeKotlinVersion)(Result.isFailure-impl((Object)var2_1) != false ? null : var2_1);
            var3_3 = IdeKotlinVersion.Companion.parse-IoAF18A(Versions.GRADLE_PLUGINS.INSTANCE.getMIN_KOTLIN_FOOJAY_VERSION().getText());
            parsedMinKotlinFoojayVersion = (IdeKotlinVersion)(Result.isFailure-impl((Object)var3_3) != false ? null : var3_3);
            if (parsedMinKotlinFoojayVersion != null && parsedKotlinVersionToUse != null && parsedKotlinVersionToUse.compareTo(parsedMinKotlinFoojayVersion) < 0) {
                return false;
            }
            v0 = parsedKotlinVersionToUse;
            if (v0 == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-GradleKotlinNewProjectWizard$Step$resolveIsFoojayPluginSupported$maxJvmTarget$1 = false;
            v1 = KotlinGradleCompatibilityStore.Companion.getMaxJvmTarget(it);
            v0 = v1;
            if (v1 != null) {
                v2 = v0.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v2 = 11;
            }
            maxJvmTarget = v2;
            v3 = this.selectedJdkJvmTarget;
            if (v3 != null) {
                it = ((Number)v3).intValue();
                $i$a$-let-GradleKotlinNewProjectWizard$Step$resolveIsFoojayPluginSupported$1 = false;
                if (it > maxJvmTarget) {
                    return false;
                }
            }
            return true;
        }

        @NotNull
        public final String getKotlinVersionToUse() {
            String string = this.kotlinVersionToUse;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"kotlinVersionToUse");
            return null;
        }

        private final String resolveKotlinVersionToUse(Project project) {
            Object kotlinPluginVersion;
            Object object = (KotlinWizardVersionState)KotlinWizardVersionStore.Companion.getInstance().getState();
            if (object == null || (object = object.getKotlinPluginVersion()) == null) {
                object = kotlinPluginVersion = "1.9.0";
            }
            if (this.isCreatingNewLinkedProject()) {
                return kotlinPluginVersion;
            }
            ModuleSourceRootGroup moduleSourceRootGroup = this.findParentModule(project);
            if (moduleSourceRootGroup == null || (moduleSourceRootGroup = moduleSourceRootGroup.getBaseModule()) == null) {
                return kotlinPluginVersion;
            }
            ModuleSourceRootGroup parentModule = moduleSourceRootGroup;
            IdeKotlinVersion bestKotlinVersion = KotlinWithGradleConfigurator.Companion.findBestKotlinVersion((Module)parentModule, this.getGradleVersionToUse());
            Object object2 = bestKotlinVersion;
            if (object2 == null || (object2 = ((IdeKotlinVersion)object2).getRawVersion()) == null) {
                object2 = kotlinPluginVersion;
            }
            return object2;
        }

        /*
         * WARNING - void declaration
         */
        private final ModuleSourceRootGroup findParentModule(Project $this$findParentModule) {
            Object v0;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            if (this.isCreatingNewLinkedProject()) {
                return null;
            }
            ModuleSourceRootMap moduleGroups = new ModuleSourceRootMap($this$findParentModule);
            Iterable iterable = moduleGroups.groupByBaseModules(ArraysKt.toList((Object[])ProjectUtil.getModules((Project)$this$findParentModule)));
            boolean $i$f$mapNotNull = false;
            void var6_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Pair pair = $this$forEach$iv$iv$iv.iterator();
            while (pair.hasNext()) {
                Pair it$iv$iv;
                String externalPath;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = pair.next();
                boolean bl = false;
                ModuleSourceRootGroup it = (ModuleSourceRootGroup)element$iv$iv;
                boolean bl2 = false;
                if ((ExternalSystemApiUtil.getExternalProjectPath((Module)it.getBaseModule()) == null ? null : TuplesKt.to((Object)it, (Object)externalPath)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                pair = (Pair)element$iv$iv;
                boolean bl = false;
                String externalPath = (String)pair.component2();
                if (!StringsKt.startsWith$default((String)this.getPath(), (String)externalPath, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Pair $i$f$filterTo2 = (Pair)maxElem$iv;
                    boolean bl = false;
                    String externalPath2 = (String)$i$f$filterTo2.component2();
                    int maxValue$iv = StringsKt.commonPrefixWith$default((CharSequence)this.getPath(), (CharSequence)externalPath2, (boolean)false, (int)2, null).length();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair externalPath2 = (Pair)e$iv;
                        $i$a$-maxByOrNull-GradleKotlinNewProjectWizard$Step$findParentModule$3 = false;
                        String externalPath3 = (String)externalPath2.component2();
                        int v$iv = StringsKt.commonPrefixWith$default((CharSequence)this.getPath(), (CharSequence)externalPath3, (boolean)false, (int)2, null).length();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Pair pair2 = v0;
            return pair2 != null ? (ModuleSourceRootGroup)pair2.getFirst() : null;
        }

        public final boolean usesParentKotlinVersion(@NotNull Project project) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ModuleSourceRootGroup moduleSourceRootGroup = this.findParentModule(project);
                if (moduleSourceRootGroup == null) {
                    return false;
                }
                ModuleSourceRootGroup parentModule = moduleSourceRootGroup;
                Iterable $this$any$iv = parentModule.getSourceRootModules();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Module it = (Module)element$iv;
                        boolean bl2 = false;
                        if (!(KotlinGradlePluginVersionKt.getKotlinGradlePluginVersion(it) != null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean usesPluginManagementKotlinVersion(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (this.isCreatingNewLinkedProject()) {
                return false;
            }
            ModuleSourceRootGroup moduleSourceRootGroup = this.findParentModule(project);
            if (moduleSourceRootGroup == null || (moduleSourceRootGroup = moduleSourceRootGroup.getBaseModule()) == null) {
                return false;
            }
            ModuleSourceRootGroup parentModule = moduleSourceRootGroup;
            DefinedKotlinPluginManagementVersion definedKotlinPluginManagementVersion = KotlinWithGradleConfigurator.Companion.getPluginManagementVersion((Module)parentModule);
            if (definedKotlinPluginManagementVersion == null) {
                return false;
            }
            DefinedKotlinPluginManagementVersion version = definedKotlinPluginManagementVersion;
            return version.getParsedVersion() != null;
        }

        public final boolean usesVersionCatalogVersionInBuildSrc(@NotNull Project project) {
            Object object;
            Module module;
            block11: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (this.isCreatingNewLinkedProject()) {
                    return false;
                }
                Module[] $this$firstOrNull$iv = ProjectUtil.getModules((Project)project);
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    Module element$iv;
                    Module it = element$iv = $this$firstOrNull$iv[j];
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)".buildSrc", (boolean)false, (int)2, null)) continue;
                    module = element$iv;
                    break block11;
                }
                module = null;
            }
            if (module == null) {
                return false;
            }
            Module buildSrcModule = module;
            PsiFile psiFile = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(buildSrcModule);
            if (psiFile == null) {
                return false;
            }
            PsiFile buildSrcBuildFile = psiFile;
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            if (virtualFile == null || (virtualFile = virtualFile.findChild("gradle")) == null) {
                return false;
            }
            VirtualFile gradleFolder = virtualFile;
            Object object2 = this;
            try {
                Object v9;
                block12: {
                    Step $this$usesVersionCatalogVersionInBuildSrc_u24lambda_u2415 = object2;
                    boolean bl = false;
                    Object object3 = gradleFolder.findChild("libs.versions.toml");
                    if (object3 == null || (object3 = object3.toNioPath()) == null || (object3 = object3.toFile()) == null) {
                        return false;
                    }
                    Object tomlFile = object3;
                    JsonNode tomlTree = new TomlMapper().readTree((File)tomlFile);
                    JsonNode jsonNode = tomlTree.get("libraries");
                    if (jsonNode == null) {
                        return false;
                    }
                    JsonNode libraryEntries = jsonNode;
                    Iterator iterator2 = libraryEntries.fields();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"fields(...)");
                    Sequence $this$firstOrNull$iv = SequencesKt.asSequence((Iterator)iterator2);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Map.Entry entry = (Map.Entry)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)entry);
                        JsonNode node = (JsonNode)entry.getValue();
                        Object object4 = node.get("module");
                        boolean bl3 = object4 != null && (object4 = object4.asText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object4), (CharSequence)"org.jetbrains.kotlin:kotlin-gradle-plugin", (boolean)false, (int)2, null) : false;
                        if (!bl3) continue;
                        v9 = element$iv;
                        break block12;
                    }
                    v9 = null;
                }
                Map.Entry entry = v9;
                object = Result.constructor-impl(entry != null ? (String)entry.getKey() : null);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (string == null) {
                return false;
            }
            String gradlePluginKey = string;
            String string2 = buildSrcBuildFile.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return StringsKt.contains$default((CharSequence)string2, (CharSequence)gradlePluginKey, (boolean)false, (int)2, null);
        }

        public void setupProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.selectedJdkJvmTarget = this.resolveSelectedJvmTarget();
            this.kotlinVersionToUse = this.resolveKotlinVersionToUse(project);
        }

        @NotNull
        public GraphProperty<String> getBuildSystemProperty() {
            return this.$$delegate_0.getBuildSystemProperty();
        }

        @NotNull
        public String getBuildSystem() {
            return this.$$delegate_0.getBuildSystem();
        }

        public void setBuildSystem(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.$$delegate_0.setBuildSystem(string);
        }

        @NotNull
        public GraphProperty<String> getLanguageProperty() {
            return this.$$delegate_0.getLanguageProperty();
        }

        @NotNull
        public String getLanguage() {
            return this.$$delegate_0.getLanguage();
        }

        public void setLanguage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.$$delegate_0.setLanguage(string);
        }

        @NotNull
        public GraphProperty<String> getNameProperty() {
            return this.$$delegate_0.getNameProperty();
        }

        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        public void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.$$delegate_0.setName(string);
        }

        @NotNull
        public GraphProperty<String> getPathProperty() {
            return this.$$delegate_0.getPathProperty();
        }

        @NotNull
        public String getPath() {
            return this.$$delegate_0.getPath();
        }

        public void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.$$delegate_0.setPath(string);
        }

        @NotNull
        public String getContentEntryPath() {
            return this.$$delegate_0.getContentEntryPath();
        }

        @NotNull
        public Path getProjectPath() {
            return this.$$delegate_0.getProjectPath();
        }

        private static final Unit setupSampleCodeUI$lambda$2$lambda$0(Step this$0, boolean it) {
            NewProjectWizardCollector.Base.INSTANCE.logAddSampleCodeChanged((NewProjectWizardStep)this$0, it);
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeUI$lambda$2$lambda$1(Step this$0) {
            NewProjectWizardCollector.Base.INSTANCE.logAddSampleCodeFinished((NewProjectWizardStep)this$0, this$0.getAddSampleCode());
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeUI$lambda$2(Step this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = UIBundle.message((String)"label.project.wizard.new.project.add.sample.code", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.whenStateChangedFromUi$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (ObservableMutableProperty)((ObservableMutableProperty)this$0.getAddSampleCodeProperty())), null, arg_0 -> Step.setupSampleCodeUI$lambda$2$lambda$0(this$0, arg_0), (int)1, null).onApply(() -> Step.setupSampleCodeUI$lambda$2$lambda$1(this$0));
            return Unit.INSTANCE;
        }

        private static final Unit setupMultipleModulesUI$lambda$5$lambda$3(Step this$0, boolean it) {
            NewProjectWizardCollector.Kotlin.INSTANCE.logGenerateMultipleModulesChanged((NewProjectWizardStep)this$0, it);
            return Unit.INSTANCE;
        }

        private static final Unit setupMultipleModulesUI$lambda$5$lambda$4(Step this$0) {
            NewProjectWizardCollector.Kotlin.INSTANCE.logGenerateMultipleModulesFinished((NewProjectWizardStep)this$0, this$0.getShouldGenerateMultipleModules$kotlin_project_wizard_gradle());
            return Unit.INSTANCE;
        }

        private static final Unit setupMultipleModulesUI$lambda$5(Step this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.whenStateChangedFromUi$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(KotlinNewProjectWizardUIBundle.message("label.project.wizard.new.project.generate.multiple.modules", new Object[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.generateMultipleModulesProperty)).enabledIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.getGradleDslProperty()), (Object)GradleDsl.KOTLIN)), null, arg_0 -> Step.setupMultipleModulesUI$lambda$5$lambda$3(this$0, arg_0), (int)1, null).onApply(() -> Step.setupMultipleModulesUI$lambda$5$lambda$4(this$0));
            Row.contextHelp$default((Row)$this$row, (String)KotlinNewProjectWizardUIBundle.message("tooltip.project.wizard.new.project.generate.multiple.modules", new Object[0]), null, (int)2, null);
            return Unit.INSTANCE;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Step.class, "addSampleCode", "getAddSampleCode()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Step.class, "generateMultipleModules", "getGenerateMultipleModules()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

