/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AddJvmOverloadsIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nAddJvmOverloadsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddJvmOverloadsIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AddJvmOverloadsIntention\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n125#2:76\n1761#3,3:77\n*S KotlinDebug\n*F\n+ 1 AddJvmOverloadsIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AddJvmOverloadsIntention\n*L\n43#1:76\n60#1:77,3\n*E\n"})
public final class AddJvmOverloadsIntention
extends SelfTargetingIntention<KtModifierListOwner>
implements LowPriorityAction {
    public AddJvmOverloadsIntention() {
        super(KtModifierListOwner.class, KotlinBundle.lazyMessage((String)"add.jvmoverloads.annotation", (Object[])new Object[0]), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtModifierListOwner element, int caretOffset) {
        KtParameter it;
        List parameters2;
        Object[] $this$safeAs$iv;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtModifierListOwner ktModifierListOwner = element;
        if (ktModifierListOwner instanceof KtNamedFunction) {
            PsiElement psiElement = ((KtNamedFunction)element).getFunKeyword();
            if (psiElement == null) {
                return false;
            }
            PsiElement funKeyword = psiElement;
            KtParameterList ktParameterList = ((KtNamedFunction)element).getValueParameterList();
            if (ktParameterList == null) {
                return false;
            }
            valueParameterList = ktParameterList;
            int n = PsiUtilsKt.getStartOffset((PsiElement)funKeyword);
            if (caretOffset > PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)valueParameterList))) return false;
            if (n > caretOffset) return false;
            boolean bl = true;
            if (!bl) {
                return false;
            }
            Object[] objectArray = new Object[]{String.valueOf(((KtNamedFunction)element).getName())};
            pair = TuplesKt.to((Object)KotlinBundle.message((String)"function.0", (Object[])objectArray), (Object)valueParameterList.getParameters());
        } else if (ktModifierListOwner instanceof KtSecondaryConstructor) {
            PsiElement constructorKeyword = ((KtSecondaryConstructor)element).getConstructorKeyword();
            KtParameterList ktParameterList = ((KtSecondaryConstructor)element).getValueParameterList();
            if (ktParameterList == null) {
                return false;
            }
            valueParameterList = ktParameterList;
            int n = PsiUtilsKt.getStartOffset((PsiElement)constructorKeyword);
            if (caretOffset > PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)valueParameterList))) return false;
            if (n > caretOffset) return false;
            boolean bl = true;
            if (!bl) {
                return false;
            }
            pair = TuplesKt.to((Object)KotlinBundle.message((String)"text.secondary.constructor", (Object[])new Object[0]), (Object)valueParameterList.getParameters());
        } else {
            boolean bl;
            boolean bl2;
            if (!(ktModifierListOwner instanceof KtPrimaryConstructor)) return false;
            $this$safeAs$iv = ((KtPrimaryConstructor)element).getParent();
            boolean $i$f$safeAs = false;
            Object[] objectArray = $this$safeAs$iv;
            if (!($this$safeAs$iv instanceof KtClass)) {
                objectArray = null;
            }
            KtClass ktClass = (KtClass)objectArray;
            if (ktClass != null) {
                if (ktClass.isAnnotation()) {
                    return false;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            KtParameterList ktParameterList = ((KtPrimaryConstructor)element).getValueParameterList();
            if (ktParameterList == null) {
                return false;
            }
            List list2 = ktParameterList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
            parameters2 = list2;
            KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)parameters2);
            if (ktParameter != null) {
                if (ktParameter.hasDefaultValue()) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return false;
            }
            pair = TuplesKt.to((Object)KotlinBundle.message((String)"text.primary.constructor", (Object[])new Object[0]), (Object)parameters2);
        }
        Pair pair2 = pair;
        String targetName = (String)pair2.component1();
        Object object = pair2.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
        parameters2 = (List)object;
        $this$safeAs$iv = new Object[]{targetName};
        this.setTextGetter((Function0<String>)KotlinBundle.lazyMessage((String)"add.jvmoverloads.annotation.to.0", (Object[])$this$safeAs$iv));
        KtFile ktFile2 = ((KtPureElement)element).getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)ktFile2))) return false;
        Iterable $this$any$iv = parameters2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KtParameter)element$iv;
            boolean bl = false;
        } while (!it.hasDefaultValue());
        boolean bl = true;
        if (!bl) return false;
        if (AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)element, JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_CLASS_ID(), null, false, 6, null) != null) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtModifierListOwner element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtPrimaryConstructor) {
            if (((KtPrimaryConstructor)element).getConstructorKeyword() == null) {
                KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)element;
                Project project = ((KtPrimaryConstructor)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ktPrimaryConstructor.addBefore(new KtPsiFactory(project, false, 2, null).createConstructorKeyword(), (PsiElement)((KtPrimaryConstructor)element).getValueParameterList());
            }
            v2 = AnnotationModificationUtilsKt.addAnnotation$default(element, JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_CLASS_ID(), null, null, false, " ", null, 46, null);
        } else {
            v2 = AnnotationModificationUtilsKt.addAnnotation$default(element, JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_CLASS_ID(), null, null, false, null, null, 62, null);
        }
    }
}

