/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalColumnSpacing;
import org.jetbrains.plugins.terminal.TerminalFontSettings;
import org.jetbrains.plugins.terminal.TerminalFontSize;
import org.jetbrains.plugins.terminal.TerminalLineSpacing;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"copyMainFont", "", "settings", "Lorg/jetbrains/plugins/terminal/TerminalFontSettings;", "preferences", "Lcom/intellij/openapi/editor/colors/impl/FontPreferencesImpl;", "copyFallbackFont", "copyFontSize", "copyLineSpacing", "DEFAULT_TERMINAL_FONT_SIZE", "Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "getDEFAULT_TERMINAL_FONT_SIZE", "()Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "DEFAULT_TERMINAL_LINE_SPACING", "Lorg/jetbrains/plugins/terminal/TerminalLineSpacing;", "getDEFAULT_TERMINAL_LINE_SPACING", "()Lorg/jetbrains/plugins/terminal/TerminalLineSpacing;", "DEFAULT_TERMINAL_COLUMN_SPACING", "Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;", "getDEFAULT_TERMINAL_COLUMN_SPACING", "()Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;", "FONT_SIZE_PRECISION", "", "SPACING_PRECISION", "intellij.terminal"})
public final class TerminalFontSettingsServiceKt {
    @NotNull
    private static final TerminalLineSpacing DEFAULT_TERMINAL_LINE_SPACING = TerminalLineSpacing.Companion.ofFloat(1.0f);
    @NotNull
    private static final TerminalColumnSpacing DEFAULT_TERMINAL_COLUMN_SPACING = TerminalColumnSpacing.Companion.ofFloat(1.0f);
    private static final int FONT_SIZE_PRECISION = 1;
    private static final int SPACING_PRECISION = 2;

    private static final void copyMainFont(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        preferences.addFontFamily(settings.getFontFamily());
        String string = FontFamilyService.getRecommendedSubFamily((String)settings.getFontFamily());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRecommendedSubFamily(...)");
        String regularSubFamily = string;
        preferences.setRegularSubFamily(regularSubFamily);
        String string2 = FontFamilyService.getRecommendedBoldSubFamily((String)settings.getFontFamily(), (String)regularSubFamily);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRecommendedBoldSubFamily(...)");
        String boldSubFamily = string2;
        preferences.setBoldSubFamily(boldSubFamily);
    }

    private static final void copyFallbackFont(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        if (!Intrinsics.areEqual((Object)settings.getFallbackFontFamily(), (Object)settings.getFontFamily())) {
            preferences.addFontFamily(settings.getFallbackFontFamily());
        }
    }

    private static final void copyFontSize(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        for (String fontFamily : preferences.getEffectiveFontFamilies()) {
            preferences.setFontSize(fontFamily, settings.getFontSize().getFloatValue());
        }
    }

    private static final void copyLineSpacing(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        preferences.setLineSpacing(settings.getLineSpacing().getFloatValue());
    }

    @NotNull
    public static final TerminalFontSize getDEFAULT_TERMINAL_FONT_SIZE() {
        return TerminalFontSize.Companion.ofFloat(FontPreferences.DEFAULT_FONT_SIZE);
    }

    @NotNull
    public static final TerminalLineSpacing getDEFAULT_TERMINAL_LINE_SPACING() {
        return DEFAULT_TERMINAL_LINE_SPACING;
    }

    @NotNull
    public static final TerminalColumnSpacing getDEFAULT_TERMINAL_COLUMN_SPACING() {
        return DEFAULT_TERMINAL_COLUMN_SPACING;
    }

    public static final /* synthetic */ void access$copyMainFont(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        TerminalFontSettingsServiceKt.copyMainFont(settings, preferences);
    }

    public static final /* synthetic */ void access$copyFallbackFont(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        TerminalFontSettingsServiceKt.copyFallbackFont(settings, preferences);
    }

    public static final /* synthetic */ void access$copyFontSize(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        TerminalFontSettingsServiceKt.copyFontSize(settings, preferences);
    }

    public static final /* synthetic */ void access$copyLineSpacing(TerminalFontSettings settings, FontPreferencesImpl preferences) {
        TerminalFontSettingsServiceKt.copyLineSpacing(settings, preferences);
    }
}

