/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;

public class DefaultZipCompressor
implements ZipCompressor {
    private final int entryCompressionMethod;
    private final Zip64Mode zip64Mode;

    public DefaultZipCompressor(boolean allowZip64Mode, int entryCompressionMethod) {
        this.entryCompressionMethod = entryCompressionMethod;
        this.zip64Mode = allowZip64Mode ? Zip64Mode.AsNeeded : Zip64Mode.Never;
    }

    @Override
    public ZipArchiveOutputStream createArchiveOutputStream(File destination) throws IOException {
        ZipArchiveOutputStream outStream = new ZipArchiveOutputStream(destination);
        try {
            outStream.setUseZip64(this.zip64Mode);
            outStream.setMethod(this.entryCompressionMethod);
            return outStream;
        }
        catch (Exception e) {
            IoActions.closeQuietly((Closeable)outStream);
            String message = String.format("Unable to create ZIP output stream for file %s.", destination);
            throw UncheckedException.throwAsUncheckedException((Throwable)new IOException(message, e), (boolean)true);
        }
    }
}

