---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Compliance standards
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/16620) in GitLab 17.11.

{{< /history >}}

You can use [GitLab compliance controls](_index.md#gitlab-compliance-controls) to help meet the requirements of many
compliance standards.

The [Compliance Adherence Templates](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates) project
contains a library of JSON templates. Use these templates to quickly adopt predefined compliance frameworks.

<!-- Content for tables is sourced from https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates -->

## CIS CSC compliance requirements

CIS CSC are the Center for Internet Security Critical Security Controls.

The following table lists the requirements supported by GitLab for CIS CSC v8.1 and the controls for the requirements.
You can use the
[`cis_csc_v8-1.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/cis_csc_v8-1.json?ref_type=heads)
to create a compliance framework for this standard.

| CIS CSC v8.1 requirement                                                          | Description                                                                                                                                                        | Supported controls |
|:----------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 6.7 Centralize Access Control                                                     | Centralize access control for all enterprise assets through a directory service or SSO provider, where supported.                                                  | <ul><li>Auth SSO enabled</li></ul> |
| 7.5 Perform Automated Vulnerability Scans of Internal Enterprise Assets           | Perform automated vulnerability scans of internal enterprise assets on a quarterly, or more frequent, basis. Conduct both authenticated and unauthenticated scans. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| 7.6 Perform Automated Vulnerability Scans of Externally-Exposed Enterprise Assets | Perform automated vulnerability scans of externally-exposed enterprise assets. Perform scans on a monthly, or more frequent, basis.                                | <ul><li>DAST running</li><li>API security running</li></ul> |
| 16.12 Implement Code-Level Security Checks                                        | Apply static and dynamic analysis tools within the application lifecycle to verify that secure coding practices are being followed.                                | <ul><li>SAST running</li><li>DAST running</li><li>Secret detection running</li></ul> |

## CSA CCM compliance requirements

CSA CCM is the Cloud Security Alliance (CSA) Cloud Controls Matrix (CCM).

The following table lists the requirements supported by GitLab for CSA CCM v4 and the controls for the requirements.
You can use the
[`csa_ccm_v4.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/csa_ccm_v4.json?ref_type=heads)
to create a compliance framework for this standard.

| CSA CCM v4 requirement                  | Description                                                                                                                                                                                                                      | Supported controls |
|:----------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| CCC-02 Quality Testing                  | Follow a defined quality change control, approval and testing process with established baselines, testing, and release standards.                                                                                                | <ul><li>Default branch protected</li><li>Code quality running</li></ul> |
| CCC-04 Unauthorized Change Protection   | Restrict the unauthorized addition, removal, update, and management of organization assets.                                                                                                                                      | <ul><li>Default branch protected</li></ul> |
| IAM-04 Separation of Duties             | Employ the separation of duties principle when implementing information system access.                                                                                                                                           | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| IAM-15 Passwords Management             | Define, implement and evaluate processes, procedures and technical measures for the secure management of passwords.                                                                                                              | <ul><li>Secret detection running</li></ul> |
| TVM-05 External Library Vulnerabilities | Define, implement and evaluate processes, procedures and technical measures to identify updates for applications which use third party or open source libraries according to the organization's vulnerability management policy. | <ul><li>Container scanning running</li></ul> |
| TVM-07 Vulnerability Identification     | Define, implement and evaluate processes, procedures and technical measures for the detection of vulnerabilities on organizationally managed assets at least monthly.                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |

## Cyber Essentials compliance requirements

The following table lists the requirements supported by GitLab for Cyber Essentials and the controls for the requirements.
You can use the
[`cyber_essentials.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/cyber_essentials.json?ref_type=heads)
to create a compliance framework for this standard.

| Cyber Essentials requirement | Description                                                                                                                                                                                                                                                                                                                                                        | Supported controls |
|:-----------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| A6.2 Supported software      | Is all the software on your devices supported by a supplier that produces regular fixes for any security problems? All software used by your organization must be supported by a supplier who provides regular security updates. Unsupported software must be removed from your devices. This includes frameworks and plugins such as Java, Adobe Reader and .NET. | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| A6.3 Software licensing      | Is all software licensed in accordance with the publisher's recommendations? All software must be licensed. It is acceptable to use free and open source software as long as you comply with any licensing requirements.                                                                                                                                           | <ul><li>License compliance running</li></ul> |

## DORA compliance requirements

DORA is DevOps Research and Assessment.

The following table lists the requirements supported by GitLab for DORA and the controls for the requirements.
You can use the
[`dora.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/dora.json?ref_type=heads)
to create a compliance framework for this standard.

| DORA requirement                            | Description                                                                                                                                                                                                                                                                                                                                                                                                     | Supported controls |
|:--------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| Article 8 Identification                    | 2. Financial entities shall, on a continuous basis, identify all sources of ICT risk, in particular the risk exposure to and from other financial entities, and assess cyber threats and ICT vulnerabilities relevant to their ICT supported business functions, information assets and ICT assets. Financial entities shall review on a regular basis, and at least yearly, the risk scenarios impacting them. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |
| Article 9 Protection and prevention         | 4. As part of the ICT risk management framework, financial entities shall implement documented policies, procedures and controls for ICT change management. These changes include software, hardware, firmware, systems or security parameters, and must be based on a risk assessment approach as part of the overall change management process.                                                               | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| Article 25 Testing of ICT tools and systems | 1. Digital operational resilience testing programs shall include vulnerability assessments, scans, open source analyses, network security assessments, gap analyses, source code reviews, scenario-based tests, compatibility testing, performance testing, and penetration testing. Testing is required before deployment of applications and infrastructure supporting critical functions.                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |

## FedRAMP compliance requirements

FedRAMP (Federal Risk and Authorization Management Program) categorizes cloud services into three impact levels:
Low, Moderate, and High, based on the potential impact of a data breach on government operations, assets, or individuals.

These levels correspond to different sets of security controls and requirements that cloud service providers (CSPs) must
meet to achieve FedRAMP authorization. Controls are available for FedRAMP Low, FedRAMP Moderate, and FedRAMP High compliance.

### FedRAMP Low compliance requirements

The following table lists the requirements supported by GitLab for FedRAMP Low and the controls for the requirements.
You can use the
[`fedramp_low_r5.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/fedramp_low_r5.json?ref_type=heads)
to create a compliance framework for this standard.

| FedRAMP Low requirement                                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                       | Supported controls |
|:-----------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| CM-5: Access Restrictions for Change                       | Define, document, approve, and enforce physical and logical access restrictions associated with changes to the system.                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li><li>At least two approvals</li></ul> |
| CM-6: Configuration Settings                               | Establish and document secure configuration settings for system components; implement these settings; identify, document, and approve deviations based on operational requirements; and monitor and control changes to configurations according to organizational policies.                                                                                                                                                                       | <ul><li>Author approved merge request is forbidden</li></ul> |
| CM-7: Least Functionality                                  | Configure the system to provide only organization-defined mission essential capabilities; and Prohibit or restrict the use of the following functions, ports, protocols, software, and/or services: organization-defined prohibited or restricted functions, system ports, protocols, software, and/or services.                                                                                                                                  | <ul><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-10: Software Usage Restrictions                         | Use software and associated documentation in accordance with contract agreements and copyright laws; track the use of software and associated documentation protected by quantity licenses to control copying and distribution; and control and document the use of peer-to-peer file sharing technology to ensure that this capability is not used for the unauthorized distribution, display, performance, or reproduction of copyrighted work. | <ul><li>License compliance running</li></ul> |
| IA-2(12): Acceptance of PIV Credentials                    | Accept and electronically verify Personal Identity Verification (PIV) credentials.                                                                                                                                                                                                                                                                                                                                                                | <ul><li>Auth SSO enabled</li></ul> |
| IA-8(1): Acceptance of PIV Credentials From Other Agencies | Accept and electronically verify Personal Identity Verification (PIV) credentials from other federal agencies.                                                                                                                                                                                                                                                                                                                                    | <ul><li>Auth SSO enabled</li></ul> |
| RA-5: Vulnerability Monitoring and Scanning                | Scan for vulnerabilities in the system and hosted applications; employ vulnerability scanning tools and techniques; analyze vulnerability scan reports and results; remediate legitimate vulnerabilities; and share vulnerability information.                                                                                                                                                                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |

### FedRAMP Moderate compliance requirements

The following table lists the requirements supported by GitLab for FedRAMP Moderate and the controls for the requirements.
You can use the
[`fedramp_moderate_r5.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/fedramp_moderate_r5.json?ref_type=heads)
to create a compliance framework for this standard.

| FedRAMP Moderate requirement                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                       | Supported controls |
|:-----------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-5: Separation of Duties                                 | Separate duties of individuals to prevent malevolent activity without collusion; document separation of duties; and define system access authorizations to support separation of duties.                                                                                                                                                                                                                                                          | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3: Configuration Change Control                         | Determine types of configuration-controlled changes; review and approve changes with security/privacy impact analysis; document decisions; implement approved changes; retain records; monitor activities associated with changes; and coordinate change control oversight through designated elements.                                                                                                                                           | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-5: Access Restrictions for Change                       | Define, document, approve, and enforce physical and logical access restrictions associated with changes to the system.                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li><li>At least two approvals</li></ul> |
| CM-6: Configuration Settings                               | Establish and document secure configuration settings for system components; implement these settings; identify, document, and approve deviations based on operational requirements; and monitor and control changes to configurations according to organizational policies.                                                                                                                                                                       | <ul><li>Author approved merge request is forbidden</li></ul> |
| CM-7: Least Functionality                                  | Configure the system to provide only organization-defined mission essential capabilities; and Prohibit or restrict the use of the following functions, ports, protocols, software, and/or services: organization-defined prohibited or restricted functions, system ports, protocols, software, and/or services.                                                                                                                                  | <ul><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-10: Software Usage Restrictions                         | Use software and associated documentation in accordance with contract agreements and copyright laws; track the use of software and associated documentation protected by quantity licenses to control copying and distribution; and control and document the use of peer-to-peer file sharing technology to ensure that this capability is not used for the unauthorized distribution, display, performance, or reproduction of copyrighted work. | <ul><li>License compliance running</li></ul> |
| IA-2(12): Acceptance of PIV Credentials                    | Accept and electronically verify Personal Identity Verification (PIV) credentials.                                                                                                                                                                                                                                                                                                                                                                | <ul><li>Auth SSO enabled</li></ul> |
| IA-5(7): No Embedded Unencrypted Static Authenticators     | Ensure that unencrypted static authenticators are not embedded in applications or other forms of static storage.                                                                                                                                                                                                                                                                                                                                  | <ul><li>Secret detection running</li></ul> |
| IA-8(1): Acceptance of PIV Credentials From Other Agencies | Accept and electronically verify Personal Identity Verification (PIV) credentials from other federal agencies.                                                                                                                                                                                                                                                                                                                                    | <ul><li>Auth SSO enabled</li></ul> |
| RA-5: Vulnerability Monitoring and Scanning                | Scan for vulnerabilities in the system and hosted applications; employ vulnerability scanning tools and techniques; analyze vulnerability scan reports and results; remediate legitimate vulnerabilities; and share vulnerability information.                                                                                                                                                                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| SA-11(1): Static Code Analysis                             | Require the developer of the system, system component, or system service to employ static code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                  | <ul><li>SAST running</li></ul> |
| SA-11(8): Dynamic Code Analysis                            | Require the developer of the system, system component, or system service to employ dynamic code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                 | <ul><li>DAST running</li></ul> |

### FedRAMP High compliance requirements

The following table lists the requirements supported by GitLab for FedRAMP High and the controls for the requirements.
You can use the
[`fedramp_high_r5.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/fedramp_high_r5.json?ref_type=heads)
to create a compliance framework for this standard.

| FedRAMP High requirement                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                       | Supported controls |
|:---------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-5: Separation of Duties                                                 | Separate duties of individuals to prevent malevolent activity without collusion; document separation of duties; and define system access authorizations to support separation of duties.                                                                                                                                                                                                                                                          | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3: Configuration Change Control                                         | Determine types of configuration-controlled changes; review and approve changes with security/privacy impact analysis; document decisions; implement approved changes; retain records; monitor activities associated with changes; and coordinate change control oversight through designated elements.                                                                                                                                           | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3(1): Automated Documentation, Notification, and Prohibition of Changes | Use automated mechanisms to document proposed changes to the system; notify organization-defined approval authorities; highlight change approvals that have not been received by organization-defined time period; prohibit changes to the system until designated approvals are received; and document all changes to the system.                                                                                                                | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-5: Access Restrictions for Change                                       | Define, document, approve, and enforce physical and logical access restrictions associated with changes to the system.                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li><li>At least two approvals</li></ul> |
| CM-6: Configuration Settings                                               | Establish and document secure configuration settings for system components; implement these settings; identify, document, and approve deviations based on operational requirements; and monitor and control changes to configurations according to organizational policies.                                                                                                                                                                       | <ul><li>Author approved merge request is forbidden</li></ul> |
| CM-7: Least Functionality                                                  | Configure the system to provide only organization-defined mission essential capabilities; and Prohibit or restrict the use of the following functions, ports, protocols, software, and/or services: organization-defined prohibited or restricted functions, system ports, protocols, software, and/or services.                                                                                                                                  | <ul><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-10: Software Usage Restrictions                                         | Use software and associated documentation in accordance with contract agreements and copyright laws; track the use of software and associated documentation protected by quantity licenses to control copying and distribution; and control and document the use of peer-to-peer file sharing technology to ensure that this capability is not used for the unauthorized distribution, display, performance, or reproduction of copyrighted work. | <ul><li>License compliance running</li></ul> |
| IA-2(12): Acceptance of PIV Credentials                                    | Accept and electronically verify Personal Identity Verification (PIV) credentials.                                                                                                                                                                                                                                                                                                                                                                | <ul><li>Auth SSO enabled</li></ul> |
| IA-5(7): No Embedded Unencrypted Static Authenticators                     | Ensure that unencrypted static authenticators are not embedded in applications or other forms of static storage.                                                                                                                                                                                                                                                                                                                                  | <ul><li>Secret detection running</li></ul> |
| IA-8(1): Acceptance of PIV Credentials From Other Agencies                 | Accept and electronically verify Personal Identity Verification (PIV) credentials from other federal agencies.                                                                                                                                                                                                                                                                                                                                    | <ul><li>Auth SSO enabled</li></ul> |
| RA-5: Vulnerability Monitoring and Scanning                                | Scan for vulnerabilities in the system and hosted applications; employ vulnerability scanning tools and techniques; analyze vulnerability scan reports and results; remediate legitimate vulnerabilities; and share vulnerability information.                                                                                                                                                                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| SA-11(1): Static Code Analysis                                             | Require the developer of the system, system component, or system service to employ static code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                  | <ul><li>SAST running</li></ul> |
| SA-11(8): Dynamic Code Analysis                                            | Require the developer of the system, system component, or system service to employ dynamic code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                 | <ul><li>DAST running</li></ul> |

## IRAP compliance requirements

IRAP is the Infosec Registered Assessors Program. Controls are available for IRAP Official, IRAP Protected, IRAP Secret,
and IRAP Top Secret.

### IRAP Official

The following table lists the requirements supported by GitLab for IRAP Official and the controls for the requirements.
You can use the
[`irap_official.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_official.json?ref_type=heads)
to create a compliance framework for this standard.

| IRAP Official requirement                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Supported controls |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 Application security testing                     | Applications are comprehensively tested for vulnerabilities, using static application security testing and dynamic application security testing, prior to their initial release and any subsequent releases.                                                                                                                                                                                                                                                | <ul><li>SAST running</li><li>DAST running</li></ul> |
| ISM-1163 Continuous monitoring plan                       | Systems have a continuous monitoring plan that includes: conducting vulnerability scans for systems at least fortnightly, conducting vulnerability assessments and penetration tests for systems prior to deployment, including prior to deployment of significant changes, and at least annually thereafter, analysing identified vulnerabilities to determine their potential impact, and implementing mitigations based on risk, effectiveness and cost. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1422 Development, testing and production environments | Unauthorised access to the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>Default branch protected</li></ul> |
| ISM-1698 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in online services.                                                                                                                                                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1700 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in applications other than office productivity suites, web browsers and their extensions, email clients, PDF software, and security products.                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1701 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in operating systems of internet-facing servers and internet-facing network devices.                                                                                                                                                                                                                                                              | <ul><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1702 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in operating systems of workstations, non-internet-facing servers and non-internet-facing network devices.                                                                                                                                                                                                                                  | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1808 Scanning for unmitigated vulnerabilities         | A vulnerability scanner with an up-to-date vulnerability database is used for vulnerability scanning activities.                                                                                                                                                                                                                                                                                                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1816 Development, testing and production environments | Unauthorised modification of the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li></ul> |
| ISM-1875 Protecting credentials                           | Networks are scanned at least monthly to identify any credentials that are being stored in the clear.                                                                                                                                                                                                                                                                                                                                                       | <ul><li>Secret detection running</li></ul> |

### IRAP Protected

The following table lists the requirements supported by GitLab for IRAP Protected and the controls for the requirements.
You can use the
[`irap_protected.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_protected.json?ref_type=heads)
to create a compliance framework for this standard.

| IRAP Protected requirement                                | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Supported controls |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 Application security testing                     | Applications are comprehensively tested for vulnerabilities, using static application security testing and dynamic application security testing, prior to their initial release and any subsequent releases.                                                                                                                                                                                                                                                | <ul><li>SAST running</li><li>DAST running</li></ul> |
| ISM-1163 Continuous monitoring plan                       | Systems have a continuous monitoring plan that includes: conducting vulnerability scans for systems at least fortnightly, conducting vulnerability assessments and penetration tests for systems prior to deployment, including prior to deployment of significant changes, and at least annually thereafter, analysing identified vulnerabilities to determine their potential impact, and implementing mitigations based on risk, effectiveness and cost. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1422 Development, testing and production environments | Unauthorised access to the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>Default branch protected</li></ul> |
| ISM-1698 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in online services.                                                                                                                                                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1700 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in applications other than office productivity suites, web browsers and their extensions, email clients, PDF software, and security products.                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1701 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in operating systems of internet-facing servers and internet-facing network devices.                                                                                                                                                                                                                                                              | <ul><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1702 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in operating systems of workstations, non-internet-facing servers and non-internet-facing network devices.                                                                                                                                                                                                                                  | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1808 Scanning for unmitigated vulnerabilities         | A vulnerability scanner with an up-to-date vulnerability database is used for vulnerability scanning activities.                                                                                                                                                                                                                                                                                                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1816 Development, testing and production environments | Unauthorised modification of the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li></ul> |
| ISM-1875 Protecting credentials                           | Networks are scanned at least monthly to identify any credentials that are being stored in the clear.                                                                                                                                                                                                                                                                                                                                                       | <ul><li>Secret detection running</li></ul> |

### IRAP Secret

The following table lists the requirements supported by GitLab for IRAP Secret and the controls for the requirements.
You can use the
[`irap_secret.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_secret.json?ref_type=heads)
to create a compliance framework for this standard.

| IRAP Secret requirement                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Supported controls |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 Application security testing                     | Applications are comprehensively tested for vulnerabilities, using static application security testing and dynamic application security testing, prior to their initial release and any subsequent releases.                                                                                                                                                                                                                                                | <ul><li>SAST running</li><li>DAST running</li></ul> |
| ISM-1163 Continuous monitoring plan                       | Systems have a continuous monitoring plan that includes: conducting vulnerability scans for systems at least fortnightly, conducting vulnerability assessments and penetration tests for systems prior to deployment, including prior to deployment of significant changes, and at least annually thereafter, analysing identified vulnerabilities to determine their potential impact, and implementing mitigations based on risk, effectiveness and cost. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1422 Development, testing and production environments | Unauthorised access to the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>Default branch protected</li></ul> |
| ISM-1698 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in online services.                                                                                                                                                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1700 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in applications other than office productivity suites, web browsers and their extensions, email clients, PDF software, and security products.                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1701 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in operating systems of internet-facing servers and internet-facing network devices.                                                                                                                                                                                                                                                              | <ul><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1702 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in operating systems of workstations, non-internet-facing servers and non-internet-facing network devices.                                                                                                                                                                                                                                  | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1808 Scanning for unmitigated vulnerabilities         | A vulnerability scanner with an up-to-date vulnerability database is used for vulnerability scanning activities.                                                                                                                                                                                                                                                                                                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1816 Development, testing and production environments | Unauthorised modification of the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li></ul> |
| ISM-1875 Protecting credentials                           | Networks are scanned at least monthly to identify any credentials that are being stored in the clear.                                                                                                                                                                                                                                                                                                                                                       | <ul><li>Secret detection running</li></ul> |

### IRAP Top Secret

The following table lists the requirements supported by GitLab for IRAP Top Secret and the controls for the requirements.
You can use the
[`irap_top_secret.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_top_secret.json?ref_type=heads)
to create a compliance framework for this standard.

| IRAP Top Secret requirement                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Supported controls |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 Application security testing                     | Applications are comprehensively tested for vulnerabilities, using static application security testing and dynamic application security testing, prior to their initial release and any subsequent releases.                                                                                                                                                                                                                                                | <ul><li>SAST running</li><li>DAST running</li></ul> |
| ISM-1163 Continuous monitoring plan                       | Systems have a continuous monitoring plan that includes: conducting vulnerability scans for systems at least fortnightly, conducting vulnerability assessments and penetration tests for systems prior to deployment, including prior to deployment of significant changes, and at least annually thereafter, analysing identified vulnerabilities to determine their potential impact, and implementing mitigations based on risk, effectiveness and cost. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1422 Development, testing and production environments | Unauthorised access to the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>Default branch protected</li></ul> |
| ISM-1698 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in online services.                                                                                                                                                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1700 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in applications other than office productivity suites, web browsers and their extensions, email clients, PDF software, and security products.                                                                                                                                                                                               | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1701 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least daily to identify missing patches or updates for vulnerabilities in operating systems of internet-facing servers and internet-facing network devices.                                                                                                                                                                                                                                                              | <ul><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| ISM-1702 Scanning for unmitigated vulnerabilities         | A vulnerability scanner is used at least fortnightly to identify missing patches or updates for vulnerabilities in operating systems of workstations, non-internet-facing servers and non-internet-facing network devices.                                                                                                                                                                                                                                  | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1808 Scanning for unmitigated vulnerabilities         | A vulnerability scanner with an up-to-date vulnerability database is used for vulnerability scanning activities.                                                                                                                                                                                                                                                                                                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ISM-1816 Development, testing and production environments | Unauthorised modification of the authoritative source for software is prevented.                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li></ul> |
| ISM-1875 Protecting credentials                           | Networks are scanned at least monthly to identify any credentials that are being stored in the clear.                                                                                                                                                                                                                                                                                                                                                       | <ul><li>Secret detection running</li></ul> |

## ISMAP compliance requirements

The Information system Security Management and Assessment Program (ISMAP) aims to secure the security level of the government's cloud service procurement
by evaluating and registering cloud services that meet the security requirements of the government in advance, thereby contributing to the smooth introduction
of cloud services.

The following table lists the requirements supported by GitLab for ISMAP and the controls for the requirements.
You can use the
[`ismap.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/ismap.json?ref_type=heads)
to create a compliance framework for this standard.

| ISMAP requirement                              | Description                                                                                                                                                                                                                                        | Supported controls |
|:-----------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 6.1.2 Segregation of duties                    | Conflicting duties and areas of responsibility should be segregated to reduce opportunities for unauthorized or unintentional modification or misuse of the organization's assets.                                                                 | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 9.3.1 Use of secret authentication information | Users should be required to follow the organization's practices in the use of secret authentication information.                                                                                                                                   | <ul><li>Secret detection running</li></ul> |
| 9.4.5 Access control to program source code    | Access to program source code should be restricted.                                                                                                                                                                                                | <ul><li>Default branch protected</li></ul> |
| 12.1.2 Change management                       | Changes to the organization, business processes, information processing facilities and systems that affect information security should be controlled.                                                                                              | <ul><li>Default branch protected</li></ul> |
| 12.6.1 Management of technical vulnerabilities | Information about technical vulnerabilities of information systems being used should be obtained in a timely fashion, the organization's exposure to such vulnerabilities evaluated and appropriate measures taken to address the associated risk. | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| 14.2.1 Secure development policy               | Rules for the development of software and systems should be established and applied to developments within the organization.                                                                                                                       | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li></ul> |
| 14.2.8 System security testing                 | Testing of security functionality should be carried out during development.                                                                                                                                                                        | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li></ul> |
| 18.1.2 Intellectual property rights            | Appropriate procedures should be implemented to ensure compliance with legislative, regulatory and contractual requirements related to intellectual property rights and use of proprietary software products.                                      | <ul><li>License compliance running</li></ul> |

## ISO 27001 compliance requirements

ISO 27001 is an internationally recognized standard that provides a framework for implementing and managing an
Information Security Management System (ISMS).

The following table lists the requirements supported by GitLab for ISO 27001 and the controls for the requirements.
You can use the
[`iso_27001:2022.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/iso_27001:2022.json?ref_type=heads)
to create a compliance framework for this standard.

| ISO 27001 requirement                               | Description                                                                                                                                                                                                  | Supported controls |
|:----------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 5.3 Segregation of duties                           | Conflicting duties and conflicting areas of responsibility shall be segregated.                                                                                                                              | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 5.17 Authentication information                     | Allocation and management of authentication information should be controlled by a management process, including advising personnel on the appropriate handling of authentication information.                | <ul><li>Secret detection running</li></ul> |
| 5.18 Access rights                                  | Access rights to information and other associated assets should be provisioned, reviewed, modified and removed in accordance with the organization's topic-specific policy on and rules for access control.  | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 5.32 Intellectual property rights                   | The organization should implement appropriate procedures to protect intellectual property rights.                                                                                                            | <ul><li>License compliance running</li></ul> |
| 8.4 Access to source code                           | Read and write access to source code, development tools and software libraries shall be appropriately managed.                                                                                               | <ul><li>Default branch protected</li></ul> |
| 8.8 Management of technical vulnerabilities         | Information about technical vulnerabilities of information systems in use shall be obtained, the organization's exposure to such vulnerabilities shall be evaluated and appropriate measures shall be taken. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |
| 8.28 Secure coding                                  | Secure coding principles shall be applied to software development.                                                                                                                                           | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li></ul> |
| 8.29 Security testing in development and acceptance | Security testing processes shall be defined and implemented in the development lifecycle.                                                                                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li></ul> |
| 8.32 Change management                              | Changes to information processing facilities and information systems shall be subject to change management procedures.                                                                                       | <ul><li>Default branch protected</li></ul> |

## NIS 2 compliance requirements

The following table lists the requirements supported by GitLab for NIS 2 and the controls for the requirements.
You can use the
[`nis_2.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nis_2.json?ref_type=heads)
to create a compliance framework for this standard.

| NIS 2 requirement                                                   | Description                                                                                                                                                                                                                                                                                                               | Supported controls |
|:--------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| Article 11 Requirements, technical capabilities and tasks of CSIRTs | 3. The CSIRTs shall have the following tasks: a) monitoring and analysing cyber threats, vulnerabilities and incidents at national level and, upon request, providing assistance to essential and important entities concerned regarding real-time or near real-time monitoring of their network and information systems. | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| Article 21 Cybersecurity risk-management measures                   | Implement cybersecurity measures based on all-hazards approach to protect systems from incidents, including supply chain security across direct suppliers and service providers, and security in network/information systems acquisition, development, maintenance, and vulnerability handling.                           | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |

## NIST compliance requirements

The National Institute of Standards and Technology (NIST) Information Technology Laboratory (ITL) provides standards,
measurements, and testing for information systems, focusing on interoperability, security, usability, and reliability.
These compliance standards involves implementing security and privacy controls across various areas, including:

- Risk management
- Identification and authentication
- Incident response
- System and communications protection

Controls are available for NIST 800-53, NIST 800-171, NIST SP 800-218, and NIST CSF 2.0 compliance standards.

### NIST 800-53 compliance requirements

The following table lists the requirements supported by GitLab for NIST 800-53 Revision 5 and the controls for the
requirements.
You can use the
[`nist_800-53_r5` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_800-53_r5.json?ref_type=heads)
to create a compliance framework for this standard.

| NIST 800-53 requirement                                                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                       | Supported controls |
|:---------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-3(2): Dual Authorization                                                | Enforce dual authorization for organization-defined privileged commands and/or other organization-defined actions.                                                                                                                                                                                                                                                                                                                                | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| AC-5: Separation of Duties                                                 | Separate duties of individuals to prevent malevolent activity without collusion; document separation of duties; and define system access authorizations to support separation of duties.                                                                                                                                                                                                                                                          | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| AU-9(5): Dual Authorization                                                | Enforce dual authorization for the deletion or modification of organization-defined audit information.                                                                                                                                                                                                                                                                                                                                            | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3: Configuration Change Control                                         | Determine types of configuration-controlled changes; review and approve changes with security/privacy impact analysis; document decisions; implement approved changes; retain records; monitor activities associated with changes; and coordinate change control oversight through designated elements.                                                                                                                                           | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3(1): Automated Documentation, Notification, and Prohibition of Changes | Use automated mechanisms to document proposed changes to the system; notify organization-defined approval authorities; highlight change approvals that have not been received by organization-defined time period; prohibit changes to the system until designated approvals are received; and document all changes to the system.                                                                                                                | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-5: Access Restrictions for Change                                       | Define, document, approve, and enforce physical and logical access restrictions associated with changes to the system.                                                                                                                                                                                                                                                                                                                            | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-5(4): Dual Authorization                                                | Enforce dual authorization for implementing changes to organization-defined system components and system-level information.                                                                                                                                                                                                                                                                                                                       | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-6: Configuration Settings                                               | Establish and document secure configuration settings for system components; implement these settings; identify, document, and approve deviations based on operational requirements; and monitor and control changes to configurations according to organizational policies.                                                                                                                                                                       | <ul><li>Author approved merge request is forbidden</li></ul> |
| CM-7: Least Functionality                                                  | Configure the system to provide only organization-defined mission essential capabilities; and Prohibit or restrict the use of the following functions, ports, protocols, software, and/or services: organization-defined prohibited or restricted functions, system ports, protocols, software, and/or services.                                                                                                                                  | <ul><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-9(1): Assignment of Responsibility                                      | Assign responsibility for developing the configuration management process to organizational personnel that are not directly involved in system development.                                                                                                                                                                                                                                                                                       | <ul><li>Default branch protected</li></ul> |
| CM-10: Software Usage Restrictions                                         | Use software and associated documentation in accordance with contract agreements and copyright laws; track the use of software and associated documentation protected by quantity licenses to control copying and distribution; and control and document the use of peer-to-peer file sharing technology to ensure that this capability is not used for the unauthorized distribution, display, performance, or reproduction of copyrighted work. | <ul><li>License compliance running</li></ul> |
| CP-9(7): Dual Authorization                                                | Enforce dual authorization for the deletion or destruction of organization-defined backup information.                                                                                                                                                                                                                                                                                                                                            | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| IA-2(10): Single Sign-on                                                   | Provide a single sign-on capability for organization-defined system accounts and services.                                                                                                                                                                                                                                                                                                                                                        | <ul><li>Auth SSO enabled</li></ul> |
| IA-2(12): Acceptance of PIV Credentials                                    | Accept and electronically verify Personal Identity Verification (PIV) credentials.                                                                                                                                                                                                                                                                                                                                                                | <ul><li>Auth SSO enabled</li></ul> |
| IA-5(7): No Embedded Unencrypted Static Authenticators                     | Ensure that unencrypted static authenticators are not embedded in applications or other forms of static storage.                                                                                                                                                                                                                                                                                                                                  | <ul><li>Secret detection running</li></ul> |
| IA-5(9): Federated Credential Management                                   | Use organization-defined external organizations to federate credentials.                                                                                                                                                                                                                                                                                                                                                                          | <ul><li>Auth SSO enabled</li></ul> |
| IA-8(1): Acceptance of PIV Credentials From Other Agencies                 | Accept and electronically verify Personal Identity Verification (PIV) credentials from other federal agencies.                                                                                                                                                                                                                                                                                                                                    | <ul><li>Auth SSO enabled</li></ul> |
| IA-8(5): Acceptance of PIV-I Credentials                                   | Accept and verify Personal Identity Verification-I (PIV-I) credentials.                                                                                                                                                                                                                                                                                                                                                                           | <ul><li>Auth SSO enabled</li></ul> |
| RA-5: Vulnerability Monitoring and Scanning                                | Scan for vulnerabilities in the system and hosted applications; employ vulnerability scanning tools and techniques; analyze vulnerability scan reports and results; remediate legitimate vulnerabilities; and share vulnerability information.                                                                                                                                                                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| SA-11(1): Static Code Analysis                                             | Require the developer of the system, system component, or system service to employ static code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                  | <ul><li>SAST running</li></ul> |
| SA-11(8): Dynamic Code Analysis                                            | Require the developer of the system, system component, or system service to employ dynamic code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                 | <ul><li>DAST running</li></ul> |

### NIST 800-171 compliance requirements

The following table lists the requirements supported by GitLab for NIST 800-171 Revision 3 CMMC and the controls for
the requirements.
You can use the
[`nist_800-171_r3_cmmc.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_800-171_r3_cmmc.json?ref_type=heads)
to create a compliance framework for this standard.

| NIST 800-171 requirement                       | Description                                                                                                                                                                                                                                                                                                                             | Supported controls |
|:-----------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 03.01.04 Separation of Duties                  | a) Identify the duties of individuals requiring separation. b) Define system access authorizations to support separation of duties.                                                                                                                                                                                                     | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 03.04.04 Impact Analyses                       | a) Analyze changes to the system to determine potential security impacts prior to change implementation. b) Verify that the security requirements for the system continue to be satisfied after the system changes have been implemented.                                                                                               | <ul><li>Default branch protected</li></ul> |
| 03.04.05 Access Restrictions for Change        | a) Define, document, approve, and enforce physical and logical access restrictions associated with changes to the system.                                                                                                                                                                                                               | <ul><li>Default branch protected</li></ul> |
| 03.04.10 System Component Inventory            | a) Develop and document an inventory of system components. b) Review and update the system component inventory (organization-defined frequency). c) Update the system component inventory as part of installations, removals, and system updates.                                                                                       | <ul><li>License compliance running</li></ul> |
| 03.05.07 Password Management                   | <!-- List intentionally starts at b) --> b) Verify that passwords are not found on the list of commonly used, expected, or compromised passwords when users create or update passwords. c) Transmit passwords only over cryptographically protected channels. d) Store passwords in a cryptographically protected form.                 | <ul><li>Secret detection running</li></ul> |
| 03.11.02 Vulnerability Monitoring and Scanning | a) Monitor and scan the system for vulnerabilities (organization-defined frequency) and when new vulnerabilities affecting the system are identified. <!-- List intentionally omits at b) --> c) Update system vulnerabilities to be scanned (organization-defined frequency) and when new vulnerabilities are identified and reported. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |

### NIST CSF 2.0 compliance requirements

The following table lists the requirements supported by GitLab for NIST CSF and the controls for the requirements.
You can use the
[`nist_csf_2.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_csf_2.json?ref_type=heads)
to create a compliance framework for this standard.

| NIST CSF 2.0 requirement                                                                                                                                                                                                                            | Description                                                                                                                                                                                | Supported controls |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ID.RA-01 - Identity - Risk Assessment: The cybersecurity risk to the organization, assets, and individuals is understood by the organization.                                                                                                       | Vulnerabilities in assets are identified, validated, and recorded.                                                                                                                         | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ID.RA-07 - Identity - Risk Assessment: The cybersecurity risk to the organization, assets, and individuals is understood by the organization.                                                                                                       | Changes and exceptions are managed, assessed for risk impact, recorded, and tracked.                                                                                                       | <ul><li>Default branch protected</li></ul> |
| PR.AA-05 - Protect - Identity Management, Authentication, and Access Control - Access to physical and logical assets is limited to authorized users, services, and hardware and managed commensurate with the assessed risk of unauthorized access. | Access permissions, entitlements, and authorizations are defined in a policy, managed, enforced, and reviewed, and incorporate the principles of least privilege and separation of duties. | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| PR.PS-06 - Protect - Platform Security - Management of hardware, software, and services aligned with risk strategy.                                                                                                                                 | Secure software development practices are integrated, and their performance is monitored throughout the software development lifecycle.                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li></ul> |

### NIST SP 800-218 compliance requirements

The following table lists the requirements supported by GitLab for NIST SP 800-218 and the controls for the requirements.
You can use the
[`nist_800-218_v1-1.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_800-218_v1-1.json?ref_type=heads)
to create a compliance framework for this standard.

| NIST SP 800-218 requirement                                                                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                      | Supported controls |
|:----------------------------------------------------------------------------------------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| PO.1.1 Define Security Requirements for Software Development                                                                | PO.1.1: Identify and document all security requirements for the organization's software development infrastructures and processes, and maintain the requirements over time.                                                                                                                                                                                                                                                      | <ul><li>Default branch protected</li></ul> |
| PW.4 Reuse Existing, Well-Secured Software When Feasible Instead of Duplicating Functionality                               | PW.4.1: Acquire and maintain well-secured software components (e.g., software libraries, modules, middleware, frameworks) from commercial, open-source, and other third-party developers for use by the organization's software. PW.4.4: Verify that acquired commercial, open-source, and all other third-party software components comply with the requirements, as defined by the organization, throughout their life cycles. | <ul><li>License compliance running</li><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| PW.5.1 Create Source Code by Adhering to Secure Coding Practices                                                            | PW.5.1: Follow all secure coding practices that are appropriate to the development languages and environment to meet the organization's requirements.                                                                                                                                                                                                                                                                            | <ul><li>Code quality running</li></ul> |
| PW.7 Review and/or Analyze Human-Readable Code to Identify Vulnerabilities and Verify Compliance with Security Requirements | PW.7.1: Implement code review (manual inspection) and/or code analysis (tool-based scanning) according to organizational needs. Perform these reviews based on secure coding standards and track all discovered issues in the development workflow system.                                                                                                                                                                       | <ul><li>SAST running</li><li>DAST running</li><li>Secret detection running</li></ul> |
| PW.8 Test Executable Code to Identify Vulnerabilities and Verify Compliance with Security Requirements                      | PW.8.2: Scope the testing, design the tests, perform the testing, and document the results, including recording and triaging all discovered issues and recommended remediations in the development team's workflow or issue tracking system.                                                                                                                                                                                     | <ul><li>DAST running</li><li>API security running</li></ul> |
| RV.1 Identify and Confirm Vulnerabilities on an Ongoing Basis                                                               | RV.1.1: Gather information from software acquirers, users, and public sources on potential vulnerabilities in the software and third-party components that the software uses, and investigate all credible reports.                                                                                                                                                                                                              | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |

## PCI DSS v4.0.1 compliance requirements

PCI DSS is the PCI Data Security Standard.

The following table lists the requirements supported by GitLab for PCI DSS v4.0.1 and the controls for the requirements.
You can use the
[`pci_dss_v4-0-1.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/pci_dss_v4-0-1.json?ref_type=heads)
to create a compliance framework for this standard.

| PCI DSS v4.0.1 requirement                                                                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Supported controls                                                                                                                                                                                                                                                                                                  |
|:------------------------------------------------------------------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 6.2 Bespoke and custom software are developed securely.                                               | 6.2.3 Review bespoke and custom software prior to release to identify and correct coding vulnerabilities. Ensure code follows secure coding guidelines and addresses emerging vulnerabilities. Implement software engineering techniques to prevent common software attacks.                                                                                                                                                                                                                                                                                                                                         | <ul><li>API security running</li><li>DAST running</li><li>SAST running</li><li>Secret detection running</li></ul>                                                                                                                                                                      |
| 6.5 Changes to all system components are managed securely.                                            | 6.5.1 Implement changes to system components according to established procedures including: documenting reason and description, security impact analysis, approval by authorized parties, and testing for security impacts. Separate production and pre-production environments.<br/><br/>6.5.3 Pre-production environments are separated from production environments and the separation is enforced with access controls.<br/><br/>6.5.4 Roles and functions are separated between production and pre-production environments to provide accountability such that only reviewed and approved changes are deployed. | <ul><li>Code changes require code owners</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>At least two approvals</li><li>Reset approvals on push</li><li>Default branch protected</li><li>Merge requests approval rules prevent editing</li></ul> |
| 7.2 Access to system components and data is appropriately defined and assigned.                       | 7.2.5 All application and system accounts and related access privileges are assigned and managed as follows: Based on the least privileges necessary for the operability of the system or application; access is limited to the systems, applications, or processes that specifically require their use.                                                                                                                                                                                                                                                                                                             | <ul><li>CI/CD job token scope enabled</li><li>User-defined CI/CD variables restricted to maintainers</li><li>Project visibility not public</li><li>Restricted build access</li><li>Strict Permission for Repository</li></ul>                                                                                       |
| 7.3 Access to system components and data is managed via an access control system(s).                  | 7.3.1 An access control system(s) is in place that restricts access based on a user's need to know and covers all system components.<br/><br/>7.3.2 The access control system(s) is configured to enforce permissions assigned to individuals, applications, and systems based on job classification and function.                                                                                                                                                                                                                                                                                                   | <ul><li>CI/CD job token scope enabled</li><li>User-defined CI/CD variables restricted to maintainers</li><li>Project visibility not public</li><li>Restricted build access</li><li>Strict Permission for Repository</li></ul>                                                                                       |
| 8.3 Strong authentication for users and administrators is established and managed.                    | 8.3.1 All user access to system components for users and administrators is authenticated via at least one of the following authentication factors: Something you know, such as a password or passphrase; something you have, such as a token device or smart card; Something you are, such as a biometric element.                                                                                                                                                                                                                                                                                                   | <ul><li>Auth SSO enabled</li><li>Require MFA at organization level</li><li>Require MFA for contributors</li></ul>                                                                                                                                                                                                   |
| 8.4 Multi-factor authentication (MFA) is implemented to secure access into the CDE.                   | 8.4.1 MFA is implemented for all non-console access into the CDE for personnel with administrative access.<br/><br/>8.4.2 MFA is implemented for all non-console access into the CDE.                                                                                                                                                                                                                                                                                                                                                                                                                                | <ul><li>Auth SSO enabled</li><li>Require MFA at organization level</li><li>Require MFA for contributors</li></ul>                                                                                                                                                                                                   |
| 8.6 Use of application and system accounts and associated authentication factors is strictly managed. | 8.6.2 Passwords/passphrases for any application and system accounts that can be used for interactive login are not hard coded in scripts, configuration/property files, or bespoke and custom source code.                                                                                                                                                                                                                                                                                                                                                                                                           | <ul><li>Secret detection running</li></ul>                                                                                                                                                                                                                                                                          |
| 11.3 External and internal vulnerabilities are regularly identified, prioritized, and addressed.      | 11.3.1 Perform internal vulnerability scans using authenticated scanning methods. Address high-risk/critical vulnerabilities promptly and manage other vulnerabilities based on risk assessment. Conduct scans after significant changes to systems.<br/><br/>11.3.2 Perform external vulnerability scans via qualified personnel. Address high-risk/critical vulnerabilities promptly and manage other vulnerabilities based on risk assessment. Conduct scans after significant changes to systems.                                                                                                                | <ul><li>Container scanning running</li><li>Dependency scanning running</li><li>DAST running</li><li>IaC scanning running</li></ul>                                                                                                                                                     |

## SOC 2 compliance requirements

SOC is the System and Organization Controls.

The following table lists the requirements supported by GitLab for SOC 2 and the controls for the requirements.
You can use the
[`soc2.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/soc2.json?ref_type=heads)
to create a compliance framework for this standard.

| SOC 2 requirement                                                                                                                                                                                                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                 | Supported controls |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| CC3.2 - COSO Principle 7: The entity identifies risks to the achievement of its objectives across the entity and analyzes risks as a basis for determining how the risks should be managed.                                                         | POF 7: Identifies Vulnerability of System Components — The entity identifies the vulnerabilities of system components, including system processes, infrastructure, software, and other information assets.                                                                                                                                                                                  | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li></ul> |
| CC3.4 - COSO Principle 9: The entity identifies and assesses changes that could significantly impact the system of internal control.                                                                                                                | POF 4: Assess changes from systems, technology environment, and evolving threats/vulnerabilities. Evaluate impact on internal controls and security posture to identify and address resulting risks.                                                                                                                                                                                        | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li><li>Default branch protected</li></ul> |
| CC5.1 - COSO Principle 10: The entity selects and develops control activities that contribute to the mitigation of risks to the achievement of objectives to acceptable levels.                                                                     | POF 6: Addresses Segregation of Duties — Management segregates incompatible duties and, where such segregation is not practical, management selects and develops alternative control activities.                                                                                                                                                                                            | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CC6.6 - The entity implements logical access security measures to protect against threats from sources outside its system boundaries.                                                                                                               | POF 2: Protects Identification and Authentication Credentials — Identification and authentication credentials are protected during transmission outside its system boundaries.                                                                                                                                                                                                              | <ul><li>Secret detection running</li></ul> |
| CC6.8 - The entity implements controls to prevent or detect and act upon the introduction of unauthorized or malicious software to meet the entity's objectives.                                                                                    | POF 2: Detects Unauthorized Changes to Software and Configuration Parameters — Processes are in place to detect changes to software and configuration parameters that may be indicative of unauthorized or malicious software.                                                                                                                                                              | <ul><li>Default branch protected</li></ul> |
| CC7.1 - To meet its objectives, the entity uses detection and monitoring procedures to identify (1) changes to configurations that result in the introduction of new vulnerabilities, and (2) susceptibilities to newly discovered vulnerabilities. | POF 5: Conducts Vulnerability Scans — The entity conducts infrastructure and software vulnerability scans designed to identify potential vulnerabilities or misconfigurations on a periodic basis and after significant changes are made to the environment. Action is taken to remediate identified deficiencies in a timely manner to support the achievement of the entity's objectives. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li></ul> |
| CC7.2 - System monitoring for anomalies and security event analysis.                                                                                                                                                                                | POF 1: Implement detection policies, procedures, and tools on infrastructure and software to identify potential intrusions, unauthorized access, and unusual system activity. Use intelligence sources to identify new threats and vulnerabilities.                                                                                                                                         | <ul><li>Secret detection running</li></ul> |
| CC8.1 - The entity authorizes, designs, develops or acquires, configures, documents, tests, approves, and implements changes to infrastructure, data, software, and procedures to meet its objectives.                                              | POF 2: Implement processes to authorize system changes before design or acquisition, test changes prior to production deployment, require formal approval of system changes, and protect confidential information during development and change processes.                                                                                                                                  | <ul><li>SAST running</li><li>DAST running</li><li>Secret detection running</li><li>Default branch protected</li><li>At least two approvals</li></ul> |

## TISAX compliance requirements

TISAX is the Trusted Information Security Assessment Exchange.

The following table lists the requirements supported by GitLab for TISAX and the controls for the requirements.
You can use the
[`tisax.json` template](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/tisax.json?ref_type=heads)
to create a compliance framework for this standard.

| TISAX requirement                                                                                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Supported controls |
|:-------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 1.2.2 To what extent are information security responsibilities organized?                                                                  | A successful ISMS requires clear responsibilities within the organization. An appropriate organizational separation of responsibilities should be established in order to avoid conflict of interests (separation of duties). (C, I, A)                                                                                                                                                                                                                             | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 1.3.4 To what extent is it ensured that only evaluated and approved software is used for processing the organization's information assets? | Information processing is mostly done using of specific software. Security issues in software will become a risk for the information processed. Accordingly, software must be appropriately managed. Software is approved before installation or use. The software repositories are protected against unauthorized manipulation. Approval of software is regularly reviewed. Software versions and patch levels are known.                                   | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>License compliance running</li></ul> |
| 5.2.1 To what extent are changes managed?                                                                                                  | The objective is to ensure that information security aspects are considered in case of any changes to the organization, business processes and IT systems (Change Management) in order to prevent these changes from causing an uncontrolled reduction in the information security level. Information security requirements for changes to the organization, business processes, IT systems are determined and applied. A formal approval procedure is established. | <ul><li>Default branch protected</li></ul> |
| 5.2.5 To what extent are vulnerabilities identified and addressed?                                                                         | Gather and evaluate information on technical vulnerabilities affecting IT systems. Identify and assess potentially affected systems and software, then address vulnerabilities based on risk assessment to prevent exploitation by attackers.                                                                                                                                                                                                                       | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| 5.3.1 To what extent is information security considered in new or further developed IT systems?                                            | Incorporate information security throughout IT system lifecycle. Determine and address security requirements during design, development, acquisition, and system changes. Conduct security-focused approval testing for all IT systems.                                                                                                                                                                                                                             | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li></ul> |
| 7.1.1 To what extent is compliance with regulatory and contractual provisions ensured?                                                     | Non-compliance with legal, regulatory, or contractual provisions can create risks to the information security of customers and the own organization. Therefore, it is essential to ensure that these provisions are known and observed. Legal, regulatory, and contractual provisions of relevance to information security (see examples) are determined at regular intervals.                                                                                      | <ul><li>License compliance running</li></ul> |
