---
stage: Plan
group: Optimize
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: バリューストリーム分析
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

バリューストリーム分析では、ソフトウェア開発プロセスの各ステージの期間を計算します。マージリクエストまたはイシューイベントを追跡することにより、アイデアから本番環境までの時間を測定できます。

バリューストリーム分析を使用して、以下を特定します:

- アイデアから本番環境までの時間。
- 特定のプロジェクトの開発速度。
- ソフトウェア開発プロセスにおけるボトルネック。
- 長期にわたるイシューまたはマージリクエスト。
- ソフトウェア開発ライフサイクルを遅らせる要因。

バリューストリーム分析は、ビジネスに役立ちます:

- エンドツーエンドのDevSecOpsワークストリームを可視化します。
- 非効率性を特定して解決します。
- より多くの価値をより迅速に提供するためにワークストリームを最適化します（例：[マージリクエストのレビュー時間の短縮](https://about.gitlab.com/blog/2025/02/20/how-we-reduced-mr-review-time-with-value-stream-management/)）。

クリック操作のデモについては、[Value Stream Managementの製品ツアー](https://gitlab.navattic.com/vsm)をご覧ください。

バリューストリーム分析には、階層構造があります:

- 1つの**value stream**（バリューストリーム） には、バリューストリームステージリストが含まれています。
- 各バリューストリームステージリストには、1つ以上の**stages**（ステージ）が含まれています。
- 各ステージは、開始と終了の2つの**events**（イベント）によって定義されます。

## バリューストリーム {#value-streams}

バリューストリームは、顧客に価値を提供する作業プロセス全体です。バリューストリームは、ステージのコンテナオブジェクトです。DevOpsライフサイクルのさまざまな側面に焦点を当てるために、グループごとに複数のバリューストリームを設定できます。

## バリューストリームのバリューストリームステージ {#value-stream-stages}

ステージは、イベントのペア（開始イベントと終了イベント）と、ステージの名前などの追加のメタデータを表します。並べ替えたり非表示にしたりできる組み込みのデフォルトのステージで、バリューストリーム分析を使用できます。特定のソフトウェア開発ワークフローに合わせて、カスタムステージを作成および追加することもできます。

## バリューストリームステージイベント {#value-stream-stage-events}

{{< history >}}

- マージリクエストの最初のレビュアー割り当てイベントがGitLab 17.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/466383)されました。GitLab 17.2より前に作成または更新されたマージリクエストのレビュアー割り当てイベントは、レポートに使用できません。

{{< /history >}}

イベントは、ステージの開始と終了を定義する構成要素です。各イベントには、開始時刻と終了時刻があります:

- 開始イベント時刻は、ステージでの作業が開始されるときを示します（たとえば、イシューが作成されたとき）。
- 終了イベント時刻は、ステージでの作業が完了したときを示します（たとえば、イシューがクローズされたとき）。

GitLabは、この式を使用して、開始イベント時刻と終了イベント時刻に基づいてステージの期間を計算します: ステージの期間=終了イベント時刻 - 開始イベント時刻

バリューストリーム分析は、次のイベントをサポートしています:

- イシューをクローズ
- イシューを作成
- イシューを最初にボードに追加
- イテレーションに最初に追加されたイシュー
- イシューを最初に割り当て
- マイルストーンに最初に関連付けられたイシュー
- イシューが最初にコミットで言及
- イシューラベルを追加
- イシューのラベル削除
- マージリクエストのクローズ
- マージリクエストの作成
- マージリクエストに最初に割り当て
- マージリクエストを最初にコミット
- マージリクエストが最初に本番環境にデプロイされたとき
- マージリクエストのラベル追加
- マージリクエストのラベル削除
- マージリクエストの最終承認
- マージリクエストの最終ビルド完了
- マージリクエストの最終ビルド開始
- マージリクエストのマージ
- マージリクエストのレビュアーの最初の割り当て

ステージイベントに関するアイデアやフィードバックを[issue 520962](https://gitlab.com/gitlab-org/gitlab/-/issues/520962)で共有できます。

## データ集計 {#data-aggregation}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 停止日によるフィルタリングの有効化がGitLab 15.0で[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/355000)されました

{{< /history >}}

バリューストリーム分析は、バックエンドプロセスを使用してステージレベルのデータを収集および集計します。これにより、多数のイシューとマージリクエストがある大規模なグループにも対応できます。このプロセスにより、アクションの実行時（たとえば、イシューをクローズするとき）と、バリューストリーム分析ページにデータが表示されるまでに、わずかな遅延が発生する可能性があります。

データの処理と結果の表示には、最大10分かかる場合があります。次の場合、データの収集に10分以上かかることがあります:

- バリューストリーム分析を初めて表示し、まだバリューストリームを作成していない場合。
- グループの階層が再編成された場合。
- イシューとマージリクエストで一括更新があった場合。

データが最後に更新された日時を表示するには、右隅の**編集**の横にある**最終更新日**のバッジにカーソルを合わせるます。

## ステージの測定 {#stage-measurement}

バリューストリーム分析は、各ステージを開始イベントから終了イベントまで測定します。終了イベントに到達したアイテムのみが、ステージ時間の計算に含まれます。

デフォルトでは、ブロックされたイシューは、ライフサイクルの概要には含まれていません。ただし、カスタムラベル（たとえば、`workflow::blocked`）を使用してそれらを追跡できます。

定義済みのイベントに基づいて、バリューストリーム分析でステージをカスタマイズできます。設定を支援するために、GitLabはテンプレートとして使用できる定義済みのステージのリストを提供します。たとえば、ラベルをイシューに追加したときに開始し、別のラベルを追加したときに終了するステージを定義できます。

次の表に、バリューストリーム分析で定義済みのステージの概要を示します。

| ステージ   | 測定方法   |
| ------- | -------------------- |
| イシュー     | イシューの作成から、ラベルを付けるか、マイルストーンに追加するかのいずれかで、それを解決するためのアクションを実行するまでの中央値時間（いずれか早い方）。ラベルは、[イシューボードリスト](../../project/issue_board.md)が既に作成されている場合にのみ追跡されます。 |
| プラン      | 前のステージで実行したアクションから、ブランチへの最初のコミットのプッシュまでの中央値時間。ブランチの最初のコミットは、**Plan**と**コード**の分離をトリガーします。ブランチ内のコミットの少なくとも1つに、関連するイシュー番号（たとえば、`#42`）が含まれている必要があります。ブランチ内のどのコミットにも関連するイシュー番号が記載されていない場合、ステージの測定時間では考慮されません。 |
| コード      | 最初のコミット（前のステージ）をプッシュしてから、そのコミットに関連するマージリクエスト（MR）を作成するまでの中央値時間。プロセスを追跡し続けるためのキーは、マージリクエストの説明に[イシューのクローズパターン](../../project/issues/managing_issues.md#default-closing-pattern)を含めることです。たとえば、`Closes #xxx`（`xxx`は、このマージリクエストに関連するイシューの番号）など。クローズパターンが存在しない場合、計算では、マージリクエストの最初のコミットの作成時刻が開始時刻として使用されます。 |
| Test      | そのプロジェクトのパイプライン全体を実行するための中央値時間。これは、GitLab CI/CDがそのマージリクエストにプッシュされたコミットごとにすべてのジョブを実行するのにかかる時間に関連しています。基本的には、すべてのパイプラインの開始から終了までの時間です。 |
| Review    | イシューのクローズパターンを持つマージリクエストの作成からマージされるまでにかかる中央値時間。 |
| ステージング   | イシューのクローズパターンを持つマージリクエストをマージしてから、[本番環境](#production-environment)への最初のデプロイまでの中央値時間。本番環境がない場合、これは追跡されません。 |

{{< alert type="note" >}}

バリューストリーム分析はタイムスタンプデータで動作し、ステージの最終的な開始イベントと停止イベントのみを集計します。複数のステージ間を行き来するアイテムの場合、ステージ時間は最終イベントのタイムスタンプのみから計算されます。

{{< /alert >}}

### ワークフローの例 {#example-workflow}

この例は、1日で7つのステージすべてを通過するワークフローを示しています。

ステージに開始時刻と停止時刻が含まれていない場合、そのデータは中央値時間に含まれません。この例では、マイルストーンが作成され、テストおよび設定環境用のCI/CDが構成されています。

- 09:00: イシューを作成。**Issue**ステージが開始されます。
- 11:00: イシューをマイルストーン（またはバックログ）に追加し、イシューでの作業を開始して、ローカルにブランチを作成します。**Issue**ステージが停止し、**Plan**ステージが開始されます。
- 12:00: 最初のコミットを作成します。
- 12:30: イシュー番号を言及するブランチに2番目のコミットを作成します。**Plan**ステージが停止し、**コード**ステージが開始されます。
- 14:00: ブランチをプッシュし、[イシューのクローズパターン](../../project/issues/managing_issues.md#closing-issues-automatically)を含むマージリクエストを作成します。**コード**ステージが停止し、**テスト**と**Review**のステージが開始されます。
- GitLab CI/CDは、[`.gitlab-ci.yml`ファイル](../../../ci/yaml/_index.md)で定義されたスクリプトを実行するのに5分かかります。
- 19:00: マージリクエストをマージします。**Review**ステージが停止し、**Stagingステージ**ステージが開始されます。
- 19:30: `production`環境へのデプロイが完了します。**Stagingステージ**が停止します。

バリューストリーム分析は、各ステージの次の時間を記録します:

- **Issue**: 09:00～11:00: 2時間
- **Plan**: 11:00～12:00: 1時間
- **コード**: 12:00～14:00: 2時間
- **テスト**: 5分
- **Review**: 14:00～19:00: 5時間
- **Stagingステージ**: 19:00～19:30: 30分

この例に関連する次の点に注意してください:

- この例は、最初のコミットがイシュー番号を言及していなくても、作業中のブランチの任意のコミットで後で実行できることを示しています。
- **テスト**ステージは、サイクルの全体時間の計算に使用されます。すべてのMRをテストする必要があるため、**Review**プロセスに含まれています。
- この例は、7つのステージの**one cycle**（1つのサイクル）のみを示しています。バリューストリーム分析のダッシュボードには、複数のサイクルの中央値時間が表示されます。

### ラベルイベントの累積期間 {#cumulative-label-event-duration}

{{< history >}}

- GitLab 16.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/432576)（`enable_vsa_cumulative_label_duration_calculation`と`vsa_duration_from_db`という名前の[フラグ](../../../administration/feature_flags/_index.md)を使用）。デフォルトでは無効になっています。
- GitLab 16.10で、[GitLab.comとGitLab Self-Managed](https://gitlab.com/gitlab-com/gl-infra/production/-/issues/17476)で有効化されました。機能フラグ`vsa_duration_from_db`は削除されました。
- GitLab 17.0で機能フラグ`enable_vsa_cumulative_label_duration_calculation`は[削除](https://gitlab.com/gitlab-com/gl-infra/production/-/issues/17478)されました。

{{< /history >}}

この機能を使用すると、バリューストリーム分析は、ラベルベースのステージでの反復イベントの期間を測定します。開始イベントと終了イベントの両方に対して、ラベルの削除または追加イベントを構成する必要があります。

たとえば、ステージは、`in progress`ラベルが追加および削除されたときを次の時間で追跡します:

- 9:00: ラベルが追加されました。
- 10:00: ラベルが削除されました。
- 12:00: ラベルが追加されました。
- 14:00ラベルが削除されました。

元の計算方法では、期間は5時間です（9:00～14:00）。ラベルイベントの累積期間の計算を有効にすると、期間は3時間になります（9:00～10:00および12:00～14:00）。

{{< alert type="note" >}}

GitLabバージョンを16.10（またはそれ以降のバージョン）にアップグレードすると、既存のラベルベースのバリューストリーム分析ステージは、バックグラウンドの集計プロセスを使用して自動的に再度集計されます。

{{< /alert >}}

#### アップグレード後にデータを再集計する {#reaggregate-data-after-upgrade}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

大規模なインスタンスでは、GitLabバージョンをアップグレードするとき、特にいくつかのマイナーバージョンをスキップした場合は、バックグラウンドの集計プロセスが長くなる可能性があります。この遅延により、バリューストリーム分析ダッシュボードに古いデータが表示される可能性があります。集計プロセスを高速化し、古いデータを回避するために、[Railsコンソール](../../../administration/operations/rails_console.md#starting-a-rails-console-session)で、特定のグループの同期集計スニペットを実行することができます:

```ruby
group = Group.find(-1) # put your group id here
group_to_aggregate = group.root_ancestor

loop do
  cursor = {}
  context = Analytics::CycleAnalytics::AggregationContext.new(cursor: cursor)
  service_response = Analytics::CycleAnalytics::DataLoaderService.new(group: group_to_aggregate, model: Issue, context: context).execute

  if service_response.success? && service_response.payload[:reason] == :limit_reached
    cursor = service_response.payload[:context].cursor
  elsif service_response.success?
    puts "finished"
    break
  else
    puts "failed"
    break
  end
end

loop do
  cursor = {}
  context = Analytics::CycleAnalytics::AggregationContext.new(cursor: cursor)
  service_response = Analytics::CycleAnalytics::DataLoaderService.new(group: group_to_aggregate, model: MergeRequest, context: context).execute

  if service_response.success? && service_response.payload[:reason] == :limit_reached
    cursor = service_response.payload[:context].cursor
  elsif service_response.success?
    puts "finished"
    break
  else
    puts "failed"
    break
  end
end
```

## 本番環境 {#production-environment}

バリューストリーム分析は、次のいずれかのパターンに一致する名前を持つプロジェクトの[本番環境](../../../ci/environments/_index.md#deployment-tier-of-environments)を検索して、[環境](../../../ci/yaml/_index.md#environment)を識別します:

- `prod`または`prod/*`
- `production`または`production/*`

これらのパターンでは、大文字と小文字は区別されません。

GitLab CI/CD設定で、プロジェクト環境の名前を変更できます。

## バリューストリーム分析を表示 {#view-value-stream-analytics}

{{< history >}}

- GitLab 16.5で、`vsa_predefined_date_ranges`という名前の[フラグ](../../../administration/feature_flags/_index.md)が定義済みの期間ドロップダウンリストとともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/408656/)されました。デフォルトでは無効になっています。
- 定義済みの期間ドロップダウンリストがGitLab 16.7で[GitLab Self-ManagedおよびGitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/433149)になりました。
- 定義済みの期間ドロップダウンリストがGitLab 16.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/438051)になりました。機能フラグ`vsa_predefined_date_ranges`は削除されました。

{{< /history >}}

前提要件: 

- レポーターロール以上が必要です。
- カスタムバリューストリームを作成する必要があります。バリューストリーム分析は、グループまたはプロジェクト用に作成されたカスタムバリューストリームのみを表示します。

グループまたはプロジェクトのバリューストリーム分析を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. 特定のステージのメトリクスを表示するには、**結果をフィルタリング**テキストボックスの下にあるステージを選択します。
1. オプション。結果をフィルタリングします: 
   1. **結果をフィルタリング**テキストボックスを選択します。
   1. パラメータを選択します。
   1. 値を並べ替えるか、テキストを入力して結果を絞り込みます。
   1. 特定の期間のメトリクスを表示するには、ドロップダウンリストから、定義済みの期間または**カスタム**オプションを選択します。**カスタム**オプションを選択した場合:

      - **From**フィールドで、開始日を選択します。
      - **To**フィールドで、終了日を選択します。

      チャートとリストには、その期間中に作成されたワークフローアイテムが表示されます。
1. オプション。昇順または降順で結果を並べ替えます:
      - 最新または最古のワークフローアイテムで並べ替えるには、**最後のイベント**ヘッダーを選択します。
      - 各ステージで費やされた時間の最長または最短で並べ替えるには、**期間**ヘッダーを選択します。

ワークフローアイテムテーブルのヘッダーの横にあるバッジには、選択したステージ中に完了したワークフローアイテムの数が表示されます。

テーブルには、選択したステージの関連するワークフローアイテムのリストが表示されます。選択したステージに基づいて、次のようになります:

- イシュー
- マージリクエスト

{{< alert type="note" >}}

定義済みの各日付範囲の終了日は当日であり、選択した日数に含まれます。たとえば、`Last 30 days`の開始日は、合計30日間で、現在の日付の29日前になります。

{{< /alert >}}

### データフィルター {#data-filters}

バリューストリーム分析をフィルタリングして、特定の基準に一致するデータを表示できます。次のフィルターがサポートされています:

- 日付範囲
- プロジェクト
- 担当者
- 作成者
- マイルストーン
- ラベル

## バリューストリーム分析のメトリクス {#value-stream-analytics-metrics}

バリューストリーム分析の**概要**ページには、プロジェクトとグループのDevSecOpsライフサイクルのパフォーマンスのキーメトリクスが表示されます。

### ライフサイクルメトリクス {#lifecycle-metrics}

バリューストリーム分析には、次のライフサイクルメトリクスが含まれています:

- **リードタイム**: イシューの作成から完了までの時間の中央値。
- **サイクルタイム**: イシューが最初にマージリクエストの[コミットメッセージで参照](../../project/issues/crosslinking_issues.md#from-commit-messages)されてから、その参照イシューがクローズされるまでの時間の中央値。コミットメッセージに`#`に続けてイシュー番号（例：`#123`）を含める必要があります。そうしないと、データは表示されません。サイクルタイムは、通常、最初のコミットの後にマージリクエストが作成されるため、リードタイムよりも短くなります。
- **新しいイシュー**: 作成された新しいイシューの数。
- **デプロイ**: 本番環境へのデプロイの合計数。

### DORAメトリクス {#dora-metrics}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- サービスタイルの復元までの時間をGitLabバージョン15.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/355304)。
- 変更失敗率タイルをGitLabバージョン15.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/357071)。

{{< /history >}}

バリューストリーム分析には、次の[DORAメトリクス](../../analytics/dora_metrics.md)が含まれています:

- デプロイ頻度
- 変更のリード時間
- サービス復旧時間
- 変更失敗率

DORAメトリクスは、[DORA API](../../../api/dora/metrics.md)のデータに基づいて計算されます。

GitLab PremiumまたはUltimateプランのサブスクリプションをお持ちの場合:

- 成功したデプロイの数は、DORAデータで計算されます。
- データは、環境と環境層に基づいてフィルタリングされます。

## ライフサイクルとDORAメトリクスの表示 {#view-lifecycle-and-dora-metrics}

前提要件: 

- デプロイメトリクスを表示するには、[本番環境が構成されている](#production-environment)必要があります。

ライフサイクルメトリクスを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。ライフサイクルメトリクスは、**結果をフィルタリング**テキストボックスの下に表示されます。
1. オプション。結果をフィルタリングします: 
   1. **結果をフィルタリング**テキストボックスを選択します。選択したフィルターに基づいて、ダッシュボードはライフサイクルメトリクスを自動的に集計し、バリューストリームのステータスを表示します。
   1. パラメータを選択します。
   1. 結果を絞り込むには、値を選択するか、テキストを入力します。
   1. 日付範囲を調整するには:
      - **From**フィールドで、開始日を選択します。
      - **To**フィールドで、終了日を選択します。

[バリューストリームダッシュボード](../../analytics/value_streams_dashboard.md)と[DORAメトリクス](../../analytics/dora_metrics.md)を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. **結果をフィルタリング**テキストボックスの下の**ライフサイクルメトリクス**行で、**Value Streams Dashboard / DORA**（バリューストリームダッシュボード / DORA） を選択します。
1. オプション。新しいページを開くには、このパス`/analytics/dashboards/value_streams_dashboard`をグループURLに追加します（例：`https://gitlab.com/groups/gitlab-org/-/analytics/dashboards/value_streams_dashboard`）。

## 各開発ステージのメトリクスを表示 {#view-metrics-for-each-development-stage}

バリューストリーム分析には、各開発ステージでイシューまたはマージリクエストに費やされた平均時間が表示されます。

グループの各ステージで費やされた平均時間を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. オプション。結果をフィルタリングします: 
   1. **結果をフィルタリング**テキストボックスを選択します。
   1. パラメータを選択します。
   1. 結果を絞り込むには、値を選択するか、テキストを入力します。
   1. 日付範囲を調整するには:
      - **From**フィールドで開始日を選択します。
      - **To**フィールドで終了日を選択します。
1. 各ステージのメトリクスを表示するには、**結果をフィルタリング**テキストボックスの上にあるステージにカーソルを合わせます。

{{< alert type="note" >}}

日付範囲セレクターは、イベント時間で項目をフィルタリングします。イベント時間は、選択したステージが指定された項目に対して終了した時間です。

{{< /alert >}}

## タイプ別にタスクを表示 {#view-tasks-by-type}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**タイプ別のタスク**チャートには、グループの1日あたりの完了済みタスク（クローズされたイシューとマージリクエスト）の累積数が表示されます。

チャートは、グローバルページフィルターを使用して、選択したグループと期間に基づいてデータを表示します。

タイプ別にタスクを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. **結果をフィルタリング**テキストボックスの下にある**概要**を選択します。**タイプ別のタスク**チャートは、**合計時間**チャートの下に表示されます。
1. オプション。タイプ別にタスクをフィルタリングするには、**設定**（{{< icon name="settings" >}}）を選択し、次に**イシュー**または**マージリクエスト**を選択します。
1. オプション。ラベルでタスクをフィルタリングするには、**設定**（{{< icon name="settings" >}}）を選択し、次に1つまたは複数のラベルを選択します。デフォルトでは、上位グループのラベル（最大10個）が選択されています。最大15個のラベルを選択できます。

## バリューストリームを作成 {#create-a-value-stream}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- **新しいバリューストリーム**が、ダイアログからGitLab 16.10のページに、`vsa_standalone_settings_page`という名前の[フラグ付きで](../../../administration/feature_flags/_index.md) [変更されました](https://gitlab.com/gitlab-org/gitlab/-/issues/381002)。デフォルトでは無効になっています。
- [GitLab](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171856) 17.7で一般提供。機能フラグ`vsa_standalone_settings_page`は削除されました。

{{< /history >}}

### デフォルトのステージで {#with-default-stages}

デフォルトのステージでバリューストリームを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **Value Stream analytics**（バリューストリーム分析） を選択します。
1. **New Value Stream**（新しいバリューストリーム）を選択します。
1. バリューストリームの名前を入力します。
1. **デフォルトテンプレートから作成**を選択します。
1. デフォルトのステージをカスタマイズ:
   - ステージの順序を変更するには、上向きまたは下向きの矢印を選択します。
   - ステージを非表示にするには、**非表示**（{{< icon name="eye-slash" >}}）を選択します。
1. カスタムステージを追加するには、**ステージを追加する**を選択します。
   - ステージの名前を入力します。
   - **開始イベント**と**Stop event**（停止イベント）を選択します。
1. **新しいバリューストリーム**を選択します。

{{< alert type="note" >}}

最近GitLab Premiumにアップグレードした場合、データが収集され表示されるまでに最大30分かかることがあります。

{{< /alert >}}

### カスタムステージあり {#with-custom-stages}

カスタムステージでバリューストリームを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **Value Stream analytics**（バリューストリーム分析） を選択します。
1. **新しいバリューストリーム**を選択します。
1. 各ステージについて:
   - ステージの名前を入力します。
   - **開始イベント**と**Stop event**（停止イベント）を選択します。
1. 別のステージを追加するには、**ステージを追加する**を選択します。
1. ステージの順序を変更するには、上向きまたは下向きの矢印を選択します。
1. **新しいバリューストリーム**を選択します。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>ビデオでの説明については、[バリューストリーム分析によるマージリクエストのレビュープロセスの最適化](https://www.youtube.com/watch?v=kblpge6xeL8)を参照してください。
<!-- Video published on 2024-07-29 -->

## カスタムバリューストリームのラベルベースステージ {#label-based-stages-for-custom-value-streams}

複雑なワークフローを測定するには、[スコープ付きラベル](../../project/labels.md#scoped-labels)を使用できます。たとえば、ステージング環境から本番環境へのデプロイ時間を測定するには、次のラベルを使用できます:

- コードがステージングにデプロイされると、`workflow::staging`ラベルがマージリクエストに追加されます。
- コードが本番環境にデプロイされると、`workflow::production`ラベルがマージリクエストに追加されます。

![ラベルベースのバリューストリーム分析ステージ](img/vsa_label_based_stage_v14_0.png "ラベルベースのバリューストリーム分析ステージの作成")

### Webhookを使用した自動データラベリング {#automatic-data-labeling-with-webhooks}

[GitLab Webhookイベント](../../project/integrations/webhook_events.md)を使用してラベルを自動的に追加できるため、特定のイベントが発生すると、ラベルがマージリクエストまたはイシューに適用されます。次に、ラベルベースステージを追加して、ワークフローを追跡できます。実装の詳細については、ブログ投稿[GitLabラベルの自動適用](https://about.gitlab.com/blog/2016/08/19/applying-gitlab-labels-automatically/)を参照してください。

### 設定例 {#example-configuration}

![設定例](img/object_hierarchy_v14_10.png "カスタムバリューストリーム設定の例")

前の例では、2つの独立したバリューストリームが、**Test Group**（トップレベルネームスペース）で異なる開発ワークフローを使用している2つのチームに対して設定されています。

最初のバリューストリームは、ステージを定義するために、標準のタイムスタンプベースのイベントを使用します。2番目のバリューストリームは、ラベルイベントを使用します。

## バリューストリームを編集 {#edit-a-value-stream}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- **バリューストリームを編集**が、ダイアログからGitLab 16.10のページに`vsa_standalone_settings_page`という名前の[フラグ](../../../administration/feature_flags/_index.md)付きで[変更されました](https://gitlab.com/gitlab-org/gitlab/-/issues/381002)。デフォルトでは無効になっています。
- [GitLab](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171856) 17.7で一般提供。機能フラグ`vsa_standalone_settings_page`は削除されました。

{{< /history >}}

バリューストリームを作成した後、目的に合わせてカスタマイズできます。バリューストリームを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. バリューストリームドロップダウンリストから、編集するバリューストリームを選択します。
1. バリューストリームドロップダウンリストの横にある**編集**を選択します。
1. （オプション）:
   - バリューストリームの名前を変更します。
   - デフォルトのステージを非表示にするか、順序を変更します。
   - 既存のカスタムステージを削除します。
   - 新しいステージを追加するには、**ステージを追加する**を選択します。
   - ステージの開始イベントと終了イベントを選択します。
1. オプション。変更を元に戻すには、**Restore value stream defaults**（バリューストリームのデフォルトを復元する）を選択します。
1. **Save Value Stream**（バリューストリームの保存）を選択します。

## バリューストリームを削除 {#delete-a-value-stream}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

カスタムバリューストリームを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. バリューストリームドロップダウンリストから、削除するバリューストリームを選択し、**Delete (name of value stream)**（削除（バリューストリーム名））を選択します。
1. 確定するには、**削除**を選択します。

## サイクルが完了するまでの日数を表示 {#view-number-of-days-for-a-cycle-to-complete}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**Total time chart**（合計時間チャート）は、開発サイクルが完了するまでの平均日数を示しています。チャートには、過去500件のワークフロー項目のデータが表示されます。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **分析** > **バリューストリーム分析**を選択します。
1. **結果をフィルタリング**ボックスの上にあるステージを選択します:
   - すべてのステージのサイクルタイムのサマリーを表示するには、**概要**を選択します。
   - 特定のステージのサイクルタイムを表示するには、ステージを選択します。
1. オプション。結果をフィルタリングします: 
   1. **結果をフィルタリング**テキストボックスを選択します。
   1. パラメータを選択します。
   1. 結果を絞り込むには、値を選択するか、テキストを入力します。
   1. 日付範囲を調整するには:
      - **From**フィールドで開始日を選択します。
      - **To**フィールドで終了日を選択します。

## アクセス許可 {#access-permissions}

バリューストリーム分析のアクセス許可は、プロジェクトの種類によって異なります。

| プロジェクトタイプ | 権限                                       |
|--------------|---------------------------------------------------|
| 公開       | 誰でもアクセスできます。                                |
| 内部     | 認証済みの認証済みユーザーは誰でもアクセスできます。                |
| 非公開      | ゲストロール以上のロールを持つユーザーは誰でもアクセスできます。 |

## バリューストリーム分析GraphQL API {#value-stream-analytics-graphql-api}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GraphQL経由でのステージメトリクスの読み込みは、GitLab 17.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/410327)されました。

{{< /history >}}

VSA GraphQL APIを使用すると、設定済みのバリューストリームとバリューストリームステージからメトリクスをリクエストできます。これは、VSAデータを外部システムまたはレポートにエクスポートする場合に役立ちます。

次のメトリクスを利用できます:

- ステージで完了した項目の数。カウントは最大10,000項目に制限されます。
- ステージで完了した項目の平均継続時間。
- ステージで完了した項目の平均継続時間。

### メトリクスをリクエスト {#request-the-metrics}

前提要件: 

- レポーターロール以上が必要です。

まず、レポートで使用するバリューストリームを決定する必要があります。

グループに設定されたバリューストリームをリクエストするには、次を実行します:

```graphql
group(fullPath: "your-group-path") {
  valueStreams {
    nodes {
      id
      name
    }
  }
}
```

同様に、プロジェクトのメトリクスをリクエストするには、次を実行します:

```graphl
project(fullPath: "your-project-path") {
  valueStreams {
    nodes {
      id
      name
    }
  }
}
```

バリューストリームのステージのメトリクスをリクエストするには、次を実行します:

```graphql
group(fullPath: "your-group-path") {
  valueStreams(id: "your-value-stream-id") {
    nodes {
      stages {
        id
        name
      }
    }
  }
}
```

データの消費方法に応じて、バリューストリーム内の特定のステージまたはすべてのステージのメトリクスをリクエストできます。

{{< alert type="note" >}}

すべてのステージのメトリクスをリクエストすると、インストールによっては速度が遅くなることがあります。推奨されるアプローチは、ステージごとにメトリクスをリクエストすることです。

{{< /alert >}}

ステージのメトリクスのリクエスト:

```graphql
group(fullPath: "your-group-path") {
  valueStreams(id: "your-value-stream-id") {
    nodes {
      stages(id: "your-stage-id") {
        id
        name
        metrics(timeframe: { start: "2024-03-01", end: "2024-03-31" }) {
          average {
            value
            unit
          }
          median {
            value
            unit
          }
          count {
            value
            unit
          }
        }
      }
    }
  }
}
```

{{< alert type="note" >}}

常に特定の期間でメトリクスをリクエストする必要があります。サポートされている最長の期間は180日です。

{{< /alert >}}

`metrics`ノードは、追加のフィルタリングオプションをサポートしています:

- アサイニーユーザー名
- 作成者のユーザー名
- ラベル名
- マイルストーンのタイトル

フィルターを使用したリクエストの例:

```graphql
group(fullPath: "your-group-path") {
  valueStreams(id: "your-value-stream-id") {
    nodes {
      stages(id: "your-stage-id") {
        id
        name
        metrics(
          labelNames: ["backend"],
          milestoneTitle: "17.0",
          timeframe: { start: "2024-03-01", end: "2024-03-31" }
        ) {
          average {
            value
            unit
          }
          median {
            value
            unit
          }
          count {
            value
            unit
          }
        }
      }
    }
  }
}
```

### ベストプラクティス {#best-practices}

- 現在のステータスの正確なビューを取得するには、可能な限り期間の終了に近いメトリクスをリクエストします。
- 定期的なレポートでは、スクリプトを作成し、[スケジュールされたパイプライン](../../../ci/pipelines/schedules.md)機能を使用して、データをタイムリーにエクスポートできます。
- APIを実行すると、データベースから現在のデータが取得されます。時間の経過とともに、データベースの基になるデータの変更により、同じメトリクスが変更される可能性があります。たとえば、グループからプロジェクトを移動または削除すると、グループレベルのメトリクスに影響を与える可能性があります。
- 以前の期間のメトリクスを再度リクエストし、以前に収集されたメトリクスと比較すると、データのスキューが表示され、変化する傾向の発見と説明に役立ちます。

## 機能の可用性 {#feature-availability}

バリューストリーム分析は、FOSSおよびライセンスバージョンで、プロジェクトレベルとグループレベルで異なる機能を提供します。

- GitLab Freeでは、バリューストリーム分析はデータを集計しません。日付範囲フィルターがイシューとマージリクエストの作成日に適用されるデータベースを直接クエリします。デフォルトで事前定義されたステージを使用して、バリューストリーム分析を表示できます。
- GitLab Premiumでは、バリューストリーム分析はデータを集計し、終了イベントに日付範囲フィルターを適用します。バリューストリームを作成、編集、削除することもできます。

| 機能                                              | グループレベル（ライセンスあり）                                                                        | プロジェクトレベル（ライセンスあり）        | プロジェクトレベル（FOSS） |
|------------------------------------------------------|-----------------------------------------------------------------------------------------------|---------------------------------|----------------------|
| カスタムバリューストリームを作成                          | はい                                                                                           | はい                             | いいえ、1つのバリューストリーム（デフォルト）のみがデフォルトのステージとともに存在します |
| カスタムステージを作成                                 | はい                                                                                           | はい                             | いいえ                   |
| フィルタリング（例：作成者、ラベル、マイルストーン別） | はい                                                                                           | 可                             | はい                  |
| ステージ時間チャート                                     | はい                                                                                           | はい                             | いいえ                   |
| 合計時間チャート                                     | はい                                                                                           | はい                             | いいえ                   |
| タイプ別のタスクチャート                                   | はい                                                                                           | いいえ                              | いいえ                   |
| DORAメトリクス                                         | はい                                                                                           | はい                             | いいえ                   |
| サイクル時間とリードタイムの概要（ライフサイクルメトリクス） | はい                                                                                           | はい                             | いいえ                   |
| 新しいイシュー、コミット、およびデプロイ（ライフサイクルメトリクス） | はい、コミットを除外する                                                                        | はい                             | はい                  |
| 集計されたバックエンドを使用                              | はい                                                                                           | はい                             | いいえ                   |
| 日付フィルターの動作                                 | 日付範囲[完了](https://gitlab.com/groups/gitlab-org/-/epics/6046)した項目をフィルタリングします | 作成日ごとに項目をフィルタリングします。 | 作成日ごとに項目をフィルタリングします。 |
| 認可                                        | 少なくともレポーター                                                                             | 少なくともレポーター               | 公開可能        |

## トラブルシューティング {#troubleshooting}

### SidekiqによるCPU使用率100％`cronjob:analytics_cycle_analytics` {#100-cpu-utilization-by-sidekiq-cronjobanalytics_cycle_analytics}

バリューストリーム分析のバックグラウンドジョブがCPUリソースを独占することで、パフォーマンスに大きな影響を与える可能性があります。

この状況から回復するには:

1. [Railsコンソール](../../../administration/operations/rails_console.md)ですべてのプロジェクトの機能を無効にし、既存のジョブを削除します:

   ```ruby
   Project.find_each do |p|
     p.analytics_access_level='disabled';
     p.save!
   end

   Analytics::CycleAnalytics::GroupStage.delete_all
   Analytics::CycleAnalytics::Aggregation.delete_all
   ```

1. たとえば、単一の`feature_category=value_stream_management`と複数の`feature_category!=value_stream_management`エントリを含む[Sidekiqルーティング](../../../administration/sidekiq/processing_specific_job_classes.md)を構成します。[Enterprise Editionリスト](../../../administration/sidekiq/processing_specific_job_classes.md#list-of-available-job-classes)で、その他の関連するキューメタデータを検索します。
1. 1つのプロジェクトずつバリューストリーム分析を有効にします。パフォーマンス要件に応じて、Sidekiqルーティングをさらに微調整する必要がある場合があります。
