/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.tools.content.IconDescriptionResolver;
import org.freeplane.plugin.ai.tools.content.IconsContent;
import org.freeplane.plugin.ai.tools.edit.EditOperation;

public class IconsContentEditor {
    private final IconDescriptionResolver iconDescriptionResolver;
    private final Iterable<NamedIcon> defaultCandidates;
    private final MIconController iconController;

    public IconsContentEditor(IconDescriptionResolver iconDescriptionResolver, Iterable<NamedIcon> defaultCandidates, MIconController iconController) {
        this.iconDescriptionResolver = Objects.requireNonNull(iconDescriptionResolver, "iconDescriptionResolver");
        this.defaultCandidates = Objects.requireNonNull(defaultCandidates, "defaultCandidates");
        this.iconController = Objects.requireNonNull(iconController, "iconController");
    }

    public void setInitialContent(NodeModel nodeModel, IconsContent iconsContent) {
        if (nodeModel == null || iconsContent == null) {
            return;
        }
        List<String> descriptions = iconsContent.getDescriptions();
        if (descriptions == null || descriptions.isEmpty()) {
            return;
        }
        IconRegistry iconRegistry = nodeModel.getMap().getIconRegistry();
        List<NamedIcon> candidates = this.collectCandidateIcons(iconRegistry);
        if (candidates.isEmpty()) {
            return;
        }
        HashSet<String> addedNames = new HashSet<String>();
        for (String description : descriptions) {
            NamedIcon icon;
            if (TextUtils.isEmpty((String)description) || (icon = this.findMatchingIcon(candidates, description.trim())) == null || !addedNames.add(icon.getName())) continue;
            nodeModel.addIcon(icon);
        }
    }

    public void editExistingIconsContent(NodeModel nodeModel, EditOperation operation, String targetKey, Integer index, String value) {
        if (nodeModel == null) {
            throw new IllegalArgumentException("Missing node model.");
        }
        EditOperation resolvedOperation = operation == null ? EditOperation.REPLACE : operation;
        ArrayList<NamedIcon> icons = new ArrayList<NamedIcon>(nodeModel.getIcons());
        switch (resolvedOperation) {
            case ADD: {
                NamedIcon addedIcon = this.findIcon(nodeModel, this.requireIconDescription(value));
                if (addedIcon == null) {
                    throw new IllegalArgumentException("Unknown icon description: " + value);
                }
                this.iconController.addIcon(nodeModel, addedIcon);
                break;
            }
            case DELETE: {
                int deleteIndex = this.findIconIndex(icons, targetKey, index);
                if (deleteIndex < 0) {
                    throw new IllegalArgumentException("Invalid icon index for delete.");
                }
                this.iconController.removeIcon(nodeModel, deleteIndex);
                break;
            }
            case REPLACE: {
                int replaceIndex = this.findIconIndex(icons, targetKey, index);
                if (replaceIndex < 0) {
                    throw new IllegalArgumentException("Invalid icon index for replace.");
                }
                NamedIcon replacementIcon = this.findIcon(nodeModel, this.requireIconDescription(value));
                if (replacementIcon == null) {
                    throw new IllegalArgumentException("Unknown icon description: " + value);
                }
                this.iconController.removeIcon(nodeModel, replaceIndex);
                this.iconController.addIcon(nodeModel, replacementIcon);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported icon operation: " + String.valueOf((Object)resolvedOperation));
            }
        }
    }

    private String requireIconDescription(String value) {
        if (TextUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("Missing icon description.");
        }
        return value.trim();
    }

    private List<NamedIcon> collectCandidateIcons(IconRegistry iconRegistry) {
        ArrayList<NamedIcon> candidates = new ArrayList<NamedIcon>();
        HashSet<String> seenNames = new HashSet<String>();
        this.addIcons(candidates, seenNames, this.defaultCandidates);
        if (iconRegistry != null) {
            Iterator iterator = iconRegistry.getIconsAsListModel().iterator();
            this.addIcons(candidates, seenNames, () -> iterator);
        }
        return candidates;
    }

    private void addIcons(List<NamedIcon> target, Set<String> seenNames, Iterable<NamedIcon> source) {
        if (source == null) {
            return;
        }
        for (NamedIcon icon : source) {
            this.addIcon(target, seenNames, icon);
        }
    }

    private void addIcon(List<NamedIcon> target, Set<String> seenNames, NamedIcon icon) {
        if (icon == null || !seenNames.add(icon.getName())) {
            return;
        }
        target.add(icon);
    }

    private NamedIcon findMatchingIcon(List<NamedIcon> candidates, String description) {
        if (description == null) {
            return null;
        }
        for (NamedIcon candidate : candidates) {
            if (!this.iconDescriptionResolver.matchesDescription(candidate, description)) continue;
            return candidate;
        }
        return null;
    }

    private NamedIcon findIcon(NodeModel nodeModel, String description) {
        if (description == null) {
            return null;
        }
        IconRegistry iconRegistry = nodeModel.getMap().getIconRegistry();
        List<NamedIcon> candidates = this.collectCandidateIcons(iconRegistry);
        return this.findMatchingIcon(candidates, description);
    }

    private int findIconIndex(List<NamedIcon> icons, String targetKey, Integer index) {
        if (index != null && index >= 0 && index < icons.size()) {
            return index;
        }
        if (TextUtils.isEmpty((String)targetKey)) {
            return -1;
        }
        for (int iconIndex = 0; iconIndex < icons.size(); ++iconIndex) {
            NamedIcon icon = icons.get(iconIndex);
            if (icon == null || !this.iconDescriptionResolver.matchesDescription(icon, targetKey)) continue;
            return iconIndex;
        }
        return -1;
    }
}

