/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.create;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.tools.content.NodeContentApplier;
import org.freeplane.plugin.ai.tools.create.NodeCreationHierarchy;
import org.freeplane.plugin.ai.tools.create.NodeCreationItem;
import org.freeplane.plugin.ai.tools.create.NodeFoldingState;
import org.freeplane.plugin.ai.tools.create.NodeModelCreator;
import org.freeplane.plugin.ai.tools.edit.NodeStyleContentEditor;

public class NodeCreationHierarchyBuilder {
    private final NodeModelCreator nodeModelCreator;
    private final NodeContentApplier nodeContentApplier;
    private final NodeStyleContentEditor nodeStyleContentEditor;

    public NodeCreationHierarchyBuilder(NodeModelCreator nodeModelCreator, NodeContentApplier nodeContentApplier, NodeStyleContentEditor nodeStyleContentEditor) {
        this.nodeModelCreator = Objects.requireNonNull(nodeModelCreator, "nodeModelCreator");
        this.nodeContentApplier = Objects.requireNonNull(nodeContentApplier, "nodeContentApplier");
        this.nodeStyleContentEditor = Objects.requireNonNull(nodeStyleContentEditor, "nodeStyleContentEditor");
    }

    public NodeCreationHierarchy buildHierarchy(List<NodeCreationItem> items, MapModel mapModel) {
        Integer parentIndex;
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("Nodes list must be non-empty.");
        }
        if (mapModel == null) {
            throw new IllegalArgumentException("Missing map model.");
        }
        HashMap<Integer, NodeModel> nodesByIndex = new HashMap<Integer, NodeModel>();
        HashSet<Integer> indices = new HashSet<Integer>();
        HashSet<Integer> parentIndices = new HashSet<Integer>();
        ArrayList<NodeModel> createdNodes = new ArrayList<NodeModel>(items.size());
        for (NodeCreationItem item : items) {
            if (item == null) {
                throw new IllegalArgumentException("Node item must be non-null.");
            }
            Integer index = item.getIndex();
            if (index == null) {
                throw new IllegalArgumentException("Missing index.");
            }
            if (index < 0) {
                throw new IllegalArgumentException("Invalid index: " + index);
            }
            if (!indices.add(index)) {
                throw new IllegalArgumentException("Duplicate index: " + index);
            }
            NodeModel nodeModel = this.nodeModelCreator.createNodeModel(mapModel);
            nodesByIndex.put(index, nodeModel);
            createdNodes.add(nodeModel);
            this.nodeContentApplier.apply(nodeModel, item.getContent());
            this.nodeStyleContentEditor.setInitialMainStyle(nodeModel, item.getMainStyle());
            parentIndex = item.getParentIndex();
            if (parentIndex == null || parentIndex < 0) continue;
            parentIndices.add(parentIndex);
        }
        ArrayList<NodeModel> rootNodes = new ArrayList<NodeModel>();
        HashMap<NodeModel, NodeFoldingState> foldingStates = new HashMap<NodeModel, NodeFoldingState>();
        for (NodeCreationItem item : items) {
            parentIndex = item.getParentIndex();
            NodeModel nodeModel = (NodeModel)nodesByIndex.get(item.getIndex());
            if (parentIndex == null || parentIndex == -1) {
                rootNodes.add(nodeModel);
            } else {
                if (parentIndex < 0) {
                    throw new IllegalArgumentException("Invalid parentIndex: " + parentIndex);
                }
                if (parentIndex.equals(item.getIndex())) {
                    throw new IllegalArgumentException("parentIndex must differ from index: " + parentIndex);
                }
                NodeModel parentNode = (NodeModel)nodesByIndex.get(parentIndex);
                if (parentNode == null) {
                    throw new IllegalArgumentException("Unknown parentIndex: " + parentIndex);
                }
                parentNode.insert(nodeModel, parentNode.getChildCount());
            }
            if (!parentIndices.contains(item.getIndex())) continue;
            NodeFoldingState foldingState = item.getFoldingState();
            foldingStates.put(nodeModel, foldingState == null ? NodeFoldingState.UNFOLD : foldingState);
        }
        return new NodeCreationHierarchy(rootNodes, createdNodes, foldingStates);
    }
}

