/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineRowType;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.CommonUtils;

public class DB2RoutineParm
implements DBSProcedureParameter,
DBSTypedObject,
DBSTypedObjectEx {
    private static final String UNNAMED_PARAM_PREFIX = "parameter#";
    private final DB2Routine procedure;
    private String name;
    private String remarks;
    private Integer scale;
    private Integer length;
    private DB2RoutineRowType rowType;
    private DB2DataType dataType;
    private DB2Schema dataTypeSchema;
    private String typeName;

    public DB2RoutineParm(DBRProgressMonitor monitor, DB2Routine procedure, ResultSet dbResult) throws DBException {
        this.procedure = procedure;
        DB2DataSource db2DataSource = this.getDataSource();
        String parmName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PARMNAME");
        this.name = parmName == null ? UNNAMED_PARAM_PREFIX + JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL") : parmName;
        this.scale = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SCALE");
        this.length = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"LENGTH");
        this.remarks = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"REMARKS");
        this.rowType = (DB2RoutineRowType)CommonUtils.valueOf(DB2RoutineRowType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROWTYPE"));
        String typeSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPESCHEMA");
        String typeModuleName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPEMODULENAME");
        this.typeName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPENAME");
        this.dataTypeSchema = db2DataSource.getSchema(monitor, typeSchemaName);
        this.dataType = db2DataSource.getLocalDataType(this.typeName);
        if (this.dataType != null) {
            return;
        }
        if (typeModuleName != null) {
            DB2Module db2Module = DB2Utils.findModuleBySchemaNameAndName(monitor, db2DataSource, typeSchemaName, typeModuleName);
            this.dataType = db2Module.getType(monitor, this.typeName);
            return;
        }
        this.dataType = this.dataTypeSchema.getUDT(monitor, this.typeName);
    }

    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return this.procedure.getDataSource();
    }

    public DB2Routine getParentObject() {
        return this.procedure;
    }

    public boolean isPersisted() {
        return true;
    }

    public Integer getPrecision() {
        return 0;
    }

    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return this.dataType.getEquivalentSqlType();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public DB2Schema getDataTypeSchema() {
        return this.dataTypeSchema;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public DB2DataType getDataType() {
        return this.dataType;
    }

    @Property(viewable=true, order=4)
    @NotNull
    public DBSProcedureParameterKind getParameterKind() {
        return this.rowType.getParameterKind();
    }

    @Property(viewable=true, order=5)
    public long getMaxLength() {
        return this.length.intValue();
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Property(viewable=true, order=6)
    public Integer getScale() {
        return this.scale;
    }

    public DB2RoutineRowType getRowType() {
        return this.rowType;
    }

    @NotNull
    public DBSTypedObject getParameterType() {
        return this;
    }
}

