/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.util.Date;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.sdef.SDEFField;
import net.sf.mpxj.sdef.SDEFRecord;

abstract class AbstractSDEFRecord
implements SDEFRecord {
    private final Object[] m_fields = new Object[this.getFieldDefinitions().length];

    AbstractSDEFRecord() {
    }

    @Override
    public void read(String line) {
        int index = 0;
        int offset = 5;
        for (SDEFField field : this.getFieldDefinitions()) {
            this.m_fields[index++] = field.read(line, offset);
            offset += field.getLength() + 1;
        }
    }

    protected abstract SDEFField[] getFieldDefinitions();

    protected String getString(int index) {
        return (String)this.m_fields[index];
    }

    protected Integer getInteger(int index) {
        return (Integer)this.m_fields[index];
    }

    protected Double getDouble(int index) {
        return (Double)this.m_fields[index];
    }

    protected Date getDate(int index) {
        return (Date)this.m_fields[index];
    }

    protected Duration getDuration(int index) {
        return (Duration)this.m_fields[index];
    }

    protected ConstraintType getConstraintType(int index) {
        return (ConstraintType)this.m_fields[index];
    }

    protected RelationType getRelationType(int index) {
        return (RelationType)this.m_fields[index];
    }
}

