﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegionalRequest.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WAFRegional {
namespace Model {

/**
 */
class DeleteIPSetRequest : public WAFRegionalRequest {
 public:
  AWS_WAFREGIONAL_API DeleteIPSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteIPSet"; }

  AWS_WAFREGIONAL_API Aws::String SerializePayload() const override;

  AWS_WAFREGIONAL_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to delete.
   * <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
   * <a>ListIPSets</a>.</p>
   */
  inline const Aws::String& GetIPSetId() const { return m_iPSetId; }
  inline bool IPSetIdHasBeenSet() const { return m_iPSetIdHasBeenSet; }
  template <typename IPSetIdT = Aws::String>
  void SetIPSetId(IPSetIdT&& value) {
    m_iPSetIdHasBeenSet = true;
    m_iPSetId = std::forward<IPSetIdT>(value);
  }
  template <typename IPSetIdT = Aws::String>
  DeleteIPSetRequest& WithIPSetId(IPSetIdT&& value) {
    SetIPSetId(std::forward<IPSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
   */
  inline const Aws::String& GetChangeToken() const { return m_changeToken; }
  inline bool ChangeTokenHasBeenSet() const { return m_changeTokenHasBeenSet; }
  template <typename ChangeTokenT = Aws::String>
  void SetChangeToken(ChangeTokenT&& value) {
    m_changeTokenHasBeenSet = true;
    m_changeToken = std::forward<ChangeTokenT>(value);
  }
  template <typename ChangeTokenT = Aws::String>
  DeleteIPSetRequest& WithChangeToken(ChangeTokenT&& value) {
    SetChangeToken(std::forward<ChangeTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_iPSetId;

  Aws::String m_changeToken;
  bool m_iPSetIdHasBeenSet = false;
  bool m_changeTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
