/**
 * @import {ElementContent} from 'hast'
 * @import {Reference, Nodes} from 'mdast'
 * @import {State} from './state.js'
 */
/**
 * Return the content of a reference without definition as plain text.
 *
 * @param {State} state
 *   Info passed around.
 * @param {Extract<Nodes, Reference>} node
 *   Reference node (image, link).
 * @returns {Array<ElementContent>}
 *   hast content.
 */
export function revert(state: State, node: Extract<Nodes, Reference>): Array<ElementContent>;
import type { State } from './state.js';
import type { Nodes } from 'mdast';
import type { Reference } from 'mdast';
import type { ElementContent } from 'hast';
//# sourceMappingURL=revert.d.ts.map