/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.ResourceBundleTools;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.chunking.Chunker;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.GRPCPostProcessing;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TestRemoteRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.rules.patterns.UnifierConfiguration;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SimpleSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Language {
    private static final Logger logger = LoggerFactory.getLogger(Language.class);
    private static final Disambiguator DEMO_DISAMBIGUATOR = new DemoDisambiguator();
    private static final Tagger DEMO_TAGGER = new DemoTagger();
    private static final SentenceTokenizer SENTENCE_TOKENIZER = new SimpleSentenceTokenizer();
    private static final WordTokenizer WORD_TOKENIZER = new WordTokenizer();
    private static final Pattern INSIDE_SUGGESTION = Pattern.compile("<suggestion>(.+?)</suggestion>");
    private static final Pattern APOSTROPHE = Pattern.compile("([\\p{L}\\d-])'([\\p{L}\u00ab])", 66);
    private static final String SUGGESTION_OPEN_TAG = "<suggestion>";
    private static final String SUGGESTION_CLOSE_TAG = "</suggestion>";
    private static final Pattern NBSPACE1 = Pattern.compile("\\b([a-zA-Z]\\.) ([a-zA-Z]\\.)");
    private static final Pattern NBSPACE2 = Pattern.compile("\\b([a-zA-Z]\\.) ");
    private static final Map<Class<Language>, JLanguageTool> languagetoolInstances = new ConcurrentHashMap<Class<Language>, JLanguageTool>();
    private static final Pattern QUOTED_CHAR_PATTERN = Pattern.compile(" '(.)'");
    private static final Pattern TYPOGRAPHY_PATTERN_1 = Pattern.compile("([\\u202f\\u00a0 \u00ab\"\\(])'");
    private static final Pattern TYPOGRAPHY_PATTERN_2 = Pattern.compile("'([\u202f\u00a0 !\\?,\\.;:\"\\)])");
    private static final Pattern TYPOGRAPHY_PATTERN_3 = Pattern.compile("\u2018s\\b([^\u2019])");
    private static final Pattern TYPOGRAPHY_PATTERN_4 = Pattern.compile("([ \\(])\"");
    private static final Pattern TYPOGRAPHY_PATTERN_5 = Pattern.compile("\"([\\u202f\\u00a0 !\\?,\\.;:\\)])");
    private final Object patternRuleLock = new Object();
    private final Object disambiguatorLock = new Object();
    private final Object sentenceTokenizerLock = new Object();
    private final Object wordTokenizerLock = new Object();
    private final UnifierConfiguration unifierConfig = new UnifierConfiguration();
    private final UnifierConfiguration disambiguationUnifierConfig = new UnifierConfiguration();
    private final Pattern ignoredCharactersRegex = Pattern.compile("[\u00ad]");
    private volatile List<AbstractPatternRule> patternRules;
    private volatile Disambiguator disambiguator;
    private Tagger tagger;
    private volatile SentenceTokenizer sentenceTokenizer;
    private volatile Tokenizer wordTokenizer;
    private Chunker chunker;
    private Chunker postDisambiguationChunker;
    private Synthesizer synthesizer;
    private String shortCodeWithCountryAndVariant;
    private static final Map<Class<? extends Language>, SpellingCheckRule> spellingRules = new ConcurrentHashMap<Class<? extends Language>, SpellingCheckRule>();

    protected Language() {
    }

    public abstract String getShortCode();

    public abstract String getName();

    public abstract String[] getCountries();

    @Nullable
    public abstract Contributor[] getMaintainers();

    public abstract List<Rule> getRelevantRules(ResourceBundle var1, UserConfig var2, Language var3, List<Language> var4) throws IOException;

    public String getCommonWordsPath() {
        return this.getShortCode() + "/common_words.txt";
    }

    @Nullable
    public String getVariant() {
        return null;
    }

    public List<String> getDefaultEnabledRulesForVariant() {
        return Collections.emptyList();
    }

    public List<String> getDefaultDisabledRulesForVariant() {
        return Collections.emptyList();
    }

    @Nullable
    public LanguageModel getLanguageModel(File indexDir) throws IOException {
        return null;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Collections.emptyList();
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel languageModel, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Collections.emptyList();
    }

    public List<Rule> getRelevantRemoteRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages, boolean inputLogging) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        GRPCPostProcessing.configure(this, configs);
        rules.addAll(GRPCRule.createAll(this, configs, inputLogging));
        configs.stream().filter(config -> config.getRuleId().startsWith("TEST")).map(c -> new TestRemoteRule(this, (RemoteRuleConfig)c)).forEach(rules::add);
        return rules;
    }

    @Experimental
    public Function<Rule, Rule> getRemoteEnhancedRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, UserConfig userConfig, Language motherTongue, List<Language> altLanguages, boolean inputLogging) throws IOException {
        return Function.identity();
    }

    public List<Rule> getRelevantRulesGlobalConfig(ResourceBundle messages, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Collections.emptyList();
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return null;
    }

    @Nullable
    public SpellingCheckRule getDefaultSpellingRule() {
        return spellingRules.computeIfAbsent(this.getClass(), c -> {
            try {
                return this.createDefaultSpellingRule(ResourceBundleTools.getMessageBundle(this));
            }
            catch (IOException e) {
                logger.warn("Failed to create default spelling rule", (Throwable)e);
                return null;
            }
        });
    }

    @Deprecated
    public SpellingCheckRule getDefaultSpellingRule(ResourceBundle messages) {
        return this.getDefaultSpellingRule();
    }

    public Locale getLocale() {
        return new Locale(this.getShortCode());
    }

    public Locale getLocaleWithCountryAndVariant() {
        if (this.getCountries().length > 0) {
            if (this.getVariant() != null) {
                return new Locale(this.getShortCode(), this.getCountries()[0], this.getVariant());
            }
            return new Locale(this.getShortCode(), this.getCountries()[0]);
        }
        return this.getLocale();
    }

    public List<String> getRuleFileNames() {
        String customFile;
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        ruleFiles.add(dataBroker.getRulesDir() + "/" + this.getShortCode() + "/grammar.xml");
        if (dataBroker.ruleFileExists(this.getShortCode() + "/style.xml")) {
            customFile = dataBroker.getRulesDir() + "/" + this.getShortCode() + "/style.xml";
            ruleFiles.add(customFile);
        }
        if (dataBroker.ruleFileExists(this.getShortCode() + "/grammar_custom.xml")) {
            customFile = dataBroker.getRulesDir() + "/" + this.getShortCode() + "/grammar_custom.xml";
            ruleFiles.add(customFile);
        }
        if (this.getShortCodeWithCountryAndVariant().length() > 2) {
            String premiumFileName;
            String styleFileName;
            String fileName = this.getShortCode() + "/" + this.getShortCodeWithCountryAndVariant() + "/grammar.xml";
            if (dataBroker.ruleFileExists(fileName)) {
                ruleFiles.add(dataBroker.getRulesDir() + "/" + fileName);
            }
            if (dataBroker.ruleFileExists(styleFileName = this.getShortCode() + "/" + this.getShortCodeWithCountryAndVariant() + "/style.xml")) {
                ruleFiles.add(dataBroker.getRulesDir() + "/" + styleFileName);
            }
            if (dataBroker.ruleFileExists(premiumFileName = this.getShortCode() + "/" + this.getShortCodeWithCountryAndVariant() + "/grammar-premium.xml")) {
                ruleFiles.add(dataBroker.getRulesDir() + "/" + premiumFileName);
            }
        }
        return ruleFiles;
    }

    @NotNull
    public Language getDefaultLanguageVariant() {
        return this;
    }

    public Disambiguator createDefaultDisambiguator() {
        return DEMO_DISAMBIGUATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            Object object = this.disambiguatorLock;
            synchronized (object) {
                if (this.disambiguator == null) {
                    this.disambiguator = this.createDefaultDisambiguator();
                }
            }
        }
        return this.disambiguator;
    }

    public void setDisambiguator(Disambiguator disambiguator) {
        this.disambiguator = disambiguator;
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return DEMO_TAGGER;
    }

    @NotNull
    public synchronized Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = this.createDefaultTagger();
        }
        return this.tagger;
    }

    public void setTagger(Tagger tagger) {
        this.tagger = tagger;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return SENTENCE_TOKENIZER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            Object object = this.sentenceTokenizerLock;
            synchronized (object) {
                if (this.sentenceTokenizer == null) {
                    this.sentenceTokenizer = this.createDefaultSentenceTokenizer();
                }
            }
        }
        return this.sentenceTokenizer;
    }

    public void setSentenceTokenizer(SentenceTokenizer tokenizer) {
        this.sentenceTokenizer = tokenizer;
    }

    public Tokenizer createDefaultWordTokenizer() {
        return WORD_TOKENIZER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            Object object = this.wordTokenizerLock;
            synchronized (object) {
                if (this.wordTokenizer == null) {
                    this.wordTokenizer = this.createDefaultWordTokenizer();
                }
            }
        }
        return this.wordTokenizer;
    }

    public void setWordTokenizer(Tokenizer tokenizer) {
        this.wordTokenizer = tokenizer;
    }

    @Nullable
    public Chunker createDefaultChunker() {
        return null;
    }

    @Nullable
    public synchronized Chunker getChunker() {
        if (this.chunker == null) {
            this.chunker = this.createDefaultChunker();
        }
        return this.chunker;
    }

    public void setChunker(Chunker chunker) {
        this.chunker = chunker;
    }

    @Nullable
    public Chunker createDefaultPostDisambiguationChunker() {
        return null;
    }

    @Nullable
    public synchronized Chunker getPostDisambiguationChunker() {
        if (this.postDisambiguationChunker == null) {
            this.postDisambiguationChunker = this.createDefaultPostDisambiguationChunker();
        }
        return this.postDisambiguationChunker;
    }

    public void setPostDisambiguationChunker(Chunker chunker) {
        this.postDisambiguationChunker = chunker;
    }

    public JLanguageTool createDefaultJLanguageTool() {
        Language self = this;
        Class<?> clazz = this.getClass();
        return languagetoolInstances.computeIfAbsent(clazz, _class -> new JLanguageTool(self));
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return null;
    }

    @Nullable
    public synchronized Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = this.createDefaultSynthesizer();
        }
        return this.synthesizer;
    }

    public void setSynthesizer(Synthesizer synthesizer) {
        this.synthesizer = synthesizer;
    }

    public Unifier getUnifier() {
        return this.unifierConfig.createUnifier();
    }

    public Unifier getDisambiguationUnifier() {
        return this.disambiguationUnifierConfig.createUnifier();
    }

    public UnifierConfiguration getUnifierConfiguration() {
        return this.unifierConfig;
    }

    public UnifierConfiguration getDisambiguationUnifierConfiguration() {
        return this.disambiguationUnifierConfig;
    }

    public final String getTranslatedName(ResourceBundle messages) {
        try {
            return messages.getString(this.getShortCodeWithCountryAndVariant());
        }
        catch (MissingResourceException e) {
            try {
                return messages.getString(this.getShortCode());
            }
            catch (MissingResourceException e1) {
                return this.getName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getShortCodeWithCountryAndVariant() {
        if (this.shortCodeWithCountryAndVariant == null) {
            Language language = this;
            synchronized (language) {
                if (this.shortCodeWithCountryAndVariant == null) {
                    this.shortCodeWithCountryAndVariant = this.buildShortCodeWithCountryAndVariant();
                }
            }
        }
        return this.shortCodeWithCountryAndVariant;
    }

    private String buildShortCodeWithCountryAndVariant() {
        Object name = this.getShortCode();
        if (this.getCountries().length == 1 && !((String)name).contains("-x-")) {
            name = (String)name + "-" + this.getCountries()[0];
            if (this.getVariant() != null) {
                name = (String)name + "-" + this.getVariant();
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbstractPatternRule> getPatternRules() throws IOException {
        if (this.patternRules == null) {
            Object object = this.patternRuleLock;
            synchronized (object) {
                if (this.patternRules == null) {
                    this.patternRules = this.initializePatternRules();
                }
            }
        }
        return this.patternRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractPatternRule> initializePatternRules() throws IOException {
        ArrayList<AbstractPatternRule> rules = new ArrayList<AbstractPatternRule>();
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        for (String fileName : this.getRuleFileNames()) {
            InputStream is = null;
            try {
                is = JLanguageTool.getDataBroker().getAsStream(fileName);
                boolean ignore = false;
                if (is == null) {
                    try {
                        is = new FileInputStream(fileName);
                    }
                    catch (FileNotFoundException e) {
                        if (fileName.contains("-test-")) {
                            ignore = true;
                        }
                        throw e;
                    }
                }
                if (ignore) continue;
                rules.addAll(ruleLoader.getRules(is, fileName, this));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return Collections.unmodifiableList(rules);
    }

    public final String toString() {
        return this.getName();
    }

    public boolean isVariant() {
        for (Language language : Languages.get()) {
            boolean skip = language.getShortCodeWithCountryAndVariant().equals(this.getShortCodeWithCountryAndVariant());
            if (skip || !language.getClass().isAssignableFrom(this.getClass())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVariant() {
        for (Language language : Languages.get()) {
            boolean skip = language.getShortCodeWithCountryAndVariant().equals(this.getShortCodeWithCountryAndVariant());
            if (skip || !this.getClass().isAssignableFrom(language.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean equalsConsiderVariantsIfSpecified(Language otherLanguage) {
        if (this.getShortCode().equals(otherLanguage.getShortCode())) {
            boolean thisHasCountry = this.hasCountry();
            boolean otherHasCountry = otherLanguage.hasCountry();
            return !thisHasCountry || !otherHasCountry || this.getShortCodeWithCountryAndVariant().equals(otherLanguage.getShortCodeWithCountryAndVariant());
        }
        return false;
    }

    private boolean hasCountry() {
        return this.getCountries().length == 1;
    }

    public Pattern getIgnoredCharactersRegex() {
        return this.ignoredCharactersRegex;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.LookingForNewMaintainer;
    }

    public boolean isHiddenFromGui() {
        return this.hasVariant() && !this.isVariant() && !this.isTheDefaultVariant();
    }

    private boolean isTheDefaultVariant() {
        if (this.getDefaultLanguageVariant() != null) {
            return this.getClass().equals(this.getDefaultLanguageVariant().getClass());
        }
        return false;
    }

    protected int getPriorityForId(String id) {
        if (id.equalsIgnoreCase("TOO_LONG_SENTENCE")) {
            return -101;
        }
        if (id.equals("REPETITIONS_STYLE")) {
            return -55;
        }
        if (id.contains("STYLE")) {
            return -50;
        }
        return 0;
    }

    public int getRulePriority(Rule rule) {
        int categoryPriority = this.getPriorityForId(rule.getCategory().getId().toString());
        int rulePriority = this.getPriorityForId(rule.getId());
        int rulePriorityFromRule = rule.getPriority();
        if (rulePriority != 0) {
            return rulePriority;
        }
        if (rulePriorityFromRule != 0) {
            return rulePriorityFromRule;
        }
        if (categoryPriority != 0) {
            return categoryPriority;
        }
        if (this.getDefaultRulePriorityForStyle() != 0 && rule.getLocQualityIssueType().equals((Object)ITSIssueType.Style)) {
            return this.getDefaultRulePriorityForStyle();
        }
        return 0;
    }

    protected int getDefaultRulePriorityForStyle() {
        return 0;
    }

    public boolean isSpellcheckOnlyLanguage() {
        return false;
    }

    public boolean hasNGramFalseFriendRule(Language motherTongue) {
        return false;
    }

    public String getOpeningDoubleQuote() {
        return "\"";
    }

    public String getClosingDoubleQuote() {
        return "\"";
    }

    public String getOpeningSingleQuote() {
        return "'";
    }

    public String getClosingSingleQuote() {
        return "'";
    }

    public boolean isAdvancedTypographyEnabled() {
        return false;
    }

    public String toAdvancedTypography(String input) {
        if (!this.isAdvancedTypographyEnabled()) {
            return input.replace(SUGGESTION_OPEN_TAG, this.getOpeningDoubleQuote()).replace(SUGGESTION_CLOSE_TAG, this.getClosingDoubleQuote());
        }
        Object output = input;
        ArrayList<String> preservedStrings = new ArrayList<String>();
        int countPreserved = 0;
        Matcher m = INSIDE_SUGGESTION.matcher((CharSequence)output);
        int offset = 0;
        while (m.find(offset)) {
            String group = m.group(1);
            preservedStrings.add(group);
            output = StringUtils.replaceOnce((String)output, (String)(SUGGESTION_OPEN_TAG + group + SUGGESTION_CLOSE_TAG), (String)("\\" + countPreserved));
            ++countPreserved;
            offset = m.end();
        }
        output = ((String)output).replace("...", "\u2026");
        output = NBSPACE1.matcher((CharSequence)output).replaceAll("$1\u00a0$2");
        output = NBSPACE2.matcher((CharSequence)output).replaceAll("$1\u00a0");
        Matcher matcher = APOSTROPHE.matcher((CharSequence)output);
        if (((String)(output = matcher.replaceAll("$1\u2019$2"))).startsWith("'")) {
            output = this.getOpeningSingleQuote() + ((String)output).substring(1);
        }
        if (((String)output).endsWith("'")) {
            output = ((String)output).substring(0, ((String)output).length() - 1) + this.getClosingSingleQuote();
        }
        output = QUOTED_CHAR_PATTERN.matcher((CharSequence)output).replaceAll(" " + this.getOpeningSingleQuote() + "$1" + this.getClosingSingleQuote());
        output = TYPOGRAPHY_PATTERN_1.matcher((CharSequence)output).replaceAll("$1" + this.getOpeningSingleQuote());
        output = TYPOGRAPHY_PATTERN_2.matcher((CharSequence)output).replaceAll(this.getClosingSingleQuote() + "$1");
        if (((String)(output = TYPOGRAPHY_PATTERN_3.matcher((CharSequence)output).replaceAll("\u2019s$1"))).startsWith("\"")) {
            output = this.getOpeningDoubleQuote() + ((String)output).substring(1);
        }
        if (((String)output).endsWith("\"")) {
            output = ((String)output).substring(0, ((String)output).length() - 1) + this.getClosingDoubleQuote();
        }
        output = TYPOGRAPHY_PATTERN_4.matcher((CharSequence)output).replaceAll("$1" + this.getOpeningDoubleQuote());
        output = TYPOGRAPHY_PATTERN_5.matcher((CharSequence)output).replaceAll(this.getClosingDoubleQuote() + "$1");
        for (int i = 0; i < preservedStrings.size(); ++i) {
            output = StringUtils.replaceOnce((String)output, (String)("\\" + i), (String)(this.getOpeningDoubleQuote() + (String)preservedStrings.get(i) + this.getClosingDoubleQuote()));
        }
        return ((String)output).replace(SUGGESTION_OPEN_TAG, this.getOpeningDoubleQuote()).replace(SUGGESTION_CLOSE_TAG, this.getClosingDoubleQuote());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language other = (Language)o;
        return Objects.equals(this.getShortCodeWithCountryAndVariant(), other.getShortCodeWithCountryAndVariant());
    }

    public int hashCode() {
        return this.getShortCodeWithCountryAndVariant().hashCode();
    }

    public boolean hasMinMatchesRules() {
        return false;
    }

    public String adaptSuggestion(String s, String originalErrorStr) {
        return s;
    }

    public String getConsistencyRulePrefix() {
        return "PREFIXFORCONSISTENCYRULES_";
    }

    public RuleMatch adjustMatch(RuleMatch rm, List<String> features) {
        return rm;
    }

    public List<String> prepareLineForSpeller(String s) {
        return Collections.singletonList(s);
    }

    public List<RuleMatch> filterRuleMatches(List<RuleMatch> ruleMatches, AnnotatedText text, Set<String> enabledRules) {
        return ruleMatches;
    }

    public MultitokenSpeller getMultitokenSpeller() {
        return null;
    }

    public Map<String, Integer> getPriorityMap() {
        return new HashMap<String, Integer>();
    }
}

