/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.common.protocol.types.Type;

public class Protocol {
    private static String indentString(int size) {
        return " ".repeat(Math.max(0, size));
    }

    private static void schemaToBnfHtml(Schema schema, StringBuilder b, int indentSize) {
        String indentStr = Protocol.indentString(indentSize);
        LinkedHashMap<String, Type> subTypes = new LinkedHashMap<String, Type>();
        for (BoundField field : schema.fields()) {
            Type type = field.def.type;
            if (type.isArray()) {
                b.append("[");
                b.append(field.def.name);
                b.append("] ");
                if (subTypes.containsKey(field.def.name)) continue;
                subTypes.put(field.def.name, type.arrayElementType().get());
                continue;
            }
            if (type instanceof TaggedFields) {
                TreeMap<Integer, Field> taggedFields = new TreeMap<Integer, Field>(((TaggedFields)type).fields());
                taggedFields.forEach((tag, taggedField) -> {
                    if (taggedField.type.isArray()) {
                        b.append("[");
                        b.append(taggedField.name);
                        b.append("]");
                        if (!subTypes.containsKey(taggedField.name)) {
                            subTypes.put(taggedField.name + "&lt;tag: " + tag.toString() + "&gt;", taggedField.type.arrayElementType().get());
                        }
                    } else {
                        b.append(taggedField.name);
                        if (!subTypes.containsKey(taggedField.name)) {
                            subTypes.put(taggedField.name + "&lt;tag: " + tag.toString() + "&gt;", taggedField.type);
                        }
                    }
                    b.append("&lt;tag: ");
                    b.append(tag);
                    b.append("&gt; ");
                });
                continue;
            }
            b.append(field.def.name);
            b.append(" ");
            if (subTypes.containsKey(field.def.name)) continue;
            subTypes.put(field.def.name, type);
        }
        b.append("\n");
        for (Map.Entry entry : subTypes.entrySet()) {
            if (entry.getValue() instanceof Schema) {
                b.append(indentStr);
                b.append((String)entry.getKey());
                b.append(" => ");
                Protocol.schemaToBnfHtml((Schema)entry.getValue(), b, indentSize + 2);
                continue;
            }
            b.append(indentStr);
            b.append((String)entry.getKey());
            b.append(" => ");
            b.append(entry.getValue());
            b.append("\n");
        }
    }

    private static void populateSchemaFields(Schema schema, Set<BoundField> fields) {
        for (BoundField field : schema.fields()) {
            fields.add(field);
            if (field.def.type.isArray()) {
                Type innerType = field.def.type.arrayElementType().get();
                if (!(innerType instanceof Schema)) continue;
                Protocol.populateSchemaFields((Schema)innerType, fields);
                continue;
            }
            if (!(field.def.type instanceof Schema)) continue;
            Protocol.populateSchemaFields((Schema)field.def.type, fields);
        }
    }

    private static void appendFieldNameToTable(String name, StringBuilder b) {
        b.append("<td>");
        b.append(name);
        b.append("</td>");
    }

    private static void schemaToFieldTableHtml(Schema schema, StringBuilder b) {
        LinkedHashSet<BoundField> fields = new LinkedHashSet<BoundField>();
        Protocol.populateSchemaFields(schema, fields);
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Field</th>\n");
        b.append("<th>Description</th>\n");
        b.append("</tr>");
        for (BoundField field : fields) {
            b.append("<tr>\n");
            if (field.def.type instanceof TaggedFields) {
                TaggedFields taggedFields = (TaggedFields)field.def.type;
                if (taggedFields.numFields() > 0) {
                    taggedFields.fields().forEach((tag, taggedField) -> {
                        Protocol.appendFieldNameToTable(taggedField.name + "&lt;tag: " + tag.toString() + "&gt;", b);
                        b.append("<td>");
                        b.append(taggedField.docString);
                        if (taggedField.type.isArray()) {
                            Type innerType = taggedField.type.arrayElementType().get();
                            if (innerType instanceof Schema) {
                                Protocol.schemaToFieldTableHtml((Schema)innerType, b);
                            }
                        } else if (taggedField.type instanceof Schema) {
                            Protocol.schemaToFieldTableHtml((Schema)taggedField.type, b);
                        }
                        b.append("</td>");
                        b.append("</tr>\n");
                    });
                }
            } else {
                Protocol.appendFieldNameToTable(field.def.name, b);
                b.append("<td>");
                b.append(field.def.docString);
            }
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</tbody></table>\n");
    }

    public static String toHtml() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("<h5>Headers:</h5>\n");
        for (i = 1; i <= 2; ++i) {
            b.append("<pre>");
            b.append("Request Header v").append(i).append(" => ");
            Protocol.schemaToBnfHtml(RequestHeaderData.SCHEMAS[i], b, 2);
            b.append("</pre>\n");
            Protocol.schemaToFieldTableHtml(RequestHeaderData.SCHEMAS[i], b);
        }
        for (i = 0; i <= 1; ++i) {
            b.append("<pre>");
            b.append("Response Header v").append(i).append(" => ");
            Protocol.schemaToBnfHtml(ResponseHeaderData.SCHEMAS[i], b, 2);
            b.append("</pre>\n");
            Protocol.schemaToFieldTableHtml(ResponseHeaderData.SCHEMAS[i], b);
        }
        for (ApiKeys key : ApiKeys.clientApis()) {
            b.append("<h5>");
            b.append("<a name=\"The_Messages_" + key.name + "\">");
            b.append(key.name);
            b.append(" API (Key: ");
            b.append(key.id);
            b.append("):</a></h5>\n\n");
            b.append("<b>Requests:</b><br>\n");
            Schema[] requests = key.messageType.requestSchemas();
            for (short version = key.oldestVersion(); version <= key.latestVersion(); version = (short)(version + 1)) {
                Schema schema = requests[version];
                if (schema == null) {
                    throw new IllegalStateException("Unexpected null schema for " + String.valueOf((Object)key) + " with version " + version);
                }
                b.append("<div>");
                b.append("<pre>");
                b.append(key.name);
                b.append(" Request (Version: ");
                b.append(version);
                b.append(") => ");
                Protocol.schemaToBnfHtml(schema, b, 2);
                b.append("</pre>");
                if (!key.isVersionEnabled(version, false)) {
                    b.append("<p>This version of the request is unstable.</p>");
                }
                b.append("<p><b>Request header version:</b> ");
                b.append(key.requestHeaderVersion(version));
                b.append("</p>\n");
                Protocol.schemaToFieldTableHtml(schema, b);
                b.append("</div>\n");
            }
            b.append("<b>Responses:</b><br>\n");
            Schema[] responses = key.messageType.responseSchemas();
            for (int version = key.oldestVersion(); version <= key.latestVersion(); ++version) {
                Schema schema = responses[version];
                if (schema == null) {
                    throw new IllegalStateException("Unexpected null schema for " + String.valueOf((Object)key) + " with version " + version);
                }
                b.append("<div>");
                b.append("<pre>");
                b.append(key.name);
                b.append(" Response (Version: ");
                b.append(version);
                b.append(") => ");
                Protocol.schemaToBnfHtml(responses[version], b, 2);
                b.append("</pre>");
                b.append("<p><b>Response header version:</b> ");
                b.append(key.responseHeaderVersion((short)version));
                b.append("</p>\n");
                Protocol.schemaToFieldTableHtml(responses[version], b);
                b.append("</div>\n");
            }
        }
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(Protocol.toHtml());
    }
}

