/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleTypeTransformer;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001GBA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001aJ\u000e\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020#J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001eJ\u0016\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020#J\u000e\u00107\u001a\u00020#2\u0006\u00105\u001a\u00020%J\u001e\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\"2\u0006\u00106\u001a\u00020#J\u0016\u0010;\u001a\u00020#2\u0006\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\"J\u0018\u0010C\u001a\u00020*2\b\u0010D\u001a\u0004\u0018\u00010=2\u0006\u0010E\u001a\u00020\rJ\u0006\u0010F\u001a\u00020*R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u0019j\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u001f\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 \u0012\u0004\u0012\u00020#0\u0019j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 \u0012\u0004\u0012\u00020#`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010$\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#0\u0019j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00101\u001a\u00020.*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0013\u0010<\u001a\u0004\u0018\u00010=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0013\u0010@\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmModuleTypeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;", "functionFileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "skipCommentInstructions", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;Lorg/jetbrains/kotlin/ir/IrFileEntry;Z)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "bodyGen", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBodyGen", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "wasmLocals", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "Lkotlin/collections/LinkedHashMap;", "wasmSyntheticLocals", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/SyntheticLocalType;", "loopLevels", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LoopLabelType;", "", "nonLocalReturnLevels", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "inlineContextStack", "Ljava/util/LinkedList;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext$InlineContext;", "defineLocal", "", "irValueDeclaration", "defineTmpVariable", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "referenceLocal", "index", "wasmType", "getWasmType", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/SyntheticLocalType;)Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "defineNonLocalReturnLevel", "block", "level", "referenceNonLocalReturnLevel", "defineLoopLevel", "irLoop", "labelType", "referenceLoopLevel", "currentFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getCurrentFunctionSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "currentFileEntry", "getCurrentFileEntry", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "stepIntoInlinedFunction", "inlineFunctionSymbol", "irFileEntry", "stepOutLastInlinedFunction", "InlineContext", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmFunctionCodegenContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmFunctionCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,123:1\n1#2:124\n382#3,7:125\n*S KotlinDebug\n*F\n+ 1 WasmFunctionCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext\n*L\n81#1:125,7\n*E\n"})
public final class WasmFunctionCodegenContext {
    @Nullable
    private final IrFunction irFunction;
    @NotNull
    private final WasmFunction.Defined wasmFunction;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final WasmModuleTypeTransformer wasmModuleTypeTransformer;
    @NotNull
    private final IrFileEntry functionFileEntry;
    @NotNull
    private final WasmExpressionBuilder bodyGen;
    @NotNull
    private final LinkedHashMap<IrValueSymbol, WasmLocal> wasmLocals;
    @NotNull
    private final LinkedHashMap<SyntheticLocalType, WasmLocal> wasmSyntheticLocals;
    @NotNull
    private final LinkedHashMap<Pair<IrLoop, LoopLabelType>, Integer> loopLevels;
    @NotNull
    private final LinkedHashMap<IrReturnableBlockSymbol, Integer> nonLocalReturnLevels;
    @NotNull
    private final LinkedList<InlineContext> inlineContextStack;

    public WasmFunctionCodegenContext(@Nullable IrFunction irFunction, @NotNull WasmFunction.Defined wasmFunction, @NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext, @NotNull WasmModuleTypeTransformer wasmModuleTypeTransformer, @NotNull IrFileEntry functionFileEntry, boolean skipCommentInstructions) {
        Intrinsics.checkNotNullParameter(wasmFunction, "wasmFunction");
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(wasmFileCodegenContext, "wasmFileCodegenContext");
        Intrinsics.checkNotNullParameter(wasmModuleTypeTransformer, "wasmModuleTypeTransformer");
        Intrinsics.checkNotNullParameter(functionFileEntry, "functionFileEntry");
        this.irFunction = irFunction;
        this.wasmFunction = wasmFunction;
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.wasmModuleTypeTransformer = wasmModuleTypeTransformer;
        this.functionFileEntry = functionFileEntry;
        this.bodyGen = new WasmExpressionBuilder(this.wasmFunction.getInstructions(), skipCommentInstructions);
        this.wasmLocals = new LinkedHashMap();
        this.wasmSyntheticLocals = new LinkedHashMap();
        this.loopLevels = new LinkedHashMap();
        this.nonLocalReturnLevels = new LinkedHashMap();
        this.inlineContextStack = new LinkedList();
    }

    @Nullable
    public final IrFunction getIrFunction() {
        return this.irFunction;
    }

    @NotNull
    public final WasmExpressionBuilder getBodyGen() {
        return this.bodyGen;
    }

    public final void defineLocal(@NotNull IrValueSymbol irValueDeclaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter(irValueDeclaration, "irValueDeclaration");
        boolean bl2 = bl = !((Map)this.wasmLocals).containsKey(irValueDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmFunctionCodegenContext$defineLocal$22 = false;
            String $i$a$-assert-WasmFunctionCodegenContext$defineLocal$22 = "Redefinition of local";
            throw new AssertionError((Object)$i$a$-assert-WasmFunctionCodegenContext$defineLocal$22);
        }
        IrValueDeclaration owner = irValueDeclaration.getOwner();
        int n2 = this.wasmFunction.getLocals().size();
        String string = owner.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        WasmLocal wasmLocal = new WasmLocal(n2, string, owner instanceof IrValueParameter ? this.wasmModuleTypeTransformer.transformValueParameterType((IrValueParameter)owner) : this.wasmModuleTypeTransformer.transformType(owner.getType()), irValueDeclaration instanceof IrValueParameterSymbol);
        ((Map)this.wasmLocals).put(irValueDeclaration, wasmLocal);
        ((Collection)this.wasmFunction.getLocals()).add(wasmLocal);
    }

    public final int defineTmpVariable(@NotNull WasmType type) {
        Intrinsics.checkNotNullParameter(type, "type");
        WasmLocal wasmLocal = new WasmLocal(this.wasmFunction.getLocals().size(), "tmp", type, false);
        ((Collection)this.wasmFunction.getLocals()).add(wasmLocal);
        return wasmLocal.getId();
    }

    @NotNull
    public final WasmLocal referenceLocal(@NotNull IrValueSymbol irValueDeclaration) {
        Intrinsics.checkNotNullParameter(irValueDeclaration, "irValueDeclaration");
        return (WasmLocal)MapsKt.getValue((Map)this.wasmLocals, irValueDeclaration);
    }

    @NotNull
    public final WasmLocal referenceLocal(int index) {
        return this.wasmFunction.getLocals().get(index);
    }

    private final WasmType getWasmType(SyntheticLocalType $this$wasmType) {
        WasmType wasmType;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$wasmType.ordinal()]) {
            case 1: {
                wasmType = new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceGcType(this.backendContext.getIrBuiltIns().getAnyClass())));
                break;
            }
            case 2: {
                wasmType = new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.getInterfaceTableTypes().getWasmAnyArrayType()));
                break;
            }
            case 3: {
                wasmType = WasmI32.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return wasmType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WasmLocal referenceLocal(@NotNull SyntheticLocalType type) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Map map = this.wasmSyntheticLocals;
        SyntheticLocalType key$iv = type;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
        if (value$iv == null) {
            WasmLocal wasmLocal;
            boolean bl = false;
            WasmLocal it = wasmLocal = new WasmLocal(this.wasmFunction.getLocals().size(), type.name(), this.getWasmType(type), false);
            boolean bl2 = false;
            ((Collection)this.wasmFunction.getLocals()).add(it);
            WasmLocal answer$iv = wasmLocal;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (WasmLocal)object;
    }

    public final void defineNonLocalReturnLevel(@NotNull IrReturnableBlockSymbol block, int level) {
        Intrinsics.checkNotNullParameter(block, "block");
        ((Map)this.nonLocalReturnLevels).put(block, level);
    }

    public final int referenceNonLocalReturnLevel(@NotNull IrReturnableBlockSymbol block) {
        Intrinsics.checkNotNullParameter(block, "block");
        return ((Number)MapsKt.getValue((Map)this.nonLocalReturnLevels, block)).intValue();
    }

    public final void defineLoopLevel(@NotNull IrLoop irLoop, @NotNull LoopLabelType labelType, int level) {
        boolean bl;
        Intrinsics.checkNotNullParameter(irLoop, "irLoop");
        Intrinsics.checkNotNullParameter((Object)labelType, "labelType");
        Pair<IrLoop, LoopLabelType> loopKey = new Pair<IrLoop, LoopLabelType>(irLoop, labelType);
        boolean bl2 = bl = !((Map)this.loopLevels).containsKey(loopKey);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Redefinition of loop";
            throw new AssertionError((Object)string);
        }
        ((Map)this.loopLevels).put(loopKey, level);
    }

    public final int referenceLoopLevel(@NotNull IrLoop irLoop, @NotNull LoopLabelType labelType) {
        Intrinsics.checkNotNullParameter(irLoop, "irLoop");
        Intrinsics.checkNotNullParameter((Object)labelType, "labelType");
        return ((Number)MapsKt.getValue((Map)this.loopLevels, new Pair<IrLoop, LoopLabelType>(irLoop, labelType))).intValue();
    }

    @Nullable
    public final IrFunctionSymbol getCurrentFunctionSymbol() {
        Object object = (InlineContext)CollectionsKt.firstOrNull((List)this.inlineContextStack);
        if (object == null || (object = ((InlineContext)object).getInlineFunctionSymbol()) == null) {
            IrFunction irFunction = this.irFunction;
            object = irFunction != null ? irFunction.getSymbol() : null;
        }
        return object;
    }

    @Nullable
    public final IrFileEntry getCurrentFileEntry() {
        Object object = (InlineContext)CollectionsKt.firstOrNull((List)this.inlineContextStack);
        if (object == null || (object = ((InlineContext)object).getIrFileEntry()) == null) {
            object = this.functionFileEntry;
        }
        return object;
    }

    public final void stepIntoInlinedFunction(@Nullable IrFunctionSymbol inlineFunctionSymbol, @NotNull IrFileEntry irFileEntry) {
        Intrinsics.checkNotNullParameter(irFileEntry, "irFileEntry");
        this.inlineContextStack.push(new InlineContext(inlineFunctionSymbol, irFileEntry));
    }

    public final void stepOutLastInlinedFunction() {
        this.inlineContextStack.pop();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext$InlineContext;", "", "inlineFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "irFileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Lorg/jetbrains/kotlin/ir/IrFileEntry;)V", "getInlineFunctionSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getIrFileEntry", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.wasm"})
    public static final class InlineContext {
        @Nullable
        private final IrFunctionSymbol inlineFunctionSymbol;
        @NotNull
        private final IrFileEntry irFileEntry;

        public InlineContext(@Nullable IrFunctionSymbol inlineFunctionSymbol, @NotNull IrFileEntry irFileEntry) {
            Intrinsics.checkNotNullParameter(irFileEntry, "irFileEntry");
            this.inlineFunctionSymbol = inlineFunctionSymbol;
            this.irFileEntry = irFileEntry;
        }

        @Nullable
        public final IrFunctionSymbol getInlineFunctionSymbol() {
            return this.inlineFunctionSymbol;
        }

        @NotNull
        public final IrFileEntry getIrFileEntry() {
            return this.irFileEntry;
        }

        @Nullable
        public final IrFunctionSymbol component1() {
            return this.inlineFunctionSymbol;
        }

        @NotNull
        public final IrFileEntry component2() {
            return this.irFileEntry;
        }

        @NotNull
        public final InlineContext copy(@Nullable IrFunctionSymbol inlineFunctionSymbol, @NotNull IrFileEntry irFileEntry) {
            Intrinsics.checkNotNullParameter(irFileEntry, "irFileEntry");
            return new InlineContext(inlineFunctionSymbol, irFileEntry);
        }

        public static /* synthetic */ InlineContext copy$default(InlineContext inlineContext, IrFunctionSymbol irFunctionSymbol, IrFileEntry irFileEntry, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irFunctionSymbol = inlineContext.inlineFunctionSymbol;
            }
            if ((n2 & 2) != 0) {
                irFileEntry = inlineContext.irFileEntry;
            }
            return inlineContext.copy(irFunctionSymbol, irFileEntry);
        }

        @NotNull
        public String toString() {
            return "InlineContext(inlineFunctionSymbol=" + this.inlineFunctionSymbol + ", irFileEntry=" + this.irFileEntry + ')';
        }

        public int hashCode() {
            int result2 = this.inlineFunctionSymbol == null ? 0 : this.inlineFunctionSymbol.hashCode();
            result2 = result2 * 31 + this.irFileEntry.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InlineContext)) {
                return false;
            }
            InlineContext inlineContext = (InlineContext)other;
            if (!Intrinsics.areEqual(this.inlineFunctionSymbol, inlineContext.inlineFunctionSymbol)) {
                return false;
            }
            return Intrinsics.areEqual(this.irFileEntry, inlineContext.irFileEntry);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyntheticLocalType.values().length];
            try {
                nArray[SyntheticLocalType.IS_INTERFACE_PARAMETER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntheticLocalType.IS_INTERFACE_ANY_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntheticLocalType.TABLE_SWITCH_SELECTOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

