/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeOrElementOrAttributeReference
implements PsiReference {
    @NonNls
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private final PsiElement myElement;
    private TextRange myRange;
    private String nsPrefix;
    @Nullable
    private final ReferenceType myType;
    static final ResolveCache.Resolver RESOLVER = (ref, incompleteCode) -> ((TypeOrElementOrAttributeReference)ref).resolveInner();

    @Nullable
    public ReferenceType getType() {
        return this.myType;
    }

    public void setNamespacePrefix(String prefix) {
        this.nsPrefix = prefix;
    }

    protected TypeOrElementOrAttributeReference(PsiElement element, TextRange range, @Nullable ReferenceType type) {
        this.myElement = element;
        this.myRange = range;
        assert (this.myRange.getLength() >= 0);
        this.myType = type;
    }

    TypeOrElementOrAttributeReference(PsiElement element, TextRange range) {
        this(element, range, TypeOrElementOrAttributeReference.determineReferenceType(element));
    }

    @Nullable
    private static ReferenceType determineReferenceType(PsiElement element) {
        String attributeLocalName;
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        if (attribute == null) {
            return null;
        }
        XmlTag tag = attribute.getParent();
        String localName = tag.getLocalName();
        return switch (attributeLocalName = attribute.getLocalName()) {
            case "ref", "substitutionGroup" -> {
                switch (localName) {
                    case "group": {
                        yield ReferenceType.GroupReference;
                    }
                    case "attributeGroup": {
                        yield ReferenceType.AttributeGroupReference;
                    }
                    case "element": {
                        yield ReferenceType.ElementReference;
                    }
                    case "attribute": {
                        yield ReferenceType.AttributeReference;
                    }
                }
                yield null;
            }
            case "type", "base", "memberTypes", "itemType" -> ReferenceType.TypeReference;
            default -> null;
        };
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, (ref, incompleteCode) -> ref.resolveInner(), false, false);
    }

    private PsiElement resolveInner() {
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return null;
        }
        String canonicalText = this.getCanonicalText();
        boolean[] redefined = new boolean[1];
        XsdNsDescriptor nsDescriptor = this.getDescriptor(tag, canonicalText, redefined);
        if (this.myType != null && nsDescriptor != null) {
            return switch (this.myType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> nsDescriptor.findGroup(canonicalText);
                case 3 -> nsDescriptor.findAttributeGroup(canonicalText);
                case 0 -> {
                    XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(XmlUtil.findLocalNameByQualifiedName((String)canonicalText), TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), new HashSet(), true);
                    if (descriptor != null) {
                        yield descriptor.getDeclaration();
                    }
                    yield null;
                }
                case 1 -> {
                    String localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName((String)canonicalText);
                    XmlAttributeDescriptor descriptor = nsDescriptor.getAttribute(localNameByQualifiedName, TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), tag);
                    if (descriptor != null) {
                        yield descriptor.getDeclaration();
                    }
                    yield null;
                }
                case 4 -> {
                    TypeDescriptor typeDescriptor;
                    TypeDescriptor v1 = typeDescriptor = redefined[0] ? nsDescriptor.findTypeDescriptor(XmlUtil.findLocalNameByQualifiedName((String)canonicalText), "") : nsDescriptor.getTypeDescriptor(canonicalText, tag);
                    if (typeDescriptor instanceof ComplexTypeDescriptor) {
                        yield typeDescriptor.getDeclaration();
                    }
                    if (typeDescriptor != null) {
                        yield this.myElement;
                    }
                    yield null;
                }
            };
        }
        return null;
    }

    @ApiStatus.Internal
    public XsdNsDescriptor getDescriptor(XmlTag tag, String text, boolean[] redefined) {
        if (this.myType != ReferenceType.ElementReference && this.myType != ReferenceType.AttributeReference) {
            XmlNSDescriptorImpl redefinedDescriptor;
            PsiElement parentElement = this.myElement.getContext();
            PsiElement grandParentElement = parentElement != null ? parentElement.getParent() : null;
            boolean doRedefineCheck = false;
            if (parentElement instanceof XmlAttribute && grandParentElement instanceof XmlTag) {
                String attrName = ((XmlAttribute)parentElement).getName();
                String tagLocalName = ((XmlTag)grandParentElement).getLocalName();
                boolean bl = doRedefineCheck = "ref".equals(attrName) && ("group".equals(tagLocalName) || "attributeGroup".equals(tagLocalName)) || "base".equals(attrName) || "memberTypes".equals(attrName);
            }
            if (doRedefineCheck && (redefinedDescriptor = SchemaReferencesProvider.findRedefinedDescriptor(tag, text)) != null) {
                redefined[0] = true;
                return redefinedDescriptor;
            }
        }
        String namespace = TypeOrElementOrAttributeReference.getNamespace(tag, text);
        XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(namespace, true);
        PsiFile file = tag.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file).getDocument();
        if (nsDescriptor == null) {
            nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        if (nsDescriptor == null) {
            XmlNSDescriptor[] descrs = new XmlNSDescriptor[1];
            URLReference.processWsdlSchemas((XmlTag)document.getRootTag(), xmlTag -> {
                if (namespace.equals(xmlTag.getAttributeValue(TARGET_NAMESPACE))) {
                    descrs[0] = (XmlNSDescriptor)xmlTag.getMetaData();
                    return false;
                }
                return true;
            });
            if (descrs[0] instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)descrs[0];
            }
        }
        return nsDescriptor instanceof XsdNsDescriptor ? (XsdNsDescriptor)nsDescriptor : null;
    }

    @NotNull
    private static String getNamespace(@NotNull XmlTag tag, String text) {
        String targetNsPrefix;
        String targetNS;
        String namespacePrefix;
        String namespaceByPrefix;
        if (tag == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(2);
        }
        if (!(namespaceByPrefix = tag.getNamespaceByPrefix(namespacePrefix = XmlUtil.findPrefixByQualifiedName((String)text))).isEmpty()) {
            String string = namespaceByPrefix;
            if (string == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(3);
            }
            return string;
        }
        XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getRootTag();
        if (rootTag != null && "schema".equals(rootTag.getLocalName()) && XmlUtil.ourSchemaUrisList.contains(rootTag.getNamespace()) && (targetNS = rootTag.getAttributeValue(TARGET_NAMESPACE)) != null && (namespacePrefix.equals(targetNsPrefix = rootTag.getPrefixByNamespace(targetNS)) || targetNsPrefix == null)) {
            String string = targetNS;
            if (string == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = namespaceByPrefix;
        if (string == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        Object name;
        String text = this.myElement.getText();
        Object object = name = this.myRange.getEndOffset() <= text.length() ? this.myRange.substring(text) : "";
        if (!((String)name).isEmpty() && this.nsPrefix != null && !this.nsPrefix.isEmpty()) {
            name = this.nsPrefix + ":" + (String)name;
        }
        String string = name;
        if (string == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(7);
        }
        String canonicalText = this.getCanonicalText();
        PsiElement element = ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
        this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getEndOffset() - (canonicalText.length() - newElementName.length()));
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(8);
        }
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(9);
        }
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public Object @NotNull [] getVariants() {
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myElement, XmlTag.class, (boolean)true);
        if (tag == null || this.myType == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(10);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = TypeOrElementOrAttributeReference.getVariants(tag, this.myType, this.nsPrefix);
        if (objectArray == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    public static Object[] getVariants(XmlTag tag, ReferenceType type, String prefix) {
        String ourNamespace;
        String[] stringArray;
        switch (type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 2: {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "group";
                break;
            }
            case 3: {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "attributeGroup";
                break;
            }
            case 1: {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "attribute";
                break;
            }
            case 0: {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "element";
                break;
            }
            case 4: {
                String[] stringArray6 = new String[2];
                stringArray6[0] = "simpleType";
                stringArray = stringArray6;
                stringArray6[1] = "complexType";
            }
        }
        String[] tagNames = stringArray;
        XmlDocument document = ((XmlFile)tag.getContainingFile()).getDocument();
        if (document == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        XmlTag rootTag = document.getRootTag();
        String string = ourNamespace = rootTag != null ? rootTag.getAttributeValue(TARGET_NAMESPACE) : "";
        if (ourNamespace == null) {
            ourNamespace = "";
        }
        CompletionProcessor processor = new CompletionProcessor(tag, prefix);
        for (String namespace : tag.knownNamespaces()) {
            XmlNSDescriptor nsDescriptor;
            if (ourNamespace.equals(namespace) || !((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof XsdNsDescriptor)) continue;
            TypeOrElementOrAttributeReference.processNamespace(namespace, processor, (XsdNsDescriptor)nsDescriptor, tagNames);
        }
        XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        if (nsDescriptor instanceof XmlNSDescriptorImpl) {
            TypeOrElementOrAttributeReference.processNamespace(ourNamespace, processor, (XsdNsDescriptor)((XmlNSDescriptorImpl)nsDescriptor), tagNames);
        }
        return ArrayUtilRt.toStringArray(processor.myElements);
    }

    private static void processNamespace(String namespace, CompletionProcessor processor, XsdNsDescriptor nsDescriptor, String[] tagNames) {
        processor.namespace = namespace;
        nsDescriptor.processTagsInNamespace(tagNames, (PsiElementProcessor)processor);
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    public static enum ReferenceType {
        ElementReference,
        AttributeReference,
        GroupReference,
        AttributeGroupReference,
        TypeReference;

    }

    private static class CompletionProcessor
    implements PsiElementProcessor<XmlTag> {
        final List<String> myElements = new ArrayList<String>(1);
        String namespace;
        final XmlTag tag;
        private final String prefix;

        CompletionProcessor(XmlTag tag, String prefix) {
            this.tag = tag;
            this.prefix = prefix;
        }

        public boolean execute(@NotNull XmlTag element) {
            if (element == null) {
                CompletionProcessor.$$$reportNull$$$0(0);
            }
            Object name = element.getAttributeValue("name");
            String prefixByNamespace = this.tag.getPrefixByNamespace(this.namespace);
            if (prefixByNamespace != null && !prefixByNamespace.isEmpty() && this.prefix == null) {
                name = prefixByNamespace + ":" + (String)name;
            }
            this.myElements.add((String)name);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference$CompletionProcessor", "execute"));
        }
    }
}

