/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryThresholdImageFilter_h
#define sitkBinaryThresholdImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class BinaryThresholdImageFilter
\brief Binarize an input image by thresholding.

This filter produces an output image whose pixels are either one of two values ( OutsideValue or InsideValue ), depending on whether the corresponding input image pixels lie between the two thresholds ( LowerThreshold and UpperThreshold ). Values equal to either threshold is considered to be between the thresholds.

More precisely \f[ Output(x_i) = \begin{cases} InsideValue & \text{if \f$LowerThreshold \leq x_i \leq UpperThreshold\f$} \\ OutsideValue & \text{otherwise} \end{cases} \f] 

This filter is templated over the input image type and the output image type.

The filter expect both images to have the same number of dimensions.

The default values for LowerThreshold and UpperThreshold are: LowerThreshold = NumericTraits<TInput>::NonpositiveMin() ; UpperThreshold = NumericTraits<TInput>::max() ; Therefore, generally only one of these needs to be set, depending on whether the user wants to threshold above or below the desired threshold.
\sa itk::simple::BinaryThreshold for the procedural interface
\sa itk::BinaryThresholdImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryThresholdImageFilter : public ImageFilter {
    public:
      using Self = BinaryThresholdImageFilter;

      /** Destructor */
      virtual ~BinaryThresholdImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryThresholdImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLowerThreshold ( double LowerThreshold ) { this->m_LowerThreshold = LowerThreshold; return *this; }

      /**
       */
      double GetLowerThreshold() const { return this->m_LowerThreshold; }\

      /**
       * Set the thresholds. The default lower threshold is NumericTraits<InputPixelType>::NonpositiveMin() . The default upper threshold is NumericTraits<InputPixelType>::max . An exception is thrown if the lower threshold is greater than the upper threshold.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpperThreshold ( double UpperThreshold ) { this->m_UpperThreshold = UpperThreshold; return *this; }

      /**
       * Get the threshold values.
       */
      double GetUpperThreshold() const { return this->m_UpperThreshold; }\

      /**
       * Set the "inside" pixel value. The default value NumericTraits<OutputPixelType>::max()
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInsideValue ( uint8_t InsideValue ) { this->m_InsideValue = InsideValue; return *this; }

      /**
       * Get the "inside" pixel value.
       */
      uint8_t GetInsideValue() const { return this->m_InsideValue; }\

      /**
       * Set the "outside" pixel value. The default value NumericTraits<OutputPixelType>::ZeroValue() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutsideValue ( uint8_t OutsideValue ) { this->m_OutsideValue = OutsideValue; return *this; }

      /**
       * Get the "outside" pixel value.
       */
      uint8_t GetOutsideValue() const { return this->m_OutsideValue; }

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryThresholdImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_LowerThreshold{0.0};

      double  m_UpperThreshold{255.0};

      uint8_t  m_InsideValue{1u};

      uint8_t  m_OutsideValue{0u};


      bool m_InPlace{false};
    };

    /**\
     * \brief Binarize an input image by thresholding.
     *
     * This function directly calls the execute method of BinaryThresholdImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BinaryThresholdImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image BinaryThreshold ( Image&& image1, double lowerThreshold = 0.0, double upperThreshold = 255.0, uint8_t insideValue = 1u, uint8_t outsideValue = 0u );
#endif
     SITKBasicFilters_EXPORT Image BinaryThreshold ( const Image& image1, double lowerThreshold = 0.0, double upperThreshold = 255.0, uint8_t insideValue = 1u, uint8_t outsideValue = 0u );

     /** @} */
}
#endif
