/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser;

import com.oracle.graal.python.pegparser.AbstractParser;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.SuppressFBWarnings;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeParamTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;

@SuppressFBWarnings
public final class Parser
extends AbstractParser {
    private static final Object[][][] reservedKeywords = new Object[][][]{null, null, {{"if", 668}, {"as", 674}, {"in", 677}, {"or", 684}, {"is", 687}}, {{"del", 660}, {"def", 667}, {"for", 671}, {"try", 672}, {"and", 685}, {"not", 686}}, {{"from", 657}, {"pass", 659}, {"with", 670}, {"elif", 675}, {"else", 676}, {"None", 680}, {"True", 681}}, {{"raise", 658}, {"yield", 661}, {"break", 663}, {"class", 669}, {"while", 673}, {"False", 682}}, {{"return", 655}, {"import", 656}, {"assert", 662}, {"global", 665}, {"except", 678}, {"lambda", 683}}, {{"finally", 679}}, {{"continue", 664}, {"nonlocal", 666}}};
    private static final String[] softKeywords = new String[]{"_", "case", "match", "type"};
    private static final int FILE_ID = 1000;
    private static final int INTERACTIVE_ID = 1001;
    private static final int EVAL_ID = 1002;
    private static final int FUNC_TYPE_ID = 1003;
    private static final int STATEMENTS_ID = 1004;
    private static final int STATEMENT_ID = 1005;
    private static final int STATEMENT_NEWLINE_ID = 1006;
    private static final int SIMPLE_STMTS_ID = 1007;
    private static final int SIMPLE_STMT_ID = 1008;
    private static final int COMPOUND_STMT_ID = 1009;
    private static final int ASSIGNMENT_ID = 1010;
    private static final int ANNOTATED_RHS_ID = 1011;
    private static final int AUGASSIGN_ID = 1012;
    private static final int RETURN_STMT_ID = 1013;
    private static final int RAISE_STMT_ID = 1014;
    private static final int GLOBAL_STMT_ID = 1015;
    private static final int NONLOCAL_STMT_ID = 1016;
    private static final int DEL_STMT_ID = 1017;
    private static final int YIELD_STMT_ID = 1018;
    private static final int ASSERT_STMT_ID = 1019;
    private static final int IMPORT_STMT_ID = 1020;
    private static final int IMPORT_NAME_ID = 1021;
    private static final int IMPORT_FROM_ID = 1022;
    private static final int IMPORT_FROM_TARGETS_ID = 1023;
    private static final int IMPORT_FROM_AS_NAMES_ID = 1024;
    private static final int IMPORT_FROM_AS_NAME_ID = 1025;
    private static final int DOTTED_AS_NAMES_ID = 1026;
    private static final int DOTTED_AS_NAME_ID = 1027;
    private static final int DOTTED_NAME_ID = 1028;
    private static final int BLOCK_ID = 1029;
    private static final int DECORATORS_ID = 1030;
    private static final int CLASS_DEF_ID = 1031;
    private static final int CLASS_DEF_RAW_ID = 1032;
    private static final int FUNCTION_DEF_ID = 1033;
    private static final int FUNCTION_DEF_RAW_ID = 1034;
    private static final int PARAMS_ID = 1035;
    private static final int PARAMETERS_ID = 1036;
    private static final int SLASH_NO_DEFAULT_ID = 1037;
    private static final int SLASH_WITH_DEFAULT_ID = 1038;
    private static final int STAR_ETC_ID = 1039;
    private static final int KWDS_ID = 1040;
    private static final int PARAM_NO_DEFAULT_ID = 1041;
    private static final int PARAM_NO_DEFAULT_STAR_ANNOTATION_ID = 1042;
    private static final int PARAM_WITH_DEFAULT_ID = 1043;
    private static final int PARAM_MAYBE_DEFAULT_ID = 1044;
    private static final int PARAM_ID = 1045;
    private static final int PARAM_STAR_ANNOTATION_ID = 1046;
    private static final int ANNOTATION_ID = 1047;
    private static final int STAR_ANNOTATION_ID = 1048;
    private static final int DEFAULT_ID = 1049;
    private static final int IF_STMT_ID = 1050;
    private static final int ELIF_STMT_ID = 1051;
    private static final int ELSE_BLOCK_ID = 1052;
    private static final int WHILE_STMT_ID = 1053;
    private static final int FOR_STMT_ID = 1054;
    private static final int WITH_STMT_ID = 1055;
    private static final int WITH_ITEM_ID = 1056;
    private static final int TRY_STMT_ID = 1057;
    private static final int EXCEPT_BLOCK_ID = 1058;
    private static final int EXCEPT_STAR_BLOCK_ID = 1059;
    private static final int FINALLY_BLOCK_ID = 1060;
    private static final int MATCH_STMT_ID = 1061;
    private static final int SUBJECT_EXPR_ID = 1062;
    private static final int CASE_BLOCK_ID = 1063;
    private static final int GUARD_ID = 1064;
    private static final int PATTERNS_ID = 1065;
    private static final int PATTERN_ID = 1066;
    private static final int AS_PATTERN_ID = 1067;
    private static final int OR_PATTERN_ID = 1068;
    private static final int CLOSED_PATTERN_ID = 1069;
    private static final int LITERAL_PATTERN_ID = 1070;
    private static final int LITERAL_EXPR_ID = 1071;
    private static final int COMPLEX_NUMBER_ID = 1072;
    private static final int SIGNED_NUMBER_ID = 1073;
    private static final int SIGNED_REAL_NUMBER_ID = 1074;
    private static final int REAL_NUMBER_ID = 1075;
    private static final int IMAGINARY_NUMBER_ID = 1076;
    private static final int CAPTURE_PATTERN_ID = 1077;
    private static final int PATTERN_CAPTURE_TARGET_ID = 1078;
    private static final int WILDCARD_PATTERN_ID = 1079;
    private static final int VALUE_PATTERN_ID = 1080;
    private static final int ATTR_ID = 1081;
    private static final int NAME_OR_ATTR_ID = 1082;
    private static final int GROUP_PATTERN_ID = 1083;
    private static final int SEQUENCE_PATTERN_ID = 1084;
    private static final int OPEN_SEQUENCE_PATTERN_ID = 1085;
    private static final int MAYBE_SEQUENCE_PATTERN_ID = 1086;
    private static final int MAYBE_STAR_PATTERN_ID = 1087;
    private static final int STAR_PATTERN_ID = 1088;
    private static final int MAPPING_PATTERN_ID = 1089;
    private static final int ITEMS_PATTERN_ID = 1090;
    private static final int KEY_VALUE_PATTERN_ID = 1091;
    private static final int DOUBLE_STAR_PATTERN_ID = 1092;
    private static final int CLASS_PATTERN_ID = 1093;
    private static final int POSITIONAL_PATTERNS_ID = 1094;
    private static final int KEYWORD_PATTERNS_ID = 1095;
    private static final int KEYWORD_PATTERN_ID = 1096;
    private static final int TYPE_ALIAS_ID = 1097;
    private static final int TYPE_PARAMS_ID = 1098;
    private static final int TYPE_PARAM_SEQ_ID = 1099;
    private static final int TYPE_PARAM_ID = 1100;
    private static final int TYPE_PARAM_BOUND_ID = 1101;
    private static final int EXPRESSIONS_ID = 1102;
    private static final int EXPRESSION_ID = 1103;
    private static final int YIELD_EXPR_ID = 1104;
    private static final int STAR_EXPRESSIONS_ID = 1105;
    private static final int STAR_EXPRESSION_ID = 1106;
    private static final int STAR_NAMED_EXPRESSIONS_ID = 1107;
    private static final int STAR_NAMED_EXPRESSION_ID = 1108;
    private static final int ASSIGNMENT_EXPRESSION_ID = 1109;
    private static final int NAMED_EXPRESSION_ID = 1110;
    private static final int DISJUNCTION_ID = 1111;
    private static final int CONJUNCTION_ID = 1112;
    private static final int INVERSION_ID = 1113;
    private static final int COMPARISON_ID = 1114;
    private static final int COMPARE_OP_BITWISE_OR_PAIR_ID = 1115;
    private static final int EQ_BITWISE_OR_ID = 1116;
    private static final int NOTEQ_BITWISE_OR_ID = 1117;
    private static final int LTE_BITWISE_OR_ID = 1118;
    private static final int LT_BITWISE_OR_ID = 1119;
    private static final int GTE_BITWISE_OR_ID = 1120;
    private static final int GT_BITWISE_OR_ID = 1121;
    private static final int NOTIN_BITWISE_OR_ID = 1122;
    private static final int IN_BITWISE_OR_ID = 1123;
    private static final int ISNOT_BITWISE_OR_ID = 1124;
    private static final int IS_BITWISE_OR_ID = 1125;
    private static final int BITWISE_OR_ID = 1126;
    private static final int BITWISE_XOR_ID = 1127;
    private static final int BITWISE_AND_ID = 1128;
    private static final int SHIFT_EXPR_ID = 1129;
    private static final int SUM_ID = 1130;
    private static final int TERM_ID = 1131;
    private static final int FACTOR_ID = 1132;
    private static final int POWER_ID = 1133;
    private static final int AWAIT_PRIMARY_ID = 1134;
    private static final int PRIMARY_ID = 1135;
    private static final int SLICES_ID = 1136;
    private static final int SLICE_ID = 1137;
    private static final int ATOM_ID = 1138;
    private static final int GROUP_ID = 1139;
    private static final int LAMBDEF_ID = 1140;
    private static final int LAMBDA_PARAMS_ID = 1141;
    private static final int LAMBDA_PARAMETERS_ID = 1142;
    private static final int LAMBDA_SLASH_NO_DEFAULT_ID = 1143;
    private static final int LAMBDA_SLASH_WITH_DEFAULT_ID = 1144;
    private static final int LAMBDA_STAR_ETC_ID = 1145;
    private static final int LAMBDA_KWDS_ID = 1146;
    private static final int LAMBDA_PARAM_NO_DEFAULT_ID = 1147;
    private static final int LAMBDA_PARAM_WITH_DEFAULT_ID = 1148;
    private static final int LAMBDA_PARAM_MAYBE_DEFAULT_ID = 1149;
    private static final int LAMBDA_PARAM_ID = 1150;
    private static final int FSTRING_MIDDLE_ID = 1151;
    private static final int FSTRING_REPLACEMENT_FIELD_ID = 1152;
    private static final int FSTRING_CONVERSION_ID = 1153;
    private static final int FSTRING_FULL_FORMAT_SPEC_ID = 1154;
    private static final int FSTRING_FORMAT_SPEC_ID = 1155;
    private static final int FSTRING_ID = 1156;
    private static final int STRING_ID = 1157;
    private static final int STRINGS_ID = 1158;
    private static final int LIST_ID = 1159;
    private static final int TUPLE_ID = 1160;
    private static final int SET_ID = 1161;
    private static final int DICT_ID = 1162;
    private static final int DOUBLE_STARRED_KVPAIRS_ID = 1163;
    private static final int DOUBLE_STARRED_KVPAIR_ID = 1164;
    private static final int KVPAIR_ID = 1165;
    private static final int FOR_IF_CLAUSES_ID = 1166;
    private static final int FOR_IF_CLAUSE_ID = 1167;
    private static final int LISTCOMP_ID = 1168;
    private static final int SETCOMP_ID = 1169;
    private static final int GENEXP_ID = 1170;
    private static final int DICTCOMP_ID = 1171;
    private static final int ARGUMENTS_ID = 1172;
    private static final int ARGS_ID = 1173;
    private static final int KWARGS_ID = 1174;
    private static final int STARRED_EXPRESSION_ID = 1175;
    private static final int KWARG_OR_STARRED_ID = 1176;
    private static final int KWARG_OR_DOUBLE_STARRED_ID = 1177;
    private static final int STAR_TARGETS_ID = 1178;
    private static final int STAR_TARGETS_LIST_SEQ_ID = 1179;
    private static final int STAR_TARGETS_TUPLE_SEQ_ID = 1180;
    private static final int STAR_TARGET_ID = 1181;
    private static final int TARGET_WITH_STAR_ATOM_ID = 1182;
    private static final int STAR_ATOM_ID = 1183;
    private static final int SINGLE_TARGET_ID = 1184;
    private static final int SINGLE_SUBSCRIPT_ATTRIBUTE_TARGET_ID = 1185;
    private static final int T_PRIMARY_ID = 1186;
    private static final int T_LOOKAHEAD_ID = 1187;
    private static final int DEL_TARGETS_ID = 1188;
    private static final int DEL_TARGET_ID = 1189;
    private static final int DEL_T_ATOM_ID = 1190;
    private static final int TYPE_EXPRESSIONS_ID = 1191;
    private static final int FUNC_TYPE_COMMENT_ID = 1192;
    private static final int INVALID_ARGUMENTS_ID = 1193;
    private static final int INVALID_KWARG_ID = 1194;
    private static final int EXPRESSION_WITHOUT_INVALID_ID = 1195;
    private static final int INVALID_LEGACY_EXPRESSION_ID = 1196;
    private static final int INVALID_EXPRESSION_ID = 1197;
    private static final int INVALID_NAMED_EXPRESSION_ID = 1198;
    private static final int INVALID_ASSIGNMENT_ID = 1199;
    private static final int INVALID_ANN_ASSIGN_TARGET_ID = 1200;
    private static final int INVALID_DEL_STMT_ID = 1201;
    private static final int INVALID_BLOCK_ID = 1202;
    private static final int INVALID_COMPREHENSION_ID = 1203;
    private static final int INVALID_DICT_COMPREHENSION_ID = 1204;
    private static final int INVALID_PARAMETERS_ID = 1205;
    private static final int INVALID_DEFAULT_ID = 1206;
    private static final int INVALID_STAR_ETC_ID = 1207;
    private static final int INVALID_KWDS_ID = 1208;
    private static final int INVALID_PARAMETERS_HELPER_ID = 1209;
    private static final int INVALID_LAMBDA_PARAMETERS_ID = 1210;
    private static final int INVALID_LAMBDA_PARAMETERS_HELPER_ID = 1211;
    private static final int INVALID_LAMBDA_STAR_ETC_ID = 1212;
    private static final int INVALID_LAMBDA_KWDS_ID = 1213;
    private static final int INVALID_DOUBLE_TYPE_COMMENTS_ID = 1214;
    private static final int INVALID_WITH_ITEM_ID = 1215;
    private static final int INVALID_FOR_TARGET_ID = 1216;
    private static final int INVALID_GROUP_ID = 1217;
    private static final int INVALID_IMPORT_ID = 1218;
    private static final int INVALID_IMPORT_FROM_TARGETS_ID = 1219;
    private static final int INVALID_WITH_STMT_ID = 1220;
    private static final int INVALID_WITH_STMT_INDENT_ID = 1221;
    private static final int INVALID_TRY_STMT_ID = 1222;
    private static final int INVALID_EXCEPT_STMT_ID = 1223;
    private static final int INVALID_FINALLY_STMT_ID = 1224;
    private static final int INVALID_EXCEPT_STMT_INDENT_ID = 1225;
    private static final int INVALID_EXCEPT_STAR_STMT_INDENT_ID = 1226;
    private static final int INVALID_MATCH_STMT_ID = 1227;
    private static final int INVALID_CASE_BLOCK_ID = 1228;
    private static final int INVALID_AS_PATTERN_ID = 1229;
    private static final int INVALID_CLASS_PATTERN_ID = 1230;
    private static final int INVALID_CLASS_ARGUMENT_PATTERN_ID = 1231;
    private static final int INVALID_IF_STMT_ID = 1232;
    private static final int INVALID_ELIF_STMT_ID = 1233;
    private static final int INVALID_ELSE_STMT_ID = 1234;
    private static final int INVALID_WHILE_STMT_ID = 1235;
    private static final int INVALID_FOR_STMT_ID = 1236;
    private static final int INVALID_DEF_RAW_ID = 1237;
    private static final int INVALID_CLASS_DEF_RAW_ID = 1238;
    private static final int INVALID_DOUBLE_STARRED_KVPAIRS_ID = 1239;
    private static final int INVALID_KVPAIR_ID = 1240;
    private static final int INVALID_STARRED_EXPRESSION_ID = 1241;
    private static final int INVALID_REPLACEMENT_FIELD_ID = 1242;
    private static final int INVALID_CONVERSION_CHARACTER_ID = 1243;
    private static final int _TMP_1_ID = 1244;
    private static final int _LOOP0_2_ID = 1245;
    private static final int _TMP_3_ID = 1246;
    private static final int _LOOP0_4_ID = 1247;
    private static final int _LOOP1_5_ID = 1248;
    private static final int _LOOP0_7_ID = 1249;
    private static final int _GATHER_6_ID = 1250;
    private static final int _TMP_8_ID = 1251;
    private static final int _TMP_9_ID = 1252;
    private static final int _TMP_10_ID = 1253;
    private static final int _TMP_11_ID = 1254;
    private static final int _TMP_12_ID = 1255;
    private static final int _TMP_13_ID = 1256;
    private static final int _TMP_14_ID = 1257;
    private static final int _TMP_15_ID = 1258;
    private static final int _TMP_16_ID = 1259;
    private static final int _LOOP1_17_ID = 1260;
    private static final int _TMP_18_ID = 1261;
    private static final int _TMP_19_ID = 1262;
    private static final int _TMP_20_ID = 1263;
    private static final int _TMP_21_ID = 1264;
    private static final int _TMP_22_ID = 1265;
    private static final int _LOOP0_24_ID = 1266;
    private static final int _GATHER_23_ID = 1267;
    private static final int _LOOP0_26_ID = 1268;
    private static final int _GATHER_25_ID = 1269;
    private static final int _TMP_27_ID = 1270;
    private static final int _TMP_28_ID = 1271;
    private static final int _LOOP0_29_ID = 1272;
    private static final int _LOOP1_30_ID = 1273;
    private static final int _TMP_31_ID = 1274;
    private static final int _LOOP0_33_ID = 1275;
    private static final int _GATHER_32_ID = 1276;
    private static final int _TMP_34_ID = 1277;
    private static final int _LOOP0_36_ID = 1278;
    private static final int _GATHER_35_ID = 1279;
    private static final int _TMP_37_ID = 1280;
    private static final int _LOOP1_38_ID = 1281;
    private static final int _TMP_39_ID = 1282;
    private static final int _TMP_40_ID = 1283;
    private static final int _TMP_41_ID = 1284;
    private static final int _TMP_42_ID = 1285;
    private static final int _TMP_43_ID = 1286;
    private static final int _TMP_44_ID = 1287;
    private static final int _TMP_45_ID = 1288;
    private static final int _TMP_46_ID = 1289;
    private static final int _TMP_47_ID = 1290;
    private static final int _TMP_48_ID = 1291;
    private static final int _LOOP0_49_ID = 1292;
    private static final int _LOOP0_50_ID = 1293;
    private static final int _TMP_51_ID = 1294;
    private static final int _LOOP0_52_ID = 1295;
    private static final int _TMP_53_ID = 1296;
    private static final int _LOOP1_54_ID = 1297;
    private static final int _LOOP0_55_ID = 1298;
    private static final int _TMP_56_ID = 1299;
    private static final int _LOOP1_57_ID = 1300;
    private static final int _TMP_58_ID = 1301;
    private static final int _LOOP1_59_ID = 1302;
    private static final int _LOOP1_60_ID = 1303;
    private static final int _LOOP0_61_ID = 1304;
    private static final int _LOOP1_62_ID = 1305;
    private static final int _LOOP0_63_ID = 1306;
    private static final int _LOOP1_64_ID = 1307;
    private static final int _LOOP0_65_ID = 1308;
    private static final int _TMP_66_ID = 1309;
    private static final int _LOOP0_67_ID = 1310;
    private static final int _TMP_68_ID = 1311;
    private static final int _LOOP1_69_ID = 1312;
    private static final int _TMP_70_ID = 1313;
    private static final int _TMP_71_ID = 1314;
    private static final int _TMP_72_ID = 1315;
    private static final int _TMP_73_ID = 1316;
    private static final int _TMP_74_ID = 1317;
    private static final int _TMP_75_ID = 1318;
    private static final int _TMP_76_ID = 1319;
    private static final int _TMP_77_ID = 1320;
    private static final int _LOOP0_79_ID = 1321;
    private static final int _GATHER_78_ID = 1322;
    private static final int _LOOP0_81_ID = 1323;
    private static final int _GATHER_80_ID = 1324;
    private static final int _TMP_82_ID = 1325;
    private static final int _LOOP0_84_ID = 1326;
    private static final int _GATHER_83_ID = 1327;
    private static final int _LOOP0_86_ID = 1328;
    private static final int _GATHER_85_ID = 1329;
    private static final int _TMP_87_ID = 1330;
    private static final int _TMP_88_ID = 1331;
    private static final int _LOOP1_89_ID = 1332;
    private static final int _TMP_90_ID = 1333;
    private static final int _TMP_91_ID = 1334;
    private static final int _LOOP1_92_ID = 1335;
    private static final int _TMP_93_ID = 1336;
    private static final int _TMP_94_ID = 1337;
    private static final int _TMP_95_ID = 1338;
    private static final int _TMP_96_ID = 1339;
    private static final int _LOOP1_97_ID = 1340;
    private static final int _LOOP0_99_ID = 1341;
    private static final int _GATHER_98_ID = 1342;
    private static final int _TMP_100_ID = 1343;
    private static final int _TMP_101_ID = 1344;
    private static final int _TMP_102_ID = 1345;
    private static final int _TMP_103_ID = 1346;
    private static final int _LOOP0_105_ID = 1347;
    private static final int _GATHER_104_ID = 1348;
    private static final int _LOOP0_107_ID = 1349;
    private static final int _GATHER_106_ID = 1350;
    private static final int _TMP_108_ID = 1351;
    private static final int _LOOP0_110_ID = 1352;
    private static final int _GATHER_109_ID = 1353;
    private static final int _LOOP0_112_ID = 1354;
    private static final int _GATHER_111_ID = 1355;
    private static final int _TMP_113_ID = 1356;
    private static final int _LOOP0_115_ID = 1357;
    private static final int _GATHER_114_ID = 1358;
    private static final int _TMP_116_ID = 1359;
    private static final int _TMP_117_ID = 1360;
    private static final int _LOOP1_118_ID = 1361;
    private static final int _TMP_119_ID = 1362;
    private static final int _TMP_120_ID = 1363;
    private static final int _LOOP1_121_ID = 1364;
    private static final int _TMP_122_ID = 1365;
    private static final int _LOOP0_124_ID = 1366;
    private static final int _GATHER_123_ID = 1367;
    private static final int _TMP_125_ID = 1368;
    private static final int _LOOP1_126_ID = 1369;
    private static final int _LOOP1_127_ID = 1370;
    private static final int _LOOP1_128_ID = 1371;
    private static final int _TMP_129_ID = 1372;
    private static final int _TMP_130_ID = 1373;
    private static final int _LOOP0_132_ID = 1374;
    private static final int _GATHER_131_ID = 1375;
    private static final int _TMP_133_ID = 1376;
    private static final int _TMP_134_ID = 1377;
    private static final int _TMP_135_ID = 1378;
    private static final int _TMP_136_ID = 1379;
    private static final int _TMP_137_ID = 1380;
    private static final int _TMP_138_ID = 1381;
    private static final int _TMP_139_ID = 1382;
    private static final int _TMP_140_ID = 1383;
    private static final int _TMP_141_ID = 1384;
    private static final int _TMP_142_ID = 1385;
    private static final int _LOOP0_143_ID = 1386;
    private static final int _LOOP0_144_ID = 1387;
    private static final int _TMP_145_ID = 1388;
    private static final int _LOOP0_146_ID = 1389;
    private static final int _TMP_147_ID = 1390;
    private static final int _LOOP1_148_ID = 1391;
    private static final int _LOOP0_149_ID = 1392;
    private static final int _TMP_150_ID = 1393;
    private static final int _LOOP1_151_ID = 1394;
    private static final int _TMP_152_ID = 1395;
    private static final int _LOOP1_153_ID = 1396;
    private static final int _LOOP1_154_ID = 1397;
    private static final int _LOOP0_155_ID = 1398;
    private static final int _LOOP1_156_ID = 1399;
    private static final int _LOOP0_157_ID = 1400;
    private static final int _LOOP1_158_ID = 1401;
    private static final int _LOOP0_159_ID = 1402;
    private static final int _TMP_160_ID = 1403;
    private static final int _LOOP1_161_ID = 1404;
    private static final int _TMP_162_ID = 1405;
    private static final int _TMP_163_ID = 1406;
    private static final int _TMP_164_ID = 1407;
    private static final int _TMP_165_ID = 1408;
    private static final int _LOOP0_166_ID = 1409;
    private static final int _LOOP0_167_ID = 1410;
    private static final int _LOOP1_168_ID = 1411;
    private static final int _TMP_169_ID = 1412;
    private static final int _TMP_170_ID = 1413;
    private static final int _TMP_171_ID = 1414;
    private static final int _LOOP0_173_ID = 1415;
    private static final int _GATHER_172_ID = 1416;
    private static final int _TMP_174_ID = 1417;
    private static final int _LOOP1_175_ID = 1418;
    private static final int _LOOP0_176_ID = 1419;
    private static final int _LOOP0_177_ID = 1420;
    private static final int _TMP_178_ID = 1421;
    private static final int _TMP_179_ID = 1422;
    private static final int _LOOP0_181_ID = 1423;
    private static final int _GATHER_180_ID = 1424;
    private static final int _TMP_182_ID = 1425;
    private static final int _LOOP0_184_ID = 1426;
    private static final int _GATHER_183_ID = 1427;
    private static final int _LOOP0_186_ID = 1428;
    private static final int _GATHER_185_ID = 1429;
    private static final int _LOOP0_188_ID = 1430;
    private static final int _GATHER_187_ID = 1431;
    private static final int _LOOP0_190_ID = 1432;
    private static final int _GATHER_189_ID = 1433;
    private static final int _LOOP0_191_ID = 1434;
    private static final int _TMP_192_ID = 1435;
    private static final int _LOOP0_194_ID = 1436;
    private static final int _GATHER_193_ID = 1437;
    private static final int _TMP_195_ID = 1438;
    private static final int _LOOP1_196_ID = 1439;
    private static final int _TMP_197_ID = 1440;
    private static final int _TMP_198_ID = 1441;
    private static final int _TMP_199_ID = 1442;
    private static final int _TMP_200_ID = 1443;
    private static final int _TMP_201_ID = 1444;
    private static final int _LOOP0_203_ID = 1445;
    private static final int _GATHER_202_ID = 1446;
    private static final int _TMP_204_ID = 1447;
    private static final int _TMP_205_ID = 1448;
    private static final int _TMP_206_ID = 1449;
    private static final int _LOOP0_208_ID = 1450;
    private static final int _GATHER_207_ID = 1451;
    private static final int _LOOP0_210_ID = 1452;
    private static final int _GATHER_209_ID = 1453;
    private static final int _LOOP0_212_ID = 1454;
    private static final int _GATHER_211_ID = 1455;
    private static final int _LOOP0_214_ID = 1456;
    private static final int _GATHER_213_ID = 1457;
    private static final int _TMP_215_ID = 1458;
    private static final int _TMP_216_ID = 1459;
    private static final int _LOOP0_218_ID = 1460;
    private static final int _GATHER_217_ID = 1461;
    private static final int _TMP_219_ID = 1462;
    private static final int _TMP_220_ID = 1463;
    private static final int _TMP_221_ID = 1464;
    private static final int _TMP_222_ID = 1465;
    private static final int _TMP_223_ID = 1466;
    private static final int _TMP_224_ID = 1467;
    private static final int _TMP_225_ID = 1468;
    private static final int _TMP_226_ID = 1469;
    private static final int _TMP_227_ID = 1470;
    private static final int _TMP_228_ID = 1471;
    private static final int _TMP_229_ID = 1472;
    private static final int _LOOP0_230_ID = 1473;
    private static final int _LOOP0_231_ID = 1474;
    private static final int _LOOP0_232_ID = 1475;
    private static final int _TMP_233_ID = 1476;
    private static final int _TMP_234_ID = 1477;
    private static final int _TMP_235_ID = 1478;
    private static final int _TMP_236_ID = 1479;
    private static final int _TMP_237_ID = 1480;
    private static final int _LOOP0_238_ID = 1481;
    private static final int _LOOP0_239_ID = 1482;
    private static final int _LOOP0_240_ID = 1483;
    private static final int _LOOP1_241_ID = 1484;
    private static final int _TMP_242_ID = 1485;
    private static final int _LOOP0_243_ID = 1486;
    private static final int _TMP_244_ID = 1487;
    private static final int _LOOP0_245_ID = 1488;
    private static final int _LOOP1_246_ID = 1489;
    private static final int _TMP_247_ID = 1490;
    private static final int _TMP_248_ID = 1491;
    private static final int _TMP_249_ID = 1492;
    private static final int _LOOP0_250_ID = 1493;
    private static final int _TMP_251_ID = 1494;
    private static final int _TMP_252_ID = 1495;
    private static final int _LOOP1_253_ID = 1496;
    private static final int _TMP_254_ID = 1497;
    private static final int _LOOP0_255_ID = 1498;
    private static final int _LOOP0_256_ID = 1499;
    private static final int _LOOP0_257_ID = 1500;
    private static final int _LOOP0_259_ID = 1501;
    private static final int _GATHER_258_ID = 1502;
    private static final int _TMP_260_ID = 1503;
    private static final int _LOOP0_261_ID = 1504;
    private static final int _TMP_262_ID = 1505;
    private static final int _LOOP0_263_ID = 1506;
    private static final int _LOOP1_264_ID = 1507;
    private static final int _LOOP1_265_ID = 1508;
    private static final int _TMP_266_ID = 1509;
    private static final int _TMP_267_ID = 1510;
    private static final int _LOOP0_268_ID = 1511;
    private static final int _TMP_269_ID = 1512;
    private static final int _TMP_270_ID = 1513;
    private static final int _TMP_271_ID = 1514;
    private static final int _LOOP0_273_ID = 1515;
    private static final int _GATHER_272_ID = 1516;
    private static final int _TMP_274_ID = 1517;
    private static final int _LOOP0_276_ID = 1518;
    private static final int _GATHER_275_ID = 1519;
    private static final int _TMP_277_ID = 1520;
    private static final int _LOOP0_279_ID = 1521;
    private static final int _GATHER_278_ID = 1522;
    private static final int _TMP_280_ID = 1523;
    private static final int _LOOP0_282_ID = 1524;
    private static final int _GATHER_281_ID = 1525;
    private static final int _TMP_283_ID = 1526;
    private static final int _LOOP0_285_ID = 1527;
    private static final int _GATHER_284_ID = 1528;
    private static final int _TMP_286_ID = 1529;
    private static final int _LOOP0_287_ID = 1530;
    private static final int _LOOP1_288_ID = 1531;
    private static final int _TMP_289_ID = 1532;
    private static final int _LOOP0_290_ID = 1533;
    private static final int _LOOP1_291_ID = 1534;
    private static final int _TMP_292_ID = 1535;
    private static final int _TMP_293_ID = 1536;
    private static final int _TMP_294_ID = 1537;
    private static final int _TMP_295_ID = 1538;
    private static final int _TMP_296_ID = 1539;
    private static final int _TMP_297_ID = 1540;
    private static final int _TMP_298_ID = 1541;
    private static final int _TMP_299_ID = 1542;
    private static final int _TMP_300_ID = 1543;
    private static final int _TMP_301_ID = 1544;
    private static final int _TMP_302_ID = 1545;
    private static final int _TMP_303_ID = 1546;
    private static final int _TMP_304_ID = 1547;
    private static final int _TMP_305_ID = 1548;
    private static final int _TMP_306_ID = 1549;
    private static final int _TMP_307_ID = 1550;
    private static final int _TMP_308_ID = 1551;
    private static final int _LOOP0_310_ID = 1552;
    private static final int _GATHER_309_ID = 1553;
    private static final int _TMP_311_ID = 1554;
    private static final int _TMP_312_ID = 1555;
    private static final int _TMP_313_ID = 1556;
    private static final int _TMP_314_ID = 1557;
    private static final int _TMP_315_ID = 1558;
    private static final int _TMP_316_ID = 1559;
    private static final int _TMP_317_ID = 1560;
    private static final int _TMP_318_ID = 1561;
    private static final int _TMP_319_ID = 1562;
    private static final int _TMP_320_ID = 1563;
    private static final int _TMP_321_ID = 1564;
    private static final int _TMP_322_ID = 1565;
    private static final int _TMP_323_ID = 1566;
    private static final int _TMP_324_ID = 1567;
    private static final int _LOOP0_325_ID = 1568;
    private static final int _TMP_326_ID = 1569;
    private static final int _TMP_327_ID = 1570;
    private static final int _TMP_328_ID = 1571;
    private static final int _TMP_329_ID = 1572;
    private static final int _TMP_330_ID = 1573;
    private static final int _TMP_331_ID = 1574;
    private static final int _TMP_332_ID = 1575;
    private static final int _TMP_333_ID = 1576;
    private static final int _TMP_334_ID = 1577;
    private static final int _TMP_335_ID = 1578;
    private static final int _TMP_336_ID = 1579;
    private static final int _TMP_337_ID = 1580;
    private static final int _TMP_338_ID = 1581;
    private static final int _TMP_339_ID = 1582;
    private static final int _TMP_340_ID = 1583;
    private static final int _TMP_341_ID = 1584;
    private static final int _TMP_342_ID = 1585;
    private static final int _TMP_343_ID = 1586;
    private static final int _TMP_344_ID = 1587;
    private static final int _TMP_345_ID = 1588;
    private static final int _TMP_346_ID = 1589;
    private static final int _TMP_347_ID = 1590;
    private static final int _TMP_348_ID = 1591;
    private static final int _TMP_349_ID = 1592;
    private static final int _TMP_350_ID = 1593;
    private static final int _TMP_351_ID = 1594;
    private static final int _TMP_352_ID = 1595;
    private static final int _TMP_353_ID = 1596;
    private static final int _TMP_354_ID = 1597;
    private static final int _TMP_355_ID = 1598;
    private static final int _TMP_356_ID = 1599;
    private static final int _TMP_357_ID = 1600;
    private static final int _TMP_358_ID = 1601;
    private static final int _TMP_359_ID = 1602;
    private static final int _TMP_360_ID = 1603;
    private static final int _LOOP0_362_ID = 1604;
    private static final int _GATHER_361_ID = 1605;
    private static final int _TMP_363_ID = 1606;
    private static final int _TMP_364_ID = 1607;
    private static final int _TMP_365_ID = 1608;
    private static final int _TMP_366_ID = 1609;
    private static final int _TMP_367_ID = 1610;
    private static final int _TMP_368_ID = 1611;

    @Override
    protected Object[][][] getReservedKeywords() {
        return reservedKeywords;
    }

    @Override
    protected String[] getSoftKeywords() {
        return softKeywords;
    }

    public Parser(String source, SourceRange sourceRange, ParserCallbacks parserCb, InputType startRule, EnumSet<AbstractParser.Flags> flags, int featureVersion) {
        super(source, sourceRange, parserCb, startRule, flags, featureVersion);
    }

    public Parser(String source, ParserCallbacks parserCb, InputType startRule, EnumSet<AbstractParser.Flags> flags, int featureVersion) {
        super(source, null, parserCb, startRule, flags, featureVersion);
    }

    public ModTy file_rule() {
        Token endmarker_var;
        int _mark = this.mark();
        ModTy _res = null;
        Token startToken = this.getAndInitializeToken();
        StmtTy[] a = this._tmp_1_rule();
        if (a == null) {
            // empty if block
        }
        if ((endmarker_var = this.expect(0)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.makeModule(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ModTy interactive_rule() {
        int _mark = this.mark();
        ModTy _res = null;
        Token startToken = this.getAndInitializeToken();
        StmtTy[] a = this.statement_newline_rule();
        if (a != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createInteractiveModule(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ModTy eval_rule() {
        Token endmarker_var;
        Token[] _loop0_2_var;
        int _mark = this.mark();
        ModTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.expressions_rule();
        if (a != null && (_loop0_2_var = this._loop0_2_rule()) != null && (endmarker_var = this.expect(0)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createExpressionModule(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ModTy func_type_rule() {
        int _mark = this.mark();
        ModTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(7);
        if (_literal != null) {
            Token endmarker_var;
            Token[] _loop0_4_var;
            ExprTy b;
            Token _literal_2;
            Token _literal_1;
            ExprTy[] a = this._tmp_3_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null && (_literal_2 = this.expect(51)) != null && (b = this.expression_rule()) != null && (_loop0_4_var = this._loop0_4_rule()) != null && (endmarker_var = this.expect(0)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createFunctionType(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] statements_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] a = this._loop1_5_rule();
        if (a != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] statement_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] a = this.compound_stmt_rule();
        if (a != null) {
            _res = new StmtTy[]{a};
            return _res;
        }
        this.reset(_mark);
        a = this.simple_stmts_rule();
        if (a != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] statement_newline_rule() {
        Token newline_var;
        int _mark = this.mark();
        StmtTy[] _res = null;
        Token startToken = this.getAndInitializeToken();
        StmtTy a = this.compound_stmt_rule();
        if (a != null && (newline_var = this.expect(4)) != null) {
            _res = new StmtTy[]{a};
            return _res;
        }
        this.reset(_mark);
        StmtTy[] simple_stmts_var = this.simple_stmts_rule();
        if (simple_stmts_var != null) {
            _res = simple_stmts_var;
            return _res;
        }
        this.reset(_mark);
        Token newline_var2 = this.expect(4);
        if (newline_var2 != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = new StmtTy[]{this.factory.createPass(startToken.sourceRange.withEnd(endToken.sourceRange))};
            return _res;
        }
        this.reset(_mark);
        Token endmarker_var = this.expect(0);
        if (endmarker_var != null) {
            _res = this.interactiveExit();
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] simple_stmts_rule() {
        Token newline_var;
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy a = this.simple_stmt_rule();
        if (a != null && this.genLookahead_expect(false, 13) && (newline_var = this.expect(4)) != null) {
            _res = new StmtTy[]{a};
            return _res;
        }
        this.reset(_mark);
        StmtTy[] a2 = this._gather_6_rule();
        if (a2 != null) {
            Token newline_var2;
            Token _opt_var = this._tmp_8_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((newline_var2 = this.expect(4)) != null) {
                _res = a2;
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy simple_stmt_rule() {
        StmtTy nonlocal_stmt_var;
        StmtTy global_stmt_var;
        StmtTy assert_stmt_var;
        StmtTy yield_stmt_var;
        StmtTy del_stmt_var;
        StmtTy raise_stmt_var;
        StmtTy import_stmt_var;
        StmtTy return_stmt_var;
        StmtTy type_alias_var;
        int _mark = this.mark();
        StmtTy _res = null;
        if (this.cache.hasResult(_mark, 1008)) {
            _res = (StmtTy)this.cache.getResult(_mark, 1008);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        StmtTy assignment_var = this.assignment_rule();
        if (assignment_var != null) {
            _res = assignment_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect_SOFT_KEYWORD(true, "type") && (type_alias_var = this.type_alias_rule()) != null) {
            _res = type_alias_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy e = this.star_expressions_rule();
        if (e != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createExpression(e, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 655) && (return_stmt_var = this.return_stmt_rule()) != null) {
            _res = return_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_9_rule(true) && (import_stmt_var = this.import_stmt_rule()) != null) {
            _res = import_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 658) && (raise_stmt_var = this.raise_stmt_rule()) != null) {
            _res = raise_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        Token _keyword = this.expect(659);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createPass(startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 660) && (del_stmt_var = this.del_stmt_rule()) != null) {
            _res = del_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 661) && (yield_stmt_var = this.yield_stmt_rule()) != null) {
            _res = yield_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 662) && (assert_stmt_var = this.assert_stmt_rule()) != null) {
            _res = assert_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(663);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBreak(startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(664);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createContinue(startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 665) && (global_stmt_var = this.global_stmt_rule()) != null) {
            _res = global_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 666) && (nonlocal_stmt_var = this.nonlocal_stmt_rule()) != null) {
            _res = nonlocal_stmt_var;
            this.cache.putResult(_mark, 1008, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1008, _res);
        return _res;
    }

    public StmtTy compound_stmt_rule() {
        StmtTy while_stmt_var;
        StmtTy try_stmt_var;
        StmtTy for_stmt_var;
        StmtTy with_stmt_var;
        StmtTy class_def_var;
        StmtTy if_stmt_var;
        StmtTy function_def_var;
        int _mark = this.mark();
        StmtTy _res = null;
        if (this.genLookahead__tmp_10_rule(true) && (function_def_var = this.function_def_rule()) != null) {
            _res = function_def_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 668) && (if_stmt_var = this.if_stmt_rule()) != null) {
            _res = if_stmt_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_11_rule(true) && (class_def_var = this.class_def_rule()) != null) {
            _res = class_def_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_12_rule(true) && (with_stmt_var = this.with_stmt_rule()) != null) {
            _res = with_stmt_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_13_rule(true) && (for_stmt_var = this.for_stmt_rule()) != null) {
            _res = for_stmt_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 672) && (try_stmt_var = this.try_stmt_rule()) != null) {
            _res = try_stmt_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 673) && (while_stmt_var = this.while_stmt_rule()) != null) {
            _res = while_stmt_var;
            return _res;
        }
        this.reset(_mark);
        StmtTy match_stmt_var = this.match_stmt_rule();
        if (match_stmt_var != null) {
            _res = match_stmt_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy assignment_rule() {
        ExprTy b;
        Object b2;
        Token _literal;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.name_token();
        if (a != null && (_literal = this.expect(11)) != null && (b2 = this.expression_rule()) != null) {
            Token endToken;
            ExprTy c = this._tmp_14_rule();
            if (c == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.checkVersion(6, "Variable annotation syntax is", this.factory.createAnnAssignment(this.setExprContext(a, ExprContextTy.Store), (ExprTy)b2, c, true, startToken.sourceRange.withEnd(endToken.sourceRange)));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        a = this._tmp_15_rule();
        if (a != null && (_literal = this.expect(11)) != null && (b2 = this.expression_rule()) != null) {
            Token endToken;
            ExprTy c = this._tmp_16_rule();
            if (c == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.checkVersion(6, "Variable annotations syntax is", this.factory.createAnnAssignment(a, (ExprTy)b2, c, false, startToken.sourceRange.withEnd(endToken.sourceRange)));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        ExprTy[] a2 = this._loop1_17_rule();
        if (a2 != null && (b = this._tmp_18_rule()) != null && this.genLookahead_expect(false, 22)) {
            Token endToken;
            Token tc = this._tmp_19_rule();
            if (tc == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createAssignment(a2, b, this.newTypeComment(tc), startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        boolean _cut_var = false;
        a = this.single_target_rule();
        if (a != null && (b2 = this.augassign_rule()) != null) {
            ExprTy c;
            _cut_var = true;
            if (true && (c = this._tmp_20_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createAugAssignment(a, (OperatorTy)((Object)b2), c, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (StmtTy)_res;
            }
        }
        this.reset(_mark);
        if (_cut_var) {
            return null;
        }
        if (this.callInvalidRules) {
            Object invalid_assignment_var = this.invalid_assignment_rule();
            if (invalid_assignment_var != null) {
                _res = invalid_assignment_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (StmtTy)_res;
    }

    public ExprTy annotated_rhs_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public OperatorTy augassign_rule() {
        int _mark = this.mark();
        OperatorTy _res = null;
        Token _literal = this.expect(36);
        if (_literal != null) {
            _res = OperatorTy.Add;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(37);
        if (_literal != null) {
            _res = OperatorTy.Sub;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(38);
        if (_literal != null) {
            _res = OperatorTy.Mult;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(50);
        if (_literal != null) {
            _res = this.checkVersion(5, "The '@' operator is", OperatorTy.MatMult);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(39);
        if (_literal != null) {
            _res = OperatorTy.Div;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(40);
        if (_literal != null) {
            _res = OperatorTy.Mod;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(41);
        if (_literal != null) {
            _res = OperatorTy.BitAnd;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(42);
        if (_literal != null) {
            _res = OperatorTy.BitOr;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(43);
        if (_literal != null) {
            _res = OperatorTy.BitXor;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(44);
        if (_literal != null) {
            _res = OperatorTy.LShift;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(45);
        if (_literal != null) {
            _res = OperatorTy.RShift;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(46);
        if (_literal != null) {
            _res = OperatorTy.Pow;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(48);
        if (_literal != null) {
            _res = OperatorTy.FloorDiv;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy return_stmt_rule() {
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(655);
        if (_keyword != null) {
            Token endToken;
            ExprTy a = this._tmp_21_rule();
            if (a == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createReturn(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy raise_stmt_rule() {
        ExprTy a;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(658);
        if (_keyword != null && (a = this.expression_rule()) != null) {
            Token endToken;
            ExprTy b = this._tmp_22_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createRaise(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(658);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createRaise(null, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy global_stmt_rule() {
        ExprTy[] a;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(665);
        if (_keyword != null && (a = this._gather_23_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGlobal(Parser.extractNames(a), startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy nonlocal_stmt_rule() {
        ExprTy[] a;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(666);
        if (_keyword != null && (a = this._gather_25_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createNonLocal(Parser.extractNames(a), startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy del_stmt_rule() {
        ExprTy[] a;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(660);
        if (_keyword != null && (a = this.del_targets_rule()) != null && this.genLookahead__tmp_27_rule(true)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createDelete(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            ExprTy invalid_del_stmt_var = this.invalid_del_stmt_rule();
            if (invalid_del_stmt_var != null) {
                _res = invalid_del_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy yield_stmt_rule() {
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy y = this.yield_expr_rule();
        if (y != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createExpression(y, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy assert_stmt_rule() {
        ExprTy a;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(662);
        if (_keyword != null && (a = this.expression_rule()) != null) {
            Token endToken;
            ExprTy b = this._tmp_28_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createAssert(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy import_stmt_rule() {
        StmtTy import_name_var;
        int _mark = this.mark();
        Object _res = null;
        if (this.callInvalidRules) {
            ExprTy[] invalid_import_var = this.invalid_import_rule();
            if (invalid_import_var != null) {
                _res = invalid_import_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((import_name_var = this.import_name_rule()) != null) {
            _res = import_name_var;
            return (StmtTy)_res;
        }
        this.reset(_mark);
        StmtTy import_from_var = this.import_from_rule();
        if (import_from_var != null) {
            _res = import_from_var;
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy import_name_rule() {
        AliasTy[] a;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(656);
        if (_keyword != null && (a = this.dotted_as_names_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createImport(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy import_from_rule() {
        AliasTy[] c;
        Token _keyword_1;
        AliasTy[] b;
        Token[] a;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(657);
        if (_keyword != null && (a = this._loop0_29_rule()) != null && (b = this.dotted_name_rule()) != null && (_keyword_1 = this.expect(656)) != null && (c = this.import_from_targets_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createImportFrom(((ExprTy.Name)b).id, c, this.countDots(a), startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(657);
        if (_keyword != null && (a = this._loop1_30_rule()) != null && (_keyword_1 = this.expect(656)) != null && (b = this.import_from_targets_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createImportFrom(null, b, this.countDots(a), startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AliasTy[] import_from_targets_rule() {
        AliasTy[] a;
        int _mark = this.mark();
        AliasTy[] _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(7);
        if (_literal != null && (a = this.import_from_as_names_rule()) != null) {
            Token _literal_1;
            Token _opt_var = this._tmp_31_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                _res = a;
                return _res;
            }
        }
        this.reset(_mark);
        AliasTy[] import_from_as_names_var = this.import_from_as_names_rule();
        if (import_from_as_names_var != null && this.genLookahead_expect(false, 12)) {
            _res = import_from_as_names_var;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = new AliasTy[]{this.factory.createAlias("*", null, startToken.sourceRange.withEnd(endToken.sourceRange))};
            return _res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            AliasTy[] invalid_import_from_targets_var = this.invalid_import_from_targets_rule();
            if (invalid_import_from_targets_var != null) {
                _res = invalid_import_from_targets_var;
                return _res;
            }
            this.reset(_mark);
        }
        _res = null;
        return _res;
    }

    public AliasTy[] import_from_as_names_rule() {
        int _mark = this.mark();
        AliasTy[] _res = null;
        AliasTy[] a = this._gather_32_rule();
        if (a != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AliasTy import_from_as_name_rule() {
        int _mark = this.mark();
        AliasTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a = this.name_token();
        if (a != null) {
            Token endToken;
            ExprTy b = this._tmp_34_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createAlias(a.id, b == null ? null : ((ExprTy.Name)b).id, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AliasTy[] dotted_as_names_rule() {
        int _mark = this.mark();
        AliasTy[] _res = null;
        AliasTy[] a = this._gather_35_rule();
        if (a != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AliasTy dotted_as_name_rule() {
        int _mark = this.mark();
        AliasTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.dotted_name_rule();
        if (a != null) {
            Token endToken;
            ExprTy b = this._tmp_37_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createAlias(((ExprTy.Name)a).id, b == null ? null : ((ExprTy.Name)b).id, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy dotted_name_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1028)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1028);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1028, _res);
            this.reset(_mark);
            ExprTy _raw = this.dotted_name_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy dotted_name_raw() {
        ExprTy.Name b;
        Token _literal;
        int _mark = this.mark();
        SSTNode _res = null;
        ExprTy a = this.dotted_name_rule();
        if (a != null && (_literal = this.expect(23)) != null && (b = this.name_token()) != null) {
            _res = this.joinNamesWithDot(a, b);
            return _res;
        }
        this.reset(_mark);
        ExprTy.Name name_var = this.name_token();
        if (name_var != null) {
            _res = name_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] block_rule() {
        Token dedent_var;
        StmtTy[] a;
        Token indent_var;
        int _mark = this.mark();
        StmtTy[] _res = null;
        if (this.cache.hasResult(_mark, 1029)) {
            _res = (StmtTy[])this.cache.getResult(_mark, 1029);
            return _res;
        }
        Token newline_var = this.expect(4);
        if (newline_var != null && (indent_var = this.expect(5)) != null && (a = this.statements_rule()) != null && (dedent_var = this.expect(6)) != null) {
            _res = a;
            this.cache.putResult(_mark, 1029, _res);
            return _res;
        }
        this.reset(_mark);
        StmtTy[] simple_stmts_var = this.simple_stmts_rule();
        if (simple_stmts_var != null) {
            _res = simple_stmts_var;
            this.cache.putResult(_mark, 1029, _res);
            return _res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_block_var = this.invalid_block_rule();
            if (invalid_block_var != null) {
                _res = invalid_block_var;
                this.cache.putResult(_mark, 1029, _res);
                return _res;
            }
            this.reset(_mark);
        }
        _res = null;
        this.cache.putResult(_mark, 1029, _res);
        return _res;
    }

    public ExprTy[] decorators_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] a = this._loop1_38_rule();
        if (a != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy class_def_rule() {
        StmtTy b;
        int _mark = this.mark();
        StmtTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy[] a = this.decorators_rule();
        if (a != null && (b = this.class_def_raw_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createClassDef(b, a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        StmtTy class_def_raw_var = this.class_def_raw_rule();
        if (class_def_raw_var != null) {
            _res = class_def_raw_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy class_def_raw_rule() {
        ExprTy.Name a;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_class_def_raw_var = this.invalid_class_def_raw_rule();
            if (invalid_class_def_raw_var != null) {
                _res = invalid_class_def_raw_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(669)) != null && (a = this.name_token()) != null) {
            StmtTy[] c;
            Token _literal;
            ExprTy b;
            TypeParamTy[] t = this._tmp_39_rule();
            if (t == null) {
                // empty if block
            }
            if ((b = this._tmp_40_rule()) == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (c = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createClassDef(a, b, c, t, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (StmtTy)_res;
            }
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy function_def_rule() {
        StmtTy f;
        int _mark = this.mark();
        StmtTy _res = null;
        ExprTy[] d = this.decorators_rule();
        if (d != null && (f = this.function_def_raw_rule()) != null) {
            _res = this.factory.createFunctionDefWithDecorators(f, d);
            return _res;
        }
        this.reset(_mark);
        StmtTy function_def_raw_var = this.function_def_raw_rule();
        if (function_def_raw_var != null) {
            _res = function_def_raw_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy function_def_raw_rule() {
        ExprTy.Name n;
        Token _literal_2;
        ExprTy a;
        Token _literal_1;
        Token _literal;
        ExprTy.Name n2;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_def_raw_var = this.invalid_def_raw_rule();
            if (invalid_def_raw_var != null) {
                _res = invalid_def_raw_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(667)) != null && (n2 = this.name_token()) != null) {
            TypeParamTy[] t = this._tmp_41_rule();
            if (t == null) {
                // empty if block
            }
            if ((_literal = this.expect_forced_token(7, "(")) != null) {
                ArgumentsTy params = this._tmp_42_rule();
                if (params == null) {
                    // empty if block
                }
                if ((_literal_1 = this.expect(8)) != null) {
                    a = this._tmp_43_rule();
                    if (a == null) {
                        // empty if block
                    }
                    if ((_literal_2 = this.expect_forced_token(11, ":")) != null) {
                        StmtTy[] b;
                        Token tc = this._tmp_44_rule();
                        if (tc == null) {
                            // empty if block
                        }
                        if ((b = this.block_rule()) != null) {
                            Token endToken = this.getLastNonWhitespaceToken();
                            if (endToken == null) {
                                return null;
                            }
                            _res = this.factory.createFunctionDef(n2.id, params == null ? this.factory.emptyArguments() : params, b, a, this.newTypeComment(tc), t, startToken.sourceRange.withEnd(endToken.sourceRange));
                            return (StmtTy)_res;
                        }
                    }
                }
            }
        }
        this.reset(_mark);
        Token async_var = this.expect(57);
        if (async_var != null && (_keyword = this.expect(667)) != null && (n = this.name_token()) != null) {
            TypeParamTy[] t = this._tmp_45_rule();
            if (t == null) {
                // empty if block
            }
            if ((_literal = this.expect_forced_token(7, "(")) != null) {
                ArgumentsTy params = this._tmp_46_rule();
                if (params == null) {
                    // empty if block
                }
                if ((_literal_1 = this.expect(8)) != null) {
                    a = this._tmp_47_rule();
                    if (a == null) {
                        // empty if block
                    }
                    if ((_literal_2 = this.expect_forced_token(11, ":")) != null) {
                        StmtTy[] b;
                        Token tc = this._tmp_48_rule();
                        if (tc == null) {
                            // empty if block
                        }
                        if ((b = this.block_rule()) != null) {
                            Token endToken = this.getLastNonWhitespaceToken();
                            if (endToken == null) {
                                return null;
                            }
                            _res = this.checkVersion(5, "Async functions are", this.factory.createAsyncFunctionDef(n.id, params == null ? this.factory.emptyArguments() : params, b, a, this.newTypeComment(tc), t, startToken.sourceRange.withEnd(endToken.sourceRange)));
                            return (StmtTy)_res;
                        }
                    }
                }
            }
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public ArgumentsTy params_rule() {
        ArgumentsTy parameters_var;
        int _mark = this.mark();
        Object _res = null;
        if (this.callInvalidRules) {
            Object invalid_parameters_var = this.invalid_parameters_rule();
            if (invalid_parameters_var != null) {
                _res = invalid_parameters_var;
                return (ArgumentsTy)_res;
            }
            this.reset(_mark);
        }
        if ((parameters_var = this.parameters_rule()) != null) {
            _res = parameters_var;
            return (ArgumentsTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (ArgumentsTy)_res;
    }

    public ArgumentsTy parameters_rule() {
        Object c;
        Object b;
        int _mark = this.mark();
        ArgumentsTy _res = null;
        Object a = this.slash_no_default_rule();
        if (a != null && (b = this._loop0_49_rule()) != null && (c = this._loop0_50_rule()) != null) {
            AbstractParser.StarEtc d = this._tmp_51_rule();
            if (d == null) {
                // empty if block
            }
            _res = this.checkVersion(8, "Positional-only parameters are", this.factory.createArguments((ArgTy[])a, null, (ArgTy[])b, (AbstractParser.NameDefaultPair[])c, d));
            return _res;
        }
        this.reset(_mark);
        a = this.slash_with_default_rule();
        if (a != null && (b = this._loop0_52_rule()) != null) {
            c = this._tmp_53_rule();
            if (c == null) {
                // empty if block
            }
            _res = this.checkVersion(8, "Positional-only parameters are", this.factory.createArguments(null, (AbstractParser.SlashWithDefault)a, null, (AbstractParser.NameDefaultPair[])b, (AbstractParser.StarEtc)c));
            return _res;
        }
        this.reset(_mark);
        a = this._loop1_54_rule();
        if (a != null && (b = this._loop0_55_rule()) != null) {
            c = this._tmp_56_rule();
            if (c == null) {
                // empty if block
            }
            _res = this.factory.createArguments(null, null, (ArgTy[])a, (AbstractParser.NameDefaultPair[])b, (AbstractParser.StarEtc)c);
            return _res;
        }
        this.reset(_mark);
        a = this._loop1_57_rule();
        if (a != null) {
            b = this._tmp_58_rule();
            if (b == null) {
                // empty if block
            }
            _res = this.factory.createArguments(null, null, null, (AbstractParser.NameDefaultPair[])a, (AbstractParser.StarEtc)b);
            return _res;
        }
        this.reset(_mark);
        a = this.star_etc_rule();
        if (a != null) {
            _res = this.factory.createArguments(null, null, null, null, (AbstractParser.StarEtc)a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] slash_no_default_rule() {
        Token _literal_1;
        Token _literal;
        int _mark = this.mark();
        ArgTy[] _res = null;
        ArgTy[] a = this._loop1_59_rule();
        if (a != null && (_literal = this.expect(17)) != null && (_literal_1 = this.expect(12)) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        ArgTy[] a2 = this._loop1_60_rule();
        if (a2 != null && (_literal = this.expect(17)) != null && this.genLookahead_expect(true, 8)) {
            _res = a2;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.SlashWithDefault slash_with_default_rule() {
        AbstractParser.NameDefaultPair[] b;
        Token _literal_1;
        Token _literal;
        AbstractParser.NameDefaultPair[] b2;
        int _mark = this.mark();
        AbstractParser.SlashWithDefault _res = null;
        ArgTy[] a = this._loop0_61_rule();
        if (a != null && (b2 = this._loop1_62_rule()) != null && (_literal = this.expect(17)) != null && (_literal_1 = this.expect(12)) != null) {
            _res = new AbstractParser.SlashWithDefault(a, b2);
            return _res;
        }
        this.reset(_mark);
        ArgTy[] a2 = this._loop0_63_rule();
        if (a2 != null && (b = this._loop1_64_rule()) != null && (_literal = this.expect(17)) != null && this.genLookahead_expect(true, 8)) {
            _res = new AbstractParser.SlashWithDefault(a2, b);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.StarEtc star_etc_rule() {
        Token _literal_1;
        AbstractParser.NameDefaultPair[] b;
        ArgTy a;
        Token _literal;
        int _mark = this.mark();
        Object _res = null;
        if (this.callInvalidRules) {
            Object invalid_star_etc_var = this.invalid_star_etc_rule();
            if (invalid_star_etc_var != null) {
                _res = invalid_star_etc_var;
                return (AbstractParser.StarEtc)_res;
            }
            this.reset(_mark);
        }
        if ((_literal = this.expect(16)) != null && (a = this.param_no_default_rule()) != null && (b = this._loop0_65_rule()) != null) {
            ArgTy c = this._tmp_66_rule();
            if (c == null) {
                // empty if block
            }
            _res = new AbstractParser.StarEtc(a, b, c);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (a = this.param_no_default_star_annotation_rule()) != null && (b = this._loop0_67_rule()) != null) {
            ArgTy c = this._tmp_68_rule();
            if (c == null) {
                // empty if block
            }
            _res = new AbstractParser.StarEtc(a, b, c);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (_literal_1 = this.expect(12)) != null && (b = this._loop1_69_rule()) != null) {
            ArgTy c = this._tmp_70_rule();
            if (c == null) {
                // empty if block
            }
            _res = new AbstractParser.StarEtc(null, b, c);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        ArgTy a2 = this.kwds_rule();
        if (a2 != null) {
            _res = new AbstractParser.StarEtc(null, null, a2);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        _res = null;
        return (AbstractParser.StarEtc)_res;
    }

    public ArgTy kwds_rule() {
        ArgTy a;
        Token _literal;
        int _mark = this.mark();
        ArgTy _res = null;
        if (this.callInvalidRules) {
            ArgTy invalid_kwds_var = this.invalid_kwds_rule();
            if (invalid_kwds_var != null) {
                _res = invalid_kwds_var;
                return _res;
            }
            this.reset(_mark);
        }
        if ((_literal = this.expect(35)) != null && (a = this.param_no_default_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy param_no_default_rule() {
        Token _literal;
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy a = this.param_rule();
        if (a != null && (_literal = this.expect(12)) != null) {
            Token tc = this.expect(59);
            if (tc == null) {
                // empty if block
            }
            _res = this.factory.createArgument(a.arg, a.annotation, this.newTypeComment(tc), a.getSourceRange());
            return _res;
        }
        this.reset(_mark);
        ArgTy a2 = this.param_rule();
        if (a2 != null) {
            Token tc = this.expect(59);
            if (tc == null) {
                // empty if block
            }
            if (this.genLookahead_expect(true, 8)) {
                _res = this.factory.createArgument(a2.arg, a2.annotation, this.newTypeComment(tc), a2.getSourceRange());
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy param_no_default_star_annotation_rule() {
        Token _literal;
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy a = this.param_star_annotation_rule();
        if (a != null && (_literal = this.expect(12)) != null) {
            Token tc = this.expect(59);
            if (tc == null) {
                // empty if block
            }
            _res = this.factory.createArgument(a.arg, a.annotation, this.newTypeComment(tc), a.getSourceRange());
            return _res;
        }
        this.reset(_mark);
        ArgTy a2 = this.param_star_annotation_rule();
        if (a2 != null) {
            Token tc = this.expect(59);
            if (tc == null) {
                // empty if block
            }
            if (this.genLookahead_expect(true, 8)) {
                _res = this.factory.createArgument(a2.arg, a2.annotation, this.newTypeComment(tc), a2.getSourceRange());
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair param_with_default_rule() {
        ExprTy c;
        Token _literal;
        ExprTy c2;
        int _mark = this.mark();
        AbstractParser.NameDefaultPair _res = null;
        ArgTy a = this.param_rule();
        if (a != null && (c2 = this.default_rule()) != null && (_literal = this.expect(12)) != null) {
            Token tc = this.expect(59);
            if (tc == null) {
                // empty if block
            }
            _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a.arg, a.annotation, this.newTypeComment(tc), a.getSourceRange()), c2);
            return _res;
        }
        this.reset(_mark);
        ArgTy a2 = this.param_rule();
        if (a2 != null && (c = this.default_rule()) != null) {
            Token tc = this.expect(59);
            if (tc == null) {
                // empty if block
            }
            if (this.genLookahead_expect(true, 8)) {
                _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a2.arg, a2.annotation, this.newTypeComment(tc), a2.getSourceRange()), c);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair param_maybe_default_rule() {
        int _mark = this.mark();
        AbstractParser.NameDefaultPair _res = null;
        ArgTy a = this.param_rule();
        if (a != null) {
            Token _literal;
            ExprTy c = this.default_rule();
            if (c == null) {
                // empty if block
            }
            if ((_literal = this.expect(12)) != null) {
                Token tc = this.expect(59);
                if (tc == null) {
                    // empty if block
                }
                _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a.arg, a.annotation, this.newTypeComment(tc), a.getSourceRange()), c);
                return _res;
            }
        }
        this.reset(_mark);
        ArgTy a2 = this.param_rule();
        if (a2 != null) {
            Token tc;
            ExprTy c = this.default_rule();
            if (c == null) {
                // empty if block
            }
            if ((tc = this.expect(59)) == null) {
                // empty if block
            }
            if (this.genLookahead_expect(true, 8)) {
                _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a2.arg, a2.annotation, this.newTypeComment(tc), a2.getSourceRange()), c);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy param_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a = this.name_token();
        if (a != null) {
            Token endToken;
            ExprTy b = this.annotation_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createArgument(a.id, b, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy param_star_annotation_rule() {
        ExprTy b;
        int _mark = this.mark();
        ArgTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a = this.name_token();
        if (a != null && (b = this.star_annotation_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createArgument(a.id, b, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy annotation_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(11);
        if (_literal != null && (a = this.expression_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy star_annotation_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(11);
        if (_literal != null && (a = this.star_expression_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy default_rule() {
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        Token _literal = this.expect(22);
        if (_literal != null && (a = this.expression_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_default_var = this.invalid_default_rule();
            if (invalid_default_var != null) {
                _res = invalid_default_var;
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return _res;
    }

    public StmtTy if_stmt_rule() {
        StmtTy[] c;
        StmtTy[] b;
        Token _literal;
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            ExprTy invalid_if_stmt_var = this.invalid_if_stmt_rule();
            if (invalid_if_stmt_var != null) {
                _res = invalid_if_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(668)) != null && (a = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (b = this.block_rule()) != null && (c = this.elif_stmt_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createIf(a, b, new StmtTy[]{c}, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _keyword = this.expect(668);
        if (_keyword != null && (a = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (b = this.block_rule()) != null) {
            Token endToken;
            c = this._tmp_71_rule();
            if (c == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createIf(a, b, c, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy elif_stmt_rule() {
        StmtTy[] c;
        StmtTy[] b;
        Token _literal;
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            ExprTy invalid_elif_stmt_var = this.invalid_elif_stmt_rule();
            if (invalid_elif_stmt_var != null) {
                _res = invalid_elif_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(675)) != null && (a = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (b = this.block_rule()) != null && (c = this.elif_stmt_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createIf(a, b, new StmtTy[]{c}, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _keyword = this.expect(675);
        if (_keyword != null && (a = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (b = this.block_rule()) != null) {
            Token endToken;
            c = this._tmp_72_rule();
            if (c == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createIf(a, b, c, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy[] else_block_rule() {
        StmtTy[] b;
        Token _literal;
        Token _keyword;
        int _mark = this.mark();
        StmtTy[] _res = null;
        if (this.callInvalidRules) {
            StmtTy[] invalid_else_stmt_var = this.invalid_else_stmt_rule();
            if (invalid_else_stmt_var != null) {
                _res = invalid_else_stmt_var;
                return _res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(676)) != null && (_literal = this.expect_forced_token(11, ":")) != null && (b = this.block_rule()) != null) {
            _res = b;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy while_stmt_rule() {
        StmtTy[] b;
        Token _literal;
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            ExprTy invalid_while_stmt_var = this.invalid_while_stmt_rule();
            if (invalid_while_stmt_var != null) {
                _res = invalid_while_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(673)) != null && (a = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (b = this.block_rule()) != null) {
            Token endToken;
            StmtTy[] c = this._tmp_73_rule();
            if (c == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createWhile(a, b, c, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy for_stmt_rule() {
        ExprTy t;
        Token _literal;
        Token _keyword_1;
        ExprTy t2;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            ExprTy invalid_for_stmt_var = this.invalid_for_stmt_rule();
            if (invalid_for_stmt_var != null) {
                _res = invalid_for_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        boolean _cut_var = false;
        Token _keyword = this.expect(671);
        if (_keyword != null && (t2 = this.star_targets_rule()) != null && (_keyword_1 = this.expect(677)) != null) {
            ExprTy ex;
            _cut_var = true;
            if (true && (ex = this.star_expressions_rule()) != null && (_literal = this.expect(11)) != null) {
                StmtTy[] b;
                Token tc = this._tmp_74_rule();
                if (tc == null) {
                    // empty if block
                }
                if ((b = this.block_rule()) != null) {
                    Token endToken;
                    StmtTy[] el = this._tmp_75_rule();
                    if (el == null) {
                        // empty if block
                    }
                    if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                        return null;
                    }
                    _res = this.factory.createFor(t2, ex, b, el, this.newTypeComment(tc), startToken.sourceRange.withEnd(endToken.sourceRange));
                    return (StmtTy)_res;
                }
            }
        }
        this.reset(_mark);
        if (_cut_var) {
            return null;
        }
        _cut_var = false;
        Token async_var = this.expect(57);
        if (async_var != null && (_keyword = this.expect(671)) != null && (t = this.star_targets_rule()) != null && (_keyword_1 = this.expect(677)) != null) {
            ExprTy ex;
            _cut_var = true;
            if (true && (ex = this.star_expressions_rule()) != null && (_literal = this.expect(11)) != null) {
                StmtTy[] b;
                Token tc = this._tmp_76_rule();
                if (tc == null) {
                    // empty if block
                }
                if ((b = this.block_rule()) != null) {
                    Token endToken;
                    StmtTy[] el = this._tmp_77_rule();
                    if (el == null) {
                        // empty if block
                    }
                    if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                        return null;
                    }
                    _res = this.checkVersion(5, "Async for loops are", this.factory.createAsyncFor(t, ex, b, el, this.newTypeComment(tc), startToken.sourceRange.withEnd(endToken.sourceRange)));
                    return (StmtTy)_res;
                }
            }
        }
        this.reset(_mark);
        if (_cut_var) {
            return null;
        }
        if (this.callInvalidRules) {
            ExprTy invalid_for_target_var = this.invalid_for_target_rule();
            if (invalid_for_target_var != null) {
                _res = invalid_for_target_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (StmtTy)_res;
    }

    public StmtTy with_stmt_rule() {
        WithItemTy[] a;
        Token _literal_2;
        Token _literal_1;
        Token _opt_var;
        WithItemTy[] a2;
        Token _literal;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object[] invalid_with_stmt_indent_var = this.invalid_with_stmt_indent_rule();
            if (invalid_with_stmt_indent_var != null) {
                _res = invalid_with_stmt_indent_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(670)) != null && (_literal = this.expect(7)) != null && (a2 = this._gather_78_rule()) != null) {
            StmtTy[] b;
            _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null && (_literal_2 = this.expect(11)) != null && (b = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createWith(a2, b, null, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (StmtTy)_res;
            }
        }
        this.reset(_mark);
        _keyword = this.expect(670);
        if (_keyword != null && (a = this._gather_80_rule()) != null && (_literal = this.expect(11)) != null) {
            StmtTy[] b;
            Token tc = this._tmp_82_rule();
            if (tc == null) {
                // empty if block
            }
            if ((b = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createWith(a, b, this.newTypeComment(tc), startToken.sourceRange.withEnd(endToken.sourceRange));
                return (StmtTy)_res;
            }
        }
        this.reset(_mark);
        Token async_var = this.expect(57);
        if (async_var != null && (_keyword = this.expect(670)) != null && (_literal = this.expect(7)) != null && (a2 = this._gather_83_rule()) != null) {
            StmtTy[] b;
            _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null && (_literal_2 = this.expect(11)) != null && (b = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.checkVersion(5, "Async with statements are", this.factory.createAsyncWith(a2, b, null, startToken.sourceRange.withEnd(endToken.sourceRange)));
                return (StmtTy)_res;
            }
        }
        this.reset(_mark);
        Token async_var2 = this.expect(57);
        if (async_var2 != null && (_keyword = this.expect(670)) != null && (a = this._gather_85_rule()) != null && (_literal = this.expect(11)) != null) {
            StmtTy[] b;
            Token tc = this._tmp_87_rule();
            if (tc == null) {
                // empty if block
            }
            if ((b = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.checkVersion(5, "Async with statements are", this.factory.createAsyncWith(a, b, this.newTypeComment(tc), startToken.sourceRange.withEnd(endToken.sourceRange)));
                return (StmtTy)_res;
            }
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object[] invalid_with_stmt_var = this.invalid_with_stmt_rule();
            if (invalid_with_stmt_var != null) {
                _res = invalid_with_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (StmtTy)_res;
    }

    public WithItemTy with_item_rule() {
        ExprTy e;
        ExprTy t;
        Token _keyword;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy e2 = this.expression_rule();
        if (e2 != null && (_keyword = this.expect(674)) != null && (t = this.star_target_rule()) != null && this.genLookahead__tmp_88_rule(true)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createWithItem(e2, t, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (WithItemTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            ExprTy invalid_with_item_var = this.invalid_with_item_rule();
            if (invalid_with_item_var != null) {
                _res = invalid_with_item_var;
                return (WithItemTy)_res;
            }
            this.reset(_mark);
        }
        if ((e = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createWithItem(e, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (WithItemTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (WithItemTy)_res;
    }

    public StmtTy try_stmt_rule() {
        StmtTy[] el;
        ExceptHandlerTy[] ex;
        StmtTy[] f;
        StmtTy[] b;
        Token _literal;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_try_stmt_var = this.invalid_try_stmt_rule();
            if (invalid_try_stmt_var != null) {
                _res = invalid_try_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(672)) != null && (_literal = this.expect_forced_token(11, ":")) != null && (b = this.block_rule()) != null && (f = this.finally_block_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createTry(b, null, null, f, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _keyword = this.expect(672);
        if (_keyword != null && (_literal = this.expect_forced_token(11, ":")) != null && (b = this.block_rule()) != null && (ex = this._loop1_89_rule()) != null) {
            Token endToken;
            StmtTy[] f2;
            el = this._tmp_90_rule();
            if (el == null) {
                // empty if block
            }
            if ((f2 = this._tmp_91_rule()) == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTry(b, ex, el, f2, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _keyword = this.expect(672);
        if (_keyword != null && (_literal = this.expect_forced_token(11, ":")) != null && (b = this.block_rule()) != null && (ex = this._loop1_92_rule()) != null) {
            Token endToken;
            StmtTy[] f3;
            el = this._tmp_93_rule();
            if (el == null) {
                // empty if block
            }
            if ((f3 = this._tmp_94_rule()) == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.checkVersion(10, "Pattern matching is", this.factory.createTryStar(b, ex, el, f3, startToken.sourceRange.withEnd(endToken.sourceRange)));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (StmtTy)_res;
    }

    public ExceptHandlerTy except_block_rule() {
        StmtTy[] b;
        Token _literal;
        ExprTy e;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_except_stmt_indent_var = this.invalid_except_stmt_indent_rule();
            if (invalid_except_stmt_indent_var != null) {
                _res = invalid_except_stmt_indent_var;
                return (ExceptHandlerTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(678)) != null && (e = this.expression_rule()) != null) {
            ExprTy t = this._tmp_95_rule();
            if (t == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (b = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createExceptHandler(e, t != null ? ((ExprTy.Name)t).id : null, b, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (ExceptHandlerTy)_res;
            }
        }
        this.reset(_mark);
        _keyword = this.expect(678);
        if (_keyword != null && (_literal = this.expect(11)) != null && (b = this.block_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createExceptHandler(null, null, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (ExceptHandlerTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_except_stmt_var = this.invalid_except_stmt_rule();
            if (invalid_except_stmt_var != null) {
                _res = invalid_except_stmt_var;
                return (ExceptHandlerTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExceptHandlerTy)_res;
    }

    public ExceptHandlerTy except_star_block_rule() {
        ExprTy e;
        Token _literal;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_except_star_stmt_indent_var = this.invalid_except_star_stmt_indent_rule();
            if (invalid_except_star_stmt_indent_var != null) {
                _res = invalid_except_star_stmt_indent_var;
                return (ExceptHandlerTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(678)) != null && (_literal = this.expect(16)) != null && (e = this.expression_rule()) != null) {
            StmtTy[] b;
            Token _literal_1;
            ExprTy t = this._tmp_96_rule();
            if (t == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(11)) != null && (b = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createExceptHandler(e, t != null ? ((ExprTy.Name)t).id : null, b, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (ExceptHandlerTy)_res;
            }
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_except_stmt_var = this.invalid_except_stmt_rule();
            if (invalid_except_stmt_var != null) {
                _res = invalid_except_stmt_var;
                return (ExceptHandlerTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExceptHandlerTy)_res;
    }

    public StmtTy[] finally_block_rule() {
        StmtTy[] a;
        Token _literal;
        Token _keyword;
        int _mark = this.mark();
        StmtTy[] _res = null;
        if (this.callInvalidRules) {
            StmtTy[] invalid_finally_stmt_var = this.invalid_finally_stmt_rule();
            if (invalid_finally_stmt_var != null) {
                _res = invalid_finally_stmt_var;
                return _res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect(679)) != null && (_literal = this.expect_forced_token(11, ":")) != null && (a = this.block_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy match_stmt_rule() {
        Token dedent_var;
        MatchCaseTy[] cases;
        Token indent_var;
        Token newline_var;
        Token _literal;
        ExprTy subject;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name _keyword = this.expect_SOFT_KEYWORD("match");
        if (_keyword != null && (subject = this.subject_expr_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && (indent_var = this.expect(5)) != null && (cases = this._loop1_97_rule()) != null && (dedent_var = this.expect(6)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.checkVersion(10, "Pattern matching is", this.factory.createMatch(subject, cases, startToken.sourceRange.withEnd(endToken.sourceRange)));
            return (StmtTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            ExprTy invalid_match_stmt_var = this.invalid_match_stmt_rule();
            if (invalid_match_stmt_var != null) {
                _res = invalid_match_stmt_var;
                return (StmtTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (StmtTy)_res;
    }

    public ExprTy subject_expr_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy value = this.star_named_expression_rule();
        if (value != null && (_literal = this.expect(12)) != null) {
            Token endToken;
            ExprTy[] values = this.star_named_expressions_rule();
            if (values == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTuple(this.insertInFront(value, values), ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy named_expression_var = this.named_expression_rule();
        if (named_expression_var != null) {
            _res = named_expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public MatchCaseTy case_block_rule() {
        PatternTy pattern;
        ExprTy.Name _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_case_block_var = this.invalid_case_block_rule();
            if (invalid_case_block_var != null) {
                _res = invalid_case_block_var;
                return (MatchCaseTy)_res;
            }
            this.reset(_mark);
        }
        if ((_keyword = this.expect_SOFT_KEYWORD("case")) != null && (pattern = this.patterns_rule()) != null) {
            StmtTy[] body;
            Token _literal;
            ExprTy guard = this.guard_rule();
            if (guard == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (body = this.block_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchCase(pattern, guard, body, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (MatchCaseTy)_res;
            }
        }
        this.reset(_mark);
        _res = null;
        return (MatchCaseTy)_res;
    }

    public ExprTy guard_rule() {
        ExprTy guard;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _keyword = this.expect(668);
        if (_keyword != null && (guard = this.named_expression_rule()) != null) {
            _res = guard;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy patterns_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        PatternTy[] patterns = this.open_sequence_pattern_rule();
        if (patterns != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchSequence(patterns, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        PatternTy pattern_var = this.pattern_rule();
        if (pattern_var != null) {
            _res = pattern_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        PatternTy as_pattern_var = this.as_pattern_rule();
        if (as_pattern_var != null) {
            _res = as_pattern_var;
            return _res;
        }
        this.reset(_mark);
        PatternTy or_pattern_var = this.or_pattern_rule();
        if (or_pattern_var != null) {
            _res = or_pattern_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy as_pattern_rule() {
        ExprTy target;
        Token _keyword;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        PatternTy pattern = this.or_pattern_rule();
        if (pattern != null && (_keyword = this.expect(674)) != null && (target = this.pattern_capture_target_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchAs(pattern, ((ExprTy.Name)target).id, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (PatternTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_as_pattern_var = this.invalid_as_pattern_rule();
            if (invalid_as_pattern_var != null) {
                _res = invalid_as_pattern_var;
                return (PatternTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (PatternTy)_res;
    }

    public PatternTy or_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        PatternTy[] patterns = this._gather_98_rule();
        if (patterns != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = patterns.length == 1 ? patterns[0] : this.factory.createMatchOr(patterns, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy closed_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        if (this.cache.hasResult(_mark, 1069)) {
            _res = (PatternTy)this.cache.getResult(_mark, 1069);
            return _res;
        }
        PatternTy literal_pattern_var = this.literal_pattern_rule();
        if (literal_pattern_var != null) {
            _res = literal_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy capture_pattern_var = this.capture_pattern_rule();
        if (capture_pattern_var != null) {
            _res = capture_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy wildcard_pattern_var = this.wildcard_pattern_rule();
        if (wildcard_pattern_var != null) {
            _res = wildcard_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy value_pattern_var = this.value_pattern_rule();
        if (value_pattern_var != null) {
            _res = value_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy group_pattern_var = this.group_pattern_rule();
        if (group_pattern_var != null) {
            _res = group_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy sequence_pattern_var = this.sequence_pattern_rule();
        if (sequence_pattern_var != null) {
            _res = sequence_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy mapping_pattern_var = this.mapping_pattern_rule();
        if (mapping_pattern_var != null) {
            _res = mapping_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        PatternTy class_pattern_var = this.class_pattern_rule();
        if (class_pattern_var != null) {
            _res = class_pattern_var;
            this.cache.putResult(_mark, 1069, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1069, _res);
        return _res;
    }

    public PatternTy literal_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy value = this.signed_number_rule();
        if (value != null && this.genLookahead__tmp_100_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchValue(value, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        value = this.complex_number_rule();
        if (value != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchValue(value, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        value = this.strings_rule();
        if (value != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchValue(value, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        Token _keyword = this.expect(680);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchSingleton(ConstantValue.NONE, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(681);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchSingleton(ConstantValue.TRUE, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(682);
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchSingleton(ConstantValue.FALSE, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy literal_expr_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy signed_number_var = this.signed_number_rule();
        if (signed_number_var != null && this.genLookahead__tmp_101_rule(false)) {
            _res = signed_number_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy complex_number_var = this.complex_number_rule();
        if (complex_number_var != null) {
            _res = complex_number_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy strings_var = this.strings_rule();
        if (strings_var != null) {
            _res = strings_var;
            return _res;
        }
        this.reset(_mark);
        Token _keyword = this.expect(680);
        if (_keyword != null) {
            _res = this.factory.createNone(startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(681);
        if (_keyword != null) {
            _res = this.factory.createBooleanLiteral(true, startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(682);
        if (_keyword != null) {
            _res = this.factory.createBooleanLiteral(false, startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy complex_number_rule() {
        ExprTy imag;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy real = this.signed_real_number_rule();
        if (real != null && (_literal = this.expect(14)) != null && (imag = this.imaginary_number_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Add, real, imag, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        real = this.signed_real_number_rule();
        if (real != null && (_literal = this.expect(15)) != null && (imag = this.imaginary_number_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Sub, real, imag, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy signed_number_rule() {
        ExprTy number;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy number_var = this.number_token();
        if (number_var != null) {
            _res = number_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(15);
        if (_literal != null && (number = this.number_token()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createUnaryOp(UnaryOpTy.USub, number, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy signed_real_number_rule() {
        ExprTy real;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy real_number_var = this.real_number_rule();
        if (real_number_var != null) {
            _res = real_number_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(15);
        if (_literal != null && (real = this.real_number_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createUnaryOp(UnaryOpTy.USub, real, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy real_number_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy real = this.number_token();
        if (real != null) {
            _res = this.ensureReal(real);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy imaginary_number_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy imag = this.number_token();
        if (imag != null) {
            _res = this.ensureImaginary(imag);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy capture_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy target = this.pattern_capture_target_rule();
        if (target != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchAs(null, ((ExprTy.Name)target).id, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy pattern_capture_target_rule() {
        ExprTy.Name name;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.genLookahead_expect_SOFT_KEYWORD(false, "_") && (name = this.name_token()) != null && this.genLookahead__tmp_102_rule(false)) {
            _res = this.setExprContext(name, ExprContextTy.Store);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy wildcard_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name _keyword = this.expect_SOFT_KEYWORD("_");
        if (_keyword != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchAs(null, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy value_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy attr = this.attr_rule();
        if (attr != null && this.genLookahead__tmp_103_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchValue(attr, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy attr_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1081)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1081);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1081, _res);
            this.reset(_mark);
            ExprTy _raw = this.attr_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy attr_raw() {
        ExprTy.Name attr;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy value = this.name_or_attr_rule();
        if (value != null && (_literal = this.expect(23)) != null && (attr = this.name_token()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGetAttribute(value, attr.id, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy name_or_attr_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy attr_var = this.attr_rule();
        if (attr_var != null) {
            _res = attr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy.Name name_var = this.name_token();
        if (name_var != null) {
            _res = name_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy group_pattern_rule() {
        Token _literal_1;
        PatternTy pattern;
        int _mark = this.mark();
        PatternTy _res = null;
        Token _literal = this.expect(7);
        if (_literal != null && (pattern = this.pattern_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = pattern;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy sequence_pattern_rule() {
        Token _literal_1;
        PatternTy[] patterns;
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(9);
        if (_literal != null) {
            patterns = this.maybe_sequence_pattern_rule();
            if (patterns == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(10)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchSequence(patterns, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null) {
            patterns = this.open_sequence_pattern_rule();
            if (patterns == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchSequence(patterns, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy[] open_sequence_pattern_rule() {
        Token _literal;
        int _mark = this.mark();
        PatternTy[] _res = null;
        PatternTy pattern = this.maybe_star_pattern_rule();
        if (pattern != null && (_literal = this.expect(12)) != null) {
            PatternTy[] patterns = this.maybe_sequence_pattern_rule();
            if (patterns == null) {
                // empty if block
            }
            _res = this.insertInFront(pattern, patterns);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy[] maybe_sequence_pattern_rule() {
        int _mark = this.mark();
        PatternTy[] _res = null;
        PatternTy[] patterns = this._gather_104_rule();
        if (patterns != null) {
            Token _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            _res = patterns;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy maybe_star_pattern_rule() {
        int _mark = this.mark();
        PatternTy _res = null;
        PatternTy star_pattern_var = this.star_pattern_rule();
        if (star_pattern_var != null) {
            _res = star_pattern_var;
            return _res;
        }
        this.reset(_mark);
        PatternTy pattern_var = this.pattern_rule();
        if (pattern_var != null) {
            _res = pattern_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy star_pattern_rule() {
        PatternTy wildcard_pattern_var;
        ExprTy target;
        int _mark = this.mark();
        PatternTy _res = null;
        if (this.cache.hasResult(_mark, 1088)) {
            _res = (PatternTy)this.cache.getResult(_mark, 1088);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(16);
        if (_literal != null && (target = this.pattern_capture_target_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchStar(((ExprTy.Name)target).id, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1088, _res);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (wildcard_pattern_var = this.wildcard_pattern_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchStar(null, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1088, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1088, _res);
        return _res;
    }

    public PatternTy mapping_pattern_rule() {
        AbstractParser.KeyPatternPair[] items;
        ExprTy rest;
        AbstractParser.KeyPatternPair[] items2;
        Token _opt_var;
        ExprTy rest2;
        Token _literal_1;
        int _mark = this.mark();
        PatternTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(25);
        if (_literal != null && (_literal_1 = this.expect(26)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchMapping(null, null, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (rest2 = this.double_star_pattern_rule()) != null) {
            _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(26)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchMapping(null, null, ((ExprTy.Name)rest2).id, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (items2 = this.items_pattern_rule()) != null && (_literal_1 = this.expect(12)) != null && (rest = this.double_star_pattern_rule()) != null) {
            Token _literal_2;
            Token _opt_var2 = this.expect(12);
            if (_opt_var2 == null) {
                // empty if block
            }
            if ((_literal_2 = this.expect(26)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchMapping(Parser.extractKeys(items2), Parser.extractPatterns(items2), ((ExprTy.Name)rest).id, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (items = this.items_pattern_rule()) != null) {
            _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(26)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchMapping(Parser.extractKeys(items), Parser.extractPatterns(items), null, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyPatternPair[] items_pattern_rule() {
        int _mark = this.mark();
        AbstractParser.KeyPatternPair[] _res = null;
        AbstractParser.KeyPatternPair[] _gather_106_var = this._gather_106_rule();
        if (_gather_106_var != null) {
            _res = _gather_106_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyPatternPair key_value_pattern_rule() {
        PatternTy pattern;
        Token _literal;
        int _mark = this.mark();
        AbstractParser.KeyPatternPair _res = null;
        ExprTy key = this._tmp_108_rule();
        if (key != null && (_literal = this.expect(11)) != null && (pattern = this.pattern_rule()) != null) {
            _res = new AbstractParser.KeyPatternPair(key, pattern);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy double_star_pattern_rule() {
        ExprTy target;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(35);
        if (_literal != null && (target = this.pattern_capture_target_rule()) != null) {
            _res = target;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy class_pattern_rule() {
        AbstractParser.KeyPatternPair[] keywords;
        PatternTy[] patterns;
        AbstractParser.KeyPatternPair[] keywords2;
        Token _opt_var;
        PatternTy[] patterns2;
        Token _literal_1;
        Token _literal;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy cls = this.name_or_attr_rule();
        if (cls != null && (_literal = this.expect(7)) != null && (_literal_1 = this.expect(8)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createMatchClass(cls, null, null, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy cls2 = this.name_or_attr_rule();
        if (cls2 != null && (_literal = this.expect(7)) != null && (patterns2 = this.positional_patterns_rule()) != null) {
            _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchClass(cls2, patterns2, null, null, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (PatternTy)_res;
            }
        }
        this.reset(_mark);
        cls2 = this.name_or_attr_rule();
        if (cls2 != null && (_literal = this.expect(7)) != null && (keywords2 = this.keyword_patterns_rule()) != null) {
            _opt_var = this.expect(12);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchClass(cls2, null, Parser.extractNames(Parser.extractKeys(keywords2)), Parser.extractPatterns(keywords2), startToken.sourceRange.withEnd(endToken.sourceRange));
                return (PatternTy)_res;
            }
        }
        this.reset(_mark);
        ExprTy cls3 = this.name_or_attr_rule();
        if (cls3 != null && (_literal = this.expect(7)) != null && (patterns = this.positional_patterns_rule()) != null && (_literal_1 = this.expect(12)) != null && (keywords = this.keyword_patterns_rule()) != null) {
            Token _literal_2;
            Token _opt_var2 = this.expect(12);
            if (_opt_var2 == null) {
                // empty if block
            }
            if ((_literal_2 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createMatchClass(cls3, patterns, Parser.extractNames(Parser.extractKeys(keywords)), Parser.extractPatterns(keywords), startToken.sourceRange.withEnd(endToken.sourceRange));
                return (PatternTy)_res;
            }
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_class_pattern_var = this.invalid_class_pattern_rule();
            if (invalid_class_pattern_var != null) {
                _res = invalid_class_pattern_var;
                return (PatternTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return _res;
    }

    public PatternTy[] positional_patterns_rule() {
        int _mark = this.mark();
        PatternTy[] _res = null;
        PatternTy[] args = this._gather_109_rule();
        if (args != null) {
            _res = args;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyPatternPair[] keyword_patterns_rule() {
        int _mark = this.mark();
        AbstractParser.KeyPatternPair[] _res = null;
        AbstractParser.KeyPatternPair[] _gather_111_var = this._gather_111_rule();
        if (_gather_111_var != null) {
            _res = _gather_111_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyPatternPair keyword_pattern_rule() {
        PatternTy value;
        Token _literal;
        int _mark = this.mark();
        AbstractParser.KeyPatternPair _res = null;
        ExprTy.Name arg = this.name_token();
        if (arg != null && (_literal = this.expect(22)) != null && (value = this.pattern_rule()) != null) {
            _res = new AbstractParser.KeyPatternPair(arg, value);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy type_alias_rule() {
        ExprTy.Name n;
        int _mark = this.mark();
        StmtTy.TypeAlias _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name _keyword = this.expect_SOFT_KEYWORD("type");
        if (_keyword != null && (n = this.name_token()) != null) {
            ExprTy b;
            Token _literal;
            TypeParamTy[] t = this._tmp_113_rule();
            if (t == null) {
                // empty if block
            }
            if ((_literal = this.expect(22)) != null && (b = this.expression_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.checkVersion(12, "Type statement is", this.factory.createTypeAlias(this.setExprContext(n, ExprContextTy.Store), t, b, startToken.sourceRange.withEnd(endToken.sourceRange)));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] type_params_rule() {
        Token _literal_1;
        TypeParamTy[] t;
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        Token _literal = this.expect(9);
        if (_literal != null && (t = this.type_param_seq_rule()) != null && (_literal_1 = this.expect(10)) != null) {
            _res = this.checkVersion(12, "Type parameter lists are", t);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] type_param_seq_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] a = this._gather_114_rule();
        if (a != null) {
            Token _opt_var = this._tmp_116_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy type_param_rule() {
        Token endToken;
        ExprTy e;
        Token colon;
        ExprTy.Name a;
        int _mark = this.mark();
        Object _res = null;
        if (this.cache.hasResult(_mark, 1100)) {
            _res = (TypeParamTy)this.cache.getResult(_mark, 1100);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a2 = this.name_token();
        if (a2 != null) {
            Token endToken2;
            ExprTy b = this._tmp_117_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken2 = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTypeVar(a2.id, b, startToken.sourceRange.withEnd(endToken2.sourceRange));
            this.cache.putResult(_mark, 1100, _res);
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(16);
        if (_literal != null && (a = this.name_token()) != null && (colon = this.expect(11)) != null && (e = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorStartingFrom(colon, e instanceof ExprTy.Tuple ? "cannot use constraints with TypeVarTuple" : "cannot use bound with TypeVarTuple", new Object[0]);
            this.cache.putResult(_mark, 1100, _res);
            return (TypeParamTy)_res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (a = this.name_token()) != null) {
            endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createTypeVarTuple(a.id, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1100, _res);
            return (TypeParamTy)_res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (a = this.name_token()) != null && (colon = this.expect(11)) != null && (e = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorStartingFrom(colon, e instanceof ExprTy.Tuple ? "cannot use constraints with ParamSpec" : "cannot use bound with ParamSpec", new Object[0]);
            this.cache.putResult(_mark, 1100, _res);
            return (TypeParamTy)_res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (a = this.name_token()) != null) {
            endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createParamSpec(a.id, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1100, _res);
            return (TypeParamTy)_res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1100, _res);
        return (TypeParamTy)_res;
    }

    public ExprTy type_param_bound_rule() {
        ExprTy e;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(11);
        if (_literal != null && (e = this.expression_rule()) != null) {
            _res = e;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy expressions_rule() {
        Token _literal;
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.expression_rule();
        if (a != null && (b = this._loop1_118_rule()) != null) {
            Token endToken;
            Token _opt_var = this._tmp_119_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTuple(this.insertInFront(a, b), ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.expression_rule();
        if (a != null && (_literal = this.expect(12)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createTuple(new ExprTy[]{a}, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy expression_rule() {
        ExprTy c;
        Token _keyword_1;
        ExprTy b;
        Token _keyword;
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        if (this.cache.hasResult(_mark, 1103)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1103);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_expression_var = this.invalid_expression_rule();
            if (invalid_expression_var != null) {
                _res = invalid_expression_var;
                this.cache.putResult(_mark, 1103, _res);
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        if (this.callInvalidRules) {
            ExprTy invalid_legacy_expression_var = this.invalid_legacy_expression_rule();
            if (invalid_legacy_expression_var != null) {
                _res = invalid_legacy_expression_var;
                this.cache.putResult(_mark, 1103, _res);
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        if ((a = this.disjunction_rule()) != null && (_keyword = this.expect(668)) != null && (b = this.disjunction_rule()) != null && (_keyword_1 = this.expect(676)) != null && (c = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createIfExpression(b, a, c, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1103, _res);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        ExprTy disjunction_var = this.disjunction_rule();
        if (disjunction_var != null) {
            _res = disjunction_var;
            this.cache.putResult(_mark, 1103, _res);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        ExprTy lambdef_var = this.lambdef_rule();
        if (lambdef_var != null) {
            _res = lambdef_var;
            this.cache.putResult(_mark, 1103, _res);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1103, _res);
        return (ExprTy)_res;
    }

    public ExprTy yield_expr_rule() {
        ExprTy a;
        Token _keyword_1;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(661);
        if (_keyword != null && (_keyword_1 = this.expect(657)) != null && (a = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createYield(a, true, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(661);
        if (_keyword != null) {
            Token endToken;
            ExprTy a2 = this._tmp_120_rule();
            if (a2 == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createYield(a2, false, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy star_expressions_rule() {
        Token _literal;
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.star_expression_rule();
        if (a != null && (b = this._loop1_121_rule()) != null) {
            Token endToken;
            Token _opt_var = this._tmp_122_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTuple(this.insertInFront(a, b), ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.star_expression_rule();
        if (a != null && (_literal = this.expect(12)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createTuple(new ExprTy[]{a}, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expression_var = this.star_expression_rule();
        if (star_expression_var != null) {
            _res = star_expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy star_expression_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1106)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1106);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(16);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createStarred(a, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1106, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            _res = expression_var;
            this.cache.putResult(_mark, 1106, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1106, _res);
        return _res;
    }

    public ExprTy[] star_named_expressions_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] a = this._gather_123_rule();
        if (a != null) {
            Token _opt_var = this._tmp_125_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy star_named_expression_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(16);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createStarred(a, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy named_expression_var = this.named_expression_rule();
        if (named_expression_var != null) {
            _res = named_expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy assignment_expression_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy.NamedExpr _res = null;
        Token startToken = this.getAndInitializeToken();
        boolean _cut_var = false;
        ExprTy.Name a = this.name_token();
        if (a != null && (_literal = this.expect(53)) != null) {
            ExprTy b;
            _cut_var = true;
            if (true && (b = this.expression_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.checkVersion(8, "Assignment expressions are", this.factory.createNamedExp(this.setExprContext(a, ExprContextTy.Store), b, startToken.sourceRange.withEnd(endToken.sourceRange)));
                return _res;
            }
        }
        this.reset(_mark);
        if (_cut_var) {
            return null;
        }
        _res = null;
        return _res;
    }

    public ExprTy named_expression_rule() {
        ExprTy expression_var;
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy assignment_expression_var = this.assignment_expression_rule();
        if (assignment_expression_var != null) {
            _res = assignment_expression_var;
            return _res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            ExprTy invalid_named_expression_var = this.invalid_named_expression_rule();
            if (invalid_named_expression_var != null) {
                _res = invalid_named_expression_var;
                return _res;
            }
            this.reset(_mark);
        }
        if ((expression_var = this.expression_rule()) != null && this.genLookahead_expect(false, 53)) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy disjunction_rule() {
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1111)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1111);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.conjunction_rule();
        if (a != null && (b = this._loop1_126_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createOr(this.insertInFront(a, b), startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1111, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy conjunction_var = this.conjunction_rule();
        if (conjunction_var != null) {
            _res = conjunction_var;
            this.cache.putResult(_mark, 1111, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1111, _res);
        return _res;
    }

    public ExprTy conjunction_rule() {
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1112)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1112);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.inversion_rule();
        if (a != null && (b = this._loop1_127_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createAnd(this.insertInFront(a, b), startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1112, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy inversion_var = this.inversion_rule();
        if (inversion_var != null) {
            _res = inversion_var;
            this.cache.putResult(_mark, 1112, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1112, _res);
        return _res;
    }

    public ExprTy inversion_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1113)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1113);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(686);
        if (_keyword != null && (a = this.inversion_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createUnaryOp(UnaryOpTy.Not, a, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1113, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy comparison_var = this.comparison_rule();
        if (comparison_var != null) {
            _res = comparison_var;
            this.cache.putResult(_mark, 1113, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1113, _res);
        return _res;
    }

    public ExprTy comparison_rule() {
        AbstractParser.CmpopExprPair[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.bitwise_or_rule();
        if (a != null && (b = this._loop1_128_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createComparison(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy bitwise_or_var = this.bitwise_or_rule();
        if (bitwise_or_var != null) {
            _res = bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair compare_op_bitwise_or_pair_rule() {
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        AbstractParser.CmpopExprPair eq_bitwise_or_var = this.eq_bitwise_or_rule();
        if (eq_bitwise_or_var != null) {
            _res = eq_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair noteq_bitwise_or_var = this.noteq_bitwise_or_rule();
        if (noteq_bitwise_or_var != null) {
            _res = noteq_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair lte_bitwise_or_var = this.lte_bitwise_or_rule();
        if (lte_bitwise_or_var != null) {
            _res = lte_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair lt_bitwise_or_var = this.lt_bitwise_or_rule();
        if (lt_bitwise_or_var != null) {
            _res = lt_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair gte_bitwise_or_var = this.gte_bitwise_or_rule();
        if (gte_bitwise_or_var != null) {
            _res = gte_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair gt_bitwise_or_var = this.gt_bitwise_or_rule();
        if (gt_bitwise_or_var != null) {
            _res = gt_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair notin_bitwise_or_var = this.notin_bitwise_or_rule();
        if (notin_bitwise_or_var != null) {
            _res = notin_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair in_bitwise_or_var = this.in_bitwise_or_rule();
        if (in_bitwise_or_var != null) {
            _res = in_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair isnot_bitwise_or_var = this.isnot_bitwise_or_rule();
        if (isnot_bitwise_or_var != null) {
            _res = isnot_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.CmpopExprPair is_bitwise_or_var = this.is_bitwise_or_rule();
        if (is_bitwise_or_var != null) {
            _res = is_bitwise_or_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair eq_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _literal = this.expect(27);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.Eq, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair noteq_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _tmp_129_var = this._tmp_129_rule();
        if (_tmp_129_var != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.NotEq, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair lte_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _literal = this.expect(29);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.LtE, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair lt_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _literal = this.expect(20);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.Lt, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair gte_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _literal = this.expect(30);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.GtE, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair gt_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _literal = this.expect(21);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.Gt, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair notin_bitwise_or_rule() {
        ExprTy a;
        Token _keyword_1;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _keyword = this.expect(686);
        if (_keyword != null && (_keyword_1 = this.expect(677)) != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.NotIn, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair in_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _keyword = this.expect(677);
        if (_keyword != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.In, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair isnot_bitwise_or_rule() {
        ExprTy a;
        Token _keyword_1;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _keyword = this.expect(687);
        if (_keyword != null && (_keyword_1 = this.expect(686)) != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.IsNot, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.CmpopExprPair is_bitwise_or_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.CmpopExprPair _res = null;
        Token _keyword = this.expect(687);
        if (_keyword != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.CmpopExprPair(CmpOpTy.Is, a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy bitwise_or_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1126)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1126);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1126, _res);
            this.reset(_mark);
            ExprTy _raw = this.bitwise_or_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy bitwise_or_raw() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.bitwise_or_rule();
        if (a != null && (_literal = this.expect(18)) != null && (b = this.bitwise_xor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.BitOr, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy bitwise_xor_var = this.bitwise_xor_rule();
        if (bitwise_xor_var != null) {
            _res = bitwise_xor_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy bitwise_xor_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1127)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1127);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1127, _res);
            this.reset(_mark);
            ExprTy _raw = this.bitwise_xor_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy bitwise_xor_raw() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.bitwise_xor_rule();
        if (a != null && (_literal = this.expect(32)) != null && (b = this.bitwise_and_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.BitXor, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy bitwise_and_var = this.bitwise_and_rule();
        if (bitwise_and_var != null) {
            _res = bitwise_and_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy bitwise_and_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1128)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1128);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1128, _res);
            this.reset(_mark);
            ExprTy _raw = this.bitwise_and_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy bitwise_and_raw() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.bitwise_and_rule();
        if (a != null && (_literal = this.expect(19)) != null && (b = this.shift_expr_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.BitAnd, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy shift_expr_var = this.shift_expr_rule();
        if (shift_expr_var != null) {
            _res = shift_expr_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy shift_expr_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1129)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1129);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1129, _res);
            this.reset(_mark);
            ExprTy _raw = this.shift_expr_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy shift_expr_raw() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.shift_expr_rule();
        if (a != null && (_literal = this.expect(33)) != null && (b = this.sum_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.LShift, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.shift_expr_rule();
        if (a != null && (_literal = this.expect(34)) != null && (b = this.sum_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.RShift, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy sum_var = this.sum_rule();
        if (sum_var != null) {
            _res = sum_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy sum_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1130)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1130);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1130, _res);
            this.reset(_mark);
            ExprTy _raw = this.sum_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy sum_raw() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.sum_rule();
        if (a != null && (_literal = this.expect(14)) != null && (b = this.term_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Add, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.sum_rule();
        if (a != null && (_literal = this.expect(15)) != null && (b = this.term_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Sub, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy term_var = this.term_rule();
        if (term_var != null) {
            _res = term_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy term_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1131)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1131);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1131, _res);
            this.reset(_mark);
            ExprTy _raw = this.term_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy term_raw() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.term_rule();
        if (a != null && (_literal = this.expect(16)) != null && (b = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Mult, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.term_rule();
        if (a != null && (_literal = this.expect(17)) != null && (b = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Div, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.term_rule();
        if (a != null && (_literal = this.expect(47)) != null && (b = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.FloorDiv, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.term_rule();
        if (a != null && (_literal = this.expect(24)) != null && (b = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Mod, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.term_rule();
        if (a != null && (_literal = this.expect(49)) != null && (b = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.checkVersion(5, "The '@' operator is", this.factory.createBinaryOp(OperatorTy.MatMult, a, b, startToken.sourceRange.withEnd(endToken.sourceRange)));
            return _res;
        }
        this.reset(_mark);
        ExprTy factor_var = this.factor_rule();
        if (factor_var != null) {
            _res = factor_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy factor_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1132)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1132);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(14);
        if (_literal != null && (a = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createUnaryOp(UnaryOpTy.UAdd, a, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1132, _res);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(15);
        if (_literal != null && (a = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createUnaryOp(UnaryOpTy.USub, a, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1132, _res);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(31);
        if (_literal != null && (a = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createUnaryOp(UnaryOpTy.Invert, a, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1132, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy power_var = this.power_rule();
        if (power_var != null) {
            _res = power_var;
            this.cache.putResult(_mark, 1132, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1132, _res);
        return _res;
    }

    public ExprTy power_rule() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.await_primary_rule();
        if (a != null && (_literal = this.expect(35)) != null && (b = this.factor_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createBinaryOp(OperatorTy.Pow, a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy await_primary_var = this.await_primary_rule();
        if (await_primary_var != null) {
            _res = await_primary_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy await_primary_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1134)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1134);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        Token await_var = this.expect(56);
        if (await_var != null && (a = this.primary_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.checkVersion(5, "Await expressions are", this.factory.createAwait(a, startToken.sourceRange.withEnd(endToken.sourceRange)));
            this.cache.putResult(_mark, 1134, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy primary_var = this.primary_rule();
        if (primary_var != null) {
            _res = primary_var;
            this.cache.putResult(_mark, 1134, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1134, _res);
        return _res;
    }

    public ExprTy primary_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1135)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1135);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1135, _res);
            this.reset(_mark);
            ExprTy _raw = this.primary_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy primary_raw() {
        Token _literal_1;
        ExprTy b;
        ExprTy b2;
        ExprTy.Name b3;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.primary_rule();
        if (a != null && (_literal = this.expect(23)) != null && (b3 = this.name_token()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGetAttribute(a, b3.id, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.primary_rule();
        if (a2 != null && (b2 = this.genexp_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createCall(a2, new ExprTy[]{b2}, EMPTY_KEYWORD_ARRAY, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy a3 = this.primary_rule();
        if (a3 != null && (_literal = this.expect(7)) != null) {
            b = this._tmp_130_rule();
            if (b == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createCall(a3, b != null ? ((ExprTy.Call)b).args : EMPTY_EXPR_ARRAY, b != null ? ((ExprTy.Call)b).keywords : EMPTY_KEYWORD_ARRAY, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        a3 = this.primary_rule();
        if (a3 != null && (_literal = this.expect(9)) != null && (b = this.slices_rule()) != null && (_literal_1 = this.expect(10)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSubscript(a3, b, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy atom_var = this.atom_rule();
        if (atom_var != null) {
            _res = atom_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy slices_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.slice_rule();
        if (a != null && this.genLookahead_expect(false, 12)) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        ExprTy[] a2 = this._gather_131_rule();
        if (a2 != null) {
            Token endToken;
            Token _opt_var = this._tmp_133_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTuple(a2, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy slice_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this._tmp_134_rule();
        if (a == null) {
            // empty if block
        }
        if ((_literal = this.expect(11)) != null) {
            Token endToken;
            ExprTy c;
            ExprTy b = this._tmp_135_rule();
            if (b == null) {
                // empty if block
            }
            if ((c = this._tmp_136_rule()) == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createSlice(a, b, c, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.named_expression_rule();
        if (a2 != null) {
            _res = a2;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy atom_rule() {
        ExprTy _tmp_140_var;
        ExprTy _tmp_139_var;
        ExprTy _tmp_138_var;
        ExprTy strings_var;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name name_var = this.name_token();
        if (name_var != null) {
            _res = name_var;
            return _res;
        }
        this.reset(_mark);
        Token _keyword = this.expect(681);
        if (_keyword != null) {
            _res = this.factory.createBooleanLiteral(true, startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(682);
        if (_keyword != null) {
            _res = this.factory.createBooleanLiteral(false, startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(680);
        if (_keyword != null) {
            _res = this.factory.createNone(startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_137_rule(true) && (strings_var = this.strings_rule()) != null) {
            _res = strings_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy number_var = this.number_token();
        if (number_var != null) {
            _res = number_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 7) && (_tmp_138_var = this._tmp_138_rule()) != null) {
            _res = _tmp_138_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 9) && (_tmp_139_var = this._tmp_139_rule()) != null) {
            _res = _tmp_139_var;
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead_expect(true, 25) && (_tmp_140_var = this._tmp_140_rule()) != null) {
            _res = _tmp_140_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(52);
        if (_literal != null) {
            _res = this.factory.createEllipsis(startToken.sourceRange);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy group_rule() {
        Token _literal_1;
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(7);
        if (_literal != null && (a = this._tmp_141_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            ExprTy invalid_group_var = this.invalid_group_rule();
            if (invalid_group_var != null) {
                _res = invalid_group_var;
                return _res;
            }
            this.reset(_mark);
        }
        _res = null;
        return _res;
    }

    public ExprTy lambdef_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _keyword = this.expect(683);
        if (_keyword != null) {
            ExprTy b;
            Token _literal;
            ArgumentsTy a = this._tmp_142_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (b = this.expression_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createLambda(a == null ? this.factory.emptyArguments() : a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgumentsTy lambda_params_rule() {
        ArgumentsTy lambda_parameters_var;
        int _mark = this.mark();
        Object _res = null;
        if (this.callInvalidRules) {
            Object invalid_lambda_parameters_var = this.invalid_lambda_parameters_rule();
            if (invalid_lambda_parameters_var != null) {
                _res = invalid_lambda_parameters_var;
                return (ArgumentsTy)_res;
            }
            this.reset(_mark);
        }
        if ((lambda_parameters_var = this.lambda_parameters_rule()) != null) {
            _res = lambda_parameters_var;
            return (ArgumentsTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (ArgumentsTy)_res;
    }

    public ArgumentsTy lambda_parameters_rule() {
        Object c;
        Object b;
        int _mark = this.mark();
        ArgumentsTy _res = null;
        Object a = this.lambda_slash_no_default_rule();
        if (a != null && (b = this._loop0_143_rule()) != null && (c = this._loop0_144_rule()) != null) {
            AbstractParser.StarEtc d = this._tmp_145_rule();
            if (d == null) {
                // empty if block
            }
            _res = this.checkVersion(8, "Positional-only parameters are", this.factory.createArguments((ArgTy[])a, null, (ArgTy[])b, (AbstractParser.NameDefaultPair[])c, d));
            return _res;
        }
        this.reset(_mark);
        a = this.lambda_slash_with_default_rule();
        if (a != null && (b = this._loop0_146_rule()) != null) {
            c = this._tmp_147_rule();
            if (c == null) {
                // empty if block
            }
            _res = this.checkVersion(8, "Positional-only parameters are", this.factory.createArguments(null, (AbstractParser.SlashWithDefault)a, null, (AbstractParser.NameDefaultPair[])b, (AbstractParser.StarEtc)c));
            return _res;
        }
        this.reset(_mark);
        a = this._loop1_148_rule();
        if (a != null && (b = this._loop0_149_rule()) != null) {
            c = this._tmp_150_rule();
            if (c == null) {
                // empty if block
            }
            _res = this.factory.createArguments(null, null, (ArgTy[])a, (AbstractParser.NameDefaultPair[])b, (AbstractParser.StarEtc)c);
            return _res;
        }
        this.reset(_mark);
        a = this._loop1_151_rule();
        if (a != null) {
            b = this._tmp_152_rule();
            if (b == null) {
                // empty if block
            }
            _res = this.factory.createArguments(null, null, null, (AbstractParser.NameDefaultPair[])a, (AbstractParser.StarEtc)b);
            return _res;
        }
        this.reset(_mark);
        a = this.lambda_star_etc_rule();
        if (a != null) {
            _res = this.factory.createArguments(null, null, null, null, (AbstractParser.StarEtc)a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] lambda_slash_no_default_rule() {
        Token _literal_1;
        Token _literal;
        int _mark = this.mark();
        ArgTy[] _res = null;
        ArgTy[] a = this._loop1_153_rule();
        if (a != null && (_literal = this.expect(17)) != null && (_literal_1 = this.expect(12)) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        ArgTy[] a2 = this._loop1_154_rule();
        if (a2 != null && (_literal = this.expect(17)) != null && this.genLookahead_expect(true, 11)) {
            _res = a2;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.SlashWithDefault lambda_slash_with_default_rule() {
        AbstractParser.NameDefaultPair[] b;
        Token _literal_1;
        Token _literal;
        AbstractParser.NameDefaultPair[] b2;
        int _mark = this.mark();
        AbstractParser.SlashWithDefault _res = null;
        ArgTy[] a = this._loop0_155_rule();
        if (a != null && (b2 = this._loop1_156_rule()) != null && (_literal = this.expect(17)) != null && (_literal_1 = this.expect(12)) != null) {
            _res = new AbstractParser.SlashWithDefault(a, b2);
            return _res;
        }
        this.reset(_mark);
        ArgTy[] a2 = this._loop0_157_rule();
        if (a2 != null && (b = this._loop1_158_rule()) != null && (_literal = this.expect(17)) != null && this.genLookahead_expect(true, 11)) {
            _res = new AbstractParser.SlashWithDefault(a2, b);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.StarEtc lambda_star_etc_rule() {
        Token _literal_1;
        AbstractParser.NameDefaultPair[] b;
        ArgTy a;
        Token _literal;
        int _mark = this.mark();
        Object _res = null;
        if (this.callInvalidRules) {
            Object invalid_lambda_star_etc_var = this.invalid_lambda_star_etc_rule();
            if (invalid_lambda_star_etc_var != null) {
                _res = invalid_lambda_star_etc_var;
                return (AbstractParser.StarEtc)_res;
            }
            this.reset(_mark);
        }
        if ((_literal = this.expect(16)) != null && (a = this.lambda_param_no_default_rule()) != null && (b = this._loop0_159_rule()) != null) {
            ArgTy c = this._tmp_160_rule();
            if (c == null) {
                // empty if block
            }
            _res = new AbstractParser.StarEtc(a, b, c);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (_literal_1 = this.expect(12)) != null && (b = this._loop1_161_rule()) != null) {
            ArgTy c = this._tmp_162_rule();
            if (c == null) {
                // empty if block
            }
            _res = new AbstractParser.StarEtc(null, b, c);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        ArgTy a2 = this.lambda_kwds_rule();
        if (a2 != null) {
            _res = new AbstractParser.StarEtc(null, null, a2);
            return (AbstractParser.StarEtc)_res;
        }
        this.reset(_mark);
        _res = null;
        return (AbstractParser.StarEtc)_res;
    }

    public ArgTy lambda_kwds_rule() {
        ArgTy a;
        Token _literal;
        int _mark = this.mark();
        ArgTy _res = null;
        if (this.callInvalidRules) {
            ArgTy invalid_lambda_kwds_var = this.invalid_lambda_kwds_rule();
            if (invalid_lambda_kwds_var != null) {
                _res = invalid_lambda_kwds_var;
                return _res;
            }
            this.reset(_mark);
        }
        if ((_literal = this.expect(35)) != null && (a = this.lambda_param_no_default_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy lambda_param_no_default_rule() {
        Token _literal;
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy a = this.lambda_param_rule();
        if (a != null && (_literal = this.expect(12)) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        ArgTy a2 = this.lambda_param_rule();
        if (a2 != null && this.genLookahead_expect(true, 11)) {
            _res = a2;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair lambda_param_with_default_rule() {
        ExprTy c;
        Token _literal;
        ExprTy c2;
        int _mark = this.mark();
        AbstractParser.NameDefaultPair _res = null;
        ArgTy a = this.lambda_param_rule();
        if (a != null && (c2 = this.default_rule()) != null && (_literal = this.expect(12)) != null) {
            _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a.arg, a.annotation, null, a.getSourceRange()), c2);
            return _res;
        }
        this.reset(_mark);
        ArgTy a2 = this.lambda_param_rule();
        if (a2 != null && (c = this.default_rule()) != null && this.genLookahead_expect(true, 11)) {
            _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a2.arg, a2.annotation, null, a2.getSourceRange()), c);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair lambda_param_maybe_default_rule() {
        int _mark = this.mark();
        AbstractParser.NameDefaultPair _res = null;
        ArgTy a = this.lambda_param_rule();
        if (a != null) {
            Token _literal;
            ExprTy c = this.default_rule();
            if (c == null) {
                // empty if block
            }
            if ((_literal = this.expect(12)) != null) {
                _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a.arg, a.annotation, null, a.getSourceRange()), c);
                return _res;
            }
        }
        this.reset(_mark);
        ArgTy a2 = this.lambda_param_rule();
        if (a2 != null) {
            ExprTy c = this.default_rule();
            if (c == null) {
                // empty if block
            }
            if (this.genLookahead_expect(true, 11)) {
                _res = new AbstractParser.NameDefaultPair(this.factory.createArgument(a2.arg, a2.annotation, null, a2.getSourceRange()), c);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy lambda_param_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a = this.name_token();
        if (a != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createArgument(a.id, null, null, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy fstring_middle_rule() {
        int _mark = this.mark();
        SSTNode _res = null;
        ExprTy fstring_replacement_field_var = this.fstring_replacement_field_rule();
        if (fstring_replacement_field_var != null) {
            _res = fstring_replacement_field_var;
            return _res;
        }
        this.reset(_mark);
        Token t = this.expect(62);
        if (t != null) {
            _res = this.constantFromToken(t);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy fstring_replacement_field_rule() {
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(25);
        if (_literal != null && (a = this._tmp_163_rule()) != null) {
            Token rbrace;
            AbstractParser.ResultTokenWithMetadata format;
            AbstractParser.ResultTokenWithMetadata conversion;
            Token debug_expr = this.expect(22);
            if (debug_expr == null) {
                // empty if block
            }
            if ((conversion = this._tmp_164_rule()) == null) {
                // empty if block
            }
            if ((format = this._tmp_165_rule()) == null) {
                // empty if block
            }
            if ((rbrace = this.expect(26)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.formattedValue(a, debug_expr, conversion, format, rbrace, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (ExprTy)_res;
            }
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_replacement_field_var = this.invalid_replacement_field_rule();
            if (invalid_replacement_field_var != null) {
                _res = invalid_replacement_field_var;
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExprTy)_res;
    }

    public AbstractParser.ResultTokenWithMetadata fstring_conversion_rule() {
        ExprTy.Name conv;
        int _mark = this.mark();
        AbstractParser.ResultTokenWithMetadata _res = null;
        Token conv_token = this.expect(54);
        if (conv_token != null && (conv = this.name_token()) != null) {
            _res = this.checkFstringConversion(conv_token, conv);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.ResultTokenWithMetadata fstring_full_format_spec_rule() {
        ExprTy[] spec;
        int _mark = this.mark();
        AbstractParser.ResultTokenWithMetadata _res = null;
        Token startToken = this.getAndInitializeToken();
        Token colon = this.expect(11);
        if (colon != null && (spec = this._loop0_166_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.setupFullFormatSpec(colon, spec, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy fstring_format_spec_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token t = this.expect(62);
        if (t != null) {
            _res = this.decodedConstantFromToken(t);
            return _res;
        }
        this.reset(_mark);
        ExprTy fstring_replacement_field_var = this.fstring_replacement_field_rule();
        if (fstring_replacement_field_var != null) {
            _res = fstring_replacement_field_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy fstring_rule() {
        Token c;
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        Token a = this.expect(61);
        if (a != null && (b = this._loop0_167_rule()) != null && (c = this.expect(63)) != null) {
            _res = this.joinedStr(a, b, c);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy string_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token s = this.string_token();
        if (s != null) {
            _res = this.constantFromString(s);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy strings_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1158)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1158);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        ExprTy[] a = this._loop1_168_rule();
        if (a != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.concatenateStrings(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1158, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1158, _res);
        return _res;
    }

    public ExprTy list_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(9);
        if (_literal != null) {
            Token _literal_1;
            ExprTy[] a = this._tmp_169_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(10)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createList(a, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy tuple_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(7);
        if (_literal != null) {
            Token _literal_1;
            ExprTy[] a = this._tmp_170_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createTuple(a, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy set_rule() {
        Token _literal_1;
        ExprTy[] a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(25);
        if (_literal != null && (a = this.star_named_expressions_rule()) != null && (_literal_1 = this.expect(26)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSet(a, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy dict_rule() {
        Object invalid_double_starred_kvpairs_var;
        Token _literal_1;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(25);
        if (_literal != null) {
            AbstractParser.KeyValuePair[] a = this._tmp_171_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(26)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createDict(Parser.extractKeys(a), Parser.extractValues(a), startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (invalid_double_starred_kvpairs_var = this.invalid_double_starred_kvpairs_rule()) != null && (_literal_1 = this.expect(26)) != null) {
            _res = this.dummyName(_literal, invalid_double_starred_kvpairs_var, _literal_1);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyValuePair[] double_starred_kvpairs_rule() {
        int _mark = this.mark();
        AbstractParser.KeyValuePair[] _res = null;
        AbstractParser.KeyValuePair[] a = this._gather_172_rule();
        if (a != null) {
            Token _opt_var = this._tmp_174_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyValuePair double_starred_kvpair_rule() {
        ExprTy a;
        int _mark = this.mark();
        AbstractParser.KeyValuePair _res = null;
        Token _literal = this.expect(35);
        if (_literal != null && (a = this.bitwise_or_rule()) != null) {
            _res = new AbstractParser.KeyValuePair(null, a);
            return _res;
        }
        this.reset(_mark);
        AbstractParser.KeyValuePair kvpair_var = this.kvpair_rule();
        if (kvpair_var != null) {
            _res = kvpair_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyValuePair kvpair_rule() {
        ExprTy b;
        Token _literal;
        int _mark = this.mark();
        AbstractParser.KeyValuePair _res = null;
        ExprTy a = this.expression_rule();
        if (a != null && (_literal = this.expect(11)) != null && (b = this.expression_rule()) != null) {
            _res = new AbstractParser.KeyValuePair(a, b);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ComprehensionTy[] for_if_clauses_rule() {
        int _mark = this.mark();
        ComprehensionTy[] _res = null;
        ComprehensionTy[] a = this._loop1_175_rule();
        if (a != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ComprehensionTy for_if_clause_rule() {
        Token _keyword_1;
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        SSTNode _res = null;
        Token startToken = this.getAndInitializeToken();
        boolean _cut_var = false;
        Token async_var = this.expect(57);
        if (async_var != null && (_keyword = this.expect(671)) != null && (a = this.star_targets_rule()) != null && (_keyword_1 = this.expect(677)) != null) {
            ExprTy[] c;
            ExprTy b;
            _cut_var = true;
            if (true && (b = this.disjunction_rule()) != null && (c = this._loop0_176_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.checkVersion(6, "Async comprehensions are", this.factory.createComprehension(a, b, c, true, startToken.sourceRange.withEnd(endToken.sourceRange)));
                return (ComprehensionTy)_res;
            }
        }
        this.reset(_mark);
        if (_cut_var) {
            return null;
        }
        _cut_var = false;
        _keyword = this.expect(671);
        if (_keyword != null && (a = this.star_targets_rule()) != null && (_keyword_1 = this.expect(677)) != null) {
            ExprTy[] c;
            ExprTy b;
            _cut_var = true;
            if (true && (b = this.disjunction_rule()) != null && (c = this._loop0_177_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createComprehension(a, b, c, false, startToken.sourceRange.withEnd(endToken.sourceRange));
                return (ComprehensionTy)_res;
            }
        }
        this.reset(_mark);
        if (_cut_var) {
            return null;
        }
        if (this.callInvalidRules) {
            ExprTy invalid_for_target_var = this.invalid_for_target_rule();
            if (invalid_for_target_var != null) {
                _res = invalid_for_target_var;
                return (ComprehensionTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ComprehensionTy)_res;
    }

    public ExprTy listcomp_rule() {
        Token _literal_1;
        ComprehensionTy[] b;
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(9);
        if (_literal != null && (a = this.named_expression_rule()) != null && (b = this.for_if_clauses_rule()) != null && (_literal_1 = this.expect(10)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createListComprehension(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (ExprTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_comprehension_var = this.invalid_comprehension_rule();
            if (invalid_comprehension_var != null) {
                _res = invalid_comprehension_var;
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExprTy)_res;
    }

    public ExprTy setcomp_rule() {
        Token _literal_1;
        ComprehensionTy[] b;
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(25);
        if (_literal != null && (a = this.named_expression_rule()) != null && (b = this.for_if_clauses_rule()) != null && (_literal_1 = this.expect(26)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSetComprehension(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (ExprTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_comprehension_var = this.invalid_comprehension_rule();
            if (invalid_comprehension_var != null) {
                _res = invalid_comprehension_var;
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExprTy)_res;
    }

    public ExprTy genexp_rule() {
        Token _literal_1;
        ComprehensionTy[] b;
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(7);
        if (_literal != null && (a = this._tmp_178_rule()) != null && (b = this.for_if_clauses_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGenerator(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (ExprTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_comprehension_var = this.invalid_comprehension_rule();
            if (invalid_comprehension_var != null) {
                _res = invalid_comprehension_var;
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExprTy)_res;
    }

    public ExprTy dictcomp_rule() {
        Token _literal_1;
        ComprehensionTy[] b;
        AbstractParser.KeyValuePair a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(25);
        if (_literal != null && (a = this.kvpair_rule()) != null && (b = this.for_if_clauses_rule()) != null && (_literal_1 = this.expect(26)) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createDictComprehension(a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (ExprTy)_res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_dict_comprehension_var = this.invalid_dict_comprehension_rule();
            if (invalid_dict_comprehension_var != null) {
                _res = invalid_dict_comprehension_var;
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        return (ExprTy)_res;
    }

    public ExprTy arguments_rule() {
        int _mark = this.mark();
        Object _res = null;
        if (this.cache.hasResult(_mark, 1172)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1172);
            return _res;
        }
        ExprTy a = this.args_rule();
        if (a != null) {
            Token _opt_var = this._tmp_179_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if (this.genLookahead_expect(true, 8)) {
                _res = a;
                this.cache.putResult(_mark, 1172, _res);
                return (ExprTy)_res;
            }
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_arguments_var = this.invalid_arguments_rule();
            if (invalid_arguments_var != null) {
                _res = invalid_arguments_var;
                this.cache.putResult(_mark, 1172, _res);
                return (ExprTy)_res;
            }
            this.reset(_mark);
        }
        _res = null;
        this.cache.putResult(_mark, 1172, _res);
        return (ExprTy)_res;
    }

    public ExprTy args_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        Object[] a = this._gather_180_rule();
        if (a != null) {
            Token endToken;
            AbstractParser.KeywordOrStarred[] b = this._tmp_182_rule();
            if (b == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.collectCallSequences((ExprTy[])a, b, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a = this.kwargs_rule();
        if (a != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createCall(this.dummyName(new Object[0]), Parser.extractStarredExpressions((AbstractParser.KeywordOrStarred[])a), Parser.deleteStarredExpressions((AbstractParser.KeywordOrStarred[])a), startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeywordOrStarred[] kwargs_rule() {
        AbstractParser.KeywordOrStarred[] b;
        Token _literal;
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        AbstractParser.KeywordOrStarred[] a = this._gather_183_rule();
        if (a != null && (_literal = this.expect(12)) != null && (b = this._gather_185_rule()) != null) {
            _res = this.join(a, b);
            return _res;
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] _gather_187_var = this._gather_187_rule();
        if (_gather_187_var != null) {
            _res = _gather_187_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] _gather_189_var = this._gather_189_rule();
        if (_gather_189_var != null) {
            _res = _gather_189_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy starred_expression_rule() {
        ExprTy a;
        Token _literal;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            ExprTy invalid_starred_expression_var = this.invalid_starred_expression_rule();
            if (invalid_starred_expression_var != null) {
                _res = invalid_starred_expression_var;
                return _res;
            }
            this.reset(_mark);
        }
        if ((_literal = this.expect(16)) != null && (a = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createStarred(a, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return (ExprTy)_res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null) {
            _res = this.raiseSyntaxError("Invalid star expression", new Object[0]);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)_res;
    }

    public AbstractParser.KeywordOrStarred kwarg_or_starred_rule() {
        ExprTy b;
        Token _literal;
        ExprTy.Name a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_kwarg_var = this.invalid_kwarg_rule();
            if (invalid_kwarg_var != null) {
                _res = invalid_kwarg_var;
                return (AbstractParser.KeywordOrStarred)_res;
            }
            this.reset(_mark);
        }
        if ((a = this.name_token()) != null && (_literal = this.expect(22)) != null && (b = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = new AbstractParser.KeywordOrStarred(this.factory.createKeyword(a.id, b, startToken.sourceRange.withEnd(endToken.sourceRange)), true);
            return (AbstractParser.KeywordOrStarred)_res;
        }
        this.reset(_mark);
        ExprTy a2 = this.starred_expression_rule();
        if (a2 != null) {
            _res = new AbstractParser.KeywordOrStarred(a2, false);
            return (AbstractParser.KeywordOrStarred)_res;
        }
        this.reset(_mark);
        _res = null;
        return (AbstractParser.KeywordOrStarred)_res;
    }

    public AbstractParser.KeywordOrStarred kwarg_or_double_starred_rule() {
        ExprTy b;
        Token _literal;
        ExprTy a;
        int _mark = this.mark();
        Object _res = null;
        Token startToken = this.getAndInitializeToken();
        if (this.callInvalidRules) {
            Object invalid_kwarg_var = this.invalid_kwarg_rule();
            if (invalid_kwarg_var != null) {
                _res = invalid_kwarg_var;
                return (AbstractParser.KeywordOrStarred)_res;
            }
            this.reset(_mark);
        }
        if ((a = this.name_token()) != null && (_literal = this.expect(22)) != null && (b = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = new AbstractParser.KeywordOrStarred(this.factory.createKeyword(a.id, b, startToken.sourceRange.withEnd(endToken.sourceRange)), true);
            return (AbstractParser.KeywordOrStarred)_res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (a = this.expression_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = new AbstractParser.KeywordOrStarred(this.factory.createKeyword(null, a, startToken.sourceRange.withEnd(endToken.sourceRange)), true);
            return (AbstractParser.KeywordOrStarred)_res;
        }
        this.reset(_mark);
        _res = null;
        return (AbstractParser.KeywordOrStarred)_res;
    }

    public ExprTy star_targets_rule() {
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.star_target_rule();
        if (a != null && this.genLookahead_expect(false, 12)) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.star_target_rule();
        if (a2 != null && (b = this._loop0_191_rule()) != null) {
            Token endToken;
            Token _opt_var = this._tmp_192_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((endToken = this.getLastNonWhitespaceToken()) == null) {
                return null;
            }
            _res = this.factory.createTuple(this.insertInFront(a2, b), ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] star_targets_list_seq_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] a = this._gather_193_rule();
        if (a != null) {
            Token _opt_var = this._tmp_195_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] star_targets_tuple_seq_rule() {
        Token _literal;
        ExprTy[] b;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy a = this.star_target_rule();
        if (a != null && (b = this._loop1_196_rule()) != null) {
            Token _opt_var = this._tmp_197_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.insertInFront(a, b);
            return _res;
        }
        this.reset(_mark);
        a = this.star_target_rule();
        if (a != null && (_literal = this.expect(12)) != null) {
            _res = new ExprTy[]{a};
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy star_target_rule() {
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1181)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1181);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        Token _literal = this.expect(16);
        if (_literal != null && (a = this._tmp_198_rule()) != null) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createStarred(this.setExprContext(a, ExprContextTy.Store), ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1181, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy target_with_star_atom_var = this.target_with_star_atom_rule();
        if (target_with_star_atom_var != null) {
            _res = target_with_star_atom_var;
            this.cache.putResult(_mark, 1181, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1181, _res);
        return _res;
    }

    public ExprTy target_with_star_atom_rule() {
        Token _literal_1;
        ExprTy b;
        ExprTy.Name b2;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1182)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1182);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.t_primary_rule();
        if (a != null && (_literal = this.expect(23)) != null && (b2 = this.name_token()) != null && this.genLookahead_t_lookahead_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGetAttribute(a, b2.id, ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1182, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.t_primary_rule();
        if (a2 != null && (_literal = this.expect(9)) != null && (b = this.slices_rule()) != null && (_literal_1 = this.expect(10)) != null && this.genLookahead_t_lookahead_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSubscript(a2, b, ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1182, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy star_atom_var = this.star_atom_rule();
        if (star_atom_var != null) {
            _res = star_atom_var;
            this.cache.putResult(_mark, 1182, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1182, _res);
        return _res;
    }

    public ExprTy star_atom_rule() {
        Token _literal_1;
        ExprTy[] a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a2 = this.name_token();
        if (a2 != null) {
            _res = this.setExprContext(a2, ExprContextTy.Store);
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(7);
        if (_literal != null && (a = this.target_with_star_atom_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = this.setExprContext((ExprTy)a, ExprContextTy.Store);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null) {
            a = this._tmp_199_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createTuple(a, ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(9);
        if (_literal != null) {
            a = this._tmp_200_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(10)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createList(a, ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy single_target_rule() {
        Token _literal_1;
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy single_subscript_attribute_target_var = this.single_subscript_attribute_target_rule();
        if (single_subscript_attribute_target_var != null) {
            _res = single_subscript_attribute_target_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy.Name a2 = this.name_token();
        if (a2 != null) {
            _res = this.setExprContext(a2, ExprContextTy.Store);
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(7);
        if (_literal != null && (a = this.single_target_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy single_subscript_attribute_target_rule() {
        Token _literal_1;
        ExprTy b;
        ExprTy.Name b2;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.t_primary_rule();
        if (a != null && (_literal = this.expect(23)) != null && (b2 = this.name_token()) != null && this.genLookahead_t_lookahead_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGetAttribute(a, b2.id, ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.t_primary_rule();
        if (a2 != null && (_literal = this.expect(9)) != null && (b = this.slices_rule()) != null && (_literal_1 = this.expect(10)) != null && this.genLookahead_t_lookahead_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSubscript(a2, b, ExprContextTy.Store, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy t_primary_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1186)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1186);
            return _res;
        }
        int _resmark = this.mark();
        while (true) {
            this.cache.putResult(_mark, 1186, _res);
            this.reset(_mark);
            ExprTy _raw = this.t_primary_raw();
            if (_raw == null || this.mark() <= _resmark) break;
            _resmark = this.mark();
            _res = _raw;
        }
        this.reset(_resmark);
        return _res;
    }

    private ExprTy t_primary_raw() {
        ExprTy b;
        Token _literal_1;
        ExprTy b2;
        ExprTy.Name b3;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.t_primary_rule();
        if (a != null && (_literal = this.expect(23)) != null && (b3 = this.name_token()) != null && this.genLookahead_t_lookahead_rule(true)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGetAttribute(a, b3.id, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.t_primary_rule();
        if (a2 != null && (_literal = this.expect(9)) != null && (b2 = this.slices_rule()) != null && (_literal_1 = this.expect(10)) != null && this.genLookahead_t_lookahead_rule(true)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSubscript(a2, b2, ExprContextTy.Load, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        ExprTy a3 = this.t_primary_rule();
        if (a3 != null && (b = this.genexp_rule()) != null && this.genLookahead_t_lookahead_rule(true)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createCall(a3, new ExprTy[]{b}, EMPTY_KEYWORD_ARRAY, startToken.sourceRange.withEnd(endToken.sourceRange));
            return _res;
        }
        this.reset(_mark);
        a2 = this.t_primary_rule();
        if (a2 != null && (_literal = this.expect(7)) != null) {
            b2 = this._tmp_201_rule();
            if (b2 == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null && this.genLookahead_t_lookahead_rule(true)) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createCall(a2, b2 != null ? ((ExprTy.Call)b2).args : EMPTY_EXPR_ARRAY, b2 != null ? ((ExprTy.Call)b2).keywords : EMPTY_KEYWORD_ARRAY, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        a3 = this.atom_rule();
        if (a3 != null && this.genLookahead_t_lookahead_rule(true)) {
            _res = a3;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token t_lookahead_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(7);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(9);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(23);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] del_targets_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] a = this._gather_202_rule();
        if (a != null) {
            Token _opt_var = this._tmp_204_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy del_target_rule() {
        Token _literal_1;
        ExprTy b;
        ExprTy.Name b2;
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.cache.hasResult(_mark, 1189)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1189);
            return _res;
        }
        Token startToken = this.getAndInitializeToken();
        ExprTy a = this.t_primary_rule();
        if (a != null && (_literal = this.expect(23)) != null && (b2 = this.name_token()) != null && this.genLookahead_t_lookahead_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createGetAttribute(a, b2.id, ExprContextTy.Del, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1189, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy a2 = this.t_primary_rule();
        if (a2 != null && (_literal = this.expect(9)) != null && (b = this.slices_rule()) != null && (_literal_1 = this.expect(10)) != null && this.genLookahead_t_lookahead_rule(false)) {
            Token endToken = this.getLastNonWhitespaceToken();
            if (endToken == null) {
                return null;
            }
            _res = this.factory.createSubscript(a2, b, ExprContextTy.Del, startToken.sourceRange.withEnd(endToken.sourceRange));
            this.cache.putResult(_mark, 1189, _res);
            return _res;
        }
        this.reset(_mark);
        ExprTy del_t_atom_var = this.del_t_atom_rule();
        if (del_t_atom_var != null) {
            _res = del_t_atom_var;
            this.cache.putResult(_mark, 1189, _res);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1189, _res);
        return _res;
    }

    public ExprTy del_t_atom_rule() {
        Token _literal_1;
        ExprTy[] a;
        int _mark = this.mark();
        ExprTy _res = null;
        Token startToken = this.getAndInitializeToken();
        ExprTy.Name a2 = this.name_token();
        if (a2 != null) {
            _res = this.setExprContext(a2, ExprContextTy.Del);
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(7);
        if (_literal != null && (a = this.del_target_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = this.setExprContext((ExprTy)a, ExprContextTy.Del);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null) {
            a = this._tmp_205_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createTuple(a, ExprContextTy.Del, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(9);
        if (_literal != null) {
            a = this._tmp_206_rule();
            if (a == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(10)) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    return null;
                }
                _res = this.factory.createList(a, ExprContextTy.Del, startToken.sourceRange.withEnd(endToken.sourceRange));
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] type_expressions_rule() {
        ExprTy a;
        ExprTy b;
        ExprTy a2;
        ExprTy b2;
        ExprTy c;
        Token _literal_3;
        Token _literal_2;
        ExprTy b3;
        Token _literal_1;
        Token _literal;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] a3 = this._gather_207_rule();
        if (a3 != null && (_literal = this.expect(12)) != null && (_literal_1 = this.expect(16)) != null && (b3 = this.expression_rule()) != null && (_literal_2 = this.expect(12)) != null && (_literal_3 = this.expect(35)) != null && (c = this.expression_rule()) != null) {
            _res = this.appendToEnd(this.appendToEnd(a3, b3), c);
            return _res;
        }
        this.reset(_mark);
        ExprTy[] a4 = this._gather_209_rule();
        if (a4 != null && (_literal = this.expect(12)) != null && (_literal_1 = this.expect(16)) != null && (b2 = this.expression_rule()) != null) {
            _res = this.appendToEnd(a4, b2);
            return _res;
        }
        this.reset(_mark);
        a4 = this._gather_211_rule();
        if (a4 != null && (_literal = this.expect(12)) != null && (_literal_1 = this.expect(35)) != null && (b2 = this.expression_rule()) != null) {
            _res = this.appendToEnd(a4, b2);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (a2 = this.expression_rule()) != null && (_literal_1 = this.expect(12)) != null && (_literal_2 = this.expect(35)) != null && (b = this.expression_rule()) != null) {
            _res = this.appendToEnd(new ExprTy[]{a2}, b);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (a = this.expression_rule()) != null) {
            _res = new ExprTy[]{a};
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (a = this.expression_rule()) != null) {
            _res = new ExprTy[]{a};
            return _res;
        }
        this.reset(_mark);
        ExprTy[] a5 = this._gather_213_rule();
        if (a5 != null) {
            _res = a5;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token func_type_comment_rule() {
        Token type_comment_var;
        Token t;
        int _mark = this.mark();
        Object _res = null;
        Token newline_var = this.expect(4);
        if (newline_var != null && (t = this.expect(59)) != null && this.genLookahead__tmp_215_rule(true)) {
            _res = t;
            return _res;
        }
        this.reset(_mark);
        if (this.callInvalidRules) {
            Object invalid_double_type_comments_var = this.invalid_double_type_comments_rule();
            if (invalid_double_type_comments_var != null) {
                _res = invalid_double_type_comments_var;
                return (Token)_res;
            }
            this.reset(_mark);
        }
        if ((type_comment_var = this.expect(59)) != null) {
            _res = type_comment_var;
            return (Token)_res;
        }
        this.reset(_mark);
        _res = null;
        return (Token)_res;
    }

    public Object invalid_arguments_rule() {
        Token b;
        ExprTy a;
        ComprehensionTy[] for_if_clauses_var;
        ExprTy expression_var;
        ComprehensionTy[] b2;
        Token _literal;
        ComprehensionTy[] b3;
        ExprTy[] _gather_217_var;
        Object a2;
        int _mark = this.mark();
        Object _res = null;
        Object _tmp_216_var = this._tmp_216_rule();
        if (_tmp_216_var != null && (a2 = this.expect(12)) != null && (_gather_217_var = this._gather_217_rule()) != null) {
            _res = this.raiseSyntaxErrorStartingFrom((Token)a2, "iterable argument unpacking follows keyword argument unpacking", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a2 = this.expression_rule();
        if (a2 != null && (b3 = this.for_if_clauses_rule()) != null && (_literal = this.expect(12)) != null) {
            Object _opt_var = this._tmp_219_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a2, (SSTNode)this.getLastComprehensionItem(this.lastItem(b3)), "Generator expression must be parenthesized", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        ExprTy a3 = this.name_token();
        if (a3 != null && (b2 = this.expect(22)) != null && (expression_var = this.expression_rule()) != null && (for_if_clauses_var = this.for_if_clauses_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a3, (Token)b2, "invalid syntax. Maybe you meant '==' or ':=' instead of '='?", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Object _opt_var = this._tmp_220_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((a = this.name_token()) != null && (b = this.expect(22)) != null && this.genLookahead__tmp_221_rule(true)) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a, b, "expected argument value expression", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a3 = this.args_rule();
        if (a3 != null && (b2 = this.for_if_clauses_rule()) != null) {
            _res = this.nonparenGenexpInCall(a3, b2);
            return _res;
        }
        this.reset(_mark);
        ExprTy args_var = this.args_rule();
        if (args_var != null && (_literal = this.expect(12)) != null && (a = this.expression_rule()) != null && (b3 = this.for_if_clauses_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a, (SSTNode)this.getLastComprehensionItem(this.lastItem(b3)), "Generator expression must be parenthesized", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a = this.args_rule();
        if (a != null && (_literal = this.expect(12)) != null && (args_var = this.args_rule()) != null) {
            _res = this.raiseArgumentsParsingError(a);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_kwarg_rule() {
        ExprTy b;
        Token _literal;
        ExprTy expression_var;
        ComprehensionTy[] for_if_clauses_var;
        ExprTy expression_var2;
        Token b2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Object a = this._tmp_222_rule();
        if (a != null && (b2 = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownRange((Token)a, b2, "cannot assign to %s", this.getText((Token)a));
            return _res;
        }
        this.reset(_mark);
        a = this.name_token();
        if (a != null && (b2 = this.expect(22)) != null && (expression_var2 = this.expression_rule()) != null && (for_if_clauses_var = this.for_if_clauses_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a, b2, "invalid syntax. Maybe you meant '==' or ':=' instead of '='?", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_223_rule(false) && (a = this.expression_rule()) != null && (b2 = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a, b2, "expression cannot contain assignment, perhaps you meant \"==\"?", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Token a2 = this.expect(35);
        if (a2 != null && (expression_var = this.expression_rule()) != null && (_literal = this.expect(22)) != null && (b = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange(a2, (SSTNode)b, "cannot assign to keyword argument unpacking", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExprTy expression_without_invalid_rule() {
        boolean prevCallInvalidRules = this.callInvalidRules;
        try {
            ExprTy exprTy;
            ExprTy c;
            Token _keyword_1;
            ExprTy b;
            Token _keyword;
            this.callInvalidRules = false;
            int _mark = this.mark();
            ExprTy _res = null;
            Token startToken = this.getAndInitializeToken();
            ExprTy a = this.disjunction_rule();
            if (a != null && (_keyword = this.expect(668)) != null && (b = this.disjunction_rule()) != null && (_keyword_1 = this.expect(676)) != null && (c = this.expression_rule()) != null) {
                Token endToken = this.getLastNonWhitespaceToken();
                if (endToken == null) {
                    ExprTy exprTy2 = null;
                    return exprTy2;
                }
                ExprTy exprTy3 = _res = this.factory.createIfExpression(b, a, c, startToken.sourceRange.withEnd(endToken.sourceRange));
                return exprTy3;
            }
            this.reset(_mark);
            ExprTy disjunction_var = this.disjunction_rule();
            if (disjunction_var != null) {
                exprTy = _res = disjunction_var;
                return exprTy;
            }
            this.reset(_mark);
            ExprTy lambdef_var = this.lambdef_rule();
            if (lambdef_var != null) {
                exprTy = _res = lambdef_var;
                return exprTy;
            }
            this.reset(_mark);
            ExprTy exprTy4 = _res = null;
            return exprTy4;
        }
        finally {
            this.callInvalidRules = prevCallInvalidRules;
        }
    }

    public ExprTy invalid_legacy_expression_rule() {
        ExprTy b;
        int _mark = this.mark();
        RuntimeException _res = null;
        ExprTy.Name a = this.name_token();
        if (a != null && this.genLookahead_expect(false, 7) && (b = this.star_expressions_rule()) != null) {
            _res = this.checkLegacyStmt(a) ? this.raiseSyntaxErrorKnownRange((SSTNode)a, (SSTNode)b, "Missing parentheses in call to '%s'. Did you mean %s(...)?", a.id, a.id) : null;
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public Object invalid_expression_rule() {
        Object b;
        Token _keyword;
        ExprTy b2;
        ExprTy a;
        int _mark = this.mark();
        RuntimeException _res = null;
        if (this.genLookahead__tmp_224_rule(false) && (a = this.disjunction_rule()) != null && (b2 = this.expression_without_invalid_rule()) != null) {
            _res = this.checkLegacyStmt(a) ? null : (this.peekToken((int)(this.mark() - 1)).level == 0 ? null : this.raiseSyntaxErrorKnownRange((SSTNode)a, (SSTNode)b2, "invalid syntax. Perhaps you forgot a comma?", new Object[0]));
            return _res;
        }
        this.reset(_mark);
        Object a2 = this.disjunction_rule();
        if (a2 != null && (_keyword = this.expect(668)) != null && (b = this.disjunction_rule()) != null && this.genLookahead__tmp_225_rule(false)) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a2, (SSTNode)b, "expected 'else' after 'if' expression", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a2 = this.expect(683);
        if (a2 != null) {
            ArgumentsTy _opt_var = this._tmp_226_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((b = this.expect(11)) != null && this.genLookahead_expect(true, 62)) {
                _res = this.raiseSyntaxErrorKnownRange((Token)a2, (Token)b, "f-string: lambda expressions are not allowed without parentheses", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_named_expression_rule() {
        ExprTy bitwise_or_var;
        Token b;
        ExprTy a;
        ExprTy b2;
        ExprTy expression_var;
        Token _literal;
        int _mark = this.mark();
        Object _res = null;
        if (this.cache.hasResult(_mark, 1198)) {
            _res = (ExprTy)this.cache.getResult(_mark, 1198);
            return _res;
        }
        ExprTy a2 = this.expression_rule();
        if (a2 != null && (_literal = this.expect(53)) != null && (expression_var = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "cannot use assignment expressions with %s", this.getExprName(a2));
            this.cache.putResult(_mark, 1198, _res);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        a2 = this.name_token();
        if (a2 != null && (_literal = this.expect(22)) != null && (b2 = this.bitwise_or_rule()) != null && this.genLookahead__tmp_227_rule(false)) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a2, (SSTNode)b2, "invalid syntax. Maybe you meant '==' or ':=' instead of '='?", new Object[0]);
            this.cache.putResult(_mark, 1198, _res);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        if (this.genLookahead__tmp_228_rule(false) && (a = this.bitwise_or_rule()) != null && (b = this.expect(22)) != null && (bitwise_or_var = this.bitwise_or_rule()) != null && this.genLookahead__tmp_229_rule(false)) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "cannot assign to %s here. Maybe you meant '==' instead of '='?", this.getExprName(a));
            this.cache.putResult(_mark, 1198, _res);
            return (ExprTy)_res;
        }
        this.reset(_mark);
        _res = null;
        this.cache.putResult(_mark, 1198, _res);
        return (ExprTy)_res;
    }

    public Object invalid_assignment_rule() {
        ExprTy _tmp_233_var;
        OperatorTy augassign_var;
        ExprTy a;
        ExprTy expression_var;
        Token _literal_1;
        ExprTy[] _loop0_230_var;
        ExprTy expression_var2;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        ExprTy a2 = this.invalid_ann_assign_target_rule();
        if (a2 != null && (_literal = this.expect(11)) != null && (expression_var2 = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "only single target (not %s) can be annotated", this.getExprName(a2));
            return _res;
        }
        this.reset(_mark);
        ExprTy a3 = this.star_named_expression_rule();
        if (a3 != null && (_literal = this.expect(12)) != null && (_loop0_230_var = this._loop0_230_rule()) != null && (_literal_1 = this.expect(11)) != null && (expression_var = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a3, "only single target (not tuple) can be annotated", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a2 = this.expression_rule();
        if (a2 != null && (_literal = this.expect(11)) != null && (expression_var2 = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "illegal target for annotation", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Object[] _loop0_231_var = this._loop0_231_rule();
        if (_loop0_231_var != null && (a = this.star_expressions_rule()) != null && (_literal = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorInvalidTarget(AbstractParser.TargetsType.STAR_TARGETS, a);
            return _res;
        }
        this.reset(_mark);
        Object[] _loop0_232_var = this._loop0_232_rule();
        if (_loop0_232_var != null && (a = this.yield_expr_rule()) != null && (_literal = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "assignment to yield expression not possible", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a2 = this.star_expressions_rule();
        if (a2 != null && (augassign_var = this.augassign_rule()) != null && (_tmp_233_var = this._tmp_233_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "'%s' is an illegal expression for augmented assignment", this.getExprName(a2));
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_ann_assign_target_rule() {
        Token _literal_1;
        ExprTy a;
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy list_var = this.list_rule();
        if (list_var != null) {
            _res = list_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy tuple_var = this.tuple_rule();
        if (tuple_var != null) {
            _res = tuple_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(7);
        if (_literal != null && (a = this.invalid_ann_assign_target_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_del_stmt_rule() {
        ExprTy a;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _keyword = this.expect(660);
        if (_keyword != null && (a = this.star_expressions_rule()) != null) {
            _res = this.raiseSyntaxErrorInvalidTarget(AbstractParser.TargetsType.DEL_TARGETS, a);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public Object invalid_block_rule() {
        int _mark = this.mark();
        RuntimeException _res = null;
        Token newline_var = this.expect(4);
        if (newline_var != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_comprehension_rule() {
        ComprehensionTy[] for_if_clauses_var;
        Token b;
        ComprehensionTy[] for_if_clauses_var2;
        ExprTy[] b2;
        Token _literal;
        ExprTy a;
        ComprehensionTy[] for_if_clauses_var3;
        ExprTy a2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _tmp_234_var = this._tmp_234_rule();
        if (_tmp_234_var != null && (a2 = this.starred_expression_rule()) != null && (for_if_clauses_var3 = this.for_if_clauses_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "iterable unpacking cannot be used in comprehension", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Token _tmp_235_var = this._tmp_235_rule();
        if (_tmp_235_var != null && (a = this.star_named_expression_rule()) != null && (_literal = this.expect(12)) != null && (b2 = this.star_named_expressions_rule()) != null && (for_if_clauses_var2 = this.for_if_clauses_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a, (SSTNode)this.lastItem(b2), "did you forget parentheses around the comprehension target?", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Token _tmp_236_var = this._tmp_236_rule();
        if (_tmp_236_var != null && (a2 = this.star_named_expression_rule()) != null && (b = this.expect(12)) != null && (for_if_clauses_var = this.for_if_clauses_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a2, b, "did you forget parentheses around the comprehension target?", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_dict_comprehension_rule() {
        Token _literal_1;
        ComprehensionTy[] for_if_clauses_var;
        ExprTy bitwise_or_var;
        Token a;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _literal = this.expect(25);
        if (_literal != null && (a = this.expect(35)) != null && (bitwise_or_var = this.bitwise_or_rule()) != null && (for_if_clauses_var = this.for_if_clauses_rule()) != null && (_literal_1 = this.expect(26)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "dict unpacking cannot be used in dict comprehension", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_parameters_rule() {
        Token a;
        AbstractParser.NameDefaultPair[] _loop0_245_var;
        Object _tmp_244_var;
        AbstractParser.NameDefaultPair[] _loop0_243_var;
        ArgTy[] _loop1_241_var;
        Token a2;
        Object invalid_parameters_helper_var;
        ArgTy[] _loop0_239_var;
        Object a3;
        AbstractParser.NameDefaultPair[] _loop0_238_var;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a4 = this.expect(17);
        if (a4 != null && (_literal = this.expect(12)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a4, "at least one argument must precede /", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Object _tmp_237_var = this._tmp_237_rule();
        if (_tmp_237_var != null && (_loop0_238_var = this._loop0_238_rule()) != null && (a3 = this.expect(17)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a3, "/ may appear only once", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        ArgTy[] _opt_var = this.slash_no_default_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((_loop0_239_var = this._loop0_239_rule()) != null && (invalid_parameters_helper_var = this.invalid_parameters_helper_rule()) != null && (a3 = this.param_no_default_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((SSTNode)a3, "parameter without a default follows parameter with a default", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        ArgTy[] _loop0_240_var = this._loop0_240_rule();
        if (_loop0_240_var != null && (a2 = this.expect(7)) != null && (_loop1_241_var = this._loop1_241_rule()) != null) {
            Token b;
            Token _opt_var2 = this.expect(12);
            if (_opt_var2 == null) {
                // empty if block
            }
            if ((b = this.expect(8)) != null) {
                _res = this.raiseSyntaxErrorKnownRange(a2, b, "Function parameters cannot be parenthesized", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        Object _opt_var3 = this._tmp_242_rule();
        if (_opt_var3 == null) {
            // empty if block
        }
        if ((_loop0_243_var = this._loop0_243_rule()) != null && (_literal = this.expect(16)) != null && (_tmp_244_var = this._tmp_244_rule()) != null && (_loop0_245_var = this._loop0_245_rule()) != null && (a = this.expect(17)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "/ must be ahead of *", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _loop1_246_var = this._loop1_246_rule();
        if (_loop1_246_var != null && (_literal = this.expect(17)) != null && (a3 = this.expect(16)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a3, "expected comma between / and *", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_default_rule() {
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(22);
        if (a != null && this.genLookahead__tmp_247_rule(true)) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "expected default value expression", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_star_etc_rule() {
        Object _tmp_251_var;
        Token a;
        AbstractParser.NameDefaultPair[] _loop0_250_var;
        Object _tmp_249_var;
        ArgTy param_var;
        Token type_comment_var;
        Token _literal_1;
        Object _tmp_248_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a2 = this.expect(16);
        if (a2 != null && (_tmp_248_var = this._tmp_248_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "named arguments must follow bare *", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(16);
        if (_literal != null && (_literal_1 = this.expect(12)) != null && (type_comment_var = this.expect(59)) != null) {
            _res = this.raiseSyntaxError("bare * has associated type comment", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (param_var = this.param_rule()) != null && (a2 = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "var-positional argument cannot have default value", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (_tmp_249_var = this._tmp_249_rule()) != null && (_loop0_250_var = this._loop0_250_rule()) != null && (a = this.expect(16)) != null && (_tmp_251_var = this._tmp_251_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "* argument may appear only once", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy invalid_kwds_rule() {
        Object a;
        Token _literal_1;
        ArgTy param_var;
        Token a2;
        ArgTy param_var2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _literal = this.expect(35);
        if (_literal != null && (param_var2 = this.param_rule()) != null && (a2 = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "var-keyword argument cannot have default value", new Object[0]);
            return (ArgTy)((Object)_res);
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (param_var = this.param_rule()) != null && (_literal_1 = this.expect(12)) != null && (a = this.param_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((SSTNode)a, "arguments cannot follow var-keyword argument", new Object[0]);
            return (ArgTy)((Object)_res);
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (param_var = this.param_rule()) != null && (_literal_1 = this.expect(12)) != null && (a = this._tmp_252_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a, "arguments cannot follow var-keyword argument", new Object[0]);
            return (ArgTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ArgTy)((Object)_res);
    }

    public Object invalid_parameters_helper_rule() {
        int _mark = this.mark();
        Object[] _res = null;
        AbstractParser.SlashWithDefault a = this.slash_with_default_rule();
        if (a != null) {
            _res = new AbstractParser.SlashWithDefault[]{a};
            return _res;
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _loop1_253_var = this._loop1_253_rule();
        if (_loop1_253_var != null) {
            _res = _loop1_253_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_lambda_parameters_rule() {
        Token a;
        AbstractParser.NameDefaultPair[] _loop0_263_var;
        Object _tmp_262_var;
        AbstractParser.NameDefaultPair[] _loop0_261_var;
        ArgTy[] _gather_258_var;
        Token a2;
        Object invalid_lambda_parameters_helper_var;
        ArgTy[] _loop0_256_var;
        Object a3;
        AbstractParser.NameDefaultPair[] _loop0_255_var;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a4 = this.expect(17);
        if (a4 != null && (_literal = this.expect(12)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a4, "at least one argument must precede /", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        Object _tmp_254_var = this._tmp_254_rule();
        if (_tmp_254_var != null && (_loop0_255_var = this._loop0_255_rule()) != null && (a3 = this.expect(17)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a3, "/ may appear only once", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        ArgTy[] _opt_var = this.lambda_slash_no_default_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((_loop0_256_var = this._loop0_256_rule()) != null && (invalid_lambda_parameters_helper_var = this.invalid_lambda_parameters_helper_rule()) != null && (a3 = this.lambda_param_no_default_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((SSTNode)a3, "parameter without a default follows parameter with a default", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        ArgTy[] _loop0_257_var = this._loop0_257_rule();
        if (_loop0_257_var != null && (a2 = this.expect(7)) != null && (_gather_258_var = this._gather_258_rule()) != null) {
            Token b;
            Token _opt_var2 = this.expect(12);
            if (_opt_var2 == null) {
                // empty if block
            }
            if ((b = this.expect(8)) != null) {
                _res = this.raiseSyntaxErrorKnownRange(a2, b, "Lambda expression parameters cannot be parenthesized", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        Object _opt_var3 = this._tmp_260_rule();
        if (_opt_var3 == null) {
            // empty if block
        }
        if ((_loop0_261_var = this._loop0_261_rule()) != null && (_literal = this.expect(16)) != null && (_tmp_262_var = this._tmp_262_rule()) != null && (_loop0_263_var = this._loop0_263_rule()) != null && (a = this.expect(17)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "/ must be ahead of *", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _loop1_264_var = this._loop1_264_rule();
        if (_loop1_264_var != null && (_literal = this.expect(17)) != null && (a3 = this.expect(16)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a3, "expected comma between / and *", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_lambda_parameters_helper_rule() {
        int _mark = this.mark();
        Object[] _res = null;
        AbstractParser.SlashWithDefault a = this.lambda_slash_with_default_rule();
        if (a != null) {
            _res = new AbstractParser.SlashWithDefault[]{a};
            return _res;
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _loop1_265_var = this._loop1_265_rule();
        if (_loop1_265_var != null) {
            _res = _loop1_265_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_lambda_star_etc_rule() {
        Object _tmp_269_var;
        Token a;
        AbstractParser.NameDefaultPair[] _loop0_268_var;
        Object _tmp_267_var;
        Token a2;
        ArgTy lambda_param_var;
        Object _tmp_266_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _literal = this.expect(16);
        if (_literal != null && (_tmp_266_var = this._tmp_266_rule()) != null) {
            _res = this.raiseSyntaxError("named arguments must follow bare *", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (lambda_param_var = this.lambda_param_rule()) != null && (a2 = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "var-positional argument cannot have default value", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(16);
        if (_literal != null && (_tmp_267_var = this._tmp_267_rule()) != null && (_loop0_268_var = this._loop0_268_rule()) != null && (a = this.expect(16)) != null && (_tmp_269_var = this._tmp_269_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "* argument may appear only once", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy invalid_lambda_kwds_rule() {
        Object a;
        Token _literal_1;
        ArgTy lambda_param_var;
        Token a2;
        ArgTy lambda_param_var2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _literal = this.expect(35);
        if (_literal != null && (lambda_param_var2 = this.lambda_param_rule()) != null && (a2 = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a2, "var-keyword argument cannot have default value", new Object[0]);
            return (ArgTy)((Object)_res);
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (lambda_param_var = this.lambda_param_rule()) != null && (_literal_1 = this.expect(12)) != null && (a = this.lambda_param_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((SSTNode)a, "arguments cannot follow var-keyword argument", new Object[0]);
            return (ArgTy)((Object)_res);
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null && (lambda_param_var = this.lambda_param_rule()) != null && (_literal_1 = this.expect(12)) != null && (a = this._tmp_270_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a, "arguments cannot follow var-keyword argument", new Object[0]);
            return (ArgTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ArgTy)((Object)_res);
    }

    public Object invalid_double_type_comments_rule() {
        Token indent_var;
        Token newline_var_1;
        Token type_comment_var_1;
        Token newline_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token type_comment_var = this.expect(59);
        if (type_comment_var != null && (newline_var = this.expect(4)) != null && (type_comment_var_1 = this.expect(59)) != null && (newline_var_1 = this.expect(4)) != null && (indent_var = this.expect(5)) != null) {
            _res = this.raiseSyntaxError("Cannot have two type comments on def", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_with_item_rule() {
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        RuntimeException _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && (_keyword = this.expect(674)) != null && (a = this.expression_rule()) != null && this.genLookahead__tmp_271_rule(true)) {
            _res = this.raiseSyntaxErrorInvalidTarget(AbstractParser.TargetsType.STAR_TARGETS, a);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public ExprTy invalid_for_target_rule() {
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _opt_var = this.expect(57);
        if (_opt_var == null) {
            // empty if block
        }
        if ((_keyword = this.expect(671)) != null && (a = this.star_expressions_rule()) != null) {
            _res = this.raiseSyntaxErrorInvalidTarget(AbstractParser.TargetsType.FOR_TARGETS, a);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public ExprTy invalid_group_rule() {
        ExprTy expression_var;
        Token _literal_1;
        Object a;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _literal = this.expect(7);
        if (_literal != null && (a = this.starred_expression_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((SSTNode)a, "cannot use starred expression here", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null && (a = this.expect(35)) != null && (expression_var = this.expression_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a, "cannot use double starred expression here", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public ExprTy[] invalid_import_rule() {
        ExprTy dotted_name_var;
        Token _keyword;
        ExprTy[] _gather_272_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(656);
        if (a != null && (_gather_272_var = this._gather_272_rule()) != null && (_keyword = this.expect(657)) != null && (dotted_name_var = this.dotted_name_rule()) != null) {
            _res = this.raiseSyntaxErrorStartingFrom(a, "Did you mean to use 'from ... import ...' instead?", new Object[0]);
            return (ExprTy[])_res;
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy[])_res;
    }

    public AliasTy[] invalid_import_from_targets_rule() {
        Token newline_var;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        AliasTy[] import_from_as_names_var = this.import_from_as_names_rule();
        if (import_from_as_names_var != null && (_literal = this.expect(12)) != null && (newline_var = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("trailing comma not allowed without surrounding parentheses", new Object[0]);
            return (AliasTy[])_res;
        }
        this.reset(_mark);
        _res = null;
        return (AliasTy[])_res;
    }

    public Object[] invalid_with_stmt_rule() {
        Object[] _gather_278_var;
        Token _literal;
        Token newline_var;
        Object[] _gather_275_var;
        Token _keyword;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _opt_var = this._tmp_274_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((_keyword = this.expect(670)) != null && (_gather_275_var = this._gather_275_rule()) != null && (newline_var = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("expected ':'", new Object[0]);
            return (Object[])_res;
        }
        this.reset(_mark);
        Token _opt_var2 = this._tmp_277_rule();
        if (_opt_var2 == null) {
            // empty if block
        }
        if ((_keyword = this.expect(670)) != null && (_literal = this.expect(7)) != null && (_gather_278_var = this._gather_278_rule()) != null) {
            Token newline_var2;
            Token _literal_1;
            Token _opt_var_1 = this.expect(12);
            if (_opt_var_1 == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null && (newline_var2 = this.expect(4)) != null) {
                _res = this.raiseSyntaxError("expected ':'", new Object[0]);
                return (Object[])_res;
            }
        }
        this.reset(_mark);
        _res = null;
        return (Object[])_res;
    }

    public Object[] invalid_with_stmt_indent_rule() {
        Object[] _gather_284_var;
        Token a;
        Token newline_var;
        Token _literal;
        Object[] _gather_281_var;
        Token a2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _opt_var = this._tmp_280_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((a2 = this.expect(670)) != null && (_gather_281_var = this._gather_281_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'with' statement on line %d", a2.getSourceRange().startLine);
            return (Object[])_res;
        }
        this.reset(_mark);
        Token _opt_var2 = this._tmp_283_rule();
        if (_opt_var2 == null) {
            // empty if block
        }
        if ((a = this.expect(670)) != null && (_literal = this.expect(7)) != null && (_gather_284_var = this._gather_284_rule()) != null) {
            Token newline_var2;
            Token _literal_2;
            Token _literal_1;
            Token _opt_var_1 = this.expect(12);
            if (_opt_var_1 == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null && (_literal_2 = this.expect(11)) != null && (newline_var2 = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
                _res = this.raiseIndentationError("expected an indented block after 'with' statement on line %d", a.getSourceRange().startLine);
                return (Object[])_res;
            }
        }
        this.reset(_mark);
        _res = null;
        return (Object[])_res;
    }

    public Object invalid_try_stmt_rule() {
        ExceptHandlerTy[] _loop1_291_var;
        StmtTy[] _loop0_290_var;
        Token _literal_1;
        Object _opt_var;
        ExprTy expression_var;
        Token b;
        Token a;
        ExceptHandlerTy[] _loop1_288_var;
        StmtTy[] _loop0_287_var;
        StmtTy[] block_var;
        Token _literal;
        Token newline_var;
        Token _literal2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a2 = this.expect(672);
        if (a2 != null && (_literal2 = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'try' statement on line %d", a2.getSourceRange().startLine);
            return _res;
        }
        this.reset(_mark);
        Token _keyword = this.expect(672);
        if (_keyword != null && (_literal = this.expect(11)) != null && (block_var = this.block_rule()) != null && this.genLookahead__tmp_286_rule(false)) {
            _res = this.raiseSyntaxError("expected 'except' or 'finally' block", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(672);
        if (_keyword != null && (_literal = this.expect(11)) != null && (_loop0_287_var = this._loop0_287_rule()) != null && (_loop1_288_var = this._loop1_288_rule()) != null && (a = this.expect(678)) != null && (b = this.expect(16)) != null && (expression_var = this.expression_rule()) != null) {
            _opt_var = this._tmp_289_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(11)) != null) {
                _res = this.raiseSyntaxErrorKnownRange(a, b, "cannot have both 'except' and 'except*' on the same 'try'", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        _keyword = this.expect(672);
        if (_keyword != null && (_literal = this.expect(11)) != null && (_loop0_290_var = this._loop0_290_rule()) != null && (_loop1_291_var = this._loop1_291_rule()) != null && (a = this.expect(678)) != null) {
            _opt_var = this._tmp_292_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(11)) != null) {
                _res = this.raiseSyntaxErrorKnownLocation(a, "cannot have both 'except' and 'except*' on the same 'try'", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_except_stmt_rule() {
        Token _tmp_295_var;
        Token _literal;
        Token newline_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _keyword = this.expect(678);
        if (_keyword != null) {
            ExprTy expressions_var;
            Token _literal2;
            ExprTy a;
            Token _opt_var = this.expect(16);
            if (_opt_var == null) {
                // empty if block
            }
            if ((a = this.expression_rule()) != null && (_literal2 = this.expect(12)) != null && (expressions_var = this.expressions_rule()) != null) {
                Token _literal_1;
                Object _opt_var_1 = this._tmp_293_rule();
                if (_opt_var_1 == null) {
                    // empty if block
                }
                if ((_literal_1 = this.expect(11)) != null) {
                    _res = this.raiseSyntaxErrorStartingFrom(a, "multiple exception types must be parenthesized", new Object[0]);
                    return _res;
                }
            }
        }
        this.reset(_mark);
        Token a = this.expect(678);
        if (a != null) {
            ExprTy expression_var;
            Token _opt_var = this.expect(16);
            if (_opt_var == null) {
                // empty if block
            }
            if ((expression_var = this.expression_rule()) != null) {
                Token newline_var2;
                Object _opt_var_1 = this._tmp_294_rule();
                if (_opt_var_1 == null) {
                    // empty if block
                }
                if ((newline_var2 = this.expect(4)) != null) {
                    _res = this.raiseSyntaxError("expected ':'", new Object[0]);
                    return _res;
                }
            }
        }
        this.reset(_mark);
        Token a2 = this.expect(678);
        if (a2 != null && (newline_var = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("expected ':'", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        a = this.expect(678);
        if (a != null && (_literal = this.expect(16)) != null && (_tmp_295_var = this._tmp_295_rule()) != null) {
            _res = this.raiseSyntaxError("expected one or more exception types", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_finally_stmt_rule() {
        Token newline_var;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(679);
        if (a != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'finally' statement on line %d", a.getSourceRange().startLine);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_except_stmt_indent_rule() {
        Token newline_var;
        Token _literal;
        ExprTy expression_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(678);
        if (a != null && (expression_var = this.expression_rule()) != null) {
            Token newline_var2;
            Object _opt_var = this._tmp_296_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (newline_var2 = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
                _res = this.raiseIndentationError("expected an indented block after 'except' statement on line %d", a.getSourceRange().startLine);
                return _res;
            }
        }
        this.reset(_mark);
        Token a2 = this.expect(678);
        if (a2 != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'except' statement on line %d", a2.getSourceRange().startLine);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_except_star_stmt_indent_rule() {
        ExprTy expression_var;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(678);
        if (a != null && (_literal = this.expect(16)) != null && (expression_var = this.expression_rule()) != null) {
            Token newline_var;
            Token _literal_1;
            Object _opt_var = this._tmp_297_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
                _res = this.raiseIndentationError("expected an indented block after 'except*' statement on line %d", a.getSourceRange().startLine);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_match_stmt_rule() {
        Token newline_var;
        Token _literal;
        ExprTy subject;
        Token newline_var2;
        ExprTy subject_expr_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        ExprTy.Name _keyword = this.expect_SOFT_KEYWORD("match");
        if (_keyword != null && (subject_expr_var = this.subject_expr_rule()) != null && (newline_var2 = this.expect(4)) != null) {
            _res = this.checkVersion(10, "Pattern matching is", () -> this.raiseSyntaxError("expected ':'", new Object[0]));
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        ExprTy.Name a = this.expect_SOFT_KEYWORD("match");
        if (a != null && (subject = this.subject_expr_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'match' statement on line %d", a.getSourceRange().startLine);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public Object invalid_case_block_rule() {
        PatternTy patterns_var;
        ExprTy _opt_var;
        PatternTy patterns_var2;
        int _mark = this.mark();
        RuntimeException _res = null;
        ExprTy.Name _keyword = this.expect_SOFT_KEYWORD("case");
        if (_keyword != null && (patterns_var2 = this.patterns_rule()) != null) {
            Token newline_var;
            _opt_var = this.guard_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((newline_var = this.expect(4)) != null) {
                _res = this.raiseSyntaxError("expected ':'", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        ExprTy.Name a = this.expect_SOFT_KEYWORD("case");
        if (a != null && (patterns_var = this.patterns_rule()) != null) {
            Token newline_var;
            Token _literal;
            _opt_var = this.guard_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
                _res = this.raiseIndentationError("expected an indented block after 'case' statement on line %d", a.getSourceRange().startLine);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_as_pattern_rule() {
        ExprTy a;
        Token _keyword;
        int _mark = this.mark();
        RuntimeException _res = null;
        PatternTy or_pattern_var = this.or_pattern_rule();
        if (or_pattern_var != null && (_keyword = this.expect(674)) != null && (a = this.expect_SOFT_KEYWORD("_")) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "cannot use '_' as a target", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        or_pattern_var = this.or_pattern_rule();
        if (or_pattern_var != null && (_keyword = this.expect(674)) != null && this.genLookahead_name_token(false) && (a = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "invalid pattern target", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_class_pattern_rule() {
        PatternTy[] a;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        ExprTy name_or_attr_var = this.name_or_attr_rule();
        if (name_or_attr_var != null && (_literal = this.expect(7)) != null && (a = this.invalid_class_argument_pattern_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange((SSTNode)a[0], (SSTNode)a[a.length - 1], "positional patterns follow keyword patterns", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy[] invalid_class_argument_pattern_rule() {
        PatternTy[] a;
        Token _literal;
        AbstractParser.KeyPatternPair[] keyword_patterns_var;
        int _mark = this.mark();
        PatternTy[] _res = null;
        Object _opt_var = this._tmp_298_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((keyword_patterns_var = this.keyword_patterns_rule()) != null && (_literal = this.expect(12)) != null && (a = this.positional_patterns_rule()) != null) {
            _res = a;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_if_stmt_rule() {
        Token newline_var;
        Token _literal;
        ExprTy a_1;
        Token newline_var2;
        ExprTy named_expression_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _keyword = this.expect(668);
        if (_keyword != null && (named_expression_var = this.named_expression_rule()) != null && (newline_var2 = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("expected ':'", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        Token a = this.expect(668);
        if (a != null && (a_1 = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'if' statement on line %d", a.getSourceRange().startLine);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public ExprTy invalid_elif_stmt_rule() {
        Token newline_var;
        Token _literal;
        ExprTy named_expression_var;
        Token newline_var2;
        ExprTy named_expression_var2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _keyword = this.expect(675);
        if (_keyword != null && (named_expression_var2 = this.named_expression_rule()) != null && (newline_var2 = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("expected ':'", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        Token a = this.expect(675);
        if (a != null && (named_expression_var = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'elif' statement on line %d", a.getSourceRange().startLine);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public Object invalid_else_stmt_rule() {
        Token newline_var;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(676);
        if (a != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'else' statement on line %d", a.getSourceRange().startLine);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_while_stmt_rule() {
        Token newline_var;
        Token _literal;
        ExprTy named_expression_var;
        Token newline_var2;
        ExprTy named_expression_var2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _keyword = this.expect(673);
        if (_keyword != null && (named_expression_var2 = this.named_expression_rule()) != null && (newline_var2 = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("expected ':'", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        Token a = this.expect(673);
        if (a != null && (named_expression_var = this.named_expression_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'while' statement on line %d", a.getSourceRange().startLine);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public ExprTy invalid_for_stmt_rule() {
        Token newline_var;
        Token _literal;
        ExprTy star_expressions_var;
        ExprTy star_targets_var;
        Token a;
        Token newline_var2;
        ExprTy star_expressions_var2;
        Token _keyword_1;
        ExprTy star_targets_var2;
        Token _keyword;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _opt_var = this._tmp_299_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((_keyword = this.expect(671)) != null && (star_targets_var2 = this.star_targets_rule()) != null && (_keyword_1 = this.expect(677)) != null && (star_expressions_var2 = this.star_expressions_rule()) != null && (newline_var2 = this.expect(4)) != null) {
            _res = this.raiseSyntaxError("expected ':'", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _opt_var = this._tmp_300_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((a = this.expect(671)) != null && (star_targets_var = this.star_targets_rule()) != null && (_keyword = this.expect(677)) != null && (star_expressions_var = this.star_expressions_rule()) != null && (_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
            _res = this.raiseIndentationError("expected an indented block after 'for' statement on line %d", a.getSourceRange().startLine);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public Object invalid_def_raw_rule() {
        ExprTy.Name name_var;
        Token a;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _opt_var = this._tmp_301_rule();
        if (_opt_var == null) {
            // empty if block
        }
        if ((a = this.expect(667)) != null && (name_var = this.name_token()) != null) {
            Token _literal;
            TypeParamTy[] _opt_var_1 = this._tmp_302_rule();
            if (_opt_var_1 == null) {
                // empty if block
            }
            if ((_literal = this.expect(7)) != null) {
                Token _literal_1;
                ArgumentsTy _opt_var_2 = this._tmp_303_rule();
                if (_opt_var_2 == null) {
                    // empty if block
                }
                if ((_literal_1 = this.expect(8)) != null) {
                    Token newline_var;
                    Token _literal_2;
                    Object _opt_var_3 = this._tmp_304_rule();
                    if (_opt_var_3 == null) {
                        // empty if block
                    }
                    if ((_literal_2 = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
                        _res = this.raiseIndentationError("expected an indented block after function definition on line %d", a.getSourceRange().startLine);
                        return _res;
                    }
                }
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_class_def_raw_rule() {
        ExprTy.Name name_var;
        Object _opt_var_1;
        TypeParamTy[] _opt_var;
        ExprTy.Name name_var2;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _keyword = this.expect(669);
        if (_keyword != null && (name_var2 = this.name_token()) != null) {
            Token newline_var;
            _opt_var = this._tmp_305_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_opt_var_1 = this._tmp_306_rule()) == null) {
                // empty if block
            }
            if ((newline_var = this.expect(4)) != null) {
                _res = this.raiseSyntaxError("expected ':'", new Object[0]);
                return _res;
            }
        }
        this.reset(_mark);
        Token a = this.expect(669);
        if (a != null && (name_var = this.name_token()) != null) {
            Token newline_var;
            Token _literal;
            _opt_var = this._tmp_307_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_opt_var_1 = this._tmp_308_rule()) == null) {
                // empty if block
            }
            if ((_literal = this.expect(11)) != null && (newline_var = this.expect(4)) != null && this.genLookahead_expect(false, 5)) {
                _res = this.raiseIndentationError("expected an indented block after class definition on line %d", a.getSourceRange().startLine);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_double_starred_kvpairs_rule() {
        Token a;
        ExprTy bitwise_or_var;
        Token a2;
        Token _literal;
        ExprTy invalid_kvpair_var;
        Token _literal2;
        int _mark = this.mark();
        Object _res = null;
        AbstractParser.KeyValuePair[] _gather_309_var = this._gather_309_rule();
        if (_gather_309_var != null && (_literal2 = this.expect(12)) != null && (invalid_kvpair_var = this.invalid_kvpair_rule()) != null) {
            _res = this.dummyName(_gather_309_var, _literal2, invalid_kvpair_var);
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && (_literal = this.expect(11)) != null && (a2 = this.expect(16)) != null && (bitwise_or_var = this.bitwise_or_rule()) != null) {
            _res = this.raiseSyntaxErrorStartingFrom(a2, "cannot use a starred expression in a dictionary value", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var2 = this.expression_rule();
        if (expression_var2 != null && (a = this.expect(11)) != null && this.genLookahead__tmp_311_rule(true)) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "expression expected after dictionary key and ':'", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy invalid_kvpair_rule() {
        ExprTy bitwise_or_var;
        Token a;
        Token _literal;
        int _mark = this.mark();
        RuntimeException _res = null;
        Object a2 = this.expression_rule();
        if (a2 != null && this.genLookahead__tmp_312_rule(false)) {
            _res = this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, (SSTNode)a2, "':' expected after dictionary key", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && (_literal = this.expect(11)) != null && (a = this.expect(16)) != null && (bitwise_or_var = this.bitwise_or_rule()) != null) {
            _res = this.raiseSyntaxErrorStartingFrom(a, "cannot use a starred expression in a dictionary value", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        ExprTy expression_var2 = this.expression_rule();
        if (expression_var2 != null && (a2 = this.expect(11)) != null && this.genLookahead__tmp_313_rule(true)) {
            _res = this.raiseSyntaxErrorKnownLocation((Token)a2, "expression expected after dictionary key and ':'", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public ExprTy invalid_starred_expression_rule() {
        ExprTy b;
        Token _literal;
        ExprTy expression_var;
        int _mark = this.mark();
        RuntimeException _res = null;
        Token a = this.expect(16);
        if (a != null && (expression_var = this.expression_rule()) != null && (_literal = this.expect(22)) != null && (b = this.expression_rule()) != null) {
            _res = this.raiseSyntaxErrorKnownRange(a, (SSTNode)b, "cannot assign to iterable argument unpacking", new Object[0]);
            return (ExprTy)((Object)_res);
        }
        this.reset(_mark);
        _res = null;
        return (ExprTy)((Object)_res);
    }

    public Object invalid_replacement_field_rule() {
        ExprTy _tmp_326_var;
        ExprTy _tmp_323_var;
        Object _opt_var_1;
        ExprTy _tmp_320_var;
        Token _opt_var;
        ExprTy _tmp_319_var;
        Token _literal_1;
        ExprTy _tmp_317_var;
        ExprTy _tmp_315_var;
        Token a;
        int _mark = this.mark();
        Object _res = null;
        Token _literal = this.expect(25);
        if (_literal != null && (a = this.expect(22)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "f-string: valid expression required before '='", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (a = this.expect(54)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "f-string: valid expression required before '!'", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (a = this.expect(11)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "f-string: valid expression required before ':'", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (a = this.expect(26)) != null) {
            _res = this.raiseSyntaxErrorKnownLocation(a, "f-string: valid expression required before '}'", new Object[0]);
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && this.genLookahead__tmp_314_rule(false)) {
            _res = this.raiseSyntaxErrorOnNextToken("f-string: expecting a valid expression after '{'");
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (_tmp_315_var = this._tmp_315_rule()) != null && this.genLookahead__tmp_316_rule(false)) {
            _res = this.raiseSyntaxErrorOnNextToken("f-string: expecting '=', or '!', or ':', or '}'");
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (_tmp_317_var = this._tmp_317_rule()) != null && (_literal_1 = this.expect(22)) != null && this.genLookahead__tmp_318_rule(false)) {
            _res = this.raiseSyntaxErrorOnNextToken("f-string: expecting '!', or ':', or '}'");
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (_tmp_319_var = this._tmp_319_rule()) != null) {
            Object invalid_conversion_character_var;
            _opt_var = this.expect(22);
            if (_opt_var == null) {
                // empty if block
            }
            if ((invalid_conversion_character_var = this.invalid_conversion_character_rule()) != null) {
                _res = this.dummyName(_literal, _tmp_319_var, _opt_var, invalid_conversion_character_var);
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (_tmp_320_var = this._tmp_320_rule()) != null) {
            _opt_var = this.expect(22);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_opt_var_1 = this._tmp_321_rule()) == null) {
                // empty if block
            }
            if (this.genLookahead__tmp_322_rule(false)) {
                _res = this.raiseSyntaxErrorOnNextToken("f-string: expecting ':' or '}'");
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (_tmp_323_var = this._tmp_323_rule()) != null) {
            ExprTy[] _loop0_325_var;
            Object _opt_var_12;
            Token _opt_var2 = this.expect(22);
            if (_opt_var2 == null) {
                // empty if block
            }
            if ((_opt_var_12 = this._tmp_324_rule()) == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(11)) != null && (_loop0_325_var = this._loop0_325_rule()) != null && this.genLookahead_expect(false, 26)) {
                _res = this.raiseSyntaxErrorOnNextToken("f-string: expecting '}', or format specs");
                return _res;
            }
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null && (_tmp_326_var = this._tmp_326_rule()) != null) {
            _opt_var = this.expect(22);
            if (_opt_var == null) {
                // empty if block
            }
            if ((_opt_var_1 = this._tmp_327_rule()) == null) {
                // empty if block
            }
            if (this.genLookahead_expect(false, 26)) {
                _res = this.raiseSyntaxErrorOnNextToken("f-string: expecting '}'");
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object invalid_conversion_character_rule() {
        int _mark = this.mark();
        RuntimeException _res = null;
        Token _literal = this.expect(54);
        if (_literal != null && this.genLookahead__tmp_328_rule(true)) {
            _res = this.raiseSyntaxErrorOnNextToken("f-string: missing conversion character");
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(54);
        if (_literal != null && this.genLookahead_name_token(false)) {
            _res = this.raiseSyntaxErrorOnNextToken("f-string: invalid conversion character");
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_1_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] statements_var = this.statements_rule();
        if (statements_var != null) {
            _res = statements_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token[] _loop0_2_rule() {
        Token newline_var;
        Token _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Token> _children = new ArrayList<Token>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((newline_var = this.expect(4)) != null) {
            _res = newline_var;
            if (_res instanceof Token) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Token[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Token[] _seq = _children.toArray(new Token[_children.size()]);
        this.cache.putResult(_start_mark, 1245, _seq);
        return _seq;
    }

    public ExprTy[] _tmp_3_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] type_expressions_var = this.type_expressions_rule();
        if (type_expressions_var != null) {
            _res = type_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token[] _loop0_4_rule() {
        Token newline_var;
        Token _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Token> _children = new ArrayList<Token>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((newline_var = this.expect(4)) != null) {
            _res = newline_var;
            if (_res instanceof Token) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Token[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Token[] _seq = _children.toArray(new Token[_children.size()]);
        this.cache.putResult(_start_mark, 1247, _seq);
        return _seq;
    }

    public StmtTy[] _loop1_5_rule() {
        StmtTy[] statement_var;
        StmtTy[] _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<StmtTy> _children = new ArrayList<StmtTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((statement_var = this.statement_rule()) != null) {
            _res = statement_var;
            if (_res instanceof StmtTy) {
                _children.add((StmtTy)_res);
            } else {
                _children.addAll(Arrays.asList(_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        StmtTy[] _seq = _children.toArray(new StmtTy[_children.size()]);
        this.cache.putResult(_start_mark, 1248, _seq);
        return _seq;
    }

    public StmtTy[] _loop0_7_rule() {
        StmtTy elem;
        Token _literal;
        StmtTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<StmtTy> _children = new ArrayList<StmtTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(13)) != null && (elem = this.simple_stmt_rule()) != null) {
            _res = elem;
            if (_res instanceof StmtTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((StmtTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        StmtTy[] _seq = _children.toArray(new StmtTy[_children.size()]);
        this.cache.putResult(_start_mark, 1249, _seq);
        return _seq;
    }

    public StmtTy[] _gather_6_rule() {
        StmtTy[] seq;
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy elem = this.simple_stmt_rule();
        if (elem != null && (seq = this._loop0_7_rule()) != null) {
            _res = this.insertInFront(elem, seq, StmtTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_8_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(13);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_9_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(656);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(657);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_10_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(667);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(49);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_11_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(669);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(49);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_12_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(670);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_13_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(671);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_14_rule() {
        ExprTy d;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(22);
        if (_literal != null && (d = this.annotated_rhs_rule()) != null) {
            _res = d;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_15_rule() {
        Token _literal_1;
        ExprTy b;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(7);
        if (_literal != null && (b = this.single_target_rule()) != null && (_literal_1 = this.expect(8)) != null) {
            _res = b;
            return _res;
        }
        this.reset(_mark);
        ExprTy single_subscript_attribute_target_var = this.single_subscript_attribute_target_rule();
        if (single_subscript_attribute_target_var != null) {
            _res = single_subscript_attribute_target_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_16_rule() {
        ExprTy d;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(22);
        if (_literal != null && (d = this.annotated_rhs_rule()) != null) {
            _res = d;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop1_17_rule() {
        ExprTy _tmp_329_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_329_var = this._tmp_329_rule()) != null) {
            _res = _tmp_329_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1260, _seq);
        return _seq;
    }

    public ExprTy _tmp_18_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_19_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token type_comment_var = this.expect(59);
        if (type_comment_var != null) {
            _res = type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_20_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_21_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_22_rule() {
        ExprTy z;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _keyword = this.expect(657);
        if (_keyword != null && (z = this.expression_rule()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_24_rule() {
        ExprTy.Name elem;
        Token _literal;
        ExprTy.Name _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.name_token()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1266, _seq);
        return _seq;
    }

    public ExprTy[] _gather_23_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy.Name elem = this.name_token();
        if (elem != null && (seq = this._loop0_24_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_26_rule() {
        ExprTy.Name elem;
        Token _literal;
        ExprTy.Name _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.name_token()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1268, _seq);
        return _seq;
    }

    public ExprTy[] _gather_25_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy.Name elem = this.name_token();
        if (elem != null && (seq = this._loop0_26_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_27_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(13);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        Token newline_var = this.expect(4);
        if (newline_var != null) {
            _res = newline_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_28_rule() {
        ExprTy z;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(12);
        if (_literal != null && (z = this.expression_rule()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token[] _loop0_29_rule() {
        Token _tmp_330_var;
        Token _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Token> _children = new ArrayList<Token>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_330_var = this._tmp_330_rule()) != null) {
            _res = _tmp_330_var;
            if (_res instanceof Token) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Token[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Token[] _seq = _children.toArray(new Token[_children.size()]);
        this.cache.putResult(_start_mark, 1272, _seq);
        return _seq;
    }

    public Token[] _loop1_30_rule() {
        Token _tmp_331_var;
        Token _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Token> _children = new ArrayList<Token>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_331_var = this._tmp_331_rule()) != null) {
            _res = _tmp_331_var;
            if (_res instanceof Token) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Token[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        Token[] _seq = _children.toArray(new Token[_children.size()]);
        this.cache.putResult(_start_mark, 1273, _seq);
        return _seq;
    }

    public Token _tmp_31_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AliasTy[] _loop0_33_rule() {
        AliasTy elem;
        Token _literal;
        AliasTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AliasTy> _children = new ArrayList<AliasTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.import_from_as_name_rule()) != null) {
            _res = elem;
            if (_res instanceof AliasTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AliasTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AliasTy[] _seq = _children.toArray(new AliasTy[_children.size()]);
        this.cache.putResult(_start_mark, 1275, _seq);
        return _seq;
    }

    public AliasTy[] _gather_32_rule() {
        AliasTy[] seq;
        int _mark = this.mark();
        AliasTy[] _res = null;
        AliasTy elem = this.import_from_as_name_rule();
        if (elem != null && (seq = this._loop0_33_rule()) != null) {
            _res = this.insertInFront(elem, seq, AliasTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_34_rule() {
        ExprTy.Name z;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (z = this.name_token()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AliasTy[] _loop0_36_rule() {
        AliasTy elem;
        Token _literal;
        AliasTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AliasTy> _children = new ArrayList<AliasTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.dotted_as_name_rule()) != null) {
            _res = elem;
            if (_res instanceof AliasTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AliasTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AliasTy[] _seq = _children.toArray(new AliasTy[_children.size()]);
        this.cache.putResult(_start_mark, 1278, _seq);
        return _seq;
    }

    public AliasTy[] _gather_35_rule() {
        AliasTy[] seq;
        int _mark = this.mark();
        AliasTy[] _res = null;
        AliasTy elem = this.dotted_as_name_rule();
        if (elem != null && (seq = this._loop0_36_rule()) != null) {
            _res = this.insertInFront(elem, seq, AliasTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_37_rule() {
        ExprTy.Name z;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (z = this.name_token()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop1_38_rule() {
        ExprTy _tmp_332_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_332_var = this._tmp_332_rule()) != null) {
            _res = _tmp_332_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1281, _seq);
        return _seq;
    }

    public TypeParamTy[] _tmp_39_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_40_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(7);
        if (_literal != null) {
            Token _literal_1;
            ExprTy z = this._tmp_333_rule();
            if (z == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                _res = z;
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _tmp_41_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgumentsTy _tmp_42_rule() {
        int _mark = this.mark();
        ArgumentsTy _res = null;
        ArgumentsTy params_var = this.params_rule();
        if (params_var != null) {
            _res = params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_43_rule() {
        ExprTy z;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(51);
        if (_literal != null && (z = this.expression_rule()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_44_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token func_type_comment_var = this.func_type_comment_rule();
        if (func_type_comment_var != null) {
            _res = func_type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _tmp_45_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgumentsTy _tmp_46_rule() {
        int _mark = this.mark();
        ArgumentsTy _res = null;
        ArgumentsTy params_var = this.params_rule();
        if (params_var != null) {
            _res = params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_47_rule() {
        ExprTy z;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(51);
        if (_literal != null && (z = this.expression_rule()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_48_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token func_type_comment_var = this.func_type_comment_rule();
        if (func_type_comment_var != null) {
            _res = func_type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] _loop0_49_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1292, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop0_50_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1293, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_51_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc star_etc_var = this.star_etc_rule();
        if (star_etc_var != null) {
            _res = star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_52_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1295, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_53_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc star_etc_var = this.star_etc_rule();
        if (star_etc_var != null) {
            _res = star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] _loop1_54_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1297, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop0_55_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1298, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_56_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc star_etc_var = this.star_etc_rule();
        if (star_etc_var != null) {
            _res = star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop1_57_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1300, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_58_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc star_etc_var = this.star_etc_rule();
        if (star_etc_var != null) {
            _res = star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] _loop1_59_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1302, _seq);
        return _seq;
    }

    public ArgTy[] _loop1_60_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1303, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_61_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1304, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_62_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1305, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_63_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1306, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_64_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1307, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop0_65_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1308, _seq);
        return _seq;
    }

    public ArgTy _tmp_66_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy kwds_var = this.kwds_rule();
        if (kwds_var != null) {
            _res = kwds_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_67_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1310, _seq);
        return _seq;
    }

    public ArgTy _tmp_68_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy kwds_var = this.kwds_rule();
        if (kwds_var != null) {
            _res = kwds_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop1_69_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1312, _seq);
        return _seq;
    }

    public ArgTy _tmp_70_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy kwds_var = this.kwds_rule();
        if (kwds_var != null) {
            _res = kwds_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_71_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_72_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_73_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_74_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token type_comment_var = this.expect(59);
        if (type_comment_var != null) {
            _res = type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_75_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_76_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token type_comment_var = this.expect(59);
        if (type_comment_var != null) {
            _res = type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_77_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public WithItemTy[] _loop0_79_rule() {
        WithItemTy elem;
        Token _literal;
        WithItemTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<WithItemTy> _children = new ArrayList<WithItemTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.with_item_rule()) != null) {
            _res = elem;
            if (_res instanceof WithItemTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((WithItemTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        WithItemTy[] _seq = _children.toArray(new WithItemTy[_children.size()]);
        this.cache.putResult(_start_mark, 1321, _seq);
        return _seq;
    }

    public WithItemTy[] _gather_78_rule() {
        WithItemTy[] seq;
        int _mark = this.mark();
        WithItemTy[] _res = null;
        WithItemTy elem = this.with_item_rule();
        if (elem != null && (seq = this._loop0_79_rule()) != null) {
            _res = this.insertInFront(elem, seq, WithItemTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public WithItemTy[] _loop0_81_rule() {
        WithItemTy elem;
        Token _literal;
        WithItemTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<WithItemTy> _children = new ArrayList<WithItemTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.with_item_rule()) != null) {
            _res = elem;
            if (_res instanceof WithItemTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((WithItemTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        WithItemTy[] _seq = _children.toArray(new WithItemTy[_children.size()]);
        this.cache.putResult(_start_mark, 1323, _seq);
        return _seq;
    }

    public WithItemTy[] _gather_80_rule() {
        WithItemTy[] seq;
        int _mark = this.mark();
        WithItemTy[] _res = null;
        WithItemTy elem = this.with_item_rule();
        if (elem != null && (seq = this._loop0_81_rule()) != null) {
            _res = this.insertInFront(elem, seq, WithItemTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_82_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token type_comment_var = this.expect(59);
        if (type_comment_var != null) {
            _res = type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public WithItemTy[] _loop0_84_rule() {
        WithItemTy elem;
        Token _literal;
        WithItemTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<WithItemTy> _children = new ArrayList<WithItemTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.with_item_rule()) != null) {
            _res = elem;
            if (_res instanceof WithItemTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((WithItemTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        WithItemTy[] _seq = _children.toArray(new WithItemTy[_children.size()]);
        this.cache.putResult(_start_mark, 1326, _seq);
        return _seq;
    }

    public WithItemTy[] _gather_83_rule() {
        WithItemTy[] seq;
        int _mark = this.mark();
        WithItemTy[] _res = null;
        WithItemTy elem = this.with_item_rule();
        if (elem != null && (seq = this._loop0_84_rule()) != null) {
            _res = this.insertInFront(elem, seq, WithItemTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public WithItemTy[] _loop0_86_rule() {
        WithItemTy elem;
        Token _literal;
        WithItemTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<WithItemTy> _children = new ArrayList<WithItemTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.with_item_rule()) != null) {
            _res = elem;
            if (_res instanceof WithItemTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((WithItemTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        WithItemTy[] _seq = _children.toArray(new WithItemTy[_children.size()]);
        this.cache.putResult(_start_mark, 1328, _seq);
        return _seq;
    }

    public WithItemTy[] _gather_85_rule() {
        WithItemTy[] seq;
        int _mark = this.mark();
        WithItemTy[] _res = null;
        WithItemTy elem = this.with_item_rule();
        if (elem != null && (seq = this._loop0_86_rule()) != null) {
            _res = this.insertInFront(elem, seq, WithItemTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_87_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token type_comment_var = this.expect(59);
        if (type_comment_var != null) {
            _res = type_comment_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_88_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(8);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExceptHandlerTy[] _loop1_89_rule() {
        ExceptHandlerTy except_block_var;
        ExceptHandlerTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExceptHandlerTy> _children = new ArrayList<ExceptHandlerTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((except_block_var = this.except_block_rule()) != null) {
            _res = except_block_var;
            if (_res instanceof ExceptHandlerTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExceptHandlerTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExceptHandlerTy[] _seq = _children.toArray(new ExceptHandlerTy[_children.size()]);
        this.cache.putResult(_start_mark, 1332, _seq);
        return _seq;
    }

    public StmtTy[] _tmp_90_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_91_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] finally_block_var = this.finally_block_rule();
        if (finally_block_var != null) {
            _res = finally_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExceptHandlerTy[] _loop1_92_rule() {
        ExceptHandlerTy except_star_block_var;
        ExceptHandlerTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExceptHandlerTy> _children = new ArrayList<ExceptHandlerTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((except_star_block_var = this.except_star_block_rule()) != null) {
            _res = except_star_block_var;
            if (_res instanceof ExceptHandlerTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExceptHandlerTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExceptHandlerTy[] _seq = _children.toArray(new ExceptHandlerTy[_children.size()]);
        this.cache.putResult(_start_mark, 1335, _seq);
        return _seq;
    }

    public StmtTy[] _tmp_93_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] else_block_var = this.else_block_rule();
        if (else_block_var != null) {
            _res = else_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _tmp_94_rule() {
        int _mark = this.mark();
        StmtTy[] _res = null;
        StmtTy[] finally_block_var = this.finally_block_rule();
        if (finally_block_var != null) {
            _res = finally_block_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_95_rule() {
        ExprTy.Name z;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (z = this.name_token()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_96_rule() {
        ExprTy.Name z;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (z = this.name_token()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public MatchCaseTy[] _loop1_97_rule() {
        MatchCaseTy case_block_var;
        MatchCaseTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<MatchCaseTy> _children = new ArrayList<MatchCaseTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((case_block_var = this.case_block_rule()) != null) {
            _res = case_block_var;
            if (_res instanceof MatchCaseTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((MatchCaseTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        MatchCaseTy[] _seq = _children.toArray(new MatchCaseTy[_children.size()]);
        this.cache.putResult(_start_mark, 1340, _seq);
        return _seq;
    }

    public PatternTy[] _loop0_99_rule() {
        PatternTy elem;
        Token _literal;
        PatternTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<PatternTy> _children = new ArrayList<PatternTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(18)) != null && (elem = this.closed_pattern_rule()) != null) {
            _res = elem;
            if (_res instanceof PatternTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((PatternTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        PatternTy[] _seq = _children.toArray(new PatternTy[_children.size()]);
        this.cache.putResult(_start_mark, 1341, _seq);
        return _seq;
    }

    public PatternTy[] _gather_98_rule() {
        PatternTy[] seq;
        int _mark = this.mark();
        PatternTy[] _res = null;
        PatternTy elem = this.closed_pattern_rule();
        if (elem != null && (seq = this._loop0_99_rule()) != null) {
            _res = this.insertInFront(elem, seq, PatternTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_100_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(14);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(15);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_101_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(14);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(15);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_102_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(23);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(22);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_103_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(23);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(22);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy[] _loop0_105_rule() {
        PatternTy elem;
        Token _literal;
        PatternTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<PatternTy> _children = new ArrayList<PatternTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.maybe_star_pattern_rule()) != null) {
            _res = elem;
            if (_res instanceof PatternTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((PatternTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        PatternTy[] _seq = _children.toArray(new PatternTy[_children.size()]);
        this.cache.putResult(_start_mark, 1347, _seq);
        return _seq;
    }

    public PatternTy[] _gather_104_rule() {
        PatternTy[] seq;
        int _mark = this.mark();
        PatternTy[] _res = null;
        PatternTy elem = this.maybe_star_pattern_rule();
        if (elem != null && (seq = this._loop0_105_rule()) != null) {
            _res = this.insertInFront(elem, seq, PatternTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyPatternPair[] _loop0_107_rule() {
        AbstractParser.KeyPatternPair elem;
        Token _literal;
        AbstractParser.KeyPatternPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeyPatternPair> _children = new ArrayList<AbstractParser.KeyPatternPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.key_value_pattern_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeyPatternPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeyPatternPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeyPatternPair[] _seq = _children.toArray(new AbstractParser.KeyPatternPair[_children.size()]);
        this.cache.putResult(_start_mark, 1349, _seq);
        return _seq;
    }

    public AbstractParser.KeyPatternPair[] _gather_106_rule() {
        AbstractParser.KeyPatternPair[] seq;
        int _mark = this.mark();
        AbstractParser.KeyPatternPair[] _res = null;
        AbstractParser.KeyPatternPair elem = this.key_value_pattern_rule();
        if (elem != null && (seq = this._loop0_107_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeyPatternPair.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_108_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy literal_expr_var = this.literal_expr_rule();
        if (literal_expr_var != null) {
            _res = literal_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy attr_var = this.attr_rule();
        if (attr_var != null) {
            _res = attr_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public PatternTy[] _loop0_110_rule() {
        PatternTy elem;
        Token _literal;
        PatternTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<PatternTy> _children = new ArrayList<PatternTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.pattern_rule()) != null) {
            _res = elem;
            if (_res instanceof PatternTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((PatternTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        PatternTy[] _seq = _children.toArray(new PatternTy[_children.size()]);
        this.cache.putResult(_start_mark, 1352, _seq);
        return _seq;
    }

    public PatternTy[] _gather_109_rule() {
        PatternTy[] seq;
        int _mark = this.mark();
        PatternTy[] _res = null;
        PatternTy elem = this.pattern_rule();
        if (elem != null && (seq = this._loop0_110_rule()) != null) {
            _res = this.insertInFront(elem, seq, PatternTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyPatternPair[] _loop0_112_rule() {
        AbstractParser.KeyPatternPair elem;
        Token _literal;
        AbstractParser.KeyPatternPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeyPatternPair> _children = new ArrayList<AbstractParser.KeyPatternPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.keyword_pattern_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeyPatternPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeyPatternPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeyPatternPair[] _seq = _children.toArray(new AbstractParser.KeyPatternPair[_children.size()]);
        this.cache.putResult(_start_mark, 1354, _seq);
        return _seq;
    }

    public AbstractParser.KeyPatternPair[] _gather_111_rule() {
        AbstractParser.KeyPatternPair[] seq;
        int _mark = this.mark();
        AbstractParser.KeyPatternPair[] _res = null;
        AbstractParser.KeyPatternPair elem = this.keyword_pattern_rule();
        if (elem != null && (seq = this._loop0_112_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeyPatternPair.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _tmp_113_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _loop0_115_rule() {
        TypeParamTy elem;
        Token _literal;
        TypeParamTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<TypeParamTy> _children = new ArrayList<TypeParamTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.type_param_rule()) != null) {
            _res = elem;
            if (_res instanceof TypeParamTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((TypeParamTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        TypeParamTy[] _seq = _children.toArray(new TypeParamTy[_children.size()]);
        this.cache.putResult(_start_mark, 1357, _seq);
        return _seq;
    }

    public TypeParamTy[] _gather_114_rule() {
        TypeParamTy[] seq;
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy elem = this.type_param_rule();
        if (elem != null && (seq = this._loop0_115_rule()) != null) {
            _res = this.insertInFront(elem, seq, TypeParamTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_116_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_117_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy type_param_bound_var = this.type_param_bound_rule();
        if (type_param_bound_var != null) {
            _res = type_param_bound_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop1_118_rule() {
        ExprTy _tmp_334_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_334_var = this._tmp_334_rule()) != null) {
            _res = _tmp_334_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1361, _seq);
        return _seq;
    }

    public Token _tmp_119_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_120_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop1_121_rule() {
        ExprTy _tmp_335_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_335_var = this._tmp_335_rule()) != null) {
            _res = _tmp_335_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1364, _seq);
        return _seq;
    }

    public Token _tmp_122_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_124_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.star_named_expression_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1366, _seq);
        return _seq;
    }

    public ExprTy[] _gather_123_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.star_named_expression_rule();
        if (elem != null && (seq = this._loop0_124_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_125_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop1_126_rule() {
        ExprTy _tmp_336_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_336_var = this._tmp_336_rule()) != null) {
            _res = _tmp_336_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1369, _seq);
        return _seq;
    }

    public ExprTy[] _loop1_127_rule() {
        ExprTy _tmp_337_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_337_var = this._tmp_337_rule()) != null) {
            _res = _tmp_337_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1370, _seq);
        return _seq;
    }

    public AbstractParser.CmpopExprPair[] _loop1_128_rule() {
        AbstractParser.CmpopExprPair compare_op_bitwise_or_pair_var;
        AbstractParser.CmpopExprPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.CmpopExprPair> _children = new ArrayList<AbstractParser.CmpopExprPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((compare_op_bitwise_or_pair_var = this.compare_op_bitwise_or_pair_rule()) != null) {
            _res = compare_op_bitwise_or_pair_var;
            if (_res instanceof AbstractParser.CmpopExprPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.CmpopExprPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.CmpopExprPair[] _seq = _children.toArray(new AbstractParser.CmpopExprPair[_children.size()]);
        this.cache.putResult(_start_mark, 1371, _seq);
        return _seq;
    }

    public Token _tmp_129_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token tok = this.expect(28);
        if (tok != null) {
            _res = this.checkBarryAsFlufl(tok) ? null : tok;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_130_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy arguments_var = this.arguments_rule();
        if (arguments_var != null) {
            _res = arguments_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_132_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_338_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1374, _seq);
        return _seq;
    }

    public ExprTy[] _gather_131_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this._tmp_338_rule();
        if (elem != null && (seq = this._loop0_132_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_133_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_134_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_135_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_136_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(11);
        if (_literal != null) {
            ExprTy d = this._tmp_339_rule();
            if (d == null) {
                // empty if block
            }
            _res = d;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_137_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token string_var = this.string_token();
        if (string_var != null) {
            _res = string_var;
            return _res;
        }
        this.reset(_mark);
        Token fstring_start_var = this.expect(61);
        if (fstring_start_var != null) {
            _res = fstring_start_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_138_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy tuple_var = this.tuple_rule();
        if (tuple_var != null) {
            _res = tuple_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy group_var = this.group_rule();
        if (group_var != null) {
            _res = group_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy genexp_var = this.genexp_rule();
        if (genexp_var != null) {
            _res = genexp_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_139_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy list_var = this.list_rule();
        if (list_var != null) {
            _res = list_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy listcomp_var = this.listcomp_rule();
        if (listcomp_var != null) {
            _res = listcomp_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_140_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy dict_var = this.dict_rule();
        if (dict_var != null) {
            _res = dict_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy set_var = this.set_rule();
        if (set_var != null) {
            _res = set_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy dictcomp_var = this.dictcomp_rule();
        if (dictcomp_var != null) {
            _res = dictcomp_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy setcomp_var = this.setcomp_rule();
        if (setcomp_var != null) {
            _res = setcomp_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_141_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy named_expression_var = this.named_expression_rule();
        if (named_expression_var != null) {
            _res = named_expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgumentsTy _tmp_142_rule() {
        int _mark = this.mark();
        ArgumentsTy _res = null;
        ArgumentsTy lambda_params_var = this.lambda_params_rule();
        if (lambda_params_var != null) {
            _res = lambda_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] _loop0_143_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1386, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop0_144_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1387, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_145_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc lambda_star_etc_var = this.lambda_star_etc_rule();
        if (lambda_star_etc_var != null) {
            _res = lambda_star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_146_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1389, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_147_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc lambda_star_etc_var = this.lambda_star_etc_rule();
        if (lambda_star_etc_var != null) {
            _res = lambda_star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] _loop1_148_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1391, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop0_149_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1392, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_150_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc lambda_star_etc_var = this.lambda_star_etc_rule();
        if (lambda_star_etc_var != null) {
            _res = lambda_star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop1_151_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1394, _seq);
        return _seq;
    }

    public AbstractParser.StarEtc _tmp_152_rule() {
        int _mark = this.mark();
        AbstractParser.StarEtc _res = null;
        AbstractParser.StarEtc lambda_star_etc_var = this.lambda_star_etc_rule();
        if (lambda_star_etc_var != null) {
            _res = lambda_star_etc_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgTy[] _loop1_153_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1396, _seq);
        return _seq;
    }

    public ArgTy[] _loop1_154_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1397, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_155_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1398, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_156_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1399, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_157_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1400, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_158_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1401, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop0_159_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1402, _seq);
        return _seq;
    }

    public ArgTy _tmp_160_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy lambda_kwds_var = this.lambda_kwds_rule();
        if (lambda_kwds_var != null) {
            _res = lambda_kwds_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop1_161_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1404, _seq);
        return _seq;
    }

    public ArgTy _tmp_162_rule() {
        int _mark = this.mark();
        ArgTy _res = null;
        ArgTy lambda_kwds_var = this.lambda_kwds_rule();
        if (lambda_kwds_var != null) {
            _res = lambda_kwds_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_163_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.ResultTokenWithMetadata _tmp_164_rule() {
        int _mark = this.mark();
        AbstractParser.ResultTokenWithMetadata _res = null;
        AbstractParser.ResultTokenWithMetadata fstring_conversion_var = this.fstring_conversion_rule();
        if (fstring_conversion_var != null) {
            _res = fstring_conversion_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.ResultTokenWithMetadata _tmp_165_rule() {
        int _mark = this.mark();
        AbstractParser.ResultTokenWithMetadata _res = null;
        AbstractParser.ResultTokenWithMetadata fstring_full_format_spec_var = this.fstring_full_format_spec_rule();
        if (fstring_full_format_spec_var != null) {
            _res = fstring_full_format_spec_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_166_rule() {
        ExprTy fstring_format_spec_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((fstring_format_spec_var = this.fstring_format_spec_rule()) != null) {
            _res = fstring_format_spec_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1409, _seq);
        return _seq;
    }

    public ExprTy[] _loop0_167_rule() {
        ExprTy fstring_middle_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((fstring_middle_var = this.fstring_middle_rule()) != null) {
            _res = fstring_middle_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1410, _seq);
        return _seq;
    }

    public ExprTy[] _loop1_168_rule() {
        ExprTy _tmp_340_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_340_var = this._tmp_340_rule()) != null) {
            _res = _tmp_340_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1411, _seq);
        return _seq;
    }

    public ExprTy[] _tmp_169_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] star_named_expressions_var = this.star_named_expressions_rule();
        if (star_named_expressions_var != null) {
            _res = star_named_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _tmp_170_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy y = this.star_named_expression_rule();
        if (y != null && (_literal = this.expect(12)) != null) {
            ExprTy[] z = this._tmp_341_rule();
            if (z == null) {
                // empty if block
            }
            _res = this.insertInFront(y, z);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyValuePair[] _tmp_171_rule() {
        int _mark = this.mark();
        AbstractParser.KeyValuePair[] _res = null;
        AbstractParser.KeyValuePair[] double_starred_kvpairs_var = this.double_starred_kvpairs_rule();
        if (double_starred_kvpairs_var != null) {
            _res = double_starred_kvpairs_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyValuePair[] _loop0_173_rule() {
        AbstractParser.KeyValuePair elem;
        Token _literal;
        AbstractParser.KeyValuePair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeyValuePair> _children = new ArrayList<AbstractParser.KeyValuePair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.double_starred_kvpair_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeyValuePair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeyValuePair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeyValuePair[] _seq = _children.toArray(new AbstractParser.KeyValuePair[_children.size()]);
        this.cache.putResult(_start_mark, 1415, _seq);
        return _seq;
    }

    public AbstractParser.KeyValuePair[] _gather_172_rule() {
        AbstractParser.KeyValuePair[] seq;
        int _mark = this.mark();
        AbstractParser.KeyValuePair[] _res = null;
        AbstractParser.KeyValuePair elem = this.double_starred_kvpair_rule();
        if (elem != null && (seq = this._loop0_173_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeyValuePair.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_174_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ComprehensionTy[] _loop1_175_rule() {
        ComprehensionTy for_if_clause_var;
        ComprehensionTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ComprehensionTy> _children = new ArrayList<ComprehensionTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((for_if_clause_var = this.for_if_clause_rule()) != null) {
            _res = for_if_clause_var;
            if (_res instanceof ComprehensionTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ComprehensionTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ComprehensionTy[] _seq = _children.toArray(new ComprehensionTy[_children.size()]);
        this.cache.putResult(_start_mark, 1418, _seq);
        return _seq;
    }

    public ExprTy[] _loop0_176_rule() {
        ExprTy _tmp_342_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_342_var = this._tmp_342_rule()) != null) {
            _res = _tmp_342_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1419, _seq);
        return _seq;
    }

    public ExprTy[] _loop0_177_rule() {
        ExprTy _tmp_343_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_343_var = this._tmp_343_rule()) != null) {
            _res = _tmp_343_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1420, _seq);
        return _seq;
    }

    public ExprTy _tmp_178_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy assignment_expression_var = this.assignment_expression_rule();
        if (assignment_expression_var != null) {
            _res = assignment_expression_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && this.genLookahead_expect(false, 53)) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_179_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_181_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_344_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1423, _seq);
        return _seq;
    }

    public ExprTy[] _gather_180_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this._tmp_344_rule();
        if (elem != null && (seq = this._loop0_181_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeywordOrStarred[] _tmp_182_rule() {
        AbstractParser.KeywordOrStarred[] k;
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        Token _literal = this.expect(12);
        if (_literal != null && (k = this.kwargs_rule()) != null) {
            _res = k;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeywordOrStarred[] _loop0_184_rule() {
        AbstractParser.KeywordOrStarred elem;
        Token _literal;
        AbstractParser.KeywordOrStarred _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeywordOrStarred> _children = new ArrayList<AbstractParser.KeywordOrStarred>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.kwarg_or_starred_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeywordOrStarred) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeywordOrStarred[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] _seq = _children.toArray(new AbstractParser.KeywordOrStarred[_children.size()]);
        this.cache.putResult(_start_mark, 1426, _seq);
        return _seq;
    }

    public AbstractParser.KeywordOrStarred[] _gather_183_rule() {
        AbstractParser.KeywordOrStarred[] seq;
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        AbstractParser.KeywordOrStarred elem = this.kwarg_or_starred_rule();
        if (elem != null && (seq = this._loop0_184_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeywordOrStarred.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeywordOrStarred[] _loop0_186_rule() {
        AbstractParser.KeywordOrStarred elem;
        Token _literal;
        AbstractParser.KeywordOrStarred _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeywordOrStarred> _children = new ArrayList<AbstractParser.KeywordOrStarred>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.kwarg_or_double_starred_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeywordOrStarred) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeywordOrStarred[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] _seq = _children.toArray(new AbstractParser.KeywordOrStarred[_children.size()]);
        this.cache.putResult(_start_mark, 1428, _seq);
        return _seq;
    }

    public AbstractParser.KeywordOrStarred[] _gather_185_rule() {
        AbstractParser.KeywordOrStarred[] seq;
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        AbstractParser.KeywordOrStarred elem = this.kwarg_or_double_starred_rule();
        if (elem != null && (seq = this._loop0_186_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeywordOrStarred.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeywordOrStarred[] _loop0_188_rule() {
        AbstractParser.KeywordOrStarred elem;
        Token _literal;
        AbstractParser.KeywordOrStarred _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeywordOrStarred> _children = new ArrayList<AbstractParser.KeywordOrStarred>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.kwarg_or_starred_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeywordOrStarred) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeywordOrStarred[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] _seq = _children.toArray(new AbstractParser.KeywordOrStarred[_children.size()]);
        this.cache.putResult(_start_mark, 1430, _seq);
        return _seq;
    }

    public AbstractParser.KeywordOrStarred[] _gather_187_rule() {
        AbstractParser.KeywordOrStarred[] seq;
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        AbstractParser.KeywordOrStarred elem = this.kwarg_or_starred_rule();
        if (elem != null && (seq = this._loop0_188_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeywordOrStarred.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeywordOrStarred[] _loop0_190_rule() {
        AbstractParser.KeywordOrStarred elem;
        Token _literal;
        AbstractParser.KeywordOrStarred _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeywordOrStarred> _children = new ArrayList<AbstractParser.KeywordOrStarred>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.kwarg_or_double_starred_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeywordOrStarred) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeywordOrStarred[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] _seq = _children.toArray(new AbstractParser.KeywordOrStarred[_children.size()]);
        this.cache.putResult(_start_mark, 1432, _seq);
        return _seq;
    }

    public AbstractParser.KeywordOrStarred[] _gather_189_rule() {
        AbstractParser.KeywordOrStarred[] seq;
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        AbstractParser.KeywordOrStarred elem = this.kwarg_or_double_starred_rule();
        if (elem != null && (seq = this._loop0_190_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeywordOrStarred.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_191_rule() {
        ExprTy _tmp_345_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_345_var = this._tmp_345_rule()) != null) {
            _res = _tmp_345_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1434, _seq);
        return _seq;
    }

    public Token _tmp_192_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_194_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.star_target_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1436, _seq);
        return _seq;
    }

    public ExprTy[] _gather_193_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.star_target_rule();
        if (elem != null && (seq = this._loop0_194_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_195_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop1_196_rule() {
        ExprTy _tmp_346_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_346_var = this._tmp_346_rule()) != null) {
            _res = _tmp_346_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1439, _seq);
        return _seq;
    }

    public Token _tmp_197_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_198_rule() {
        ExprTy star_target_var;
        int _mark = this.mark();
        ExprTy _res = null;
        if (this.genLookahead_expect(false, 16) && (star_target_var = this.star_target_rule()) != null) {
            _res = star_target_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _tmp_199_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] star_targets_tuple_seq_var = this.star_targets_tuple_seq_rule();
        if (star_targets_tuple_seq_var != null) {
            _res = star_targets_tuple_seq_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _tmp_200_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] star_targets_list_seq_var = this.star_targets_list_seq_rule();
        if (star_targets_list_seq_var != null) {
            _res = star_targets_list_seq_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_201_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy arguments_var = this.arguments_rule();
        if (arguments_var != null) {
            _res = arguments_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_203_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.del_target_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1445, _seq);
        return _seq;
    }

    public ExprTy[] _gather_202_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.del_target_rule();
        if (elem != null && (seq = this._loop0_203_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_204_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _tmp_205_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] del_targets_var = this.del_targets_rule();
        if (del_targets_var != null) {
            _res = del_targets_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _tmp_206_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] del_targets_var = this.del_targets_rule();
        if (del_targets_var != null) {
            _res = del_targets_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_208_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.expression_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1450, _seq);
        return _seq;
    }

    public ExprTy[] _gather_207_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.expression_rule();
        if (elem != null && (seq = this._loop0_208_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_210_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.expression_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1452, _seq);
        return _seq;
    }

    public ExprTy[] _gather_209_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.expression_rule();
        if (elem != null && (seq = this._loop0_210_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_212_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.expression_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1454, _seq);
        return _seq;
    }

    public ExprTy[] _gather_211_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.expression_rule();
        if (elem != null && (seq = this._loop0_212_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_214_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.expression_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1456, _seq);
        return _seq;
    }

    public ExprTy[] _gather_213_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.expression_rule();
        if (elem != null && (seq = this._loop0_214_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_215_rule() {
        Token indent_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token newline_var = this.expect(4);
        if (newline_var != null && (indent_var = this.expect(5)) != null) {
            _res = this.dummyName(newline_var, indent_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_216_rule() {
        int _mark = this.mark();
        AbstractParser.KeywordOrStarred[] _res = null;
        AbstractParser.KeywordOrStarred[] _tmp_347_var = this._tmp_347_rule();
        if (_tmp_347_var != null) {
            _res = _tmp_347_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.KeywordOrStarred[] kwargs_var = this.kwargs_rule();
        if (kwargs_var != null) {
            _res = kwargs_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_218_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_348_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1460, _seq);
        return _seq;
    }

    public ExprTy[] _gather_217_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this._tmp_348_rule();
        if (elem != null && (seq = this._loop0_218_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_219_rule() {
        ComprehensionTy[] for_if_clauses_var;
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy args_var = this.args_rule();
        if (args_var != null) {
            _res = args_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && (for_if_clauses_var = this.for_if_clauses_rule()) != null) {
            _res = this.dummyName(expression_var, for_if_clauses_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_220_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy args_var = this.args_rule();
        if (args_var != null && (_literal = this.expect(12)) != null) {
            _res = this.dummyName(args_var, _literal);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_221_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(8);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_222_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(681);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(682);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(680);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_223_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy.Name name_var = this.name_token();
        if (name_var != null && (_literal = this.expect(22)) != null) {
            _res = this.dummyName(name_var, _literal);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_224_rule() {
        Token string_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy.Name name_var = this.name_token();
        if (name_var != null && (string_var = this.string_token()) != null) {
            _res = this.dummyName(name_var, string_var);
            return _res;
        }
        this.reset(_mark);
        ExprTy.Name soft_keyword_var = this.soft_keyword_token();
        if (soft_keyword_var != null) {
            _res = soft_keyword_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_225_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(676);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgumentsTy _tmp_226_rule() {
        int _mark = this.mark();
        ArgumentsTy _res = null;
        ArgumentsTy lambda_params_var = this.lambda_params_rule();
        if (lambda_params_var != null) {
            _res = lambda_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_227_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(22);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(53);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_228_rule() {
        int _mark = this.mark();
        Object _res = null;
        ExprTy list_var = this.list_rule();
        if (list_var != null) {
            _res = list_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy tuple_var = this.tuple_rule();
        if (tuple_var != null) {
            _res = tuple_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy genexp_var = this.genexp_rule();
        if (genexp_var != null) {
            _res = genexp_var;
            return _res;
        }
        this.reset(_mark);
        Token _keyword = this.expect(681);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(680);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(682);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_229_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(22);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(53);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_230_rule() {
        ExprTy[] star_named_expressions_var;
        ExprTy[] _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((star_named_expressions_var = this.star_named_expressions_rule()) != null) {
            _res = star_named_expressions_var;
            if (_res instanceof ExprTy) {
                _children.add((ExprTy)_res);
            } else {
                _children.addAll(Arrays.asList(_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1473, _seq);
        return _seq;
    }

    public Object[] _loop0_231_rule() {
        Object _tmp_349_var;
        Object _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Object> _children = new ArrayList<Object>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_349_var = this._tmp_349_rule()) != null) {
            _res = _tmp_349_var;
            if (_res instanceof Object) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Object[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Object[] _seq = _children.toArray(new Object[_children.size()]);
        this.cache.putResult(_start_mark, 1474, _seq);
        return _seq;
    }

    public Object[] _loop0_232_rule() {
        Object _tmp_350_var;
        Object _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Object> _children = new ArrayList<Object>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_tmp_350_var = this._tmp_350_rule()) != null) {
            _res = _tmp_350_var;
            if (_res instanceof Object) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Object[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Object[] _seq = _children.toArray(new Object[_children.size()]);
        this.cache.putResult(_start_mark, 1475, _seq);
        return _seq;
    }

    public ExprTy _tmp_233_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_234_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(9);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(7);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_235_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(9);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_236_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(9);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(25);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_237_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy[] slash_no_default_var = this.slash_no_default_rule();
        if (slash_no_default_var != null) {
            _res = slash_no_default_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.SlashWithDefault slash_with_default_var = this.slash_with_default_rule();
        if (slash_with_default_var != null) {
            _res = slash_with_default_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_238_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1481, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_239_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1482, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_240_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1483, _seq);
        return _seq;
    }

    public ArgTy[] _loop1_241_rule() {
        ArgTy param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_no_default_var = this.param_no_default_rule()) != null) {
            _res = param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1484, _seq);
        return _seq;
    }

    public Object _tmp_242_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy[] slash_no_default_var = this.slash_no_default_rule();
        if (slash_no_default_var != null) {
            _res = slash_no_default_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.SlashWithDefault slash_with_default_var = this.slash_with_default_rule();
        if (slash_with_default_var != null) {
            _res = slash_with_default_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_243_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1486, _seq);
        return _seq;
    }

    public Object _tmp_244_rule() {
        int _mark = this.mark();
        Object _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        ArgTy param_no_default_var = this.param_no_default_rule();
        if (param_no_default_var != null) {
            _res = param_no_default_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_245_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1488, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_246_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1489, _seq);
        return _seq;
    }

    public Token _tmp_247_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(8);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_248_rule() {
        Token _tmp_351_var;
        int _mark = this.mark();
        Object _res = null;
        Token _literal = this.expect(8);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(12);
        if (_literal != null && (_tmp_351_var = this._tmp_351_rule()) != null) {
            _res = this.dummyName(_literal, _tmp_351_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_249_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy param_no_default_var = this.param_no_default_rule();
        if (param_no_default_var != null) {
            _res = param_no_default_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_250_rule() {
        AbstractParser.NameDefaultPair param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_maybe_default_var = this.param_maybe_default_rule()) != null) {
            _res = param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1493, _seq);
        return _seq;
    }

    public Object _tmp_251_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy param_no_default_var = this.param_no_default_rule();
        if (param_no_default_var != null) {
            _res = param_no_default_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_252_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(16);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(17);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop1_253_rule() {
        AbstractParser.NameDefaultPair param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((param_with_default_var = this.param_with_default_rule()) != null) {
            _res = param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1496, _seq);
        return _seq;
    }

    public Object _tmp_254_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy[] lambda_slash_no_default_var = this.lambda_slash_no_default_rule();
        if (lambda_slash_no_default_var != null) {
            _res = lambda_slash_no_default_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.SlashWithDefault lambda_slash_with_default_var = this.lambda_slash_with_default_rule();
        if (lambda_slash_with_default_var != null) {
            _res = lambda_slash_with_default_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_255_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1498, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_256_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1499, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_257_rule() {
        ArgTy lambda_param_no_default_var;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_no_default_var = this.lambda_param_no_default_rule()) != null) {
            _res = lambda_param_no_default_var;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1500, _seq);
        return _seq;
    }

    public ArgTy[] _loop0_259_rule() {
        ArgTy elem;
        Token _literal;
        ArgTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ArgTy> _children = new ArrayList<ArgTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.lambda_param_rule()) != null) {
            _res = elem;
            if (_res instanceof ArgTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ArgTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ArgTy[] _seq = _children.toArray(new ArgTy[_children.size()]);
        this.cache.putResult(_start_mark, 1501, _seq);
        return _seq;
    }

    public ArgTy[] _gather_258_rule() {
        ArgTy[] seq;
        int _mark = this.mark();
        ArgTy[] _res = null;
        ArgTy elem = this.lambda_param_rule();
        if (elem != null && (seq = this._loop0_259_rule()) != null) {
            _res = this.insertInFront(elem, seq, ArgTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_260_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy[] lambda_slash_no_default_var = this.lambda_slash_no_default_rule();
        if (lambda_slash_no_default_var != null) {
            _res = lambda_slash_no_default_var;
            return _res;
        }
        this.reset(_mark);
        AbstractParser.SlashWithDefault lambda_slash_with_default_var = this.lambda_slash_with_default_rule();
        if (lambda_slash_with_default_var != null) {
            _res = lambda_slash_with_default_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_261_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1504, _seq);
        return _seq;
    }

    public Object _tmp_262_rule() {
        int _mark = this.mark();
        Object _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        ArgTy lambda_param_no_default_var = this.lambda_param_no_default_rule();
        if (lambda_param_no_default_var != null) {
            _res = lambda_param_no_default_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_263_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1506, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_264_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1507, _seq);
        return _seq;
    }

    public AbstractParser.NameDefaultPair[] _loop1_265_rule() {
        AbstractParser.NameDefaultPair lambda_param_with_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_with_default_var = this.lambda_param_with_default_rule()) != null) {
            _res = lambda_param_with_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1508, _seq);
        return _seq;
    }

    public Object _tmp_266_rule() {
        Token _tmp_352_var;
        int _mark = this.mark();
        Object _res = null;
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(12);
        if (_literal != null && (_tmp_352_var = this._tmp_352_rule()) != null) {
            _res = this.dummyName(_literal, _tmp_352_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_267_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy lambda_param_no_default_var = this.lambda_param_no_default_rule();
        if (lambda_param_no_default_var != null) {
            _res = lambda_param_no_default_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.NameDefaultPair[] _loop0_268_rule() {
        AbstractParser.NameDefaultPair lambda_param_maybe_default_var;
        AbstractParser.NameDefaultPair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.NameDefaultPair> _children = new ArrayList<AbstractParser.NameDefaultPair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((lambda_param_maybe_default_var = this.lambda_param_maybe_default_rule()) != null) {
            _res = lambda_param_maybe_default_var;
            if (_res instanceof AbstractParser.NameDefaultPair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.NameDefaultPair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.NameDefaultPair[] _seq = _children.toArray(new AbstractParser.NameDefaultPair[_children.size()]);
        this.cache.putResult(_start_mark, 1511, _seq);
        return _seq;
    }

    public Object _tmp_269_rule() {
        int _mark = this.mark();
        Object _res = null;
        ArgTy lambda_param_no_default_var = this.lambda_param_no_default_rule();
        if (lambda_param_no_default_var != null) {
            _res = lambda_param_no_default_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_270_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(16);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(17);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_271_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(8);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_273_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.dotted_name_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1515, _seq);
        return _seq;
    }

    public ExprTy[] _gather_272_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this.dotted_name_rule();
        if (elem != null && (seq = this._loop0_273_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_274_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object[] _loop0_276_rule() {
        Object elem;
        Token _literal;
        Object _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Object> _children = new ArrayList<Object>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_353_rule()) != null) {
            _res = elem;
            if (_res instanceof Object) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Object[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Object[] _seq = _children.toArray(new Object[_children.size()]);
        this.cache.putResult(_start_mark, 1518, _seq);
        return _seq;
    }

    public Object[] _gather_275_rule() {
        Object[] seq;
        int _mark = this.mark();
        Object[] _res = null;
        Object elem = this._tmp_353_rule();
        if (elem != null && (seq = this._loop0_276_rule()) != null) {
            _res = this.insertInFront(elem, seq, Object.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_277_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object[] _loop0_279_rule() {
        Object elem;
        Token _literal;
        Object _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Object> _children = new ArrayList<Object>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_354_rule()) != null) {
            _res = elem;
            if (_res instanceof Object) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Object[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Object[] _seq = _children.toArray(new Object[_children.size()]);
        this.cache.putResult(_start_mark, 1521, _seq);
        return _seq;
    }

    public Object[] _gather_278_rule() {
        Object[] seq;
        int _mark = this.mark();
        Object[] _res = null;
        Object elem = this._tmp_354_rule();
        if (elem != null && (seq = this._loop0_279_rule()) != null) {
            _res = this.insertInFront(elem, seq, Object.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_280_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object[] _loop0_282_rule() {
        Object elem;
        Token _literal;
        Object _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Object> _children = new ArrayList<Object>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_355_rule()) != null) {
            _res = elem;
            if (_res instanceof Object) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Object[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Object[] _seq = _children.toArray(new Object[_children.size()]);
        this.cache.putResult(_start_mark, 1524, _seq);
        return _seq;
    }

    public Object[] _gather_281_rule() {
        Object[] seq;
        int _mark = this.mark();
        Object[] _res = null;
        Object elem = this._tmp_355_rule();
        if (elem != null && (seq = this._loop0_282_rule()) != null) {
            _res = this.insertInFront(elem, seq, Object.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_283_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object[] _loop0_285_rule() {
        Object elem;
        Token _literal;
        Object _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<Object> _children = new ArrayList<Object>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_356_rule()) != null) {
            _res = elem;
            if (_res instanceof Object) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((Object[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        Object[] _seq = _children.toArray(new Object[_children.size()]);
        this.cache.putResult(_start_mark, 1527, _seq);
        return _seq;
    }

    public Object[] _gather_284_rule() {
        Object[] seq;
        int _mark = this.mark();
        Object[] _res = null;
        Object elem = this._tmp_356_rule();
        if (elem != null && (seq = this._loop0_285_rule()) != null) {
            _res = this.insertInFront(elem, seq, Object.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_286_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _keyword = this.expect(678);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _keyword = this.expect(679);
        if (_keyword != null) {
            _res = _keyword;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _loop0_287_rule() {
        StmtTy[] block_var;
        StmtTy[] _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<StmtTy> _children = new ArrayList<StmtTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((block_var = this.block_rule()) != null) {
            _res = block_var;
            if (_res instanceof StmtTy) {
                _children.add((StmtTy)_res);
            } else {
                _children.addAll(Arrays.asList(_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        StmtTy[] _seq = _children.toArray(new StmtTy[_children.size()]);
        this.cache.putResult(_start_mark, 1530, _seq);
        return _seq;
    }

    public ExceptHandlerTy[] _loop1_288_rule() {
        ExceptHandlerTy except_block_var;
        ExceptHandlerTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExceptHandlerTy> _children = new ArrayList<ExceptHandlerTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((except_block_var = this.except_block_rule()) != null) {
            _res = except_block_var;
            if (_res instanceof ExceptHandlerTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExceptHandlerTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExceptHandlerTy[] _seq = _children.toArray(new ExceptHandlerTy[_children.size()]);
        this.cache.putResult(_start_mark, 1531, _seq);
        return _seq;
    }

    public Object _tmp_289_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_keyword, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public StmtTy[] _loop0_290_rule() {
        StmtTy[] block_var;
        StmtTy[] _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<StmtTy> _children = new ArrayList<StmtTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((block_var = this.block_rule()) != null) {
            _res = block_var;
            if (_res instanceof StmtTy) {
                _children.add((StmtTy)_res);
            } else {
                _children.addAll(Arrays.asList(_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        StmtTy[] _seq = _children.toArray(new StmtTy[_children.size()]);
        this.cache.putResult(_start_mark, 1533, _seq);
        return _seq;
    }

    public ExceptHandlerTy[] _loop1_291_rule() {
        ExceptHandlerTy except_star_block_var;
        ExceptHandlerTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExceptHandlerTy> _children = new ArrayList<ExceptHandlerTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((except_star_block_var = this.except_star_block_rule()) != null) {
            _res = except_star_block_var;
            if (_res instanceof ExceptHandlerTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExceptHandlerTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        if (_children.size() == 0) {
            return null;
        }
        ExceptHandlerTy[] _seq = _children.toArray(new ExceptHandlerTy[_children.size()]);
        this.cache.putResult(_start_mark, 1534, _seq);
        return _seq;
    }

    public Object _tmp_292_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            Object _opt_var = this._tmp_357_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.dummyName(expression_var, _opt_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_293_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_keyword, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_294_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_keyword, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_295_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token newline_var = this.expect(4);
        if (newline_var != null) {
            _res = newline_var;
            return _res;
        }
        this.reset(_mark);
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_296_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_keyword, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_297_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_keyword, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_298_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        PatternTy[] positional_patterns_var = this.positional_patterns_rule();
        if (positional_patterns_var != null && (_literal = this.expect(12)) != null) {
            _res = this.dummyName(positional_patterns_var, _literal);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_299_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_300_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_301_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token async_var = this.expect(57);
        if (async_var != null) {
            _res = async_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _tmp_302_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ArgumentsTy _tmp_303_rule() {
        int _mark = this.mark();
        ArgumentsTy _res = null;
        ArgumentsTy params_var = this.params_rule();
        if (params_var != null) {
            _res = params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_304_rule() {
        ExprTy expression_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _literal = this.expect(51);
        if (_literal != null && (expression_var = this.expression_rule()) != null) {
            _res = this.dummyName(_literal, expression_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _tmp_305_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_306_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _literal = this.expect(7);
        if (_literal != null) {
            Token _literal_1;
            ExprTy _opt_var = this._tmp_358_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                _res = this.dummyName(_literal, _opt_var, _literal_1);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public TypeParamTy[] _tmp_307_rule() {
        int _mark = this.mark();
        TypeParamTy[] _res = null;
        TypeParamTy[] type_params_var = this.type_params_rule();
        if (type_params_var != null) {
            _res = type_params_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_308_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _literal = this.expect(7);
        if (_literal != null) {
            Token _literal_1;
            ExprTy _opt_var = this._tmp_359_rule();
            if (_opt_var == null) {
                // empty if block
            }
            if ((_literal_1 = this.expect(8)) != null) {
                _res = this.dummyName(_literal, _opt_var, _literal_1);
                return _res;
            }
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public AbstractParser.KeyValuePair[] _loop0_310_rule() {
        AbstractParser.KeyValuePair elem;
        Token _literal;
        AbstractParser.KeyValuePair _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<AbstractParser.KeyValuePair> _children = new ArrayList<AbstractParser.KeyValuePair>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this.double_starred_kvpair_rule()) != null) {
            _res = elem;
            if (_res instanceof AbstractParser.KeyValuePair) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((AbstractParser.KeyValuePair[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        AbstractParser.KeyValuePair[] _seq = _children.toArray(new AbstractParser.KeyValuePair[_children.size()]);
        this.cache.putResult(_start_mark, 1552, _seq);
        return _seq;
    }

    public AbstractParser.KeyValuePair[] _gather_309_rule() {
        AbstractParser.KeyValuePair[] seq;
        int _mark = this.mark();
        AbstractParser.KeyValuePair[] _res = null;
        AbstractParser.KeyValuePair elem = this.double_starred_kvpair_rule();
        if (elem != null && (seq = this._loop0_310_rule()) != null) {
            _res = this.insertInFront(elem, seq, AbstractParser.KeyValuePair.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_311_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(26);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_312_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_313_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(26);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(12);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_314_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_315_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_316_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(22);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(54);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(26);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_317_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_318_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(54);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(26);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_319_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_320_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_321_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _literal = this.expect(54);
        if (_literal != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_literal, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_322_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(26);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_323_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_324_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _literal = this.expect(54);
        if (_literal != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_literal, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_325_rule() {
        ExprTy fstring_format_spec_var;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((fstring_format_spec_var = this.fstring_format_spec_rule()) != null) {
            _res = fstring_format_spec_var;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1568, _seq);
        return _seq;
    }

    public ExprTy _tmp_326_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy yield_expr_var = this.yield_expr_rule();
        if (yield_expr_var != null) {
            _res = yield_expr_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy star_expressions_var = this.star_expressions_rule();
        if (star_expressions_var != null) {
            _res = star_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_327_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _literal = this.expect(54);
        if (_literal != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_literal, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_328_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(26);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_329_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy z = this.star_targets_rule();
        if (z != null && (_literal = this.expect(22)) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_330_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(23);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(52);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_331_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(23);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(52);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_332_rule() {
        Token newline_var;
        ExprTy f;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(49);
        if (_literal != null && (f = this.named_expression_rule()) != null && (newline_var = this.expect(4)) != null) {
            _res = f;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_333_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy arguments_var = this.arguments_rule();
        if (arguments_var != null) {
            _res = arguments_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_334_rule() {
        ExprTy c;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(12);
        if (_literal != null && (c = this.expression_rule()) != null) {
            _res = c;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_335_rule() {
        ExprTy c;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(12);
        if (_literal != null && (c = this.star_expression_rule()) != null) {
            _res = c;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_336_rule() {
        ExprTy c;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _keyword = this.expect(684);
        if (_keyword != null && (c = this.conjunction_rule()) != null) {
            _res = c;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_337_rule() {
        ExprTy c;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _keyword = this.expect(685);
        if (_keyword != null && (c = this.inversion_rule()) != null) {
            _res = c;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_338_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy slice_var = this.slice_rule();
        if (slice_var != null) {
            _res = slice_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy starred_expression_var = this.starred_expression_rule();
        if (starred_expression_var != null) {
            _res = starred_expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_339_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_340_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy fstring_var = this.fstring_rule();
        if (fstring_var != null) {
            _res = fstring_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy string_var = this.string_rule();
        if (string_var != null) {
            _res = string_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _tmp_341_rule() {
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy[] star_named_expressions_var = this.star_named_expressions_rule();
        if (star_named_expressions_var != null) {
            _res = star_named_expressions_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_342_rule() {
        ExprTy z;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _keyword = this.expect(668);
        if (_keyword != null && (z = this.disjunction_rule()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_343_rule() {
        ExprTy z;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _keyword = this.expect(668);
        if (_keyword != null && (z = this.disjunction_rule()) != null) {
            _res = z;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_344_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy starred_expression_var = this.starred_expression_rule();
        if (starred_expression_var != null) {
            _res = starred_expression_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy _tmp_360_var = this._tmp_360_rule();
        if (_tmp_360_var != null && this.genLookahead_expect(false, 22)) {
            _res = _tmp_360_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_345_rule() {
        ExprTy c;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(12);
        if (_literal != null && (c = this.star_target_rule()) != null) {
            _res = c;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_346_rule() {
        ExprTy c;
        int _mark = this.mark();
        ExprTy _res = null;
        Token _literal = this.expect(12);
        if (_literal != null && (c = this.star_target_rule()) != null) {
            _res = c;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_347_rule() {
        AbstractParser.KeywordOrStarred[] kwargs_var;
        Token _literal;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy[] _gather_361_var = this._gather_361_rule();
        if (_gather_361_var != null && (_literal = this.expect(12)) != null && (kwargs_var = this.kwargs_rule()) != null) {
            _res = this.dummyName(_gather_361_var, _literal, kwargs_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_348_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy starred_expression_var = this.starred_expression_rule();
        if (starred_expression_var != null && this.genLookahead_expect(false, 22)) {
            _res = starred_expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_349_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy star_targets_var = this.star_targets_rule();
        if (star_targets_var != null && (_literal = this.expect(22)) != null) {
            _res = this.dummyName(star_targets_var, _literal);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_350_rule() {
        Token _literal;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy star_targets_var = this.star_targets_rule();
        if (star_targets_var != null && (_literal = this.expect(22)) != null) {
            _res = this.dummyName(star_targets_var, _literal);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_351_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(8);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Token _tmp_352_rule() {
        int _mark = this.mark();
        Token _res = null;
        Token _literal = this.expect(11);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _literal = this.expect(35);
        if (_literal != null) {
            _res = _literal;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_353_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            Object _opt_var = this._tmp_363_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.dummyName(expression_var, _opt_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_354_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy expressions_var = this.expressions_rule();
        if (expressions_var != null) {
            Object _opt_var = this._tmp_364_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.dummyName(expressions_var, _opt_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_355_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null) {
            Object _opt_var = this._tmp_365_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.dummyName(expression_var, _opt_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_356_rule() {
        int _mark = this.mark();
        ExprTy.Name _res = null;
        ExprTy expressions_var = this.expressions_rule();
        if (expressions_var != null) {
            Object _opt_var = this._tmp_366_rule();
            if (_opt_var == null) {
                // empty if block
            }
            _res = this.dummyName(expressions_var, _opt_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_357_rule() {
        ExprTy.Name name_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (name_var = this.name_token()) != null) {
            _res = this.dummyName(_keyword, name_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_358_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy arguments_var = this.arguments_rule();
        if (arguments_var != null) {
            _res = arguments_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_359_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy arguments_var = this.arguments_rule();
        if (arguments_var != null) {
            _res = arguments_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_360_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy assignment_expression_var = this.assignment_expression_rule();
        if (assignment_expression_var != null) {
            _res = assignment_expression_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && this.genLookahead_expect(false, 53)) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy[] _loop0_362_rule() {
        ExprTy elem;
        Token _literal;
        ExprTy _res = null;
        int _mark = this.mark();
        int _start_mark = this.mark();
        ArrayList<ExprTy> _children = new ArrayList<ExprTy>();
        boolean _children_capacity = true;
        boolean _n = false;
        while ((_literal = this.expect(12)) != null && (elem = this._tmp_367_rule()) != null) {
            _res = elem;
            if (_res instanceof ExprTy) {
                _children.add(_res);
            } else {
                _children.addAll(Arrays.asList((ExprTy[])_res));
            }
            _mark = this.mark();
        }
        this.reset(_mark);
        ExprTy[] _seq = _children.toArray(new ExprTy[_children.size()]);
        this.cache.putResult(_start_mark, 1604, _seq);
        return _seq;
    }

    public ExprTy[] _gather_361_rule() {
        ExprTy[] seq;
        int _mark = this.mark();
        ExprTy[] _res = null;
        ExprTy elem = this._tmp_367_rule();
        if (elem != null && (seq = this._loop0_362_rule()) != null) {
            _res = this.insertInFront(elem, seq, ExprTy.class);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_363_rule() {
        ExprTy star_target_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (star_target_var = this.star_target_rule()) != null) {
            _res = this.dummyName(_keyword, star_target_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_364_rule() {
        ExprTy star_target_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (star_target_var = this.star_target_rule()) != null) {
            _res = this.dummyName(_keyword, star_target_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_365_rule() {
        ExprTy star_target_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (star_target_var = this.star_target_rule()) != null) {
            _res = this.dummyName(_keyword, star_target_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public Object _tmp_366_rule() {
        ExprTy star_target_var;
        int _mark = this.mark();
        ExprTy.Name _res = null;
        Token _keyword = this.expect(674);
        if (_keyword != null && (star_target_var = this.star_target_rule()) != null) {
            _res = this.dummyName(_keyword, star_target_var);
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_367_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy starred_expression_var = this.starred_expression_rule();
        if (starred_expression_var != null) {
            _res = starred_expression_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy _tmp_368_var = this._tmp_368_rule();
        if (_tmp_368_var != null && this.genLookahead_expect(false, 22)) {
            _res = _tmp_368_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    public ExprTy _tmp_368_rule() {
        int _mark = this.mark();
        ExprTy _res = null;
        ExprTy assignment_expression_var = this.assignment_expression_rule();
        if (assignment_expression_var != null) {
            _res = assignment_expression_var;
            return _res;
        }
        this.reset(_mark);
        ExprTy expression_var = this.expression_rule();
        if (expression_var != null && this.genLookahead_expect(false, 53)) {
            _res = expression_var;
            return _res;
        }
        this.reset(_mark);
        _res = null;
        return _res;
    }

    private boolean genLookahead_expect(boolean match, int arg0) {
        int tmpPos = this.mark();
        Token result = this.expect(arg0);
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead_expect_SOFT_KEYWORD(boolean match, String arg0) {
        int tmpPos = this.mark();
        ExprTy.Name result = this.expect_SOFT_KEYWORD(arg0);
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_9_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_9_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_10_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_10_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_11_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_11_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_12_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_12_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_13_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_13_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_27_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_27_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_88_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_88_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_100_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_100_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_101_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_101_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_102_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_102_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_103_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_103_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_137_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_137_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead_t_lookahead_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this.t_lookahead_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_215_rule(boolean match) {
        int tmpPos = this.mark();
        Object result = this._tmp_215_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_221_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_221_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_223_rule(boolean match) {
        int tmpPos = this.mark();
        Object result = this._tmp_223_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_224_rule(boolean match) {
        int tmpPos = this.mark();
        Object result = this._tmp_224_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_225_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_225_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_227_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_227_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_228_rule(boolean match) {
        int tmpPos = this.mark();
        Object result = this._tmp_228_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_229_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_229_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_247_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_247_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_271_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_271_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_286_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_286_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead_name_token(boolean match) {
        int tmpPos = this.mark();
        ExprTy.Name result = this.name_token();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_311_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_311_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_312_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_312_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_313_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_313_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_314_rule(boolean match) {
        int tmpPos = this.mark();
        ExprTy result = this._tmp_314_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_316_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_316_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_318_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_318_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_322_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_322_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    private boolean genLookahead__tmp_328_rule(boolean match) {
        int tmpPos = this.mark();
        Token result = this._tmp_328_rule();
        this.reset(tmpPos);
        return result != null == match;
    }

    @Override
    protected SSTNode runParser(InputType inputType) {
        SSTNode result = null;
        switch (inputType) {
            case FILE: {
                return this.file_rule();
            }
            case SINGLE: {
                return this.interactive_rule();
            }
            case EVAL: {
                return this.eval_rule();
            }
            case FUNCTION_TYPE: {
                return this.func_type_rule();
            }
        }
        return result;
    }
}

