/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

abstract class PythonDispatchers {
    private PythonDispatchers() {
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CallDispatchers.class})
    static abstract class TernaryPythonSlotDispatcherNode
    extends PythonSlotDispatcherNodeBase {
        TernaryPythonSlotDispatcherNode() {
        }

        final Object execute(VirtualFrame frame, Node inliningTarget, Object callable, Object type, Object self, Object arg1, Object arg2) {
            assert (!(callable instanceof TruffleWeakReference));
            assert (!(type instanceof TruffleWeakReference));
            return this.executeImpl(frame, inliningTarget, callable, type, self, arg1, arg2);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee", "isSimpleSignature(cachedCallee, 3)"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        protected static Object doCachedPFunction(VirtualFrame frame, Node inliningTarget, PFunction callee, Object type, Object self, Object arg1, Object arg2, @Cached(value="callee") PFunction cachedCallee, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached CallDispatchers.FunctionDirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, arg1);
            PArguments.setArgument(arguments, 2, arg2);
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, arguments);
        }

        @Specialization(replaces={"doCachedPFunction"})
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object callableObj, Object type, Object self, Object arg1, Object arg2, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached(inline=false) CallNode callNode) {
            Object[] arguments;
            Object callable;
            Object bound = bindDescriptorNode.execute((Frame)frame, inliningTarget, callableObj, self, type);
            if (bound instanceof BoundDescriptor) {
                BoundDescriptor boundDescr = (BoundDescriptor)bound;
                callable = boundDescr.descriptor;
                arguments = new Object[]{arg1, arg2};
            } else {
                callable = bound;
                arguments = new Object[]{self, arg1, arg2};
            }
            return callNode.execute((Frame)frame, callable, arguments);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CallDispatchers.class})
    static abstract class BinaryPythonSlotDispatcherNode
    extends PythonSlotDispatcherNodeBase {
        BinaryPythonSlotDispatcherNode() {
        }

        final Object execute(VirtualFrame frame, Node inliningTarget, Object callable, Object type, Object self, Object arg1) {
            assert (!(callable instanceof TruffleWeakReference));
            assert (!(type instanceof TruffleWeakReference));
            return this.executeImpl(frame, inliningTarget, callable, type, self, arg1, false);
        }

        final Object executeIgnoreDescriptorBindErrors(VirtualFrame frame, Node inliningTarget, Object callable, Object type, Object self, Object arg1) {
            assert (!(callable instanceof TruffleWeakReference));
            assert (!(type instanceof TruffleWeakReference));
            return this.executeImpl(frame, inliningTarget, callable, type, self, arg1, true);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5, Object var6, boolean var7);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee", "isSimpleSignature(cachedCallee, 2)"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        protected static Object doCachedPFunction(VirtualFrame frame, Node inliningTarget, PFunction callee, Object type, Object self, Object arg1, boolean ignoreDescBindErrors, @Cached(value="callee") PFunction cachedCallee, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached CallDispatchers.FunctionDirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(2);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, arg1);
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, arguments);
        }

        @Specialization(replaces={"doCachedPFunction"})
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object callableObj, Object type, Object self, Object arg1, boolean ignoreDescBindErrors, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached(inline=false) CallNode callNode) {
            Object[] arguments;
            Object callable;
            Object bound;
            try {
                bound = bindDescriptorNode.execute((Frame)frame, inliningTarget, callableObj, self, type);
            }
            catch (PException ex) {
                if (ignoreDescBindErrors) {
                    return PNotImplemented.NOT_IMPLEMENTED;
                }
                throw ex;
            }
            if (bound instanceof BoundDescriptor) {
                BoundDescriptor boundDescr = (BoundDescriptor)bound;
                callable = boundDescr.descriptor;
                arguments = new Object[]{arg1};
            } else {
                callable = bound;
                arguments = new Object[]{self, arg1};
            }
            return callNode.execute((Frame)frame, callable, arguments);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CallDispatchers.class})
    static abstract class UnaryPythonSlotDispatcherNode
    extends PythonSlotDispatcherNodeBase {
        UnaryPythonSlotDispatcherNode() {
        }

        final Object execute(VirtualFrame frame, Node inliningTarget, Object callable, Object type, Object self) {
            assert (!(callable instanceof TruffleWeakReference));
            assert (!(type instanceof TruffleWeakReference));
            return this.executeImpl(frame, inliningTarget, callable, type, self);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee", "isSimpleSignature(cachedCallee, 1)"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        protected static Object doCachedPFunction(VirtualFrame frame, Node inliningTarget, PFunction callee, Object type, Object self, @Cached(value="callee") PFunction cachedCallee, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached CallDispatchers.FunctionDirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, arguments);
        }

        @Specialization(replaces={"doCachedPFunction"})
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object callableObj, Object type, Object self, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached(inline=false) CallNode callNode) {
            Object[] arguments;
            Object callable;
            Object bound = bindDescriptorNode.execute((Frame)frame, inliningTarget, callableObj, self, type);
            if (bound instanceof BoundDescriptor) {
                BoundDescriptor boundDescr = (BoundDescriptor)bound;
                callable = boundDescr.descriptor;
                arguments = PythonUtils.EMPTY_OBJECT_ARRAY;
            } else {
                callable = bound;
                arguments = new Object[]{self};
            }
            return callNode.execute((Frame)frame, callable, arguments);
        }
    }

    static abstract class PythonSlotDispatcherNodeBase
    extends PNodeWithContext {
        PythonSlotDispatcherNodeBase() {
        }

        @Idempotent
        static boolean isSimpleSignature(PFunction callable, int positionArgsCount) {
            CompilerAsserts.partialEvaluationConstant((Object)callable);
            CompilerAsserts.partialEvaluationConstant((int)positionArgsCount);
            Signature signature = callable.getCode().getSignature();
            boolean result = signature.takesPositionalOnly() && signature.getMaxNumOfPositionalArgs() == positionArgsCount;
            CompilerAsserts.partialEvaluationConstant((boolean)result);
            return result;
        }
    }
}

