/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressorObject;
import com.oracle.graal.python.builtins.modules.zlib.ZlibNodes;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ZlibDecompressor})
public final class ZlibDecompressorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ZlibDecompressorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZlibDecompressorBuiltinsFactory.getFactories();
    }

    @Builtin(name="needs_input", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NeedsInputNode
    extends PythonUnaryBuiltinNode {
        NeedsInputNode() {
        }

        @Specialization
        static boolean doit(ZlibDecompressorObject self) {
            return self.isNeedsInput();
        }
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EOFNode
    extends PythonUnaryBuiltinNode {
        EOFNode() {
        }

        @Specialization(guards={"self.isEof() || !self.isInitialized()", "self.isNative()"})
        static boolean doit(ZlibDecompressorObject self) {
            return self.isEof();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isEof()", "self.isInitialized()", "self.isNative()"})
        boolean doNative(ZlibDecompressorObject self, @Cached NativeLibrary.InvokeNativeFunction getEOF) {
            ZlibDecompressorObject zlibDecompressorObject = self;
            synchronized (zlibDecompressorObject) {
                assert (self.isInitialized());
                NFIZlibSupport zlibSupport = PythonContext.get(this).getNFIZlibSupport();
                self.setEof(zlibSupport.getEOF(self.getZst(), getEOF) == 1);
                return self.isEof();
            }
        }

        @Specialization(guards={"!self.isNative()"})
        static boolean doJava(ZlibDecompressorObject self) {
            return self.isEof();
        }
    }

    @Builtin(name="unused_data", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnusedDataNode
    extends PythonUnaryBuiltinNode {
        UnusedDataNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()", "self.isNative()"})
        static PBytes doit(ZlibDecompressorObject self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached ZlibNodes.GetNativeBufferNode getBuffer) {
            ZlibDecompressorObject zlibDecompressorObject = self;
            synchronized (zlibDecompressorObject) {
                assert (self.isInitialized());
                return PFactory.createBytes(context.getLanguage(inliningTarget), getBuffer.getUnusedDataBuffer(inliningTarget, self.getZst(), context));
            }
        }

        @Specialization(guards={"!self.isInitialized()", "self.isNative()"})
        static PBytes doeof(ZlibDecompressorObject self) {
            return self.getUnusedData();
        }

        @Specialization(guards={"!self.isNative()"})
        static PBytes doit(ZlibDecompressorObject self) {
            return self.getUnusedData();
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "data", "max_length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="max_length", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="-1", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        DecompressNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibDecompressorBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PBytes decompress(VirtualFrame frame, ZlibDecompressorObject self, Object buffer, int maxLength, @Bind Node inliningTarget, @Bind PythonLanguage language, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached DecompressBufInnerNode innerNode, @Cached PRaiseNode raiseNode) {
            try {
                int tailLen;
                if (!self.isInitialized()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, -2, "while decompressing data", "inconsistent stream state");
                }
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                PBytes tail = self.getUnconsumedTail();
                int n = tailLen = tail == null ? 0 : bufferLib.getBufferLength(tail);
                if (tailLen > 0) {
                    byte[] tailBytes = bufferLib.getInternalOrCopiedByteArray(self.getUnconsumedTail());
                    byte[] tmp = new byte[tailLen + len];
                    PythonUtils.arraycopy(tailBytes, 0, tmp, 0, tailLen);
                    PythonUtils.arraycopy(bytes, 0, tmp, tailLen, len);
                    bytes = tmp;
                    len += tailLen;
                }
                PBytes pBytes = PFactory.createBytes(language, innerNode.execute(frame, inliningTarget, self, bytes, len, maxLength));
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class DecompressBufInnerNode
        extends Node {
            DecompressBufInnerNode() {
            }

            abstract byte[] execute(VirtualFrame var1, Node var2, Object var3, byte[] var4, int var5, int var6);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Specialization(guards={"self.isNative()"})
            static byte[] doNative(Node inliningTarget, ZlibDecompressorObject self, byte[] bytes, int length, int maxLength, @Cached ZlibNodes.ZlibNativeDecompressor decompress) {
                ZlibDecompressorObject zlibDecompressorObject = self;
                synchronized (zlibDecompressorObject) {
                    return decompress.execute(inliningTarget, self, PythonContext.get(inliningTarget), bytes, length, maxLength);
                }
            }

            @Specialization(guards={"!self.isNative()"})
            static byte[] doJava(VirtualFrame frame, Node inliningTarget, ZlibDecompressorObject self, byte[] bytes, int length, int maxLength, @Cached(inline=false) BytesNodes.ToBytesNode toBytes) {
                byte[] ret = self.getStream().decompress(frame, bytes, length, maxLength, 16384, inliningTarget, toBytes);
                if (self.isEof()) {
                    self.setNeedsInput(false);
                } else if (self.getUnconsumedTail() == null || self.getUnconsumedTail().getSequenceStorage().length() == 0) {
                    self.setNeedsInput(true);
                } else {
                    self.setNeedsInput(false);
                }
                return ret;
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="_ZlibDecompressor", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, parameterNames={"$cls", "wbits", "zdict"})
    @ImportStatic(value={ZLibModuleBuiltins.class})
    @ArgumentsClinic(value={@ArgumentClinic(name="wbits", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.MAX_WBITS", useDefaultForNone=true), @ArgumentClinic(name="zdict", conversionClass=ZLibModuleBuiltins.ExpectByteLikeNode.class, defaultValue="ZLibModuleBuiltins.EMPTY_BYTE_ARRAY", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class ZlibDecompressorNewNode
    extends PythonClinicBuiltinNode {
        ZlibDecompressorNewNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibDecompressorBuiltinsClinicProviders.ZlibDecompressorNewNodeClinicProviderGen.INSTANCE;
        }

        @NonIdempotent
        protected boolean useNative() {
            return PythonContext.get(this).getNFIZlibSupport().isAvailable();
        }

        protected static boolean isValidWBitRange(int wbits) {
            return wbits < -7 || wbits > 7 && wbits <= 15 || wbits > 24 && wbits <= 31;
        }

        @Specialization(guards={"useNative()"})
        static Object doNative(Object type, int wbits, byte[] zdict, @Bind Node inliningTarget, @Bind PythonContext context, @Cached NativeLibrary.InvokeNativeFunction createCompObject, @Cached NativeLibrary.InvokeNativeFunction decompressObjInit, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            Object zst = zlibSupport.createCompObject(createCompObject);
            int err = zdict.length > 0 ? zlibSupport.decompressObjInitWithDict(zst, wbits, zdict, zdict.length, decompressObjInit) : zlibSupport.decompressObjInit(zst, wbits, decompressObjInit);
            if (err != 0) {
                errorHandling.execute(inliningTarget, zst, err, zlibSupport, true);
            }
            return PFactory.createNativeZlibDecompressorObject(context.getLanguage(inliningTarget), zst, zlibSupport);
        }

        @Specialization(guards={"!useNative()", "isValidWBitRange(wbits)"})
        static Object doJava(Object type, int wbits, byte[] zdict, @Bind PythonLanguage language) {
            ZlibDecompressorObject obj = PFactory.createJavaZlibDecompressorObject(language, wbits, zdict);
            if (wbits < 0) {
                obj.getStream().setDictionary();
            }
            obj.setUnusedData(PFactory.createEmptyBytes(language));
            obj.setUnconsumedTail(PFactory.createEmptyBytes(language));
            return obj;
        }
    }
}

