/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import java.util.Properties;

public class OptsTokenizer {
    final int COMA = 44;
    final int OPAR = 40;
    final int CPAR = 41;
    final int CMTCHAR = 35;
    final int EQUALCHAR = 61;
    private char[] pca;
    private int cidx;
    private int slen;

    public OptsTokenizer(String ins) {
        String pstr = ins.trim();
        this.slen = pstr.length();
        this.pca = pstr.toCharArray();
        this.cidx = 0;
        this.skipWS();
    }

    public Properties getOpts() {
        String token;
        Properties opts = new Properties();
        while ((token = this.getNextToken()).length() != 0) {
            int pos = token.indexOf(61);
            if (pos == -1) {
                opts.put(token, "");
                continue;
            }
            opts.put(token.substring(0, pos), token.substring(pos + 1));
        }
        return opts;
    }

    private void skipWS() {
        while (this.cidx < this.slen && (Character.isWhitespace(this.pca[this.cidx]) || this.pca[this.cidx] == ',')) {
            ++this.cidx;
        }
    }

    private String getNextToken() {
        int tstart = this.cidx;
        while (this.cidx < this.slen) {
            if (this.pca[this.cidx] == '#') {
                return new String(this.pca, tstart, this.cidx - tstart);
            }
            if (this.pca[this.cidx] == '(') {
                this.matchPar();
                continue;
            }
            if (Character.isWhitespace(this.pca[this.cidx]) || this.pca[this.cidx] == ',') {
                String token = new String(this.pca, tstart, this.cidx - tstart);
                this.skipWS();
                return token;
            }
            ++this.cidx;
        }
        return new String(this.pca, tstart, this.cidx - tstart);
    }

    private void matchPar() {
        int pcnt = 0;
        while (this.cidx < this.slen) {
            if (this.pca[this.cidx] == '(') {
                ++this.cidx;
                ++pcnt;
                continue;
            }
            if (this.pca[this.cidx] == ')') {
                ++this.cidx;
                if (--pcnt != 0) continue;
                return;
            }
            if (this.pca[this.cidx] == '#') {
                return;
            }
            ++this.cidx;
        }
    }
}

