/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.openapi.vfs.CharsetToolkit;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInfo {
    public final String text;
    public final byte[] bytes;
    public final Charset charset;

    public TextInfo(@NotNull String text, byte @NotNull [] bytes, @NotNull Charset charset) {
        if (text == null) {
            TextInfo.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            TextInfo.$$$reportNull$$$0(1);
        }
        if (bytes == null) {
            TextInfo.$$$reportNull$$$0(2);
        }
        this.text = text;
        this.bytes = bytes;
        this.charset = charset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextInfo info = (TextInfo)o;
        if (!this.text.equals(info.text)) {
            return false;
        }
        if (!this.charset.equals(info.charset)) {
            return false;
        }
        return Arrays.equals(this.bytes, info.bytes);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.charset.hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    @Nullable
    public static TextInfo tryDetectString(byte @NotNull [] bytes) {
        Charset charset;
        if (bytes == null) {
            TextInfo.$$$reportNull$$$0(3);
        }
        String text = (charset = TextInfo.guessCharsetFromContent(bytes)) == null ? null : TextInfo.validateDetectedString(CharsetToolkit.tryDecodeString((byte[])bytes, (Charset)charset));
        return text == null ? null : new TextInfo(text, bytes, charset);
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content) {
        if (content == null) {
            TextInfo.$$$reportNull$$$0(4);
        }
        if (content.length == 0) {
            return StandardCharsets.UTF_8;
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, Charset.defaultCharset(), false);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        return switch (guessedEncoding) {
            case CharsetToolkit.GuessedEncoding.SEVEN_BIT, CharsetToolkit.GuessedEncoding.VALID_UTF8 -> StandardCharsets.UTF_8;
            default -> null;
        };
    }

    @Nullable
    private static String validateDetectedString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            return null;
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/TextInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryDetectString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "guessCharsetFromContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

