/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.FormatterCreatorProvider;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.DateDelegate;
import com.intellij.database.run.ui.grid.editors.DateToLocalDateTimeDelegate;
import com.intellij.database.run.ui.grid.editors.EraDateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimestampDelegate;
import com.intellij.database.run.ui.grid.editors.TimeDelegate;
import com.intellij.database.run.ui.grid.editors.TimestampDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimestampDelegate;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterCreator {
    public static final int MAX_FRACTION_DIGITS = 340;
    public static final FormatterKey<SimpleDateFormat> SIMPLE_TIMESTAMP_FORMATTER_KEY = new FormatterKey("SIMPLE_TIMESTAMP_FORMATTER_KEY");
    public static final FormatterKey<SimpleDateFormat> SHORT_TIMESTAMP_FORMATTER_KEY = new FormatterKey("SHORT_TIMESTAMP_FORMATTER_KEY");
    public static final FormatterKey<SimpleDateFormat> TIMESTAMP_WITH_MILLI_FORMATTER_KEY = new FormatterKey("TIMESTAMP_WITH_MILLI_FORMATTER_KEY");
    public static final FormatterKey<SimpleDateFormat> SIMPLE_DATE_FORMATTER_KEY = new FormatterKey("SIMPLE_DATE_FORMATTER_KEY");
    public static final FormatterKey<DateTimeFormatter> LOCAL_DATE_WITH_MILLI_FORMATTER_KEY = new FormatterKey("LOCAL_DATE_WITH_MILLI");
    public static final FormatterKey<DateTimeFormatter> LOCAL_DATE_FORMATTER_KEY = new FormatterKey("LOCAL_DATE");
    public static final FormatterKey<DateTimeFormatter> OFFSET_DATE_TIME_FORMATTER_KEY = new FormatterKey("OFFSET_DATE_TIME");
    private static final Key<Function<@NotNull CoreGrid<GridRow, GridColumn>, @NotNull FormatterCreator>> FORMATTER_CREATOR_KEY = new Key("FORMATTER_CREATOR_KEY");
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String ERA_PATTERN = "[ ][GGG]";
    private static final String INT_FORMATTER_KEY = "INT_FORMATTER_KEY";
    private static final String LONG_FORMATTER_KEY = "LONG_FORMATTER_KEY";
    private static final String BIG_INT_FORMATTER_KEY = "BIG_INT_FORMATTER_KEY";
    private static final String FLOAT_FORMATTER_KEY = "FLOAT_FORMATTER_KEY";
    private static final String DOUBLE_FORMATTER_KEY = "DOUBLE_FORMATTER_KEY";
    private static final String DECIMAL_WITH_PRIORITY_TYPE = "DECIMAL_WITH_PRIORITY_TYPE";
    private static final String TIMESTAMP_WITH_SCALE_TYPE = "TIMESTAMP_WITH_SCALE_TYPE";
    private static final String TIME_FORMATTER_KEY = "TIME_FORMATTER_KEY";
    private static final String TIMESTAMP_FORMATTER_KEY = "TIMESTAMP_FORMATTER_KEY";
    private static final String SHORT_ERA_ZONED_TIMESTAMP = "SHORT_ERA_ZONED_TIMESTAMP";
    private static final String ERA_TIMESTAMP = "ERA_TIMESTAMP";
    private static final String ZONED_TIME_FORMATTER_KEY = "ZONED_TIME_FORMATTER_KEY";
    private static final String ZONED_TIMESTAMP_FORMATTER_KEY = "ZONED_TIMESTAMP_FORMATTER_KEY";
    private static final String DATE_FORMATTER_KEY = "DATE_FORMATTER_KEY";
    private static final String DECIMAL_FORMATTER_KEY = "DECIMAL_FORMATTER_KEY";
    private static final String BIG_DECIMAL_FORMATTER_KEY = "BIG_DECIMAL_FORMATTER_KEY";
    private static final Key<FormatsCache> FORMATTER_KEY_FORMATS_CACHE_KEY = new Key("FORMATTER_KEY_FORMATS_CACHE_KEY");
    private static final Key<Integer> FORMATTER_KEY_INT_KEY = new Key("FORMATTER_KEY_INT_KEY");
    private static final Key<GridColumn> FORMATTER_KEY_GRID_COLUMN_KEY = new Key("FORMATTER_KEY_GRID_COLUMN_KEY");
    private static final Key<ObjectFormatterConfig> FORMATTER_KEY_CONFIG_KEY = new Key("FORMATTER_KEY_CONFIG_KEY");

    @NotNull
    public static FormatterCreator get(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Function<CoreGrid<GridRow, GridColumn>, FormatterCreator> cache;
        if (grid == null) {
            FormatterCreator.$$$reportNull$$$0(0);
        }
        if ((cache = (Function<CoreGrid<GridRow, GridColumn>, FormatterCreator>)grid.getUserData(FORMATTER_CREATOR_KEY)) == null) {
            cache = FormatterCreatorProvider.getCache();
            grid.putUserData(FORMATTER_CREATOR_KEY, cache);
        }
        FormatterCreator formatterCreator = (FormatterCreator)cache.fun(grid);
        if (formatterCreator == null) {
            FormatterCreator.$$$reportNull$$$0(1);
        }
        return formatterCreator;
    }

    public static FormatterKey<NumberFormatter> getIntKey(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(new FormatterKey(INT_FORMATTER_KEY), config);
    }

    public static FormatterKey<NumberFormatter> getLongKey(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(new FormatterKey(LONG_FORMATTER_KEY), config);
    }

    public static FormatterKey<NumberFormatter> getBigIntKey(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(new FormatterKey(BIG_INT_FORMATTER_KEY), config);
    }

    public static FormatterKey<NumberFormatter> getFloatKey(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(new FormatterKey(FLOAT_FORMATTER_KEY), config);
    }

    public static FormatterKey<NumberFormatter> getDoubleKey(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(new FormatterKey(DOUBLE_FORMATTER_KEY), config);
    }

    public static FormatterKey<NumberFormatter> getDecimalWithPriorityTypeKey(int type, @Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(FormatterCreator.add(new FormatterKey(DECIMAL_WITH_PRIORITY_TYPE), type), config);
    }

    public static FormatterKey<Formatter> getTimeKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(2);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(TIME_FORMATTER_KEY), column), config), formatsCache);
    }

    public static FormatterKey<Formatter> getTimestampKey(int scale, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(3);
        }
        return FormatterCreator.add(FormatterCreator.add(new FormatterKey(TIMESTAMP_WITH_SCALE_TYPE), scale), formatsCache);
    }

    public static FormatterKey<Formatter> getTimestampKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(4);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(TIMESTAMP_FORMATTER_KEY), column), config), formatsCache);
    }

    public static FormatterKey<Formatter> getShortEraZonedTimestampKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(5);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(SHORT_ERA_ZONED_TIMESTAMP), column), config), formatsCache);
    }

    public static FormatterKey<Formatter> getEraTimestampKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(6);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(ERA_TIMESTAMP), column), config), formatsCache);
    }

    public static FormatterKey<CompositeFormatter> getZonedTimeKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(7);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(ZONED_TIME_FORMATTER_KEY), column), config), formatsCache);
    }

    public static FormatterKey<CompositeFormatter> getZonedTimestampKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(8);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(ZONED_TIMESTAMP_FORMATTER_KEY), column), config), formatsCache);
    }

    public static FormatterKey<Formatter> getDateKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(9);
        }
        return FormatterCreator.add(FormatterCreator.add(FormatterCreator.add(new FormatterKey(DATE_FORMATTER_KEY), column), config), formatsCache);
    }

    public static FormatterKey<NumberFormatter> getDecimalKey(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return FormatterCreator.add(FormatterCreator.add(new FormatterKey(DECIMAL_FORMATTER_KEY), column), config);
    }

    public <T> T create(@NotNull FormatterKey<T> key) {
        NumberFormatter res;
        if (key == null) {
            FormatterCreator.$$$reportNull$$$0(10);
        }
        Object object = key.getName().equals(INT_FORMATTER_KEY) ? this.newIntFormat(FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(FLOAT_FORMATTER_KEY) ? this.newFloatFormat(FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(DOUBLE_FORMATTER_KEY) ? this.newDoubleFormat(FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(LONG_FORMATTER_KEY) ? this.newLongFormat(FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(BIG_INT_FORMATTER_KEY) ? this.newBigIntFormat(FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(DECIMAL_FORMATTER_KEY) ? this.newDecimalFormat(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(BIG_DECIMAL_FORMATTER_KEY) ? FormatterCreator.newBigDecimalFormat(FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(DECIMAL_WITH_PRIORITY_TYPE) ? FormatterCreator.getDecimalFormatWithPriorityType(FormatterCreator.getInt(key), FormatterCreator.getFormaterConfig(key)) : (key.getName().equals(TIMESTAMP_WITH_SCALE_TYPE) ? this.newTimestampFormat(null, FormatterCreator.getInt(key), this.resolver(null), null, FormatterCreator.getFormatsCache(key)) : (key.getName().equals(TIMESTAMP_FORMATTER_KEY) ? this.newTimestampFormat(FormatterCreator.getColumn(key), this.calculateScale(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key)), this.resolver(FormatterCreator.getColumn(key)), FormatterCreator.getFormaterConfig(key), FormatterCreator.getFormatsCache(key)) : (key.getName().equals(SHORT_ERA_ZONED_TIMESTAMP) ? this.newShortEraZonedTimestampFormat(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key), FormatterCreator.getFormatsCache(key)) : (key.getName().equals(ERA_TIMESTAMP) ? this.newEraTimestampFormat(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key), FormatterCreator.getFormatsCache(key)) : (key.getName().equals(TIME_FORMATTER_KEY) ? this.newTimeFormat(FormatterCreator.getFormaterConfig(key), this.calculateScale(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key))) : (key.is(SIMPLE_TIMESTAMP_FORMATTER_KEY) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G Z", Locale.US) : (key.is(SHORT_TIMESTAMP_FORMATTER_KEY) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G", Locale.US) : (key.is(TIMESTAMP_WITH_MILLI_FORMATTER_KEY) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G SSS", Locale.US) : (key.is(SIMPLE_DATE_FORMATTER_KEY) ? new SimpleDateFormat("yyyy-MM-dd G", Locale.US) : (key.is(LOCAL_DATE_WITH_MILLI_FORMATTER_KEY) ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss G SSS", Locale.US) : (key.is(LOCAL_DATE_FORMATTER_KEY) ? DateTimeFormatter.ofPattern("yyyy-MM-dd G", Locale.US) : (key.is(OFFSET_DATE_TIME_FORMATTER_KEY) ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss G ZZZ", Locale.US) : (key.getName().equals(ZONED_TIME_FORMATTER_KEY) ? this.newZonedTimeFormat(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key), FormatterCreator.getFormatsCache(key)) : (key.getName().equals(ZONED_TIMESTAMP_FORMATTER_KEY) ? this.newZonedTimestampFormat(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key), FormatterCreator.getFormatsCache(key)) : (res = key.getName().equals(DATE_FORMATTER_KEY) ? this.newDateFormatter(FormatterCreator.getColumn(key), FormatterCreator.getFormaterConfig(key), FormatterCreator.getFormatsCache(key)) : null))))))))))))))))))))));
        if (res != null) {
            return (T)res;
        }
        throw new IllegalArgumentException("Unknown key: " + key.getName());
    }

    @NotNull
    protected static <T> FormatsCache getFormatsCache(@NotNull FormatterKey<T> key) {
        if (key == null) {
            FormatterCreator.$$$reportNull$$$0(11);
        }
        FormatsCache formatsCache = Objects.requireNonNull((FormatsCache)key.getUserData(FORMATTER_KEY_FORMATS_CACHE_KEY));
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(12);
        }
        return formatsCache;
    }

    private static <T> int getInt(FormatterKey<T> key) {
        return Objects.requireNonNull((Integer)key.getUserData(FORMATTER_KEY_INT_KEY));
    }

    @Nullable
    private static <T> GridColumn getColumn(FormatterKey<T> key) {
        return (GridColumn)key.getUserData(FORMATTER_KEY_GRID_COLUMN_KEY);
    }

    @Nullable
    private static <T> ObjectFormatterConfig getFormaterConfig(FormatterKey<T> key) {
        return (ObjectFormatterConfig)key.getUserData(FORMATTER_KEY_CONFIG_KEY);
    }

    @NotNull
    protected NumberFormatter newDecimalFormat(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return FormatterCreator.configureDecimalFormat(new DecimalFormat(), config);
    }

    @NotNull
    protected static NumberFormatter newBigDecimalFormat(@Nullable ObjectFormatterConfig config) {
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(), config);
        formatter.setParseBigDecimal(true);
        formatter.setMaximumFractionDigits(340);
        NumberFormatter numberFormatter = formatter;
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(13);
        }
        return numberFormatter;
    }

    @NotNull
    protected NumberFormatter newFloatFormat(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text, ParsePosition pos) {
                Number n = super.parse(text, pos);
                return n != null ? Float.valueOf(n.floatValue()) : null;
            }

            @Override
            public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
                number = Double.valueOf(Float.toString((float)number));
                return super.format(number, result, fieldPosition);
            }
        }, config);
    }

    @NotNull
    private NumberFormatter newDoubleFormat(@Nullable ObjectFormatterConfig config) {
        return FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text, ParsePosition pos) {
                Number n = super.parse(text, pos);
                return n == null ? (Number)null : (Number)((Number)ObjectUtils.notNull((Object)FormatterCreator.asInt(n), (Object)n));
            }
        }, config);
    }

    @NotNull
    private NumberFormatter newIntFormat(@Nullable ObjectFormatterConfig config) {
        DecimalFormat format = new DecimalFormat(){

            @Override
            public Number parse(String text, ParsePosition pos) {
                Number n = super.parse(text, pos);
                return n != null ? Integer.valueOf(n.intValue()) : null;
            }
        };
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(format, config);
        formatter.setParseIntegerOnly(true);
        NumberFormatter numberFormatter = formatter;
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(14);
        }
        return numberFormatter;
    }

    @NotNull
    private NumberFormatter newLongFormat(@Nullable ObjectFormatterConfig config) {
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text, ParsePosition pos) {
                Number n = super.parse(text, pos);
                return n != null ? Long.valueOf(n.longValue()) : null;
            }
        }, config);
        formatter.setParseIntegerOnly(true);
        NumberFormatter numberFormatter = formatter;
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(15);
        }
        return numberFormatter;
    }

    @NotNull
    private NumberFormatter newBigIntFormat(@Nullable ObjectFormatterConfig config) {
        NumberFormatter format = this.newDecimalFormat(null, config);
        format.setParseIntegerOnly(true);
        format.setParseBigDecimal(true);
        NumberFormatter numberFormatter = format;
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(16);
        }
        return numberFormatter;
    }

    private static NumberFormatter getDecimalFormatWithPriorityType(final int priorityType, @Nullable ObjectFormatterConfig config) {
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text, ParsePosition pos) {
                Number n = super.parse(text, pos);
                return n == null ? (Number)null : (Number)((Number)ObjectUtils.notNull((Object)(priorityType == 4 ? FormatterCreator.asInt(n) : null), (Object)((Number)ObjectUtils.notNull((Object)(priorityType == 4 || priorityType == -5 ? FormatterCreator.asLong(n) : null), (Object)((Number)ObjectUtils.notNull((Object)(priorityType == 8 ? FormatterCreator.asDouble(n) : null), (Object)n))))));
            }
        }, config);
        formatter.setParseBigDecimal(true);
        formatter.setMaximumFractionDigits(340);
        return formatter;
    }

    @Nullable
    private static Integer asInt(Number n) {
        try {
            return n instanceof Long && (long)n.intValue() == (Long)n ? Integer.valueOf(n.intValue()) : (n instanceof BigDecimal ? Integer.valueOf(((BigDecimal)n).intValueExact()) : null);
        }
        catch (ArithmeticException ignored) {
            return null;
        }
    }

    @Nullable
    private static Long asLong(Number n) {
        try {
            return n instanceof Long ? (Long)n : (n instanceof BigDecimal ? Long.valueOf(((BigDecimal)n).longValueExact()) : null);
        }
        catch (ArithmeticException ignored) {
            return null;
        }
    }

    private static Double asDouble(Number n) {
        return n instanceof Double ? (Double)n : (n instanceof BigDecimal && n.equals(BigDecimal.valueOf(n.doubleValue())) ? Double.valueOf(n.doubleValue()) : null);
    }

    @NotNull
    private Formatter newZonedTimeFormat(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        Formatter customFormatter;
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(17);
        }
        if ((customFormatter = this.newCustomDateTimeFormat(config, (Function<? super DataGridSettings, String>)((Function)DataGridSettings::getEffectiveZonedTimePattern), this.newZonedTimeDelegate(config))) != null) {
            Formatter formatter = customFormatter;
            if (formatter == null) {
                FormatterCreator.$$$reportNull$$$0(18);
            }
            return formatter;
        }
        CompositeFormatter compositeFormatter = this.newZonedTimeFormat(this.newZonedTimeDelegate(config), this.calculateScale(column, config), config);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(19);
        }
        return compositeFormatter;
    }

    @NotNull
    protected ZonedTimeDelegate<?> newZonedTimeDelegate(final @Nullable ObjectFormatterConfig config) {
        return new ZonedTimeDelegate<Object>(this){

            @Override
            protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
                if (value == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!(value instanceof OffsetTime)) {
                    throw new IllegalArgumentException("Value must be of type OffsetTime");
                }
                OffsetTime time = (OffsetTime)value;
                return DataGridFormattersUtilCore.adjustOffset(time, DataGridFormattersUtilCore.getZoneId(config));
            }

            @Override
            protected OffsetTime createFromTemporal(@NotNull TemporalAccessor value) {
                if (value == null) {
                    6.$$$reportNull$$$0(1);
                }
                return DataGridFormattersUtilCore.adjustOffset(OffsetTime.from(value), DataGridFormattersUtilCore.getZoneId(config));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/extractors/FormatterCreator$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toTemporalAccessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createFromTemporal";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private Formatter newTimeFormat(@Nullable ObjectFormatterConfig config, int scale) {
        Formatter formatter = this.newTimeFormat(config, scale, new TimeDelegate(config));
        if (formatter == null) {
            FormatterCreator.$$$reportNull$$$0(20);
        }
        return formatter;
    }

    @NotNull
    public Formatter newTimeFormat(@Nullable ObjectFormatterConfig config, int scale, @NotNull DateAndTimeFormatterDelegate<?, ?> delegate) {
        Formatter customFormatter;
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(21);
        }
        if ((customFormatter = this.newCustomDateTimeFormat(config, (Function<? super DataGridSettings, String>)((Function)DataGridSettings::getEffectiveTimePattern), delegate)) != null) {
            Formatter formatter = customFormatter;
            if (formatter == null) {
                FormatterCreator.$$$reportNull$$$0(22);
            }
            return formatter;
        }
        Builders builders = new Builders();
        FormatterCreator.appendTime(builders);
        if (scale > 0) {
            FormatterCreator.appendFraction(builders, scale);
        }
        return new DateAndTimeFormatter(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), delegate);
    }

    @NotNull
    protected Formatter newTimestampFormat(@Nullable GridColumn column, int scale, @NotNull BoundaryValueResolver resolver, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        Formatter customFormatter;
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(23);
        }
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(24);
        }
        if ((customFormatter = this.newCustomTimestampFormat(config, formatsCache)) != null) {
            Formatter formatter = customFormatter;
            if (formatter == null) {
                FormatterCreator.$$$reportNull$$$0(25);
            }
            return formatter;
        }
        Formatter formatter = this.newIntrinsicTimestampFormat(column, scale, resolver, config, formatsCache);
        if (formatter == null) {
            FormatterCreator.$$$reportNull$$$0(26);
        }
        return formatter;
    }

    @NotNull
    protected Formatter newIntrinsicTimestampFormat(@Nullable GridColumn column, int scale, @NotNull BoundaryValueResolver resolver, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(27);
        }
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(28);
        }
        Formatter formatter = FormatterCreator.checkInfinity(this.newTimestampFormat(config, scale, formatsCache), resolver);
        if (formatter == null) {
            FormatterCreator.$$$reportNull$$$0(29);
        }
        return formatter;
    }

    @NotNull
    private DateAndTimeFormatter<Timestamp, OffsetDateTime> newTimestampFormat(@Nullable ObjectFormatterConfig config, int scale, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(30);
        }
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append(' ');
        builders.fb.appendPattern("[ ]");
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        return new DateAndTimeFormatter<Timestamp, OffsetDateTime>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate(formatsCache, this, config));
    }

    @Nullable
    protected Formatter newCustomTimestampFormat(@Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(31);
        }
        return this.newCustomDateTimeFormat(config, (Function<? super DataGridSettings, String>)((Function)DataGridSettings::getEffectiveDateTimePattern), new TimestampDelegate(formatsCache, this, config));
    }

    @Nullable
    protected Formatter newCustomDateTimeFormat(@Nullable ObjectFormatterConfig config, @NotNull Function<? super DataGridSettings, String> patternGetter, @NotNull DateAndTimeFormatterDelegate<?, ?> delegate) {
        String pattern;
        if (patternGetter == null) {
            FormatterCreator.$$$reportNull$$$0(32);
        }
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(33);
        }
        if (config == null || config.getMode() != ObjectFormatterMode.DISPLAY) {
            return null;
        }
        DataGridSettings settings = config.getSettings();
        String string = pattern = settings != null ? (String)patternGetter.fun((Object)settings) : null;
        if (pattern == null) {
            return null;
        }
        return new DateAndTimeFormatter(pattern, FormatterCreator.toFormatter(new DateTimeFormatterBuilder().appendPattern(pattern)), delegate);
    }

    @NotNull
    private CompositeFormatter newZonedTimestampFormat(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(34);
        }
        CompositeFormatter compositeFormatter = this.newZonedTimestampFormat(this.resolver(column), this.calculateScale(column, config), formatsCache, config);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(35);
        }
        return compositeFormatter;
    }

    @NotNull
    public CompositeFormatter newZonedTimestampFormat(@NotNull BoundaryValueResolver resolver, int scale, @NotNull FormatsCache formatsCache, @Nullable ObjectFormatterConfig config) {
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(36);
        }
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(37);
        }
        CompositeFormatter compositeFormatter = this.newZonedTimestampFormat(new ZonedTimestampDelegate<OffsetDateTime>(this){

            @Override
            protected OffsetDateTime toTemporalAccessor(@NotNull Object value) {
                if (value == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (!(value instanceof OffsetDateTime)) {
                    throw new IllegalArgumentException("Value must be type of OffsetDateTime");
                }
                return (OffsetDateTime)value;
            }

            @Override
            protected OffsetDateTime createFromTemporal(@NotNull OffsetDateTime value) {
                if (value == null) {
                    7.$$$reportNull$$$0(1);
                }
                return value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/extractors/FormatterCreator$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toTemporalAccessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createFromTemporal";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, resolver, scale, config);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(38);
        }
        return compositeFormatter;
    }

    @NotNull
    public Formatter newIsoFormatter(@NotNull DateAndTimeFormatterDelegate<?, ?> delegate) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(39);
        }
        return new DateAndTimeFormatter("ISO-8601", DateTimeFormatter.ISO_DATE_TIME, delegate);
    }

    @NotNull
    public <T, V extends TemporalAccessor> CompositeFormatter newZonedTimestampFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, int scale, @Nullable ObjectFormatterConfig config) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(40);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(41);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders, config);
        String pattern = builders.sb.toString();
        List mapped = ContainerUtil.map(formatters, f -> this.eraFormatter(pattern, (DateTimeFormatter)f, delegate, resolver, false));
        return new CompositeFormatter(DataGridBundle.message("expected.timestamp.with.time.zone", new Object[0]), mapped);
    }

    @NotNull
    protected Formatter newEraTimestampFormat(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(42);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(this.calculateScale(column, config));
        Formatter formatter = FormatterCreator.checkInfinity(this.eraFormatter(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate(formatsCache, this, config), this.resolver(column), this.omitEmptyTime(column)), this.resolver(column));
        if (formatter == null) {
            FormatterCreator.$$$reportNull$$$0(43);
        }
        return formatter;
    }

    protected boolean omitEmptyTime(@Nullable GridColumn column) {
        return false;
    }

    @NotNull
    protected BoundaryValueResolver resolver(@Nullable GridColumn column) {
        BoundaryValueResolver boundaryValueResolver = BoundaryValueResolver.ALWAYS_NULL;
        if (boundaryValueResolver == null) {
            FormatterCreator.$$$reportNull$$$0(44);
        }
        return boundaryValueResolver;
    }

    @NotNull
    private Formatter newShortEraZonedTimestampFormat(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        Formatter customFormatter;
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(45);
        }
        if ((customFormatter = this.newCustomDateTimeFormat(config, (Function<? super DataGridSettings, String>)((Function)DataGridSettings::getEffectiveZonedDateTimePattern), this.newShortZonedTimestampDelegate(config))) != null) {
            Formatter formatter = customFormatter;
            if (formatter == null) {
                FormatterCreator.$$$reportNull$$$0(46);
            }
            return formatter;
        }
        Formatter formatter = FormatterCreator.checkInfinity(this.newShortEraZonedTimestampFormat(this.calculateScale(column, config), config, formatsCache), this.resolver(column));
        if (formatter == null) {
            FormatterCreator.$$$reportNull$$$0(47);
        }
        return formatter;
    }

    protected int calculateScale(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return 0;
    }

    @NotNull
    private Formatter newShortEraZonedTimestampFormat(int scale, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(48);
        }
        return FormatterCreator.newShortZonedTimestampFormat(scale, (PairFunction<DateTimeFormatter, String, Formatter>)((PairFunction)(formatter, pattern) -> this.eraFormatter((String)pattern, (DateTimeFormatter)formatter, (DateAndTimeFormatterDelegate)this.newShortZonedTimestampDelegate(config), BoundaryValueResolver.ALWAYS_NULL, false)), config);
    }

    @NotNull
    protected ShortZonedTimestampDelegate<?> newShortZonedTimestampDelegate(final @Nullable ObjectFormatterConfig config) {
        return new ShortZonedTimestampDelegate<Object>(this){

            @Override
            protected Temporal toTemporalAccessor(@NotNull Object value) {
                if (value == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (!(value instanceof OffsetDateTime)) {
                    throw new IllegalArgumentException("Value must be of type OffsetDateTime");
                }
                OffsetDateTime dateTime = (OffsetDateTime)value;
                return DataGridFormattersUtilCore.adjustTimeZone(dateTime, DataGridFormattersUtilCore.getZoneId(config));
            }

            @Override
            protected Temporal createFromTemporal(@NotNull TemporalAccessor value) {
                if (value == null) {
                    8.$$$reportNull$$$0(1);
                }
                return DataGridFormattersUtilCore.toOffsetDateTime(value, DataGridFormattersUtilCore.getZoneId(config));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/extractors/FormatterCreator$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toTemporalAccessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createFromTemporal";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected Formatter newEraDateFormatter(@Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache, @NotNull BoundaryValueResolver resolver) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(49);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(50);
        }
        Formatter formatter = this.newEraDateFormatter(config, new DateDelegate(formatsCache, this), resolver);
        if (formatter == null) {
            FormatterCreator.$$$reportNull$$$0(51);
        }
        return formatter;
    }

    @Nullable
    public Formatter newGeoWrapperFormatter(GridColumn column, ObjectFormatter formatter) {
        return null;
    }

    @NotNull
    public Formatter newEraDateFormatter(@Nullable ObjectFormatterConfig config, @NotNull DateAndTimeFormatterDelegate<?, ?> delegate, @NotNull BoundaryValueResolver resolver) {
        Formatter formatter;
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(52);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(53);
        }
        if ((formatter = this.newCustomDateTimeFormat(config, (Function<? super DataGridSettings, String>)((Function)DataGridSettings::getEffectiveDatePattern), delegate)) != null) {
            Formatter formatter2 = formatter;
            if (formatter2 == null) {
                FormatterCreator.$$$reportNull$$$0(54);
            }
            return formatter2;
        }
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        String pattern = builders.sb.toString();
        DateAndTimeFormatter regular = new DateAndTimeFormatter(pattern, FormatterCreator.toFormatter(builders.fb), delegate, resolver, null);
        builders.fb.appendPattern(ERA_PATTERN);
        DateAndTimeFormatter era = new DateAndTimeFormatter(pattern, FormatterCreator.toFormatter(builders.fb), delegate, resolver, null);
        return new EraDateAndTimeFormatter(regular, era);
    }

    @NotNull
    protected Formatter newDateFormatter(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        DateDelegate delegate;
        DateAndTimeFormatter<Date, LocalDate> formatter;
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(55);
        }
        if ((formatter = this.newCustomDateTimeFormat(config, (Function<? super DataGridSettings, String>)((Function)DataGridSettings::getEffectiveDatePattern), delegate = new DateDelegate(formatsCache, this))) != null) {
            DateAndTimeFormatter<Date, LocalDate> dateAndTimeFormatter = formatter;
            if (dateAndTimeFormatter == null) {
                FormatterCreator.$$$reportNull$$$0(56);
            }
            return dateAndTimeFormatter;
        }
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        formatter = new DateAndTimeFormatter<Date, LocalDate>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), delegate);
        Formatter formatter2 = FormatterCreator.checkInfinity(formatter, this.resolver(column));
        if (formatter2 == null) {
            FormatterCreator.$$$reportNull$$$0(57);
        }
        return formatter2;
    }

    @NotNull
    protected Formatter newDateFormatWithTime(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(58);
        }
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append('T');
        builders.fb.appendLiteral('T');
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, 3);
        builders.sb.append('Z');
        builders.fb.appendLiteral('Z');
        DateAndTimeFormatter<Date, LocalDateTime> formatter = new DateAndTimeFormatter<Date, LocalDateTime>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new DateToLocalDateTimeDelegate(formatsCache, this, config));
        Formatter formatter2 = FormatterCreator.checkInfinity(formatter, this.resolver(column));
        if (formatter2 == null) {
            FormatterCreator.$$$reportNull$$$0(59);
        }
        return formatter2;
    }

    @NotNull
    public <T, V extends TemporalAccessor> CompositeFormatter newZonedTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, int scale, @Nullable ObjectFormatterConfig config) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(60);
        }
        Builders builders = new Builders();
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders, config);
        String pattern = builders.sb.toString();
        List mapped = ContainerUtil.map(formatters, f -> new DateAndTimeFormatter(pattern, (DateTimeFormatter)f, delegate));
        return new CompositeFormatter(DataGridBundle.message("unexpected.data.format", new Object[0]), mapped);
    }

    @NotNull
    protected static Formatter newShortZonedTimestampFormat(int scale, @NotNull PairFunction<DateTimeFormatter, String, Formatter> mapper, @Nullable ObjectFormatterConfig config) {
        if (mapper == null) {
            FormatterCreator.$$$reportNull$$$0(61);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders, config);
        String pattern = builders.sb.toString();
        return new CompositeFormatter(DataGridBundle.message("unexpected.data.format", new Object[0]), ContainerUtil.map(formatters, formatter -> (Formatter)mapper.fun(formatter, (Object)pattern)));
    }

    private static void appendTime(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(62);
        }
        builders.sb.append("HH:mm:ss");
        FormatterCreator.appendTime(builders.fb);
    }

    public static DateTimeFormatterBuilder appendTime(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(63);
        }
        return builder.parseLenient().optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().parseStrict();
    }

    @NotNull
    private static List<DateTimeFormatter> appendTimeZone(@NotNull Builders builders, @Nullable ObjectFormatterConfig config) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(64);
        }
        String hourPattern = config != null && config.getMode() == ObjectFormatterMode.NORMALIZE ? "H" : "HH";
        return FormatterCreator.withZoneOffsets(builders, builder -> builder.appendOffset("+" + hourPattern + ":MM:ss", "+00:00"), builder -> builder.appendOffset("+" + hourPattern + ":mm", "+00:00"), builder -> builder.appendOffset("+HHmm", "+0000"), builder -> builder.appendZoneOrOffsetId());
    }

    @NotNull
    private static List<DateTimeFormatter> withZoneOffsets(@NotNull Builders builders, Consumer<DateTimeFormatterBuilder> ... consumers) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(65);
        }
        if (consumers == null) {
            FormatterCreator.$$$reportNull$$$0(66);
        }
        List list = ContainerUtil.append((List)ContainerUtil.map((Object[])consumers, c -> {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(FormatterCreator.toFormatter(builders.fb)).appendPattern("[ ]");
            c.consume((Object)builder);
            return FormatterCreator.toFormatter(builder);
        }), (Object[])new DateTimeFormatter[]{FormatterCreator.toFormatter(builders.fb)});
        if (list == null) {
            FormatterCreator.$$$reportNull$$$0(67);
        }
        return list;
    }

    private static void appendDate(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(68);
        }
        builders.sb.append(DATE_PATTERN);
        FormatterCreator.appendDate(builders.fb);
    }

    public static DateTimeFormatterBuilder appendDate(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(69);
        }
        return builder.parseLenient().appendValue(ChronoField.YEAR_OF_ERA, 4, 7, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).parseStrict();
    }

    private static void appendFraction(@NotNull Builders builders, int scale) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(70);
        }
        builders.sb.append(scale > 0 ? "." : "");
        for (int i = 0; i < scale; ++i) {
            builders.sb.append('f');
        }
        if (scale > 0) {
            builders.fb.parseLenient().appendFraction(ChronoField.NANO_OF_SECOND, scale, scale, true).parseStrict();
        }
    }

    @NotNull
    protected <T, V extends TemporalAccessor> EraDateAndTimeFormatter eraFormatter(@NotNull String regular, @NotNull DateTimeFormatter regularFormatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, boolean omitEmptyTime) {
        Builders dateBuilders;
        if (regular == null) {
            FormatterCreator.$$$reportNull$$$0(71);
        }
        if (regularFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(72);
        }
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(73);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(74);
        }
        DateTimeFormatter era = FormatterCreator.toFormatter(new DateTimeFormatterBuilder().append(regularFormatter).appendPattern(ERA_PATTERN));
        Builders builders = dateBuilders = omitEmptyTime ? new Builders() : null;
        if (dateBuilders != null) {
            FormatterCreator.appendDate(dateBuilders);
        }
        return new EraDateAndTimeFormatter(new DateAndTimeFormatter<T, V>(regular, regularFormatter, delegate, resolver, dateBuilders == null ? null : FormatterCreator.toFormatter(dateBuilders.fb)), new DateAndTimeFormatter<T, V>(regular, era, delegate, resolver, dateBuilders == null ? null : FormatterCreator.toFormatter(dateBuilders.fb)));
    }

    @NotNull
    public static DateTimeFormatter toFormatter(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(75);
        }
        DateTimeFormatter dateTimeFormatter = builder.toFormatter(Locale.US);
        if (dateTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(76);
        }
        return dateTimeFormatter;
    }

    @NotNull
    private static Builders createBuildersForTimestamp(int scale) {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append(' ');
        builders.fb.appendPattern("[ ]");
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        Builders builders2 = builders;
        if (builders2 == null) {
            FormatterCreator.$$$reportNull$$$0(77);
        }
        return builders2;
    }

    @NotNull
    private static NumberFormatter configureDecimalFormat(@NotNull DecimalFormat format, @Nullable ObjectFormatterConfig config) {
        String pattern;
        if (format == null) {
            FormatterCreator.$$$reportNull$$$0(78);
        }
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        DataGridSettings settings = config != null ? config.getSettings() : null;
        String string = pattern = settings != null ? settings.getEffectiveNumberPattern() : null;
        if (settings != null && config.supportsNumberFormats()) {
            format.setGroupingUsed(settings.isNumberGroupingEnabled());
            symbols.setGroupingSeparator(settings.getNumberGroupingSeparator());
            symbols.setDecimalSeparator(settings.getDecimalSeparator());
            symbols.setNaN(settings.getNan());
            symbols.setInfinity(settings.getInfinity());
        } else {
            format.setGroupingUsed(false);
            symbols.setDecimalSeparator('.');
            symbols.setNaN("NaN");
            symbols.setInfinity("Infinity");
        }
        symbols.setMinusSign('-');
        format.setDecimalFormatSymbols(symbols);
        if (pattern != null) {
            format.applyLocalizedPattern(pattern);
        }
        return new NumberFormatter(format);
    }

    private static <T> FormatterKey<T> add(@NotNull FormatterKey<T> key, @Nullable GridColumn column) {
        if (key == null) {
            FormatterCreator.$$$reportNull$$$0(79);
        }
        key.putUserData(FORMATTER_KEY_GRID_COLUMN_KEY, column);
        return key;
    }

    private static <T> FormatterKey<T> add(@NotNull FormatterKey<T> key, @Nullable ObjectFormatterConfig config) {
        if (key == null) {
            FormatterCreator.$$$reportNull$$$0(80);
        }
        key.putUserData(FORMATTER_KEY_CONFIG_KEY, config);
        return key;
    }

    private static <T> FormatterKey<T> add(@NotNull FormatterKey<T> key, int value) {
        if (key == null) {
            FormatterCreator.$$$reportNull$$$0(81);
        }
        key.putUserData(FORMATTER_KEY_INT_KEY, value);
        return key;
    }

    private static <T> FormatterKey<T> add(@NotNull FormatterKey<T> key, @NotNull FormatsCache formatsCache) {
        if (key == null) {
            FormatterCreator.$$$reportNull$$$0(82);
        }
        if (formatsCache == null) {
            FormatterCreator.$$$reportNull$$$0(83);
        }
        key.putUserData(FORMATTER_KEY_FORMATS_CACHE_KEY, formatsCache);
        return key;
    }

    private static Formatter checkInfinity(final @NotNull Formatter format, final @NotNull BoundaryValueResolver resolver) {
        if (format == null) {
            FormatterCreator.$$$reportNull$$$0(84);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(85);
        }
        return new Formatter(){

            @Override
            public Object parse(@NotNull String value) throws ParseException {
                if (value == null) {
                    9.$$$reportNull$$$0(0);
                }
                return format.parse(value);
            }

            @Override
            public Object parse(@NotNull String value, ParsePosition position) {
                if (value == null) {
                    9.$$$reportNull$$$0(1);
                }
                return format.parse(value, position);
            }

            @Override
            public String format(Object value) {
                String infinityString = resolver.getInfinityString(value);
                return infinityString != null ? infinityString : format.format(value);
            }

            public String toString() {
                return format.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/FormatterCreator$9", "parse"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12, 13, 14, 15, 16, 18, 19, 20, 22, 25, 26, 29, 35, 38, 43, 44, 46, 47, 51, 54, 56, 57, 59, 67, 76, 77 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/FormatterCreator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 42: 
            case 45: 
            case 48: 
            case 49: 
            case 55: 
            case 58: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 10: 
            case 11: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 21: 
            case 33: 
            case 39: 
            case 40: 
            case 52: 
            case 60: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 23: 
            case 27: 
            case 36: 
            case 41: 
            case 50: 
            case 53: 
            case 74: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternGetter";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 62: 
            case 64: 
            case 65: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 63: 
            case 69: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularFormatter";
                break;
            }
            case 78: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/FormatterCreator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatsCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newBigDecimalFormat";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newIntFormat";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newLongFormat";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newBigIntFormat";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newZonedTimeFormat";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimeFormat";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimestampFormat";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "newIntrinsicTimestampFormat";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newZonedTimestampFormat";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "newEraTimestampFormat";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "resolver";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "newShortEraZonedTimestampFormat";
                break;
            }
            case 51: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "newEraDateFormatter";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormatter";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormatWithTime";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "withZoneOffsets";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "toFormatter";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildersForTimestamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 76: 
            case 77: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTimeKey";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTimestampKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShortEraZonedTimestampKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEraTimestampKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getZonedTimeKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getZonedTimestampKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDateKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFormatsCache";
                break;
            }
            case 17: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimeFormat";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newTimeFormat";
                break;
            }
            case 23: 
            case 24: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "newTimestampFormat";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newIntrinsicTimestampFormat";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "newCustomTimestampFormat";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newCustomDateTimeFormat";
                break;
            }
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimestampFormat";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newIsoFormatter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "newEraTimestampFormat";
                break;
            }
            case 45: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "newShortEraZonedTimestampFormat";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "newEraDateFormatter";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormatter";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormatWithTime";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "newShortZonedTimestampFormat";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "appendTime";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "appendTimeZone";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "withZoneOffsets";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "appendDate";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "appendFraction";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "eraFormatter";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "toFormatter";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "configureDecimalFormat";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "checkInfinity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12, 13, 14, 15, 16, 18, 19, 20, 22, 25, 26, 29, 35, 38, 43, 44, 46, 47, 51, 54, 56, 57, 59, 67, 76, 77 -> new IllegalStateException(string);
        };
    }

    public static class FormatterKey<T>
    extends UserDataHolderBase {
        private final String myName;

        public FormatterKey(@NotNull String name) {
            if (name == null) {
                FormatterKey.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FormatterKey.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean is(FormatterKey<?> key) {
            return this.myName.equals(key.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/FormatterCreator$FormatterKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/FormatterCreator$FormatterKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Builders {
        private final StringBuilder sb = new StringBuilder();
        private final DateTimeFormatterBuilder fb = new DateTimeFormatterBuilder();

        private Builders() {
        }
    }
}

